/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.util.TypeInfoSpec;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.gx.BInsets;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BToolPane;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.sidebar.BWbSideBar;

public class BSideBarPane
extends BEdgePane
implements BToolPane.MenuController {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$shell$BSideBarPane == null ? (class$com$tridium$workbench$shell$BSideBarPane = BSideBarPane.class$("com.tridium.workbench.shell.BSideBarPane")) : class$com$tridium$workbench$shell$BSideBarPane));
    public static final String defaultPickle = "workbench:NavSideBar;|toolpane=10000";
    static BModule module = Sys.loadModule((String)"workbench");
    BNiagaraWbShell shell;
    BToolPane toolPane;
    ArrayList bars = new ArrayList();
    static /* synthetic */ Class class$com$tridium$workbench$shell$BSideBarPane;

    public Type getType() {
        return TYPE;
    }

    public BSideBarPane() {
        this.toolPane = new BToolPane();
        this.toolPane.setMenuController((BToolPane.MenuController)this);
        this.setCenter((BWidget)new BBorderPane((BWidget)this.toolPane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    public BWbSideBar[] list() {
        return this.bars.toArray(new BWbSideBar[this.bars.size()]);
    }

    void initFromProfile(BWbProfile profile) {
        try {
            BWbSideBar[] bars = profile.getDefaultSideBars();
            for (int i = 0; bars != null && i < bars.length; ++i) {
                this.open(bars[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    BWbSideBar open(TypeInfoSpec spec) {
        return this.open(spec, (BWbSideBar)spec.info.getInstance());
    }

    BWbSideBar open(BWbSideBar bar) {
        return this.open(new TypeInfoSpec(bar.getType().getTypeInfo()), bar);
    }

    BWbSideBar open(TypeInfoSpec spec, BWbSideBar bar) {
        this.bars.add(bar);
        this.toolPane.addPane(spec.label, spec.icon, (BWidget)bar);
        if (this.shell != null) {
            this.showSideBar().setSelected(true);
        }
        return bar;
    }

    void close(BWbSideBar bar) {
        for (int i = 0; i < this.bars.size(); ++i) {
            if (this.bars.get(i) != bar) continue;
            this.bars.remove(i);
            this.toolPane.removePane((BWidget)bar);
            if (this.bars.size() == 0) {
                this.showSideBar().setSelected(false);
            }
            return;
        }
        throw new IllegalStateException("not open");
    }

    void closeAll() {
        this.bars.clear();
        this.toolPane.removeAll();
    }

    ToggleCommand showSideBar() {
        return this.shell.commands.showSideBar;
    }

    public String pickle() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.bars.size(); ++i) {
            BWbSideBar bar = (BWbSideBar)((Object)this.bars.get(i));
            s.append(bar.getType().toString()).append(";");
        }
        s.append('|').append(this.toolPane.pickle());
        return s.toString();
    }

    public void unpickle(String s) {
        try {
            this.closeAll();
            if (s.equals("") || s.startsWith("|")) {
                return;
            }
            StringTokenizer top = new StringTokenizer(s, "|");
            String types = top.nextToken();
            String positions = top.nextToken();
            StringTokenizer st = new StringTokenizer(types, ";");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                TypeInfo info = Sys.getRegistry().getType(tok);
                this.open(new TypeInfoSpec(info));
            }
            this.toolPane.unpickle(positions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BMenu getMenu(BToolPane toolPane, BWidget content) {
        BWbSideBar sideBar = (BWbSideBar)content;
        if (sideBar.hasCloseCommand()) {
            BMenu menu = new BMenu();
            menu.add(null, (Command)new CloseCommand(sideBar));
            return menu;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class CloseCommand
    extends SideBarCommand {
        CloseCommand(BWbSideBar sideBar) {
            super(sideBar, "sideBar.close");
        }

        public CommandArtifact doInvoke() {
            BSideBarPane.this.close(this.sideBar);
            return null;
        }
    }

    class SideBarCommand
    extends Command {
        BWbSideBar sideBar;

        SideBarCommand(BWbSideBar sideBar, String keyBase) {
            super((BWidget)sideBar, module, keyBase);
            this.sideBar = sideBar;
        }
    }
}

