/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.NiagaraWbShell;
import com.tridium.ui.ShellManager;
import com.tridium.ui.ShellPeer;
import com.tridium.ui.theme.palladium.PalladiumWidgetTheme;
import com.tridium.util.ThrowableUtil;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.bql.builder.BBqlQueryBuilder;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.file.BTextFileEditor;
import com.tridium.workbench.shell.BErrorPanel;
import com.tridium.workbench.shell.BFontSize;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BIRebootable;
import com.tridium.workbench.shell.BNiagaraWbApplet;
import com.tridium.workbench.shell.BNiagaraWbFrame;
import com.tridium.workbench.shell.BSaveAllDialog;
import com.tridium.workbench.shell.BSideBarPane;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BViewTabbedPane;
import com.tridium.workbench.shell.BWbApplication;
import com.tridium.workbench.shell.BWbPane;
import com.tridium.workbench.shell.NHyperlinkInfo;
import com.tridium.workbench.shell.WbCommands;
import com.tridium.workbench.shell.WbHistory;
import com.tridium.workbench.shell.WbMain;
import com.tridium.workbench.sidebars.BNavSideBar;
import java.io.File;
import java.net.ConnectException;
import java.net.UnknownHostException;
import javax.baja.file.BFileSystem;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.license.LicenseException;
import javax.baja.log.Log;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.security.AuthenticationException;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.PermissionException;
import javax.baja.sys.BObject;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.sidebar.BWbSideBar;
import javax.baja.workbench.view.BWbView;

public abstract class BNiagaraWbShell
extends BWbShell
implements NiagaraWbShell,
ShellManager.ShellPeerFactory,
NavListener {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$shell$BNiagaraWbShell == null ? (class$com$tridium$workbench$shell$BNiagaraWbShell = BNiagaraWbShell.class$("com.tridium.workbench.shell.BNiagaraWbShell")) : class$com$tridium$workbench$shell$BNiagaraWbShell));
    static Log log;
    static String statusDefault;
    static BImage errorIcon;
    static WbHistory history;
    public final BWbProfile profile;
    public final WbCommands commands;
    public final BWbPane pane;
    public BFileChooser fileChooser;
    public BDirectoryChooser dirChooser;
    public BBqlQueryBuilder bqlBuilder;
    static /* synthetic */ Class class$com$tridium$workbench$shell$BNiagaraWbShell;

    public Type getType() {
        return TYPE;
    }

    BNiagaraWbShell(Type profileType) {
        this.profile = BWbProfile.make(this, profileType);
        this.commands = new WbCommands(this);
        this.pane = new BWbPane(this);
        this.setContent((BWidget)this.pane);
    }

    BNiagaraWbShell(Type profileType, ShellPeer peer) {
        super(peer);
        this.profile = BWbProfile.make(this, profileType);
        this.commands = new WbCommands(this);
        this.pane = new BWbPane(this);
        this.setContent((BWidget)this.pane);
    }

    abstract void doShowStatus(String var1);

    BSideBarPane makeSideBar() {
        return new BSideBarPane();
    }

    public Command getRefreshCommand() {
        return this.commands.refresh;
    }

    public Command getSaveCommand() {
        return this.commands.save;
    }

    public Command getExportCommand() {
        return this.commands.export;
    }

    public Command getBackCommand() {
        return this.commands.back;
    }

    public Command getForwardCommand() {
        return this.commands.forward;
    }

    public Command getLogoffCommand() {
        return this.commands.logoff;
    }

    public final BWbProfile getProfile() {
        return this.profile;
    }

    public final void showStatus(String msg) {
        if (msg == null) {
            msg = statusDefault;
        }
        this.doShowStatus(msg);
    }

    public final BOrd getActiveOrd() {
        return this.tab().ord;
    }

    public final OrdTarget getActiveOrdTarget() {
        return this.tab().target;
    }

    public final BWbView getActiveView() {
        return this.tab().view;
    }

    public void updateCommandStates(BWbView view) {
        this.commands.updateView(view);
    }

    public void exitBusy() {
        super.exitBusy();
        this.commands.updateSaveBog();
    }

    public void debug() {
    }

    public final boolean isApplet() {
        return this instanceof BNiagaraWbApplet;
    }

    public final boolean isFrame() {
        return this instanceof BNiagaraWbFrame;
    }

    public void updateTransferWidgetStates() {
        if (this.tab().view != null) {
            this.tab().view.updateTransferWidgetStates();
        }
    }

    public static BWbApplication app() {
        return (BWbApplication)BNiagaraWbShell.getApplication();
    }

    public String getSelectedText() {
        BTextFileEditor editor;
        String text;
        if (this.tab().view instanceof BTextFileEditor && (text = (editor = (BTextFileEditor)this.tab().view).getSelectedText()) != null && (text = text.trim()).length() > 0) {
            return text;
        }
        return null;
    }

    public void started() throws Exception {
        super.started();
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
    }

    public void stopped() throws Exception {
        super.stopped();
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
    }

    public void setModified(BWbPlugin view) {
        if (view == this.tab().view) {
            this.commands.save.setEnabled(true);
        }
    }

    public void clearModified(BWbPlugin view) {
        if (view == this.tab().view) {
            this.commands.save.setEnabled(false);
        }
    }

    public void navEvent(NavEvent event) {
        this.commands.updateSaveBog();
        if (event.getId() == 2 || event.getId() == 5) {
            this.checkTabsForRemoveEvent(event);
        }
    }

    private void checkTabsForRemoveEvent(NavEvent event) {
        BViewTab[] tabs = this.pane.views.getTabs();
        boolean tabRemoved = false;
        for (int i = 0; i < tabs.length; ++i) {
            BISession session;
            BViewTab tab = tabs[i];
            BOrd activeOrd = tab.ord;
            if (activeOrd == null || tab.getTarget() == null) continue;
            OrdTarget target = tab.getTarget();
            BObject object = target == null ? null : target.get();
            BISession bISession = session = object == null ? null : BOrd.toSession((BObject)object);
            if (tab.view instanceof BIRebootable && ((BIRebootable)((Object)tab.view)).isRebooting()) continue;
            if (session != null && !session.isConnected()) {
                tabRemoved = true;
                tab.stopView(false);
                this.error(tab, activeOrd, (Throwable)new LocalizableException("bajaui", "errorPanel.disconnected"), false);
                continue;
            }
            if (!WbMain.isRemoved(event, activeOrd)) continue;
            tabRemoved = true;
            tab.stopView(false);
            this.error(tab, activeOrd, (Throwable)new LocalizableException("bajaui", "errorPanel.targetRemoved"), false);
        }
        if (tabRemoved) {
            this.tab().updateShell();
            this.relayout();
        }
    }

    void autoLogoff() {
    }

    public final boolean confirmClose() {
        String title = UiLexicon.bajaui().getText("saveBeforeClose");
        int result = BSaveAllDialog.saveTabs(this, title);
        return result != 2;
    }

    public void hyperlink(File file, int line1, int col1, int line2, int col2) {
        BWbView active;
        BOrd fileOrd = BFileSystem.INSTANCE.localFileToOrd(file);
        BViewTab[] tabs = this.pane.views.getTabs();
        for (int i = 0; i < tabs.length; ++i) {
            if (tabs[i].ord == null || !tabs[i].ord.equals((Object)fileOrd) || this.tab() == tabs[i]) continue;
            this.pane.views.selectLabelPane(tabs[i]);
        }
        if (!this.tab().ord.equals((Object)fileOrd)) {
            this.hyperlink(fileOrd);
        }
        if ((active = this.getActiveView()) instanceof BTextFileEditor) {
            ((BTextFileEditor)active).highlight(line1, col1, line2, col2);
        }
    }

    public void hyperlink(HyperlinkInfo hyperlinkInfo) {
        this.doHyperlink(hyperlinkInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doHyperlink(HyperlinkInfo hyperlinkInfo) {
        this.showStatus("");
        NHyperlinkInfo info = NHyperlinkInfo.make(hyperlinkInfo);
        if (info.getMode() == BHyperlinkMode.newShell) {
            WbMain.openFrame((BNiagaraWbFrame)this, info.getOrd(), this.profile.getType());
            return;
        }
        BViewTab tab = this.tab();
        if (info.getMode() == BHyperlinkMode.newTab) {
            tab = this.pane.views.addTab();
        } else if (!this.confirmHyperlink()) {
            return;
        }
        if (!this.profile.canHyperlink(info.getOrd())) {
            this.error(tab, info.getOrd(), (Throwable)new LocalizableException("bajaui", "errorPanel.ordNotAccessible"), true);
            return;
        }
        ShellManager shellManager = (ShellManager)this.widgetSupport(null);
        this.enterBusy();
        try {
            info.hyperlink(tab);
        }
        catch (Throwable e) {
            this.error(tab, info.getOrd(), e, true);
        }
        finally {
            this.exitBusy();
        }
    }

    public final boolean confirmHyperlink() {
        return this.confirmHyperlink(this.tab());
    }

    public final boolean confirmHyperlink(BViewTab tab) {
        if (tab.view != null && tab.view.isModified()) {
            int buttons;
            String msg = UiLexicon.bajaui().getText("confirmHyperlink.message", new Object[]{tab.getDisplayName()});
            int result = BDialog.confirm((BWidget)this, null, (Object)msg, (int)(buttons = 14));
            if (result == 2) {
                return false;
            }
            if (result == 4) {
                this.save(tab.view);
                if (tab.view.isModified()) {
                    return false;
                }
            }
        }
        return true;
    }

    public void syncTree() {
        this.syncTree(false);
    }

    public void syncTree(boolean silence) {
        if (this.getProfile().hasSideBar()) {
            try {
                BWbSideBar[] bars = this.pane.sideBar.list();
                for (int i = 0; i < bars.length; ++i) {
                    if (!(bars[i] instanceof BNavSideBar)) continue;
                    ((BNavSideBar)bars[i]).syncTree(silence);
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void initShell() {
        ((ShellManager)this.widgetSupport(null)).activate();
    }

    public void shutdownShell() {
        BViewTab[] tabs = this.pane.views.getTabs();
        for (int i = 0; i < tabs.length; ++i) {
            tabs[i].stopView(true);
        }
        ((ShellManager)this.widgetSupport(null)).deactivate();
    }

    public OrdTarget resolve(BOrd ord, BICredentials credentials) throws Exception {
        BICredentials lastCreds = credentials;
        AuthenticationRealm realm = null;
        boolean newSession = false;
        int i = 0;
        while (true) {
            try {
                BISession session;
                BOrd openOrd;
                BWbProfile profile;
                if (realm != null) {
                    lastCreds = realm.getCredentials();
                }
                OrdTarget target = ord.resolve();
                if (newSession && (profile = this.getProfile()) != null && (openOrd = profile.getOpenOrd(session = BOrd.toSession((BObject)target.get()), ord)) != null) {
                    ord = openOrd;
                    target = openOrd.resolve();
                }
                return target;
            }
            catch (AuthenticationException e) {
                newSession = true;
                realm = e.getAuthenticationRealm();
                if (credentials != null && e.getAuthenticationRealm() != null) {
                    realm.setCredentials(credentials);
                    credentials = null;
                } else if (i == 0 && WbMain.kioskCredentials != null) {
                    realm.setCredentials(WbMain.kioskCredentials);
                } else if (!(i == 0 && AuthUtil.resolveSSO(e) || AuthUtil.handleAuthResponse(e, this, lastCreds) || AuthUtil.challenge((BWidget)this, e, i > 1))) {
                    throw e;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(BWbView view) {
        this.enterBusy();
        try {
            view.saveValue();
        }
        catch (Throwable e) {
            Throwable cause = e;
            String msg = UiLexicon.bajaui().getText("plugin.save.error");
            if (e instanceof CannotSaveException) {
                CannotSaveException cse = (CannotSaveException)((Object)e);
                if (cse.isSilent()) {
                    return;
                }
                msg = e.getMessage();
                cause = ((CannotSaveException)((Object)e)).getCause();
                if (cause == null) {
                    cause = e;
                }
            }
            cause.printStackTrace();
            String title = UiLexicon.bajaui().getText("dialog.error");
            BDialog.error((BWidget)this, (String)title, (Object)msg, (Throwable)e);
            this.repaint();
            return;
        }
        finally {
            this.exitBusy();
        }
        this.commands.updateSaveBog();
        this.commands.save.setEnabled(false);
        this.repaint();
    }

    void error(BViewTab tab, BOrd ord, Throwable e, boolean logIt) {
        String msg = null;
        if (e instanceof UnresolvedException) {
            Throwable cause = ThrowableUtil.getCause((Throwable)e);
            msg = this.exceptionToMessage(cause);
            if (msg == null) {
                msg = this.exceptionToMessage(e);
            }
        } else {
            msg = this.exceptionToMessage(e);
        }
        if (msg == null) {
            msg = UiLexicon.bajaui().getText("errorPanel.cannotHyperlink");
        }
        this.error(tab, ord, msg, e, logIt);
    }

    void error(BViewTab tab, BOrd ord, String msg, Throwable e, boolean logIt) {
        if (logIt) {
            log.error(msg, e);
        }
        this.showStatus(msg);
        String tabName = BViewTabbedPane.toTabName(ord, null);
        BImage tabIcon = errorIcon;
        tab.fault = null;
        tab.setLabel(new BLabel(tabIcon, tabName));
        Object errorDisplay = null;
        BWbProfile profile = this.getProfile();
        if (profile != null) {
            errorDisplay = profile.makeErrorDisplay(this, msg, ord, e);
        }
        if (errorDisplay == null) {
            errorDisplay = new BErrorPanel(this, msg, ord, e);
        }
        tab.setContent((BWidget)errorDisplay);
        tab.relayout();
    }

    private String exceptionToMessage(Throwable e) {
        UiLexicon lex = UiLexicon.bajaui();
        if (e instanceof LocalizableException) {
            return e.getMessage();
        }
        if (e instanceof LocalizableRuntimeException) {
            return e.getMessage();
        }
        if (e instanceof UnresolvedException) {
            return lex.getText("errorPanel.targetNotFound");
        }
        if (e instanceof AuthenticationException) {
            return lex.getText("errorPanel.failedToAuthenticate");
        }
        if (e instanceof PermissionException) {
            return lex.getText("errorPanel.noPermission");
        }
        if (e instanceof LicenseException) {
            return lex.getText("errorPanel.license", new Object[]{e.getMessage()});
        }
        if (e instanceof ConnectException) {
            return lex.getText("errorPanel.connect");
        }
        if (e instanceof UnknownHostException) {
            return lex.getText("errorPanel.unknownHost", new Object[]{e.getMessage()});
        }
        return null;
    }

    public BConsole getConsole() {
        return this.pane.console;
    }

    public BConsole openConsole() {
        this.commands.console.setSelected(true);
        this.pane.console.appendBreak();
        this.relayout();
        return this.pane.console;
    }

    public BViewTab tab() {
        return this.pane.views.tab();
    }

    private static BFont incFontSize(BFont f) {
        return BFont.make((String)f.getName(), (double)(f.getSize() + 4.0), (int)f.getStyle());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (BGeneralOptions.make().getFontSize() == BFontSize.large) {
            PalladiumWidgetTheme.plainText = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.plainText);
            PalladiumWidgetTheme.boldText = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.boldText);
            PalladiumWidgetTheme.largeFont = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.largeFont);
            PalladiumWidgetTheme.largeBoldFont = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.largeBoldFont);
            PalladiumWidgetTheme.fixedWidth = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.fixedWidth);
            PalladiumWidgetTheme.fixedWidthBold = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.fixedWidthBold);
        }
        log = Log.getLog((String)"wb.shell");
        statusDefault = "";
        errorIcon = BImage.make((String)"module://icons/x16/error.png");
        history = new WbHistory();
    }

    static class Support {
        BNiagaraWbShell shell;
        BWbProfile profile;

        Support(BNiagaraWbShell shell) {
            this.shell = shell;
            this.profile = shell.profile;
        }
    }
}

