/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.fox.session.Fox;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.FatalAuthenticationException;
import com.tridium.net.HttpUtil;
import com.tridium.ui.BNiagaraWidgetApplication;
import com.tridium.ui.ShellPeer;
import com.tridium.ui.UiEnv;
import com.tridium.ui.awt.PanelPeer;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.CustomThemeModuleManager;
import com.tridium.web.WebUtil;
import com.tridium.workbench.auth.BUsernameAndPasswordFE;
import com.tridium.workbench.job.JobMonitor;
import com.tridium.workbench.shell.BDefaultWbWebProfile;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BNiagaraWbAppletLoginPane;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BSideBarPane;
import com.tridium.workbench.shell.WbMain;
import java.applet.Applet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BHttpFoxCredentials;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.web.BAuthenticationType;
import javax.baja.web.BWebService;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.net.ssl.SSLHandshakeException;

public class BNiagaraWbApplet
extends BNiagaraWbShell {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$shell$BNiagaraWbApplet == null ? (class$com$tridium$workbench$shell$BNiagaraWbApplet = BNiagaraWbApplet.class$("com.tridium.workbench.shell.BNiagaraWbApplet")) : class$com$tridium$workbench$shell$BNiagaraWbApplet));
    private static BFoxSession lastFoxSession = null;
    private BFoxSession foxSession;
    private Applet applet;
    private boolean initSideBar;
    private boolean appletReload = true;
    private static Log log = Log.getLog((String)"com.tridium.workbench.shell");
    private KeepaliveThread keepaliveThread;
    private static final String KEEPALIVE_URL = "/wb/keepalive";
    static /* synthetic */ Class class$com$tridium$workbench$shell$BNiagaraWbApplet;
    static /* synthetic */ Class class$java$lang$String;

    public Type getType() {
        return TYPE;
    }

    public static BNiagaraWbApplet make(Applet applet) {
        String themeParam;
        Type profileType = null;
        try {
            String param = applet.getParameter("profile");
            if (param != null) {
                profileType = Sys.getType((String)param);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (profileType == null) {
            profileType = BDefaultWbWebProfile.TYPE;
        }
        if ((themeParam = applet.getParameter("selectedWorkbenchTheme")) != null) {
            try {
                BDynamicEnum themeEnum = (BDynamicEnum)BDynamicEnum.DEFAULT.decodeFromString(themeParam);
                CustomThemeModuleManager.installFromEnum((BDynamicEnum)themeEnum);
            }
            catch (Exception e) {
                e.printStackTrace();
                Theme.installDefaultTheme();
            }
        } else {
            if (log.isTraceOn()) {
                log.trace("Applet parameter 'selectedWorkbenchTheme' not found (Workbench Theme not selected on user profile). Using default theme.");
            }
            BDynamicEnum defaultTheme = CustomThemeModuleManager.getDefaultThemeEnum();
            CustomThemeModuleManager.installFromEnum((BDynamicEnum)defaultTheme);
        }
        return new BNiagaraWbApplet(applet, profileType);
    }

    public BNiagaraWbApplet() {
        super(null);
        throw new IllegalStateException();
    }

    public BNiagaraWbApplet(Applet applet, Type profileType) {
        super(profileType);
        this.applet = applet;
        this.appletReload = this.getParameter("appletReloadOnHyperlink", true);
        WbMain.initApplet();
    }

    public ShellPeer newShellPeer() {
        return new PanelPeer();
    }

    public Applet getApplet() {
        return this.applet;
    }

    public URL ordToUrl(BOrd ord) {
        try {
            String ordStr = ord.toString();
            if (ordStr.startsWith("http://") || ordStr.startsWith("https://")) {
                return new URL(ordStr);
            }
            ord = BOrd.make((BOrd)this.getActiveOrd(), (BOrd)ord).normalize();
            OrdTarget target = this.getActiveOrdTarget();
            URL base = this.applet.getDocumentBase();
            String servletPath = this.applet.getParameter("servletPath");
            URL url = servletPath == null || servletPath.length() == 0 || servletPath.equals("/") ? new URL(base, WebUtil.toUri((OrdTarget)target, (String)"/ord?", (BOrd)ord, (URL)base)) : new URL(base, WebUtil.toUri((OrdTarget)target, (String)(servletPath + "/ord?"), (BOrd)ord, (URL)base));
            return url;
        }
        catch (Exception e) {
            throw new SyntaxException("" + ord, (Throwable)e);
        }
    }

    public BSimple getParameter(String param, BSimple def) {
        if (this.applet == null) {
            return def;
        }
        String val = this.applet.getParameter(param);
        if (val == null) {
            return def;
        }
        try {
            return (BSimple)def.decodeFromString(val);
        }
        catch (IOException e) {
            return def;
        }
    }

    public boolean getParameter(String param, boolean def) {
        return ((BBoolean)this.getParameter(param, (BSimple)BBoolean.make((boolean)def))).getBoolean();
    }

    boolean isAppletReloadOnHyperlink() {
        return this.appletReload;
    }

    void browserForward() {
        try {
            this.getApplet().getAppletContext().showDocument(new URL("javascript:history.go(1)"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void browserBack() {
        try {
            this.getApplet().getAppletContext().showDocument(new URL("javascript:history.go(-1)"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void doShowStatus(String msg) {
        this.pane.showStatus(msg);
        this.applet.showStatus(msg);
    }

    public void hyperlink(HyperlinkInfo hyperlinkInfo) {
        boolean reload;
        boolean bl = reload = this.appletReload || this.foxSession == null || !this.foxSession.isConnected();
        if (!reload) {
            int i;
            String hostname = this.foxSession.getHost().getHostname();
            String foxSessionBody = null;
            OrdQuery[] queries = this.foxSession.getOrdInHost().normalize().parse();
            for (i = 0; i < queries.length; ++i) {
                if (!queries[i].getScheme().equalsIgnoreCase("fox") && !queries[i].getScheme().equalsIgnoreCase("foxs")) continue;
                foxSessionBody = queries[i].getBody();
                break;
            }
            queries = hyperlinkInfo.getOrd().parse();
            for (i = 0; i < queries.length; ++i) {
                if (queries[i].getScheme().indexOf("http") > -1) {
                    reload = true;
                    break;
                }
                if (queries[i].getScheme().equalsIgnoreCase("ip") && !queries[i].getBody().equalsIgnoreCase(hostname)) {
                    reload = true;
                    break;
                }
                if (!queries[i].getScheme().equalsIgnoreCase("fox") && !queries[i].getScheme().equalsIgnoreCase("foxs") || queries[i].getBody().equalsIgnoreCase(foxSessionBody)) continue;
                reload = true;
                break;
            }
        }
        if (reload) {
            URL url = this.ordToUrl(hyperlinkInfo.getOrd());
            String target = hyperlinkInfo.getMode() == BHyperlinkMode.newShell ? "_blank" : (hyperlinkInfo.getMode() == BHyperlinkMode.newTab ? "_blank" : "_self");
            this.applet.getAppletContext().showDocument(url, target);
        } else {
            super.hyperlink(hyperlinkInfo);
        }
    }

    public BWidget getMenuBar() {
        return this.pane.getMenuBar();
    }

    public void appletStart() {
        String ordParam;
        String currentUser;
        BFoxClientConnection conn;
        BNiagaraWbApplet.app().applet = true;
        this.initShell();
        Properties props = null;
        BHost host = null;
        int port = -1;
        boolean useFoxs = false;
        URL pingUrl = null;
        try {
            this.downloadFacetKeys();
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] tunnelAuthorities = null;
        try {
            int defaultPort;
            URL docBase = this.applet.getDocumentBase();
            URL url = new URL(docBase, "/wb/logon");
            InputStream in = url.openStream();
            props = new Properties();
            props.load(in);
            in.close();
            String hostname = docBase.getHost();
            host = (BHost)BOrd.make((String)("ip:" + hostname)).get();
            try {
                port = Integer.parseInt(props.getProperty("foxPort"));
                useFoxs = Boolean.valueOf(props.getProperty("useFoxs"));
                if (useFoxs) {
                    System.setProperty("sha1FingerPrint", props.getProperty("sha1FingerPrint"));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            int n = defaultPort = useFoxs ? 4911 : 1911;
            if (port == -1) {
                port = defaultPort;
            }
            Array tunnelList = new Array(class$java$lang$String == null ? (class$java$lang$String = BNiagaraWbApplet.class$("java.lang.String")) : class$java$lang$String);
            String currentPrefix = "";
            String prefix = WebUtil.parseTunnelPrefix((URL)docBase);
            pingUrl = new URL(docBase, prefix + KEEPALIVE_URL);
            while (prefix != null && prefix.startsWith("/tunnel/")) {
                prefix = prefix.substring("/tunnel/".length());
                int lastIndex = prefix.indexOf("/tunnel/");
                String tunnelAuthority = null;
                if (lastIndex < 0) {
                    tunnelAuthority = prefix;
                    prefix = null;
                } else {
                    tunnelAuthority = prefix.substring(0, lastIndex);
                    prefix = prefix.substring(lastIndex);
                }
                currentPrefix = currentPrefix + "/tunnel/" + tunnelAuthority;
                url = new URL(docBase, currentPrefix + "/wb/logon");
                in = url.openStream();
                props = new Properties();
                props.load(in);
                in.close();
                int foxPort = Integer.parseInt(props.getProperty("foxPort"));
                tunnelAuthority = HttpUtil.parseHost((String)tunnelAuthority);
                if (foxPort != defaultPort) {
                    tunnelAuthority = tunnelAuthority + ":" + foxPort;
                }
                tunnelList.add((Object)tunnelAuthority);
            }
            if (!tunnelList.isEmpty()) {
                tunnelAuthorities = (String[])tunnelList.array();
            }
            this.foxSession = tunnelAuthorities == null ? BFoxSession.make((BHost)host, (int)port, (boolean)useFoxs) : BFoxSession.make(null, (BHost)host, (int)port, (boolean)useFoxs, (String[])tunnelAuthorities);
        }
        catch (Exception e) {
            this.error(this.tab(), BOrd.NULL, "Cannot logon using fox", e, true);
            return;
        }
        String user = this.applet.getParameter("user");
        if (user != null && this.foxSession.isConnected() && (conn = this.foxSession.getConnection()) != null && !user.equals(currentUser = conn.getUsername())) {
            System.out.println("NiagaraWbApplet.relogin: " + user + " != " + currentUser);
            this.logoff();
            this.foxSession = tunnelAuthorities == null ? BFoxSession.make((BHost)host, (int)port, (boolean)useFoxs) : BFoxSession.make(null, (BHost)host, (int)port, (boolean)useFoxs, (String[])tunnelAuthorities);
        }
        if (!this.foxSession.isConnected()) {
            try {
                this.logon(props);
            }
            catch (Exception e) {
                try {
                    String query = "";
                    if (e instanceof ConnectException || e instanceof SSLHandshakeException) {
                        query = "?loginFailed=6";
                    }
                    URL docBase = this.applet.getDocumentBase();
                    String prefix = WebUtil.parseTunnelPrefix((URL)docBase);
                    URL url = new URL(docBase, prefix + "/logout" + query);
                    this.applet.getAppletContext().showDocument(url, "_top");
                }
                catch (Exception ex) {
                    this.error(this.tab(), BOrd.NULL, "Cannot logon using fox", e, true);
                }
                return;
            }
        }
        if ((ordParam = this.applet.getParameter("ord")) == null) {
            this.error(this.tab(), BOrd.NULL, "Missing 'ord' parameter", null, true);
            return;
        }
        this.loadSideBar();
        JobMonitor.get();
        BOrd ord = BOrd.make((BOrd)this.foxSession.getNavOrd(), (String)ordParam);
        this.doHyperlink(new HyperlinkInfo(ord));
        this.startKeepalive(pingUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFacetKeys() throws Exception {
        String userHome = System.getProperty("user.home");
        File bajaHome = new File(userHome + File.separator + "niagara" + File.separator + "wbapplet" + File.separator + BNiagaraWbApplet.calcHostNameKey(this.applet));
        File workbench = new File(bajaHome, "workbench");
        workbench.mkdirs();
        File dest = new File(workbench, "facetKeys.properties");
        if (!dest.exists()) {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
            URL base = this.applet.getDocumentBase();
            URL target = new URL(base, "/wb/facetkeys");
            InputStream in = target.openStream();
            try {
                int n;
                int len = 4096;
                byte[] buf = new byte[len];
                while ((n = in.read(buf, 0, len)) >= 0) {
                    ((OutputStream)out).write(buf, 0, n);
                }
                ((OutputStream)out).close();
                System.out.println("Facet keys copied");
            }
            finally {
                in.close();
            }
        }
    }

    public void appletStop() {
        this.shutdownShell();
        this.saveSideBar();
        this.stopKeepalive();
    }

    LastSideBarInfo getLastSideBarInfo() {
        if (lastFoxSession != null && BNiagaraWbApplet.lastFoxSession.uiCache instanceof LastSideBarInfo) {
            return (LastSideBarInfo)BNiagaraWbApplet.lastFoxSession.uiCache;
        }
        return null;
    }

    BSideBarPane makeSideBar() {
        BSideBarPane sideBar = null;
        LastSideBarInfo info = this.getLastSideBarInfo();
        if (info != null) {
            sideBar = info.lastSideBar;
            info.lastSideBar = null;
        }
        if (sideBar != null) {
            this.initSideBar = false;
        } else {
            this.initSideBar = true;
            sideBar = new BSideBarPane();
        }
        return sideBar;
    }

    void loadSideBar() {
        boolean lastSideBarVisible = true;
        double lastSideBarPosition = 30.0;
        LastSideBarInfo info = this.getLastSideBarInfo();
        if (info != null) {
            lastSideBarVisible = info.lastSideBarVisible;
            lastSideBarPosition = info.lastSideBarPosition;
        }
        if (lastFoxSession != this.foxSession) {
            boolean bl = this.initSideBar = this.pane.sideBar != null;
            if (this.initSideBar) {
                this.pane.sideBar.closeAll();
            }
        }
        if (this.initSideBar && lastSideBarVisible) {
            this.pane.sideBar.initFromProfile(this.getProfile());
        }
        this.commands.showSideBar.setSelected(lastSideBarVisible);
        this.pane.setSplitPosition(lastSideBarPosition);
    }

    void saveSideBar() {
        lastFoxSession = this.foxSession;
        BSideBarPane sideBar = this.pane.sideBar;
        if (sideBar == null) {
            return;
        }
        sideBar.getParent().set(sideBar.getPropertyInParent(), (BValue)new BNullWidget());
        if (this.foxSession != null && this.foxSession.isConnected()) {
            LastSideBarInfo info = this.getLastSideBarInfo();
            if (info == null) {
                info = new LastSideBarInfo();
            }
            info.lastSideBar = sideBar;
            info.lastSideBarVisible = this.commands.showSideBar.isSelected();
            info.lastSideBarPosition = this.pane.getSplitPosition();
            this.foxSession.uiCache = info;
        }
    }

    void logon(Properties props) throws Exception {
        WbMain.licenseAdmin = BNiagaraWbApplet.get(props, "admin", false);
        BGeneralOptions opt = BGeneralOptions.make();
        opt.setFlags((Slot)BGeneralOptions.autoLogoffEnabled, 1);
        opt.setFlags((Slot)BGeneralOptions.autoLogoffPeriod, 1);
        opt.setAutoLogoffEnabled(BNiagaraWbApplet.get(props, "autoLogoffEnabled", true));
        opt.setAutoLogoffPeriod(BNiagaraWbApplet.get(props, "autoLogoffPeriod", 900000L));
        opt.initFromUserFacets(BNiagaraWbApplet.get(props, "userFacets", BFacets.DEFAULT));
        String sessionId = props.getProperty("httpSession");
        String username = props.getProperty("username");
        BHttpFoxCredentials cred = new BHttpFoxCredentials(username, sessionId);
        this.foxSession.setCredentials((BICredentials)cred);
        Fox.appName = "WbApplet";
        Fox.appVersion = "" + Sys.getBajaModule().getVendorVersion();
        this.foxSession.getConnection().setCheckBrandCompatibility(false);
        String httpSession = props.getProperty("httpSession");
        if (httpSession != null) {
            BString httpSessionVal = BString.make((String)httpSession);
            BFoxClientConnection conn = this.foxSession.getConnection();
            if (conn.get("httpSession") != null) {
                conn.set("httpSession", (BValue)httpSessionVal);
            } else {
                conn.add("httpSession", (BValue)httpSessionVal, 7);
            }
        }
        this.connect();
    }

    private void connect() throws Exception {
        while (true) {
            String username = null;
            BICredentials credentials = this.foxSession.getCredentials();
            if (credentials != null && credentials instanceof BIUserCredentials) {
                username = ((BIUserCredentials)credentials).getUsername();
            }
            try {
                this.foxSession.connect();
                return;
            }
            catch (IOException e) {
                throw e;
            }
            catch (FatalAuthenticationException e) {
                throw e;
            }
            catch (Exception e) {
                this.foxSession.setCredentials((BICredentials)new BUsernameAndPassword());
                if (this.challenge(username)) continue;
                throw e;
            }
            break;
        }
    }

    private boolean challenge(String username) {
        BICredentials credentials;
        int result;
        Lexicon lex = Lexicon.make((String)"workbench");
        String error = lex.getText("wbapplet.login.failed");
        BNiagaraWbAppletLoginPane loginPane = new BNiagaraWbAppletLoginPane((AuthenticationRealm)this.foxSession, true, lex.getText("wbapplet.login.failed"));
        BWbFieldEditor editor = loginPane.getCredInputPane().getEditor();
        if (editor instanceof BUsernameAndPasswordFE) {
            BUsernameAndPasswordFE credEditor = (BUsernameAndPasswordFE)editor;
            if (username != null) {
                credEditor.loadValue((BObject)new BUsernameAndPassword(username, BPassword.make((String)"")));
                credEditor.setUsernameReadonly(true);
            }
        }
        if ((result = BDialog.open((BWidget)this, (String)"Enter credentials", (Object)((Object)loginPane), (int)3)) == 2) {
            loginPane.getCredInputPane().cleanCredentials();
            return false;
        }
        try {
            credentials = loginPane.getCredInputPane().extractCredentials();
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (String)UiLexicon.bajaui().getText("dialog.error"), (Object)e.getMessage(), (Throwable)e);
            return false;
        }
        this.foxSession.setCredentials(credentials);
        return true;
    }

    void logoff() {
        if (this.foxSession == null) {
            return;
        }
        try {
            this.foxSession.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.foxSession = null;
    }

    void autoLogoff() {
        try {
            URL docBase = this.applet.getDocumentBase();
            String prefix = WebUtil.parseTunnelPrefix((URL)docBase);
            URL url = new URL(docBase, prefix + "/logout");
            this.applet.getAppletContext().showDocument(url, "_top");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static boolean get(Properties props, String key, boolean def) {
        String val = props.getProperty(key, null);
        if (val == null) {
            return def;
        }
        return val.equals("true");
    }

    static BRelTime get(Properties props, String key, long def) throws Exception {
        String val = props.getProperty(key, null);
        if (val == null) {
            return BRelTime.make((long)def);
        }
        return BRelTime.make((String)val);
    }

    static BFacets get(Properties props, String key, BFacets def) throws Exception {
        String val = props.getProperty(key, null);
        if (val == null) {
            return def;
        }
        return BFacets.make((String)val);
    }

    public BFoxSession getFoxSession() {
        return this.foxSession;
    }

    public void debug() {
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        while (g.getParent() != null) {
            g = g.getParent();
        }
        System.out.println("---- Threads ---");
        BNiagaraWbApplet.dumpThreads(g, "");
    }

    static void dumpThreads(ThreadGroup g, String indent) {
        System.out.println(indent + g.getName() + " : " + g.getClass().getName());
        System.out.println(indent + "{");
        ThreadGroup[] subs = new ThreadGroup[g.activeGroupCount()];
        g.enumerate(subs, false);
        for (int i = 0; i < subs.length; ++i) {
            ThreadGroup s = subs[i];
            if (s == null) continue;
            if (s.getParent() != g) {
                System.out.print("ERR>");
            }
            BNiagaraWbApplet.dumpThreads(subs[i], indent + "  ");
        }
        Thread[] threads = new Thread[g.activeCount()];
        g.enumerate(threads, false);
        for (int i = 0; i < threads.length; ++i) {
            Thread t = threads[i];
            if (t == null) continue;
            if (t.getThreadGroup() != g) {
                System.out.print("ERR>");
            }
            System.out.println(indent + "  " + t.getName() + " [" + t.getPriority() + "]" + (t.isDaemon() ? " daemon" : "") + " : " + t.getClass().getName());
        }
        System.out.println(indent + "}");
    }

    private static final String calcHostNameKey(Applet applet) throws NoSuchAlgorithmException {
        String host = applet.getCodeBase().getHost() + applet.getCodeBase().getPort();
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        byte[] sha1 = digest.digest(host.getBytes());
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < sha1.length; ++i) {
            hexString.append(Integer.toHexString(0xFF & sha1[i]));
        }
        return hexString.toString();
    }

    private long getAutoLogoffPeriod() {
        BGeneralOptions opts = BGeneralOptions.make();
        if (opts.getAutoLogoffEnabled()) {
            return opts.getAutoLogoffPeriod().getMillis();
        }
        return Long.MAX_VALUE;
    }

    private boolean isCookieDigest() {
        try {
            BWebService ws = this.getWebService();
            return ws.getAuthenticationScheme() == BAuthenticationType.cookieDigest;
        }
        catch (Exception ignore) {
            return true;
        }
    }

    private void startKeepalive(URL pingUrl) {
        if (this.keepaliveThread != null && this.keepaliveThread.alive) {
            return;
        }
        if (!this.isCookieDigest()) {
            return;
        }
        try {
            long autoLogoffPeriod = this.getAutoLogoffPeriod();
            this.keepaliveThread = new KeepaliveThread(autoLogoffPeriod, pingUrl);
            this.keepaliveThread.start();
        }
        catch (Exception e) {
            log.error("Error starting keepalive. You may experience timeouts.", (Throwable)e);
        }
    }

    private void stopKeepalive() {
        if (this.keepaliveThread != null) {
            this.keepaliveThread.kill();
            this.keepaliveThread = null;
        }
    }

    private BWebService getWebService() {
        BOrd ord = BOrd.make((String)"service:web:WebService");
        BWebService webService = (BWebService)ord.get((BObject)this.foxSession);
        webService.lease();
        return webService;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class KeepaliveThread
    extends Thread {
        private boolean alive = true;
        private long inactive;
        private long inactivityTimeout;
        private static final long PING_INTERVAL = 30000L;
        private URL url;

        KeepaliveThread(long inactivityTimeout, URL url) {
            super("BWbNiagaraApplet#KeepaliveThread");
            this.inactivityTimeout = inactivityTimeout;
            this.url = url;
        }

        private BNiagaraWidgetApplication getApp() {
            return (BNiagaraWidgetApplication)UiEnv.app;
        }

        public void kill() {
            this.alive = false;
            this.interrupt();
        }

        public void run() {
            BNiagaraWidgetApplication.InactivityListener listener = new BNiagaraWidgetApplication.InactivityListener(){

                public void onInactivity(long millisInactive) {
                    KeepaliveThread.this.inactive = millisInactive;
                }
            };
            this.getApp().addInactivityListener(listener);
            try {
                while (this.alive) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (!this.alive) continue;
                    if (this.inactive < this.inactivityTimeout) {
                        if (!BNiagaraWbApplet.this.getApplet().isActive()) {
                            this.alive = false;
                            continue;
                        }
                        this.connect();
                        continue;
                    }
                    this.alive = false;
                }
            }
            catch (IOException e) {
                this.alive = false;
            }
            finally {
                this.getApp().removeInactivityListener(listener);
            }
        }

        private void connect() throws IOException {
            InputStream in = null;
            try {
                HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
                in = conn.getInputStream();
                while (in.read() != -1) {
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    class LastSideBarInfo {
        BSideBarPane lastSideBar = null;
        boolean lastSideBarVisible = true;
        double lastSideBarPosition = 30.0;

        LastSideBarInfo() {
        }
    }
}

