/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.service;

import com.tridium.workbench.service.BWbServiceSpec;
import java.util.ArrayList;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.options.BOptions;
import javax.baja.workbench.tool.BWbService;
import javax.baja.workbench.tool.WbServiceManager;

public class BWbServiceManager
extends BOptions
implements WbServiceManager {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$service$BWbServiceManager == null ? (class$com$tridium$workbench$service$BWbServiceManager = BWbServiceManager.class$("com.tridium.workbench.service.BWbServiceManager")) : class$com$tridium$workbench$service$BWbServiceManager));
    private static BWbServiceManager options;
    public static final Log log;
    static /* synthetic */ Class class$com$tridium$workbench$service$BWbServiceManager;

    public Type getType() {
        return TYPE;
    }

    public static BWbServiceManager make() {
        if (options == null) {
            options = (BWbServiceManager)BOptions.load((Type)TYPE);
        }
        return options;
    }

    public void boot() {
        log.trace("Booting...");
        this.syncWithInstalledServices();
        this.autoStart();
        log.trace("Booted!");
    }

    private void syncWithInstalledServices() {
        BWbServiceSpec[] specs = this.getSpecs();
        for (int i = 0; i < specs.length; ++i) {
            specs[i].setInstalled(false);
        }
        TypeInfo[] installed = BWbService.getInstalled();
        for (int i = 0; i < installed.length; ++i) {
            BWbServiceSpec spec = this.getSpec(installed[i]);
            spec.setInstalled(true);
            spec.typeInfo = installed[i];
        }
    }

    public void autoStart() {
        BWbServiceSpec[] specs = this.getSpecs();
        for (int i = 0; i < specs.length; ++i) {
            if (!specs[i].getAutoStart()) continue;
            specs[i].start();
        }
    }

    public void shutdown() {
        BWbServiceSpec[] specs = this.getSpecs();
        for (int i = 0; i < specs.length; ++i) {
            specs[i].stop();
        }
    }

    public void start(TypeInfo serviceType) {
        this.getSpec(serviceType).start();
    }

    public void start(BWbService service) {
        this.getSpec(service).start();
    }

    public void stop(TypeInfo serviceType) {
        this.getSpec(serviceType).stop();
    }

    public void stop(BWbService service) {
        this.getSpec(service).stop();
    }

    public boolean isRunning(TypeInfo serviceType) {
        return this.getSpec(serviceType).getRunning();
    }

    public boolean isAutoStart(TypeInfo serviceType) {
        return this.getSpec(serviceType).getAutoStart();
    }

    public void setAutoStart(TypeInfo serviceType, boolean autoStart) {
        this.getSpec(serviceType).updateAutoStart(autoStart);
    }

    public BWbServiceSpec[] getSpecs() {
        ArrayList<BObject> v = new ArrayList<BObject>();
        SlotCursor c = this.getProperties();
        while (c.next()) {
            if (!(c.get() instanceof BWbServiceSpec)) continue;
            v.add(c.get());
        }
        return v.toArray(new BWbServiceSpec[v.size()]);
    }

    public BWbServiceSpec getSpec(TypeInfo serviceTypeInfo) {
        String name = SlotPath.escape((String)serviceTypeInfo.toString());
        BWbServiceSpec spec = (BWbServiceSpec)this.get(name);
        if (spec == null) {
            if (!serviceTypeInfo.is(BWbService.TYPE.getTypeInfo())) {
                throw new IllegalArgumentException("TypeInfo not instance of workbench:WbService");
            }
            spec = new BWbServiceSpec();
            spec.setServiceType(serviceTypeInfo.getTypeSpec());
            this.add(name, (BValue)spec);
        }
        return spec;
    }

    public BWbServiceSpec getSpec(BWbService service) {
        return this.getSpec(service.getType().getTypeInfo());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        log = Log.getLog((String)"wb.service");
    }
}

