/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.propsheet;

import com.tridium.workbench.propsheet.BPropertyEntry;
import com.tridium.workbench.propsheet.BPropertySheet;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BValue;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

public class PropSheetState {
    static Array history = new Array();
    final String key;
    Array expands = new Array();

    static void save(BPropertySheet view) {
        try {
            String key = PropSheetState.toKey(view);
            PropSheetState state = new PropSheetState(key);
            state.save("", view.sheet.root);
            PropSheetState.add(state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void restore(BPropertySheet view) {
        try {
            String key = PropSheetState.toKey(view);
            PropSheetState state = PropSheetState.get(key);
            if (state != null) {
                state.restore(view.sheet.root);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String toKey(BWbView view) {
        BWbShell shell = view.getWbShell();
        if (shell == null) {
            return null;
        }
        return "" + shell.getActiveOrdTarget().getOrdWithoutViewQuery();
    }

    static PropSheetState get(String key) {
        for (int i = history.size() - 1; i >= 0; --i) {
            PropSheetState state = (PropSheetState)history.get(i);
            if (!state.key.equals(key)) continue;
            return state;
        }
        return (PropSheetState)history.last();
    }

    static void add(PropSheetState state) {
        if (history.size() > 10) {
            history.remove(0);
        }
        history.add((Object)state);
    }

    PropSheetState(String key) {
        this.key = key;
    }

    void save(String path, BPropertyEntry entry) {
        this.expands.add((Object)path);
        BPropertyEntry[] kids = entry.getChildEntries();
        for (int i = 0; i < kids.length; ++i) {
            BPropertyEntry kid = kids[i];
            if (!kid.isExpanded) continue;
            this.save(path + "/" + kid.property.getName(), kid);
        }
    }

    void restore(BPropertyEntry root) {
        if (this.expands.size() == 0) {
            return;
        }
        for (int i = 0; i < this.expands.size(); ++i) {
            String pathStr = (String)this.expands.get(i);
            if (pathStr.length() == 0) continue;
            this.tryToExpand(root, new SlotPath(pathStr));
        }
        root.relayout();
    }

    void tryToExpand(BPropertyEntry entry, SlotPath path) {
        for (int i = 0; i < path.depth(); ++i) {
            String name = path.nameAt(i);
            BValue kid = entry.get("e_" + name);
            if (!(kid instanceof BPropertyEntry)) {
                return;
            }
            entry = (BPropertyEntry)kid;
            entry.expand();
        }
    }
}

