/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.propsheet;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.propsheet.BAtomicEntry;
import com.tridium.workbench.propsheet.BFieldEditorSheet;
import com.tridium.workbench.propsheet.BPropertyEntry;
import com.tridium.workbench.propsheet.BPropertySheetFE;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BAction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BTopic;
import javax.baja.sys.BValue;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.style.IStylable;
import javax.baja.util.BWsAnnotation;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BComplexEntry
extends BPropertyEntry {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$propsheet$BComplexEntry == null ? (class$com$tridium$workbench$propsheet$BComplexEntry = BComplexEntry.class$("com.tridium.workbench.propsheet.BComplexEntry")) : class$com$tridium$workbench$propsheet$BComplexEntry));
    private boolean builtExpansion = false;
    private Object lock = new Object();
    static /* synthetic */ Class class$com$tridium$workbench$propsheet$BComplexEntry;

    public Type getType() {
        return TYPE;
    }

    public BComplexEntry() {
    }

    public BComplexEntry(BFieldEditorSheet sheet, BComplexEntry parent, Property prop, BObject target) {
        super(sheet, parent, prop, target);
    }

    void layoutEntries(int depth) {
        int i;
        BPropertyEntry[] kids = this.getChildEntries();
        double w = this.getWidth();
        double expanderDim = EXPANDER_DIM;
        double expanderX = 5.0 + (double)depth * INDENT;
        double labelX = expanderX + expanderDim + 6.0;
        double maxWidth = 0.0;
        double maxLabel = 0.0;
        for (int i2 = 0; i2 < kids.length; ++i2) {
            maxLabel = Math.max(maxLabel, (double)kids[i2].computeSizes());
        }
        double cx = labelX + maxLabel + 20.0;
        double y = Math.max(16.0, EXPANDER_DIM) + 4.0;
        for (i = 0; i < kids.length; ++i) {
            BPropertyEntry kid = kids[i];
            double ch = Math.max(kid.content.height, kid.label.height) + 4.0;
            kid.expander.x = expanderX;
            kid.expander.y = (ch - expanderDim) / 2.0;
            kid.label.x = labelX;
            kid.label.y = (ch - kid.label.height) / 2.0;
            kid.content.x = cx;
            kid.content.y = 2.0;
            if (kid instanceof BComplexEntry && kid.isExpanded) {
                ((BComplexEntry)kid).layoutEntries(depth + 1);
                kid.setBounds(0.0, y, w, kid.getPreferredHeight());
                y += kid.getPreferredHeight();
                maxWidth = Math.max(maxWidth, kid.getPreferredWidth());
                continue;
            }
            kid.setBounds(0.0, y, w, ch);
            y += kid.getHeight();
            maxWidth = Math.max(maxWidth, kid.content.x + kid.content.width);
        }
        for (i = 0; i < kids.length; ++i) {
            kids[i].positionsComputed();
        }
        this.setPreferredSize(maxWidth, y);
    }

    void computeContentSize() {
        this.content.width = 250.0;
        this.content.height = Math.max(16.0, EXPANDER_DIM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintContent(Graphics g) {
        String summary;
        try {
            summary = this.target.toString(this.sheet.getCurrentContext());
        }
        catch (Throwable e) {
            summary = e.toString();
        }
        double w = font.width(summary);
        g.setBrush(Theme.propertySheetTree().getTextBrush((IStylable)this));
        if (w > 250.0) {
            IRectGeom oldClip = g.getClipBounds();
            String dots = "...";
            double dotsWidth = font.width(dots);
            g.push();
            try {
                g.clip(this.content.x, oldClip.y(), 250.0 - dotsWidth, oldClip.height());
                g.drawString(summary, this.content.x, this.content.y + textBaseline);
            }
            finally {
                g.pop();
            }
            g.drawString("...", this.content.x + 250.0 - dotsWidth, this.content.y + textBaseline);
        } else {
            g.drawString(summary, this.content.x, this.content.y + (this.content.height + font.getAscent() - font.getDescent()) / 2.0);
        }
        this.paintChildren(g);
    }

    boolean isHyperlinkSupported() {
        return this.target.isComponent() && this.getShell() instanceof BWbShell;
    }

    void hyperlink(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        if (shell instanceof BWbShell) {
            ((BWbShell)shell).hyperlink(new HyperlinkInfo(((BINavNode)this.target).getNavOrd(), (BInputEvent)event));
        }
    }

    boolean isExpandable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doExpand() {
        block23: {
            Object target;
            if (this.isBuiltExpansion()) {
                return;
            }
            try {
                this.enterBusy();
                if (this.target instanceof BIPropertyContainer) {
                    target = (BIPropertyContainer)this.target;
                    target.loadSlots();
                    Property[] props = target.getPropertiesArray();
                    for (int i = 0; i < props.length; ++i) {
                        BValue value = target.get(props[i]);
                        if (value instanceof BComponent) {
                            try {
                                ((BComponent)value).lease();
                            }
                            catch (Exception e) {
                                continue;
                            }
                        }
                        this.add((BIPropertyContainer)target, props[i], (BObject)value);
                    }
                    if (target instanceof BComponent) {
                        this.sheet.registerForComponentEvents((BComponent)target);
                    }
                    break block23;
                }
                target = (BComplex)this.target;
                target.loadSlots();
                Property[] props = target.getPropertiesArray();
                for (int i = 0; i < props.length; ++i) {
                    this.add((BComplex)target, props[i], (BObject)target.get(props[i]));
                }
                if (target.isComponent()) {
                    this.sheet.registerForComponentEvents(target.asComponent());
                }
            }
            catch (Throwable e) {
                BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)"Cannot expand", (Throwable)e);
            }
            finally {
                target = this.lock;
                synchronized (target) {
                    this.builtExpansion = true;
                }
                this.exitBusy();
            }
        }
    }

    void add(BComplex target, Property prop, BObject kid) {
        if (Flags.isHidden((BComplex)target, (Slot)prop)) {
            return;
        }
        if (kid instanceof BLink) {
            return;
        }
        if (kid instanceof BWsAnnotation) {
            return;
        }
        if (kid instanceof BAction) {
            return;
        }
        if (kid instanceof BTopic) {
            return;
        }
        String name = prop.getName();
        try {
            BPropertyEntry entry = this.makeEntry(prop, kid);
            String newName = "e_" + name;
            Property p = this.getProperty(newName);
            if (p == null) {
                this.add(newName, (BValue)entry, null);
                if (this.getShell() != null) {
                    entry.init();
                }
            } else {
                BPropertyEntry currentEntry = (BPropertyEntry)this.get(p);
                currentEntry.reloadIcon();
                currentEntry.repaint();
            }
        }
        catch (DuplicateSlotException dse) {
            System.out.println("Duplicate slot exception " + name + " -> " + kid.getType());
            dse.printStackTrace();
        }
        catch (Throwable e) {
            System.out.println("Cannot add entry " + name + " -> " + kid.getType());
            e.printStackTrace();
        }
    }

    void add(BIPropertyContainer target, Property prop, BObject kid) {
        if ((target.getFlags((Slot)prop) & 4) != 0) {
            return;
        }
        if (kid instanceof BLink) {
            return;
        }
        if (kid instanceof BWsAnnotation) {
            return;
        }
        if (kid instanceof BAction) {
            return;
        }
        if (kid instanceof BTopic) {
            return;
        }
        String name = prop.getName();
        try {
            BPropertyEntry entry = this.makeEntry(prop, kid);
            String newName = "e_" + name;
            Property p = this.getProperty(newName);
            if (p == null) {
                this.add(newName, (BValue)entry, null);
                if (this.getShell() != null) {
                    entry.init();
                }
            } else {
                BPropertyEntry currentEntry = (BPropertyEntry)this.get(p);
                currentEntry.reloadIcon();
                currentEntry.repaint();
            }
        }
        catch (DuplicateSlotException dse) {
            System.out.println("Duplicate slot exception " + name + " -> " + kid.getType());
            dse.printStackTrace();
        }
        catch (Throwable e) {
            System.out.println("Cannot add entry " + name + " -> " + kid.getType());
            e.printStackTrace();
        }
    }

    BPropertyEntry makeEntry(Property prop, BObject kid) {
        AgentInfo editor = null;
        editor = this.target instanceof BIPropertyContainer ? this.getEditorType((BIPropertyContainer)this.target, prop, kid) : this.getEditorType((BComplex)this.target, prop, kid);
        boolean isEditorPropSheet = editor.getAgentType().is(BPropertySheetFE.TYPE);
        BPropertyEntry entry = kid.isSimple() || !isEditorPropSheet ? new BAtomicEntry(this.sheet, this, prop, kid, editor) : new BComplexEntry(this.sheet, this, prop, kid);
        return entry;
    }

    AgentInfo getEditorType(BComplex complex, Property prop, BObject kid) {
        BFacets facets = complex.getSlotFacets((Slot)prop);
        return this.getEditorType(kid, facets);
    }

    AgentInfo getEditorType(BIPropertyContainer container, Property prop, BObject kid) {
        BFacets facets = container.getSlotFacets((Slot)prop);
        return this.getEditorType(kid, facets);
    }

    private AgentInfo getEditorType(BObject kid, BFacets facets) {
        String explicit;
        if (facets != null && (explicit = facets.gets("fieldEditor", null)) != null) {
            return Sys.getRegistry().getType(explicit).getAgentInfo();
        }
        BWbShell shell = null;
        try {
            shell = BWbShell.getWbShell((BWidget)this.getShell());
        }
        catch (Exception e) {
            // empty catch block
        }
        AgentList agents = kid.getAgents().filter(BWbFieldEditor.getAgentFilter(shell));
        return agents.getDefault();
    }

    void rebuildEntry(BPropertyEntry oldEntry, BObject newValue) {
        if (newValue.isComponent()) {
            this.sheet.registerForComponentEvents(newValue.asComponent());
        }
        BPropertyEntry newEntry = this.makeEntry(oldEntry.property, newValue);
        this.set(oldEntry.getPropertyInParent(), (BValue)newEntry);
        if (this.getShell() != null) {
            newEntry.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCollapse() {
        if (!this.sheet.unsubscribeOnCollapse || !this.isBuiltExpansion()) {
            return;
        }
        try {
            this.enterBusy();
            Object kids = this.getChildEntries();
            for (int i = 0; i < ((BPropertyEntry[])kids).length; ++i) {
                if (kids[i].isExpandable() && kids[i].isExpanded) {
                    kids[i].collapse();
                }
                this.remove((BComplex)kids[i]);
            }
            if (this.target.isComponent()) {
                this.sheet.unregisterForComponentEvents(this.target.asComponent());
            }
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)"Cannot collapse", (Throwable)e);
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.builtExpansion = false;
            }
            this.exitBusy();
        }
    }

    public void init() {
        BPropertyEntry[] kids = this.getChildEntries();
        for (int i = 0; i < kids.length; ++i) {
            kids[i].init();
        }
    }

    void doUpdate(BObject target) {
        this.target = target;
        if (!this.isBuiltExpansion()) {
            return;
        }
        if (target instanceof BIPropertyContainer) {
            BIPropertyContainer targetContainer = (BIPropertyContainer)target;
            Property[] props = targetContainer.getPropertiesArray();
            for (int i = 0; i < props.length; ++i) {
                BPropertyEntry kid = (BPropertyEntry)this.get("e_" + props[i].getName());
                if (kid == null) continue;
                kid.update((BObject)targetContainer.get(props[i]));
            }
        } else {
            BComplex targetComplex = target.asComplex();
            Property[] props = targetComplex.getPropertiesArray();
            for (int i = 0; i < props.length; ++i) {
                BPropertyEntry kid = (BPropertyEntry)this.get("e_" + props[i].getName());
                if (kid == null) continue;
                kid.update((BObject)targetComplex.get(props[i]));
            }
        }
        this.repaint();
    }

    void reorder() {
        if (!this.isBuiltExpansion()) {
            return;
        }
        BPropertyEntry[] kids = this.getChildEntries();
        if (kids == null || kids.length == 0) {
            return;
        }
        Property[] newOrder = new Property[kids.length];
        Property[] props = null;
        props = this.target instanceof BIPropertyContainer ? ((BIPropertyContainer)this.target).getPropertiesArray() : this.target.asComplex().getPropertiesArray();
        int n = 0;
        block0: for (int i = 0; i < props.length; ++i) {
            String name = "e_" + props[i].getName();
            for (int j = 0; j < kids.length; ++j) {
                if (!kids[j].getName().equals(name)) continue;
                newOrder[n++] = kids[j].getPropertyInParent();
                continue block0;
            }
        }
        if (n != newOrder.length) {
            System.out.println("BPropertyEntry.reorder problems!!!");
            return;
        }
        this.reorder(newOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBuiltExpansion() {
        Object object = this.lock;
        synchronized (object) {
            return this.builtExpansion;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

