/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.pathbar;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.auth.BCnxHandler;
import com.tridium.workbench.pathbar.BPathBarAgent;
import com.tridium.workbench.pathbar.BPathBarButton;
import com.tridium.workbench.pathbar.PathBarHyperlinkCommand;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BViewTab;
import java.util.ArrayList;
import javax.baja.agent.AgentInfo;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavFileNode;
import javax.baja.nav.BNavRoot;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;

public class BPathBar
extends BEdgePane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$pathbar$BPathBar == null ? (class$com$tridium$workbench$pathbar$BPathBar = BPathBar.class$("com.tridium.workbench.pathbar.BPathBar")) : class$com$tridium$workbench$pathbar$BPathBar));
    private static final BImage errIcon = BImage.make((String)"module://icons/x16/error.png");
    private static final BImage editIcon = BImage.make((String)"module://icons/x16/edit.png");
    private static final BImage defaultViewIcon = BImage.make((String)"module://icons/x16/views/view.png");
    private static final int menuLimit = 30;
    public final BNiagaraWbShell shell;
    private BINavNode root;
    private BPathBarButton[] buttons;
    private BViewTab tab;
    private BWidget view;
    private boolean restrictToNavFile = false;
    private boolean showViewMenu = true;
    static /* synthetic */ Class class$com$tridium$workbench$pathbar$BPathBar;

    public Type getType() {
        return TYPE;
    }

    public BPathBar() {
        throw new IllegalStateException();
    }

    public BPathBar(BNiagaraWbShell shell) {
        this.shell = shell;
    }

    public void setRestrictToNavFile(boolean v) {
        this.restrictToNavFile = v;
    }

    public void setShowViewMenu(boolean v) {
        this.showViewMenu = v;
    }

    public void computePreferredSize() {
        if (this.buttons == null) {
            this.setPreferredSize(200.0, 26.0);
        } else {
            super.computePreferredSize();
        }
    }

    public void doLayout(BWidget[] kids) {
        double dw;
        if (this.buttons != null) {
            for (int i = 0; i < this.buttons.length; ++i) {
                this.buttons[i].reset();
            }
        }
        super.doLayout(kids);
        if (this.buttons == null) {
            return;
        }
        BWidget center = this.getCenter();
        BWidget right = this.getRight();
        center.computePreferredSize();
        right.computePreferredSize();
        double w = this.getWidth() - 5.0;
        double pw = center.getPreferredWidth() + right.getPreferredWidth();
        for (int i = 0; pw > w && i < this.buttons.length - 1; pw -= dw - this.buttons[i].getPreferredWidth(), ++i) {
            this.buttons[i].computePreferredSize();
            dw = this.buttons[i].getPreferredWidth();
            this.buttons[i].setText("");
            this.buttons[i].computePreferredSize();
        }
        center.layout();
    }

    public void paint(Graphics g) {
        super.paint(g);
        double w = this.getWidth() - 1.0;
        double h = this.getHeight() - 1.0;
        BBrush background = Theme.pathBar().getControlBackground((IStylable)this);
        BBrush highlight = Theme.pathBar().getControlHighlight((IStylable)this);
        BBrush shadow = Theme.pathBar().getControlShadow((IStylable)this);
        BBrush outline = Theme.pathBar().getControlForeground((IStylable)this);
        g.setBrush(highlight);
        g.strokeLine(0.0, h, w, h);
        g.strokeLine(w, 0.0, w, h);
        g.setBrush(shadow);
        g.strokeLine(0.0, 0.0, w, 0.0);
        g.strokeLine(0.0, 0.0, 0.0, h);
        g.setBrush(outline);
        g.strokeRect(1.0, 1.0, w - 2.0, h - 2.0);
        if (this.showViewMenu && this.view != null) {
            double x = w - this.view.getWidth() - 2.0;
            g.setBrush(outline);
            g.strokeLine(x, 1.0, x, h - 1.0);
            g.strokeLine(x - 4.0, 1.0, x - 4.0, h - 1.0);
            g.setBrush(highlight);
            g.strokeLine(x - 3.0, 1.0, x - 3.0, h);
            g.setBrush(background);
            g.strokeLine(x - 2.0, 0.0, x - 2.0, h);
            g.setBrush(shadow);
            g.strokeLine(x - 1.0, 0.0, x - 1.0, h);
        }
    }

    public String getStyleSelector() {
        return "path-bar";
    }

    public void update(BViewTab tab) {
        if (this.root == null) {
            BOrd ord = this.shell.getProfile().getNavRootOrd();
            this.root = (BINavNode)ord.resolve().get();
        }
        this.tab = tab;
        this.buttons = null;
        BPathBarAgent[] pa = tab.getPathBarAgents();
        BOrd ord = tab.getOrd();
        if (tab.getTarget() == null || pa == null) {
            this.setToError(ord);
            return;
        }
        String viewText = "";
        BImage viewIcon = errIcon;
        if (tab.getView() != null) {
            AgentInfo agent = tab.getViewAgent();
            viewText = agent.getDisplayName(null);
            viewIcon = BImage.make((BIcon)agent.getIcon(null));
        }
        BPathBarButton viewButton = new BPathBarButton(this.shell, viewIcon, viewText);
        viewButton.setMenuController(new ViewController());
        viewButton.setPinArrow(true);
        this.view = viewButton;
        ArrayList<BPathBarButton> list = new ArrayList<BPathBarButton>();
        for (int i = 0; i < pa.length; ++i) {
            if (this.root != null && this.root != BNavRoot.INSTANCE) {
                try {
                    BINavNode nav;
                    for (nav = pa[i].nav(); nav != null && nav != this.root; nav = nav.getNavParent()) {
                    }
                    if (nav == null) {
                        continue;
                    }
                }
                catch (Exception e) {
                    break;
                }
            }
            if (this.restrictToNavFile && pa[i].nav() instanceof BISession) continue;
            BPathBarButton b = new BPathBarButton(this.shell, pa[i].getAgentIcon(), pa[i].getAgentText());
            if (this.root != null && this.root != BNavRoot.INSTANCE && this.root == pa[i].nav()) {
                if (!this.restrictToNavFile || this.restrictToNavFile && pa[i].nav() instanceof BNavFileNode) {
                    b.setPinArrow(true);
                    b.setMenuController(new AgentController(pa[i]));
                } else {
                    b.setEnabled(false);
                }
            } else {
                BOrd navord = pa[i].getAgentOrd();
                if (navord != null && !navord.isNull()) {
                    b.setCommand(new PathBarHyperlinkCommand((BWidget)this.shell, null, null, navord));
                }
                if (!this.restrictToNavFile || this.restrictToNavFile && pa[i].nav() instanceof BNavFileNode) {
                    if (i == 0) {
                        b.setMenuController(new HostController());
                    } else {
                        b.setMenuController(new AgentController(pa[i]));
                    }
                } else {
                    b.setEnabled(false);
                }
            }
            list.add(b);
        }
        if (list.isEmpty()) {
            this.setToError(ord);
            return;
        }
        this.buttons = new BPathBarButton[list.size()];
        BGridPane grid = new BGridPane(list.size());
        grid.setColumnGap(0.0);
        grid.setHalign(BHalign.left);
        for (int i = 0; i < list.size(); ++i) {
            BPathBarButton b;
            this.buttons[i] = b = (BPathBarButton)((Object)list.get(i));
            grid.add(null, (BValue)b);
        }
        if (this.showViewMenu) {
            this.setContents((BWidget)grid, viewButton);
        } else {
            this.setContents((BWidget)grid, (BWidget)new BNullWidget());
        }
    }

    private void setToError(BOrd ord) {
        this.view = null;
        BLabel err = new BLabel(errIcon, String.valueOf(ord));
        err.setForeground(BColor.white.toBrush());
        err.setHalign(BHalign.left);
        this.setContents((BWidget)new BBorderPane((BWidget)err, 0.0, 0.0, 0.0, 5.0), (BWidget)new BNullWidget());
    }

    private void setContents(BWidget center, BWidget right) {
        this.setCenter((BWidget)new BBorderPane(center, 2.0, 0.0, 2.0, 2.0));
        this.setRight((BWidget)new BBorderPane(right, 2.0, 2.0, 2.0, 0.0));
    }

    private BMenu makeSubMenu(BWbShell shell, BINavNode[] kids, int start) {
        BMenu menu = new BMenu("More");
        for (int i = start; i < start + 30 && i < kids.length; ++i) {
            menu.add(null, (Command)new PathBarHyperlinkCommand((BWidget)shell, BImage.make((BIcon)kids[i].getNavIcon()), kids[i].getNavDisplayName(null), kids[i].getNavOrd()));
        }
        return menu;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ViewController
    implements BPathBarButton.MenuController {
        ViewController() {
        }

        public BMenu getMenu() {
            return NavMenuUtil.makeViewsMenu((BWidget)BPathBar.this, BPathBar.this.tab.getTarget().get(), BPathBar.this.tab.getOrd());
        }
    }

    class AgentController
    implements BPathBarButton.MenuController {
        private BPathBarAgent agent;

        public AgentController(BPathBarAgent agent) {
            this.agent = agent;
        }

        public BMenu getMenu() {
            int i;
            BINavNode[] kids = this.agent.getChildren();
            Command[] cmds = this.agent.getCommands(BPathBar.this.shell);
            if (kids == null && cmds == null) {
                return null;
            }
            BMenu menu = new BMenu();
            if (kids != null) {
                for (i = 0; i < 30 && i < kids.length; ++i) {
                    menu.add(null, (Command)new PathBarHyperlinkCommand((BWidget)BPathBar.this.shell, BImage.make((BIcon)kids[i].getNavIcon()), kids[i].getNavDisplayName(null), kids[i].getNavOrd()));
                }
                BMenu prev = menu;
                while (i < kids.length - 1) {
                    BMenu sub = BPathBar.this.makeSubMenu(BPathBar.this.shell, kids, i);
                    prev.add(null, (BValue)new BSubMenuItem(sub));
                    prev = sub;
                    i += 30;
                }
            }
            if (cmds != null) {
                for (i = 0; i < cmds.length; ++i) {
                    if (i == 0 && kids != null) {
                        menu.add(null, (BValue)new BSeparator());
                    }
                    menu.add(null, cmds[i]);
                }
            }
            return menu;
        }
    }

    class HostController
    implements BPathBarButton.MenuController {
        HostController() {
        }

        public BMenu getMenu() {
            BMenu menu = new BMenu();
            BINavNode[] hosts = BNavRoot.INSTANCE.getNavChildren();
            for (int i = 0; i < hosts.length; ++i) {
                BMenu sub = new BMenu(hosts[i].getNavDisplayName(null));
                BINavNode[] kids = hosts[i].getNavChildren();
                for (int j = 0; j < kids.length; ++j) {
                    sub.add(null, (Command)new PathBarHyperlinkCommand((BWidget)BPathBar.this.shell, BImage.make((BIcon)kids[j].getNavIcon()), kids[j].getNavDisplayName(null), kids[j].getNavOrd()));
                }
                Command[] sessionOpens = BCnxHandler.getCnxCommands((BWidget)BPathBar.this.shell, (BHost)hosts[i]);
                for (int k = 0; k < sessionOpens.length; ++k) {
                    if (k == 0 && kids.length > 0) {
                        sub.add(null, (BValue)new BSeparator());
                    }
                    sub.add(null, sessionOpens[k]);
                }
                BSubMenuItem item = new BSubMenuItem(sub);
                item.setImage(BImage.make((BIcon)hosts[i].getNavIcon()));
                menu.add(null, (BValue)item);
            }
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, BPathBar.this.shell.commands.findStations);
            return menu;
        }
    }
}

