/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.ord;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.fieldeditors.BDialogFE;
import javax.baja.gx.BFont;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.options.BMruButton;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BIValidator;
import javax.baja.util.CannotValidateException;
import javax.baja.util.Lexicon;

public class BHostOrdFE
extends BDialogFE
implements BIValidator {
    public static final Action dropDownModified = BHostOrdFE.newAction((int)0, null);
    public static final Action textModified = BHostOrdFE.newAction((int)0, null);
    public static final Action mruModified = BHostOrdFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$ord$BHostOrdFE == null ? (class$com$tridium$workbench$ord$BHostOrdFE = BHostOrdFE.class$("com.tridium.workbench.ord.BHostOrdFE")) : class$com$tridium$workbench$ord$BHostOrdFE));
    private static final Lexicon wbLexicon = Lexicon.make((Class)(class$com$tridium$workbench$ord$BHostOrdFE == null ? (class$com$tridium$workbench$ord$BHostOrdFE = BHostOrdFE.class$("com.tridium.workbench.ord.BHostOrdFE")) : class$com$tridium$workbench$ord$BHostOrdFE));
    protected static UiLexicon bajaUiLex = UiLexicon.bajaui();
    protected static final BFont bold = Theme.widget().getBoldText();
    protected HostScheme[] schemes = new HostScheme[0];
    protected String hostScheme;
    protected String body;
    protected BListDropDown dropDown;
    protected BTextField bodyField;
    protected BTextField port;
    protected BLabel tunnelLabel;
    protected BTextField cnxTunnelPath = null;
    protected int tunnelSchemeIndex = 1;
    protected boolean portEditableOnReadonly = false;
    protected BMruButton history;
    protected boolean autoSaveHistory = true;
    protected boolean local = false;
    protected String localBody = null;
    static /* synthetic */ Class class$com$tridium$workbench$ord$BHostOrdFE;
    static /* synthetic */ Class class$com$tridium$workbench$ord$BHostOrdFE$HostScheme;
    static /* synthetic */ Class class$java$lang$String;

    public void dropDownModified() {
        this.invoke(dropDownModified, null, null);
    }

    public void textModified() {
        this.invoke(textModified, null, null);
    }

    public void mruModified() {
        this.invoke(mruModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BHostOrdFE() {
        this.setContent(this.buildContent());
    }

    protected BWidget buildContent() {
        this.schemes = this.buildHostSchemes();
        this.history = new BMruButton("hostOrdFE");
        this.history.setMruController((BMruButton.MruController)new MruController());
        this.history.setButtonStyle(BButtonStyle.toolBar);
        BAbstractButton.MenuController menuController = this.getHistoryMenuController();
        if (menuController != null) {
            this.history.setMenuController(menuController);
        }
        this.dropDown = new BListDropDown();
        for (int i = 0; i < this.schemes.length; ++i) {
            this.dropDown.getList().addItem((Object)this.schemes[i]);
        }
        this.dropDown.setSelectedIndex(0);
        this.bodyField = new BTextField("", 16);
        this.linkTo((BComponent)this.bodyField, (Slot)BTextField.textModified, (Slot)textModified);
        this.linkTo((BComponent)this.bodyField, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.linkTo((BComponent)this.bodyField, (Slot)BTextField.textModified, (Slot)setModified);
        BGridPane grid = new BGridPane(4);
        grid.setHalign(BHalign.left);
        grid.add(null, (BValue)this.dropDown);
        grid.add(null, (BValue)this.bodyField);
        grid.add(null, (BValue)this.getEditButton());
        grid.add(null, (BValue)this.history);
        this.linkTo(null, (BComponent)this.dropDown, (Slot)BListDropDown.listActionPerformed, (Slot)dropDownModified);
        this.linkTo(null, (BComponent)this.dropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        return grid;
    }

    protected HostScheme[] buildHostSchemes() {
        Array schemes = new Array(class$com$tridium$workbench$ord$BHostOrdFE$HostScheme == null ? (class$com$tridium$workbench$ord$BHostOrdFE$HostScheme = BHostOrdFE.class$("com.tridium.workbench.ord.BHostOrdFE$HostScheme")) : class$com$tridium$workbench$ord$BHostOrdFE$HostScheme);
        try {
            schemes.add((Object)new IpScheme());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            schemes.add((Object)new PlatformTunnelScheme());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (HostScheme[])schemes.trim();
    }

    protected BAbstractButton.MenuController getHistoryMenuController() {
        return new MenuController();
    }

    protected void doSetReadonly(boolean readonly) {
        super.doSetReadonly(readonly);
        this.bodyField.setEditable(!readonly);
        this.history.setEnabled(!readonly);
        this.getEditButton().setVisible(!readonly);
        if (this.dropDown != null) {
            this.dropDown.setDropDownEnabled(this.portEditableOnReadonly || !readonly);
        }
        if (this.port != null) {
            this.port.setEditable(this.portEditableOnReadonly || !readonly);
        }
        if (this.tunnelLabel != null) {
            this.tunnelLabel.setEnabled(this.portEditableOnReadonly || !readonly);
        }
        if (this.cnxTunnelPath != null) {
            this.cnxTunnelPath.setEditable(this.portEditableOnReadonly || !readonly);
        }
    }

    protected void doLoadValue(BObject v, Context cx) {
        BBoolean b;
        BOrd ord = (BOrd)v;
        if (cx != null && (b = (BBoolean)cx.getFacet("mruAutoSave")) != null) {
            this.setAutoSaveHistory(b.getBoolean());
        }
        String scheme = "ip";
        String body = "";
        if (null != ord && !ord.isNull()) {
            OrdQuery[] queries = ord.parse();
            if (queries.length > 0) {
                OrdQuery q = queries[0];
                scheme = q.getScheme();
                this.local = scheme.equals("local");
                if (this.local) {
                    try {
                        body = Sys.getLocalHost().getHostName();
                    }
                    catch (Exception e) {
                        body = null;
                    }
                    this.localBody = body;
                }
                if (!this.local || body == null) {
                    body = q.getBody();
                }
            }
            if (!this.local) {
                for (int i = 0; i < this.schemes.length; ++i) {
                    if (!scheme.equals(this.schemes[i].scheme)) continue;
                    this.dropDown.setSelectedIndex(i);
                    break;
                }
            } else {
                this.hostScheme = scheme;
                for (int i = 0; i < this.schemes.length; ++i) {
                    if (!this.schemes[i].scheme.equals("ip")) continue;
                    this.dropDown.setSelectedIndex(i);
                    break;
                }
            }
        }
        if (!this.local) {
            this.doDropDownModified();
        }
        this.bodyField.setText(body);
    }

    protected BObject doSaveValue(BObject v, Context cx) {
        this.body = this.local ? "" : this.bodyField.getText();
        BOrd host = BOrd.make((String)(this.hostScheme + ":" + this.body));
        if (this.autoSaveHistory) {
            this.saveHistory(host);
        }
        return host;
    }

    public final void saveHistory() {
        this.saveHistory((BOrd)this.getCurrentValue());
    }

    protected final void saveHistory(BOrd host) {
        try {
            this.history.getMruOptions().save(host.encodeToString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAutoSaveHistory(boolean b) {
        this.autoSaveHistory = b;
    }

    public boolean getAutoSaveHistory() {
        return this.autoSaveHistory;
    }

    public boolean isTunnelScheme() {
        return this.dropDown.getSelectedItem() instanceof PlatformTunnelScheme;
    }

    public void setTunnelSelected() {
        if (this.isTunnelScheme()) {
            return;
        }
        for (int idx = 0; idx < this.dropDown.getList().getItemCount(); ++idx) {
            if (!((HostScheme)this.dropDown.getList().getItem(idx) instanceof PlatformTunnelScheme)) continue;
            this.dropDown.setSelectedIndex(idx);
            break;
        }
    }

    public void setTunnelAuthorities(String[] tunnelAuthorities) {
        if (null == tunnelAuthorities) {
            return;
        }
        String join = TextUtil.join((String[])tunnelAuthorities, (char)'/');
        if (this.cnxTunnelPath != null) {
            this.cnxTunnelPath.setText(join);
        }
        this.repaint();
    }

    public void doTextModified() {
        if (this.local && this.localBody != null && !this.bodyField.getText().equals(this.localBody)) {
            HostScheme host = (HostScheme)this.dropDown.getSelectedItem();
            this.hostScheme = host.scheme;
            this.local = false;
        }
    }

    public void doDropDownModified() {
        HostScheme host = (HostScheme)this.dropDown.getSelectedItem();
        this.hostScheme = host.scheme;
        this.getEditButton().setEnabled(!(host instanceof IpScheme));
        if (this.cnxTunnelPath != null) {
            this.cnxTunnelPath.setText("");
        }
        this.getEditButton().repaint();
        this.local = false;
    }

    public void doMruModified() {
        this.textModified();
    }

    public void validate(BObject value, Context cx) throws CannotValidateException {
        BOrd ord = (BOrd)value;
        OrdQuery[] query = ord.parse();
        if (query.length == 0) {
            return;
        }
        for (int i = 0; i < query.length; ++i) {
            if (!query[i].getScheme().equalsIgnoreCase("ip")) continue;
            String hostname = query[i].getBody();
            if (IPAddressUtil.isNumericAddr((String)hostname)) {
                return;
            }
            if (IPAddressUtil.isHostname((String)hostname)) {
                return;
            }
            throw new CannotValidateException("Invalid hostname: " + hostname);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Entry
    extends Command {
        private String value;
        private BMruButton.MruController controller;

        public Entry(BWidget owner, String value, BMruButton.MruController controller) {
            super(owner, controller.toDisplayString(value));
            this.value = value;
            this.controller = controller;
        }

        public CommandArtifact doInvoke() {
            this.controller.select(this.value);
            return null;
        }
    }

    class MenuController
    implements BAbstractButton.MenuController {
        MenuController() {
        }

        public boolean isMenuDistinct() {
            return false;
        }

        public BMenu getMenu(BAbstractButton b) {
            BMruButton mruButton = (BMruButton)b;
            BMruButton.MruController controller = mruButton.getMruController();
            BMenu menu = new BMenu();
            String[] v = mruButton.getMruOptions().getHistory(mruButton.getFilter());
            Array values = new Array(class$java$lang$String == null ? (class$java$lang$String = BHostOrdFE.class$("java.lang.String")) : class$java$lang$String);
            for (int i = 0; i < v.length; ++i) {
                OrdQuery[] queries;
                String value = v[i];
                BOrd ord = BOrd.make((String)value);
                if (!ord.isNull() && (queries = ord.parse()).length > 0) {
                    value = queries[0].toString();
                }
                if (values.contains((Object)value)) continue;
                values.add((Object)value);
                menu.add(null, (Command)new Entry((BWidget)b, value, controller));
            }
            return menu;
        }
    }

    class MruController
    extends BMruButton.MruController {
        MruController() {
        }

        public void select(String value) {
            BFacets mruFacets = BFacets.make((BFacets)BHostOrdFE.this.getCurrentContext().getFacets(), (BFacets)BFacets.make((String)"MruControllerSelect", (boolean)true));
            BHostOrdFE.this.loadValue((BObject)BOrd.make((String)value), (Context)mruFacets);
            BHostOrdFE.this.mruModified();
            BHostOrdFE.this.setModified();
        }
    }

    public static class PlatformTunnelScheme
    extends IpScheme {
        PlatformTunnelScheme() {
            this.scheme = "ip";
            this.displayName = wbLexicon.getText("hostScheme.tunnelplat");
        }
    }

    public static class IpScheme
    extends HostScheme {
        public IpScheme() {
            super("ip");
        }
    }

    public static abstract class HostScheme {
        public String scheme;
        public String displayName;

        public HostScheme(String scheme) {
            this.scheme = scheme;
            this.displayName = wbLexicon.getText("hostScheme." + scheme);
        }

        public String toString() {
            return this.displayName;
        }
    }
}

