/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav.editor;

import com.tridium.workbench.nav.editor.BNavFileEditor;
import com.tridium.workbench.nav.editor.Node;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.space.Mark;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.treetable.TreeTableNode;

public class TransferSupport {
    BNavFileEditor editor;

    public TransferSupport(BNavFileEditor editor) {
        this.editor = editor;
    }

    private Node addNodeCopy(Node target, Node n) {
        Node foo = new Node(target, this.editor.getValidName(target, n.name), n.ord, n.icon);
        for (int i = 0; i < n.getChildCount(); ++i) {
            Node child = this.addNodeCopy(foo, (Node)n.getChild(i));
            foo.kids.add(child);
        }
        return foo;
    }

    public CommandArtifact insert(Node target, TransferContext cx) throws Exception {
        Node[] nodes;
        String s = (String)cx.getEnvelope().getData(TransferFormat.string);
        if (s.startsWith("navFileEditorNode")) {
            nodes = new Node[this.editor.dragNodes.length];
            for (int i = 0; i < this.editor.dragNodes.length; ++i) {
                nodes[i] = this.addNodeCopy(target, this.editor.dragNodes[i]);
            }
        } else {
            Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
            BObject[] obj = mark.getValues();
            nodes = new Node[obj.length];
            for (int i = 0; i < obj.length; ++i) {
                BINavNode nav = (BINavNode)obj[i];
                String name = this.editor.toNodeName(nav);
                BOrd ord = nav.getNavOrd().relativizeToSession();
                BImage icon = BImage.make((BIcon)nav.getNavIcon());
                String temp = name;
                if (i == 0) {
                    temp = this.editor.getValidName(target, temp);
                } else {
                    int counter = 1;
                    for (int j = 0; j < nodes.length && nodes[j] != null; ++j) {
                        if (!nodes[j].name.equals(temp) && temp.equals(this.editor.getValidName(target, temp))) continue;
                        temp = name + counter++;
                        j = -1;
                    }
                }
                nodes[i] = new Node(target, temp, ord, icon);
            }
        }
        InsertArtifact art = new InsertArtifact(target, nodes);
        art.redo();
        return art;
    }

    public CommandArtifact doDelete(boolean drag) throws Exception {
        Node target;
        Node[] kids;
        if (drag) {
            kids = this.editor.dragNodes;
            target = (Node)kids[0].getParent();
        } else {
            ArrayList<TreeTableNode> list = new ArrayList<TreeTableNode>();
            int[] rows = this.editor.model.getSelection().getRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                list.add(this.editor.model.rowToNode(rows[i]));
            }
            kids = list.toArray(new Node[list.size()]);
            target = (Node)kids[0].getParent();
        }
        DeleteArtifact art = new DeleteArtifact(target, kids);
        art.redo();
        return art;
    }

    private void doInsert(Node target, Node[] kids) throws Exception {
        for (int i = 0; i < kids.length; ++i) {
            Node n = new Node(target, kids[i].name, kids[i].ord, kids[i].icon);
            target.kids.add(n);
            if (kids[i].getChildCount() <= 0) continue;
            Node[] subkids = kids[i].kids.toArray(new Node[kids[i].getChildCount()]);
            this.doInsert(n, subkids);
        }
    }

    private void doRemove(Node target, Node[] kids) throws Exception {
        for (int i = 0; i < kids.length; ++i) {
            for (int j = 0; j < target.kids.size(); ++j) {
                Node n = (Node)((Object)target.kids.get(j));
                if (!n.name.equals(kids[i].name)) continue;
                target.kids.remove((Object)n);
            }
        }
    }

    class DeleteArtifact
    extends InsertArtifact {
        public DeleteArtifact(Node target, Node[] kids) {
            super(target, kids);
        }

        public void undo() throws Exception {
            super.redo();
        }

        public void redo() throws Exception {
            super.undo();
        }
    }

    class InsertArtifact
    implements CommandArtifact {
        String[] path;
        Node[] kids;

        public InsertArtifact(Node target, Node[] kids) {
            this.path = TransferSupport.this.editor.toPath(target);
            this.kids = kids;
        }

        public void undo() throws Exception {
            Node target = TransferSupport.this.editor.findNode(this.path);
            TransferSupport.this.doRemove(target, this.kids);
            target.setExpanded(true);
            TransferSupport.this.editor.model.updateTreeTable(true);
            TransferSupport.this.editor.model.getSelection().deselectAll();
            TransferSupport.this.editor.setModified();
        }

        public void redo() throws Exception {
            Node target = TransferSupport.this.editor.findNode(this.path);
            TransferSupport.this.doInsert(target, this.kids);
            target.setExpanded(true);
            TransferSupport.this.editor.model.updateTreeTable(true);
            TransferSupport.this.editor.model.getSelection().deselectAll();
            TransferSupport.this.editor.setModified();
        }
    }
}

