/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.sys.Nre;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavListener;
import javax.baja.nre.util.Array;
import javax.baja.space.BISpaceNode;
import javax.baja.space.BSpace;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.NavTreeNode;

public class NavMonitor
extends Thread {
    public static final long SCAN_RATE = Long.getLong("niagara.nav.touch.scanRate", 20000L);
    static NavMonitor monitor = null;
    static BAbsTime lastScanStart = BAbsTime.NULL;
    static long lastScanTicks = 0L;
    static long minScanTicks = Long.MAX_VALUE;
    static long maxScanTicks = Long.MIN_VALUE;
    static long sumScanTicks = 0L;
    static long numScans = 0L;
    static Log log = Log.getLog((String)"NavMonitor");
    static /* synthetic */ Class class$javax$baja$naming$BOrd;

    public static NavMonitor get() {
        if (monitor == null) {
            log.message("*** NavMonitor lazy init ***");
            NavMonitor.init();
        }
        return monitor;
    }

    public static void init() {
        if (monitor == null) {
            monitor = new NavMonitor();
            monitor.start();
            if (log.isTraceOn()) {
                log.trace("NavMonitor thread started.");
            }
        }
    }

    NavMonitor() {
        super(Nre.mainThreadGroup, "Ui:NavMonitor");
        this.setDaemon(true);
        Spy.ROOT.add("navMonitor", (Spy)new MySpy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (SCAN_RATE <= 0L) {
            if (log.isTraceOn()) {
                log.trace("NavMonitor disabled since SCAN_RATE = " + SCAN_RATE);
            }
            return;
        }
        long waitTime = SCAN_RATE - 500L;
        if (waitTime <= 0L) {
            waitTime = SCAN_RATE;
        }
        if (log.isTraceOn()) {
            log.trace("NavMonitor enabled with SCAN_RATE = " + SCAN_RATE);
        }
        while (true) {
            try {
                while (true) {
                    NavMonitor navMonitor = this;
                    synchronized (navMonitor) {
                        this.wait(waitTime);
                    }
                    Thread.sleep(500L);
                    lastScanStart = BAbsTime.now();
                    long scanStartTicks = Clock.ticks();
                    if (log.isTraceOn()) {
                        log.trace("Performing full TOUCH Scan");
                    }
                    this.scan();
                    NavMonitor navMonitor2 = monitor;
                    synchronized (navMonitor2) {
                        lastScanTicks = Clock.ticks() - scanStartTicks;
                        minScanTicks = Math.min(lastScanTicks, minScanTicks);
                        maxScanTicks = Math.max(lastScanTicks, maxScanTicks);
                        sumScanTicks += lastScanTicks;
                        ++numScans;
                    }
                    if (!log.isTraceOn()) continue;
                    log.trace("Completed full TOUCH Scan in " + lastScanTicks + " ticks");
                }
            }
            catch (Throwable e) {
                log.error("Exception in NavMonitor", e);
                continue;
            }
            break;
        }
    }

    void scan() {
        NavListener[] listeners = BNavRoot.INSTANCE.getNavListeners();
        if (listeners == null) {
            return;
        }
        HashMap<BSpace, Array> bySpace = new HashMap<BSpace, Array>();
        for (int i = 0; i < listeners.length; ++i) {
            TableModel model;
            int rowCount;
            Array bucket;
            BSpace space;
            BISpaceNode spaceNode;
            int j;
            if (listeners[i] instanceof BNavTree) {
                BNavTree navTree = (BNavTree)listeners[i];
                TreeNode[] visibleNodes = navTree.getVisibleNodes();
                if (visibleNodes == null) continue;
                for (j = 0; j < visibleNodes.length; ++j) {
                    BINavNode navNode = ((NavTreeNode)visibleNodes[j]).getNavNode();
                    if (!(navNode instanceof BISpaceNode)) continue;
                    spaceNode = (BISpaceNode)navNode;
                    space = spaceNode.getSpace();
                    bucket = (Array)bySpace.get(space);
                    if (bucket == null) {
                        bucket = new Array(class$javax$baja$naming$BOrd == null ? NavMonitor.class$("javax.baja.naming.BOrd") : class$javax$baja$naming$BOrd);
                        bySpace.put(space, bucket);
                    }
                    bucket.add((Object)spaceNode.getOrdInSpace());
                }
                continue;
            }
            if (!(listeners[i] instanceof TableModel) || (rowCount = (model = (TableModel)listeners[i]).getRowCount()) < 1) continue;
            for (j = 0; j < rowCount; ++j) {
                Object obj = model.getSubject(j);
                if (!(obj instanceof BINavNode) || !(obj instanceof BISpaceNode)) continue;
                spaceNode = (BISpaceNode)obj;
                space = spaceNode.getSpace();
                bucket = (Array)bySpace.get(space);
                if (bucket == null) {
                    bucket = new Array(class$javax$baja$naming$BOrd == null ? NavMonitor.class$("javax.baja.naming.BOrd") : class$javax$baja$naming$BOrd);
                    bySpace.put(space, bucket);
                }
                bucket.add((Object)spaceNode.getOrdInSpace());
            }
        }
        Iterator it = bySpace.keySet().iterator();
        while (it.hasNext()) {
            BSpace space = (BSpace)it.next();
            if (space == null) continue;
            Array bucket = (Array)bySpace.get(space);
            space.fw(110, (Object)((BOrd[])bucket.trim()), null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) {
        out.startProps();
        out.trTitle((Object)"NavMonitor", 2);
        if (SCAN_RATE <= 0L) {
            out.prop((Object)"SCAN_RATE", (Object)(SCAN_RATE + " (disabled)"));
        } else {
            out.prop((Object)"SCAN_RATE", (Object)(SCAN_RATE + " (" + BRelTime.make((long)SCAN_RATE) + ")"));
        }
        out.prop((Object)"lastScanStart", (Object)lastScanStart);
        NavMonitor navMonitor = monitor;
        synchronized (navMonitor) {
            out.prop((Object)"numScans", (Object)("" + numScans));
            out.prop((Object)"lastScanTicks", (Object)(lastScanTicks + " (" + BRelTime.make((long)lastScanTicks) + ")"));
            out.prop((Object)"minScanTicks", (Object)(minScanTicks + " (" + BRelTime.make((long)minScanTicks) + ")"));
            out.prop((Object)"maxScanTicks", (Object)(maxScanTicks + " (" + BRelTime.make((long)maxScanTicks) + ")"));
            if (numScans > 0L) {
                double avgScan = (double)sumScanTicks / (double)numScans;
                out.prop((Object)"avgScanTicks", (Object)(avgScan + " (" + BRelTime.make((long)((long)avgScan)) + ")"));
            }
        }
        out.endProps();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MySpy
    extends Spy {
        MySpy() {
        }

        public void write(SpyWriter out) {
            NavMonitor.this.spy(out);
        }
    }
}

