/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.util.ArrayUtil;
import com.tridium.workbench.shell.BSaveAllDialog;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.BSession;
import javax.baja.nav.BINavNode;
import javax.baja.spy.BSpySpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.HyperlinkCommand;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.BNavMenuAgent;
import javax.baja.workbench.nav.menu.NavMenuUtil;

public class BSessionMenuAgent
extends BNavMenuAgent {
    public static final BSessionMenuAgent INSTANCE = new BSessionMenuAgent();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$nav$BSessionMenuAgent == null ? (class$com$tridium$workbench$nav$BSessionMenuAgent = BSessionMenuAgent.class$("com.tridium.workbench.nav.BSessionMenuAgent")) : class$com$tridium$workbench$nav$BSessionMenuAgent));
    public static final BModule module = TYPE.getModule();
    public static final UiLexicon lex = new UiLexicon(module);
    static /* synthetic */ Class class$com$tridium$workbench$nav$BSessionMenuAgent;

    public Type getType() {
        return TYPE;
    }

    protected BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        BSession session = (BSession)target;
        BSpySpace spy = (BSpySpace)session.getNavChild("spy");
        BMenu menu = new BMenu();
        if (session.isConnected()) {
            menu.add("views", (BValue)new BSubMenuItem(NavMenuUtil.makeViewsMenu(owner, (BObject)session)));
            menu.add(null, (BValue)new BSeparator());
        }
        menu.add(null, (Command)new Connect(owner, session));
        menu.add(null, (Command)new Disconnect(owner, session));
        menu.add(null, (Command)new Close(owner, session));
        if (spy != null) {
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (Command)new HyperlinkCommand(owner, BImage.make((BIcon)spy.getIcon()), spy.getNavDisplayName(null), spy.getNavOrd()));
        }
        return menu;
    }

    public static boolean confirmDisconnect(BWidget owner, String title, String typeKey, String confirmKey, BINavNode[] objects) {
        String type = objects.length == 1 ? lex.getText(typeKey + ".one", new Object[]{objects[0].getNavDisplayName(null)}) : lex.getText(typeKey + ".batch", new Object[]{"" + objects.length});
        String confirm = lex.getText(confirmKey, new Object[]{type});
        String save = lex.getText("saveBeforeDisconnect", new Object[]{type});
        BOrd[] ords = new BOrd[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            ords[i] = objects[i].getNavOrd();
        }
        int result = BSaveAllDialog.saveAll(owner, save, ords);
        if (result == 2) {
            return false;
        }
        return result != 0 || BDialog.confirm((BWidget)owner, (String)title, (Object)confirm) == 4;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Close
    extends Command {
        BSession[] sessions;

        public Close(BWidget owner, BSession session) {
            this(owner, new BSession[]{session});
        }

        public Close(BWidget owner, BSession[] sessions) {
            super(owner, module, "close");
            this.sessions = sessions;
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BSessionMenuAgent.confirmDisconnect(this.getOwner(), this.getLabel(), "confirm.session", "confirm.close", (BINavNode[])this.sessions)) {
                for (int i = 0; i < this.sessions.length; ++i) {
                    this.sessions[i].close();
                }
                this.getOwner().repaint();
            }
            return null;
        }

        public Command doMerge(Command c) {
            return new Close(this.getOwner(), (BSession[])ArrayUtil.add((Object[])this.sessions, (Object[])((Close)c).sessions));
        }
    }

    public static class Disconnect
    extends Command {
        BSession[] sessions;

        public Disconnect(BWidget owner, BSession session) {
            this(owner, new BSession[]{session});
        }

        public Disconnect(BWidget owner, BSession[] sessions) {
            super(owner, module, "disconnect");
            this.sessions = sessions;
            boolean enabled = false;
            for (int i = 0; i < sessions.length; ++i) {
                enabled |= sessions[i].isConnected();
            }
            this.setEnabled(enabled);
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BSessionMenuAgent.confirmDisconnect(this.getOwner(), this.getLabel(), "confirm.session", "confirm.disconnect", (BINavNode[])this.sessions)) {
                for (int i = 0; i < this.sessions.length; ++i) {
                    this.sessions[i].disconnect();
                }
                this.getOwner().repaint();
            }
            return null;
        }

        public Command doMerge(Command c) {
            return new Disconnect(this.getOwner(), (BSession[])ArrayUtil.add((Object[])this.sessions, (Object[])((Disconnect)c).sessions));
        }
    }

    public static class Connect
    extends Command {
        BSession session;

        public Connect(BWidget owner, BSession session) {
            super(owner, module, "connect");
            this.session = session;
            this.setEnabled(!session.isConnected());
        }

        public CommandArtifact doInvoke() throws Exception {
            BWidgetShell shell = this.getShell();
            if (shell instanceof BWbShell) {
                ((BWbShell)shell).hyperlink(this.session.getNavOrd());
            }
            return null;
        }
    }
}

