/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.util.ArrayList;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.BIAgent;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BICredentials;
import javax.baja.sys.BModule;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.xml.XElem;

public abstract class BSessionAgent
extends BSingleton
implements BIAgent {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$nav$BSessionAgent == null ? (class$com$tridium$workbench$nav$BSessionAgent = BSessionAgent.class$("com.tridium.workbench.nav.BSessionAgent")) : class$com$tridium$workbench$nav$BSessionAgent));
    static AgentFilter agentFilter = AgentFilter.is((Type)TYPE);
    static /* synthetic */ Class class$com$tridium$workbench$nav$BSessionAgent;

    public static BSessionAgent[] list() {
        TypeInfo[] types = Sys.getRegistry().getTypes(TYPE.getTypeInfo());
        ArrayList<BSessionAgent> list = new ArrayList<BSessionAgent>();
        for (int i = 0; i < types.length; ++i) {
            try {
                Type t = types[i].getTypeSpec().getResolvedType();
                if (t.isAbstract()) continue;
                list.add((BSessionAgent)t.getInstance());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list.toArray(new BSessionAgent[list.size()]);
    }

    public static OpenCommand[] listOpenCommands(BWidget owner, BHost host) {
        BNiagaraWbShell shell = (BNiagaraWbShell)owner.getShell();
        ArrayList<OpenCommand> list = new ArrayList<OpenCommand>();
        BSessionAgent[] agents = BSessionAgent.list();
        for (int i = 0; i < agents.length; ++i) {
            try {
                BOrd ord;
                OpenCommand cmd = agents[i].getOpenCommand(owner, host);
                if (cmd == null || !shell.profile.canHyperlink(ord = BOrd.make((String)("local:|" + cmd.sessionScheme + ":")))) continue;
                list.add(cmd);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list.toArray(new OpenCommand[list.size()]);
    }

    public static BSessionAgent makeFor(BISession session) {
        try {
            return (BSessionAgent)session.asObject().getAgents().filter(agentFilter).getDefault().getInstance();
        }
        catch (NoSuchAgentException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Type getType() {
        return TYPE;
    }

    public abstract void pickle(BISession var1, XElem var2);

    public abstract BISession unpickle(BHost var1, XElem var2);

    public OpenCommand getOpenCommand(BWidget owner, BHost host) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class OpenCommand
    extends Command {
        public String key;
        public String title;
        public String description;
        public BHost host;
        public String sessionScheme;
        public int defaultPort;
        public BICredentials credentials;
        public String[] tunnelAuthorities = null;

        public OpenCommand(BWidget owner, BModule module, String key, BHost host, String sessionScheme, int defaultPort, BICredentials credentials) {
            this(owner, module, key, host, sessionScheme, defaultPort, credentials, null);
        }

        public OpenCommand(BWidget owner, BModule module, String key, BHost host, String sessionScheme, int defaultPort, BICredentials credentials, String[] tunnelAuthorities) {
            super(owner, module, key);
            this.key = key;
            this.title = new UiLexicon(module).getText(key + ".title");
            this.description = new UiLexicon(module).getText(key + ".description");
            this.host = host;
            this.sessionScheme = sessionScheme;
            this.defaultPort = defaultPort;
            this.credentials = credentials;
            this.tunnelAuthorities = tunnelAuthorities;
            if (host != null) {
                this.accelerator = null;
            }
        }

        public CommandArtifact doInvoke() throws Exception {
            AuthUtil.open(this.getOwner(), this.makeOpenHandler());
            return null;
        }

        public AuthUtil.OpenHandler makeOpenHandler() {
            return new AuthUtil.OpenHandler(this.title, this.description, this.host, this.sessionScheme, this.defaultPort, this.credentials, this.tunnelAuthorities);
        }

        public String toSlotName() {
            StringBuffer s = new StringBuffer();
            String[] toks = TextUtil.split((String)this.key, (char)'.');
            for (int i = 0; i < toks.length; ++i) {
                String tok = toks[i];
                if (i == 0) {
                    s.append(tok);
                    continue;
                }
                s.append(TextUtil.capitalize((String)tok));
            }
            return s.toString();
        }
    }
}

