/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.util.ArrayUtil;
import com.tridium.workbench.auth.BCnxHandler;
import com.tridium.workbench.nav.BSessionMenuAgent;
import javax.baja.naming.BHost;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.nav.menu.BNavMenuAgent;

public class BHostMenuAgent
extends BNavMenuAgent {
    public static final BHostMenuAgent INSTANCE = new BHostMenuAgent();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$nav$BHostMenuAgent == null ? (class$com$tridium$workbench$nav$BHostMenuAgent = BHostMenuAgent.class$("com.tridium.workbench.nav.BHostMenuAgent")) : class$com$tridium$workbench$nav$BHostMenuAgent));
    public static final BModule module = TYPE.getModule();
    public static final UiLexicon lex = new UiLexicon(module);
    static /* synthetic */ Class class$com$tridium$workbench$nav$BHostMenuAgent;

    public Type getType() {
        return TYPE;
    }

    protected BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        BHost host = (BHost)target;
        BMenu menu = new BMenu();
        menu.add(null, (Command)new Disconnect(owner, host));
        menu.add(null, (Command)new Close(owner, host));
        menu.add(null, (BValue)new BSeparator());
        Command[] sessionOpens = BCnxHandler.getCnxCommands(owner, host);
        for (int i = 0; i < sessionOpens.length; ++i) {
            menu.add(null, sessionOpens[i]);
        }
        return menu;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Close
    extends Command {
        BHost[] hosts;

        public Close(BWidget owner, BHost host) {
            this(owner, new BHost[]{host});
        }

        public Close(BWidget owner, BHost[] hosts) {
            super(owner, module, "close");
            this.hosts = hosts;
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BSessionMenuAgent.confirmDisconnect(this.getOwner(), this.getLabel(), "confirm.host", "confirm.close", (BINavNode[])this.hosts)) {
                for (int i = 0; i < this.hosts.length; ++i) {
                    this.hosts[i].close();
                }
                this.getOwner().repaint();
            }
            return null;
        }

        public Command doMerge(Command c) {
            return new Close(this.getOwner(), (BHost[])ArrayUtil.add((Object[])this.hosts, (Object[])((Close)c).hosts));
        }
    }

    public static class Disconnect
    extends Command {
        BHost[] hosts;

        public Disconnect(BWidget owner, BHost host) {
            this(owner, new BHost[]{host});
        }

        public Disconnect(BWidget owner, BHost[] hosts) {
            super(owner, module, "disconnect");
            this.hosts = hosts;
            boolean enabled = false;
            for (int i = 0; i < hosts.length; ++i) {
                enabled |= hosts[i].isConnected();
            }
            this.setEnabled(enabled);
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BSessionMenuAgent.confirmDisconnect(this.getOwner(), this.getLabel(), "confirm.host", "confirm.disconnect", (BINavNode[])this.hosts)) {
                for (int i = 0; i < this.hosts.length; ++i) {
                    this.hosts[i].disconnect();
                }
                this.getOwner().repaint();
            }
            return null;
        }

        public Command doMerge(Command c) {
            return new Disconnect(this.getOwner(), (BHost[])ArrayUtil.add((Object[])this.hosts, (Object[])((Disconnect)c).hosts));
        }
    }
}

