/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.util.PxUtil;
import com.tridium.workbench.commands.LinkFromCommand;
import com.tridium.workbench.commands.LinkMarkCommand;
import com.tridium.workbench.commands.LinkToCommand;
import com.tridium.workbench.commands.PasteSpecialCommand;
import com.tridium.workbench.file.BExportDialog;
import com.tridium.workbench.nav.BFileMenuAgent;
import com.tridium.workbench.nav.BToolSpace;
import com.tridium.workbench.transfer.TransferUtil;
import com.tridium.workbench.util.BComponentFinder;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.file.BExporter;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.CopyCommand;
import javax.baja.ui.commands.CutCommand;
import javax.baja.ui.commands.DeleteCommand;
import javax.baja.ui.commands.DuplicateCommand;
import javax.baja.ui.commands.PasteCommand;
import javax.baja.ui.commands.RenameCommand;
import javax.baja.ui.commands.SetDisplayNameCommand;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFolder;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.commands.ComponentCompositeCommand;
import javax.baja.workbench.commands.ComponentRenameCommand;
import javax.baja.workbench.commands.ComponentReorderCommand;
import javax.baja.workbench.nav.menu.BNavMenuAgent;
import javax.baja.workbench.nav.menu.NavMenuUtil;

public class BComponentMenuAgent
extends BNavMenuAgent {
    public static final BComponentMenuAgent INSTANCE = new BComponentMenuAgent();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$nav$BComponentMenuAgent == null ? (class$com$tridium$workbench$nav$BComponentMenuAgent = BComponentMenuAgent.class$("com.tridium.workbench.nav.BComponentMenuAgent")) : class$com$tridium$workbench$nav$BComponentMenuAgent));
    public static final String VIEWS = "views";
    public static final String ACTIONS = "actions";
    public static final String NEW = "new";
    public static final String CUT = "cut";
    public static final String COPY = "copy";
    public static final String PASTE = "paste";
    public static final String PASTE_SPECIAL = "pasteSpecial";
    public static final String DELETE = "delete";
    public static final String DUPLICATE = "duplicate";
    public static final String LINK_MARK = "linkMark";
    public static final String LINK_TO = "linkTo";
    public static final String LINK_FROM = "linkFrom";
    public static final String SET_DISPLAY_NAME = "setDisplayName";
    public static final String RENAME = "rename";
    public static final String REORDER = "reorder";
    public static final String COMPOSITE = "composite";
    public static final String FIND = "find";
    public static final String EXPORT = "export";
    static boolean disable = BFileMenuAgent.disable;
    static /* synthetic */ Class class$com$tridium$workbench$nav$BComponentMenuAgent;

    public Type getType() {
        return TYPE;
    }

    protected BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        BComponent comp = target instanceof BComponentSpace ? ((BComponentSpace)target).getRootComponent() : (BComponent)target;
        BMenu menu = new BMenu();
        BComponentSpace space = comp.getComponentSpace();
        boolean tool = space instanceof BToolSpace;
        comp.lease();
        BMenu views = NavMenuUtil.makeViewsMenu(owner, (BObject)comp);
        menu.add(VIEWS, (BValue)new BSubMenuItem(views));
        BMenu actions = NavMenuUtil.makeActionsMenu(owner, comp);
        menu.add(ACTIONS, (BValue)new BSubMenuItem(actions));
        menu.add(null, (BValue)new BSeparator());
        boolean readonly = false;
        if (!comp.getPermissions(null).has(BPermissions.adminWrite)) {
            readonly = true;
        } else if (space != null && space.isSpaceReadonly()) {
            readonly = true;
        }
        if (tool) {
            this.addFind(menu, owner, comp);
        } else if (readonly && disable) {
            this.addCopy(menu, owner, comp);
        } else {
            this.addNewMenu(menu, owner, comp);
            this.addCut(menu, owner, comp);
            this.addCopy(menu, owner, comp);
            this.addPaste(menu, owner, comp);
            this.addPasteSpecial(menu, owner, comp);
            this.addDuplicate(menu, owner, comp);
            this.addDelete(menu, owner, comp);
            menu.add(null, (BValue)new BSeparator());
            this.addFind(menu, owner, comp);
            menu.add(null, (BValue)new BSeparator());
            this.addLinkMark(menu, owner, comp);
            this.addLinkFrom(menu, owner, comp);
            this.addLinkTo(menu, owner, comp);
            menu.add(null, (BValue)new BSeparator());
            this.addRename(menu, owner, comp);
            this.addSetDisplayName(menu, owner, comp);
            this.addReorder(menu, owner, comp);
            this.addComposite(menu, owner, comp);
            menu.add(null, (BValue)new BSeparator());
            this.addExport(menu, owner, comp);
        }
        return menu;
    }

    private void addNewMenu(BMenu menu, BWidget owner, BComponent comp) {
        if (this.isReadonly(comp)) {
            return;
        }
        BMenu newMenu = BComponentMenuAgent.makeNewMenu(owner, comp, null);
        if (newMenu == null) {
            return;
        }
        menu.add(NEW, (BValue)new BSubMenuItem(newMenu));
        menu.add(null, (BValue)new BSeparator());
    }

    private void addCut(BMenu menu, BWidget owner, BComponent comp) {
        if (owner instanceof BTransferWidget) {
            CutCommand cmd = new CutCommand((BTransferWidget)owner);
            if (this.isFrozen(comp)) {
                cmd.setEnabled(false);
            }
            if (this.isReadonly(comp)) {
                cmd.setEnabled(false);
            }
            if (!((BTransferWidget)owner).isCutEnabled()) {
                cmd.setEnabled(false);
            }
            menu.add(CUT, (Command)cmd);
        }
    }

    private void addCopy(BMenu menu, BWidget owner, BComponent comp) {
        if (owner instanceof BTransferWidget) {
            CopyCommand cmd = new CopyCommand((BTransferWidget)owner);
            if (!((BTransferWidget)owner).isCopyEnabled()) {
                cmd.setEnabled(false);
            }
            menu.add(COPY, (Command)cmd);
        }
    }

    private void addPaste(BMenu menu, BWidget owner, BComponent comp) {
        if (owner instanceof BTransferWidget) {
            PasteCommand cmd = new PasteCommand((BTransferWidget)owner);
            if (this.isReadonly(comp)) {
                cmd.setEnabled(false);
            }
            if (!((BTransferWidget)owner).isPasteEnabled()) {
                cmd.setEnabled(false);
            }
            menu.add(PASTE, (Command)cmd);
        }
    }

    private void addPasteSpecial(BMenu menu, BWidget owner, BComponent comp) {
        if (owner instanceof BTransferWidget) {
            PasteSpecialCommand cmd = new PasteSpecialCommand((BTransferWidget)owner, comp);
            if (this.isReadonly(comp)) {
                cmd.setEnabled(false);
            }
            if (!((BTransferWidget)owner).isPasteEnabled()) {
                cmd.setEnabled(false);
            }
            menu.add(PASTE_SPECIAL, (Command)cmd);
        }
    }

    private void addDuplicate(BMenu menu, BWidget owner, BComponent comp) {
        if (owner instanceof BTransferWidget) {
            DuplicateCommand cmd = new DuplicateCommand((BTransferWidget)owner);
            if (this.isReadonly(comp)) {
                cmd.setEnabled(false);
            }
            if (this.isRoot(comp)) {
                cmd.setEnabled(false);
            }
            if (!((BTransferWidget)owner).isDuplicateEnabled()) {
                cmd.setEnabled(false);
            }
            menu.add(DUPLICATE, (Command)cmd);
        }
    }

    private void addDelete(BMenu menu, BWidget owner, BComponent comp) {
        if (owner instanceof BTransferWidget) {
            DeleteCommand cmd = new DeleteCommand((BTransferWidget)owner);
            if (this.isFrozen(comp)) {
                cmd.setEnabled(false);
            }
            if (this.isReadonly(comp)) {
                cmd.setEnabled(false);
            }
            if (!((BTransferWidget)owner).isDeleteEnabled()) {
                cmd.setEnabled(false);
            }
            menu.add(DELETE, (Command)cmd);
        }
    }

    private void addLinkMark(BMenu menu, BWidget owner, BComponent comp) {
        LinkMarkCommand cmd = new LinkMarkCommand(owner, comp);
        menu.add(LINK_MARK, (Command)cmd);
    }

    private void addLinkFrom(BMenu menu, BWidget owner, BComponent comp) {
        LinkFromCommand cmd = new LinkFromCommand(owner, comp);
        menu.add(LINK_FROM, (Command)cmd);
    }

    private void addLinkTo(BMenu menu, BWidget owner, BComponent comp) {
        LinkToCommand cmd = new LinkToCommand(owner, comp);
        if (this.isReadonly(comp)) {
            cmd.setEnabled(false);
        }
        menu.add(LINK_TO, (Command)cmd);
    }

    private void addRename(BMenu menu, BWidget owner, BComponent comp) {
        Object cmd = owner instanceof BTransferWidget ? new RenameCommand((BTransferWidget)owner) : new ComponentRenameCommand(owner, comp);
        if (this.isFrozen(comp)) {
            cmd.setEnabled(false);
        }
        if (this.isReadonly(comp)) {
            cmd.setEnabled(false);
        }
        menu.add(RENAME, (Command)cmd);
    }

    private void addSetDisplayName(BMenu menu, BWidget owner, BComponent comp) {
        SetDisplayNameCommand cmd = new SetDisplayNameCommand(owner, comp);
        if (this.isReadonly(comp)) {
            cmd.setEnabled(false);
        }
        menu.add(SET_DISPLAY_NAME, (Command)cmd);
    }

    private void addReorder(BMenu menu, BWidget owner, BComponent comp) {
        ComponentReorderCommand cmd = new ComponentReorderCommand(owner, comp);
        if (this.isReadonly(comp)) {
            cmd.setEnabled(false);
        }
        menu.add(REORDER, (Command)cmd);
    }

    private void addComposite(BMenu menu, BWidget owner, BComponent comp) {
        ComponentCompositeCommand cmd = new ComponentCompositeCommand(owner, comp);
        if (this.isReadonly(comp)) {
            cmd.setEnabled(false);
        }
        menu.add(COMPOSITE, (Command)cmd);
    }

    private void addFind(BMenu menu, BWidget owner, BComponent comp) {
        FindCommand cmd = new FindCommand(owner, comp);
        menu.add(FIND, (Command)cmd);
    }

    private void addExport(BMenu menu, BWidget owner, BComponent comp) {
        AgentFilter filter = AgentFilter.is((Type)BExporter.TYPE);
        AgentList list = comp.getAgents().filter(filter);
        int agents = list.size();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof PxUtil.PxAgent)) continue;
            --agents;
        }
        ExportCommand cmd = new ExportCommand(owner, comp);
        cmd.setEnabled(agents > 0);
        menu.add(EXPORT, (Command)cmd);
    }

    private boolean isReadonly(BComponent comp) {
        return comp.isComponentReadonly() && disable;
    }

    private boolean isFrozen(BComponent comp) {
        Property prop = comp.getPropertyInParent();
        if (prop != null) {
            return prop.isFrozen() && disable;
        }
        return true;
    }

    private boolean isRoot(BComponent comp) {
        return comp.getParent() == null;
    }

    public static BMenu makeNewMenu(BWidget owner, BComponent parent, BWsAnnotation anno) {
        try {
            if (parent.getType().getTypeSpec().toString().equals("nsedona:SedonaComponent")) {
                return null;
            }
            BMenu menu = new BMenu(UiLexicon.bajaui().getText("menu.new.label"));
            BComponent root = (BComponent)BOrd.make((String)"file:!workbench/newComponents.bog|bog:|slot:/").get();
            BComponent[] kids = root.getChildComponents();
            for (int i = 0; i < kids.length; ++i) {
                BComponentMenuAgent.addToNewMenu(owner, menu, parent, kids[i], anno);
            }
            return menu;
        }
        catch (UnresolvedException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void addToNewMenu(BWidget owner, BMenu menu, BComponent parent, BComponent child, BWsAnnotation anno) {
        if (child instanceof BFolder) {
            BComponent[] kids = child.getChildComponents();
            if (kids.length == 0) {
                menu.add(null, (Command)new NewComponentCommand(owner, parent, child, anno));
                return;
            }
            BMenu subMenu = new BMenu(child.getDisplayName(null));
            for (int i = 0; i < kids.length; ++i) {
                BComponentMenuAgent.addToNewMenu(owner, subMenu, parent, kids[i], anno);
            }
            menu.add(null, (BValue)new BSubMenuItem(subMenu));
        } else if (child instanceof BSeparator) {
            menu.add(null, (BValue)new BSeparator());
        } else {
            menu.add(null, (Command)new NewComponentCommand(owner, parent, child, anno));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ExportCommand
    extends Command {
        BComponent target;

        public ExportCommand(BWidget owner, BComponent target) {
            super(owner, (Lexicon)UiLexicon.bajaui, "commands.export");
            this.target = target;
        }

        public CommandArtifact doInvoke() {
            try {
                this.target.lease(1);
                BExportDialog.invoke(this.getOwner(), this.target.getAbsoluteOrd(), false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public class FindCommand
    extends Command {
        BComponent base;

        public FindCommand(BWidget owner, BComponent base) {
            super(owner, (Lexicon)UiLexicon.bajaui, "findComponent");
            this.base = base;
        }

        public CommandArtifact doInvoke() {
            BWbShell shell = (BWbShell)this.getShell();
            BComponentFinder.open(shell, this.getLabel(), this.base);
            return null;
        }
    }

    public static class NewComponentCommand
    extends Command {
        BComponent parent;
        BComponent child;
        BWsAnnotation anno;

        public NewComponentCommand(BWidget owner, BComponent parent, BComponent child, BWsAnnotation anno) {
            super(owner, child.getDisplayName(null));
            this.icon = BImage.make((BIcon)child.getNavIcon());
            this.parent = parent;
            this.child = child;
            this.anno = anno;
        }

        public CommandArtifact doInvoke() throws Exception {
            String name = this.child.getName();
            BComponent child = (BComponent)this.child.newCopy(true);
            Property annoProp = child.getProperty("wsAnnotation");
            if (this.anno == null) {
                if (annoProp != null && annoProp.isDynamic()) {
                    child.remove(annoProp);
                }
            } else if (annoProp == null) {
                child.add("wsAnnotation", (BValue)this.anno);
            } else {
                child.set(annoProp, (BValue)BWsAnnotation.merge((BWsAnnotation)((BWsAnnotation)child.get(annoProp)), (BWsAnnotation)this.anno));
            }
            return TransferUtil.insert(this.getOwner(), 16, new Mark((BObject)child, name), (BObject)this.parent, null, null);
        }
    }
}

