/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.job;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.sys.Nre;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.JobEvent;
import com.tridium.workbench.job.JobListener;
import com.tridium.workbench.job.NotificationQueue;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.BNotification;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.kiosk.BKioskProfile;
import javax.baja.workbench.util.BNotifyPane;

public class JobMonitor
extends Thread {
    static final BImage messageIcon = BImage.make((String)"module://icons/x16/info.png");
    static final BImage unknownIcon = BImage.make((String)"module://icons/x16/job/unknown.png");
    static final BImage runningIcon = BImage.make((String)"module://icons/x16/job/running.png");
    static final BImage canceledIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    static final BImage successIcon = BImage.make((String)"module://icons/x16/job/success.png");
    static final BImage failedIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    static JobMonitor monitor;
    Log log = Log.getLog((String)"JobMonitor");
    Array sessions = new Array(class$com$tridium$workbench$job$JobMonitor$Session == null ? (class$com$tridium$workbench$job$JobMonitor$Session = JobMonitor.class$("com.tridium.workbench.job.JobMonitor$Session")) : class$com$tridium$workbench$job$JobMonitor$Session);
    Subscriber subscriber = new MySubscriber();
    Array listeners = new Array(class$com$tridium$workbench$job$JobListener == null ? (class$com$tridium$workbench$job$JobListener = JobMonitor.class$("com.tridium.workbench.job.JobListener")) : class$com$tridium$workbench$job$JobListener);
    static /* synthetic */ Class class$javax$baja$job$BJobService;
    static /* synthetic */ Class class$com$tridium$workbench$job$JobMonitor$Session;
    static /* synthetic */ Class class$com$tridium$workbench$job$JobListener;

    public static JobMonitor get() {
        if (monitor == null) {
            System.out.println("*** JobMonitor lazy init ***");
            JobMonitor.init();
        }
        return monitor;
    }

    public static void init() {
        monitor = new JobMonitor();
        monitor.start();
    }

    JobMonitor() {
        super(Nre.mainThreadGroup, "Ui:JobMonitor");
        this.setDaemon(true);
        Spy.ROOT.add("jobMonitor", (Spy)new MySpy());
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    this.scan();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    void scan() {
        int i;
        BFoxSession[] foxSessions = BFoxSession.list();
        Session[] mySessions = (Session[])this.sessions.trim();
        for (i = 0; i < foxSessions.length; ++i) {
            BFoxSession fox = foxSessions[i];
            if (!fox.isConnected()) continue;
            boolean found = false;
            for (int j = 0; j < mySessions.length; ++j) {
                if (fox != mySessions[j].foxSession) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.register(fox);
        }
        mySessions = (Session[])this.sessions.copy().trim();
        for (i = 0; i < mySessions.length; ++i) {
            if (mySessions[i].foxSession.isConnected()) continue;
            this.unregister(mySessions[i]);
        }
    }

    void register(BFoxSession fox) {
        this.log.trace("register " + fox);
        Session session = new Session();
        session.foxSession = fox;
        this.sessions.add((Object)session);
        try {
            session.service = (BJobService)BOrd.make((String)"service:baja:JobService").get((BObject)fox);
            session.service.loadSlots();
            SlotCursor c = session.service.getProperties();
            while (c.nextComponent()) {
                ((BComponent)c.get()).loadSlots();
            }
            this.subscriber.subscribe((BComponent)session.service, 1);
            this.jobEvent(new JobEvent(1, session.service));
        }
        catch (Throwable e) {
            this.log.error("Cannot register: " + e);
            session.error = true;
        }
    }

    void unregister(Session session) {
        try {
            this.log.trace("unregister " + session.foxSession);
            this.sessions.remove((Object)session);
            this.jobEvent(new JobEvent(2, session.service));
        }
        catch (Throwable e) {
            this.log.error("unregister", e);
        }
    }

    void handleComponentEvent(BComponentEvent event) {
        if (event.getId() == 0 && event.getSourceComponent() instanceof BJob) {
            BJobState state;
            BJob job = (BJob)event.getSourceComponent();
            this.jobEvent(new JobEvent(5, job, event));
            if (event.getSlot() == BJob.jobState && ((state = (BJobState)event.getValue()) == BJobState.success || state == BJobState.failed)) {
                this.notify(job);
            }
            return;
        }
        if (event.getId() == 1 && event.getValue() instanceof BJob) {
            BJob job = (BJob)event.getValue();
            this.subscriber.subscribe((BComponent)job);
            this.jobEvent(new JobEvent(3, job, event));
            BJobState state = job.getJobState();
            if (state == BJobState.success || state == BJobState.failed) {
                this.notify(job);
            }
            return;
        }
        if (event.getId() == 2 && event.getValue() instanceof BJob) {
            BJob job = (BJob)event.getValue();
            this.jobEvent(new JobEvent(4, job, event));
            return;
        }
        if (event.getId() == 5 && event.getValue() instanceof BNotification) {
            BNotification notify = (BNotification)event.getValue();
            NotificationQueue.enqueue(notify, (Context)BFacets.makePickle((BFacets)BFacets.DEFAULT, (Object)event.getSourceComponent()));
        }
    }

    void notify(BJob job) {
        BWidgetShell[] shells = BWidget.getApplication().getShells();
        for (int i = 0; i < shells.length; ++i) {
            BWbProfile profile;
            if (!(shells[i] instanceof BWbShell) || !((profile = ((BWbShell)shells[i]).getProfile()) instanceof BKioskProfile)) continue;
            return;
        }
        BLabel station = null;
        try {
            BJobService service = (BJobService)job.getParent();
            BHost host = service.getHost();
            BFoxSession session = (BFoxSession)service.getSession();
            station = new BLabel(session.getStationName() + " on " + host.getNavDisplayName(null));
            station.setForeground(Theme.widget().getControlShadow());
        }
        catch (Exception e) {
            // empty catch block
        }
        String jobName = job.getType().getDisplayName(null);
        if (jobName.endsWith(" Job")) {
            jobName = jobName.substring(0, jobName.length() - 4);
        }
        BLabel name = new BLabel(BImage.make((BIcon)job.getIcon()), jobName);
        name.setFont(Theme.widget().getBoldText());
        BLabel status = new BLabel(JobMonitor.stateToIcon(job.getJobState()), job.getJobState().toString());
        BGridPane grid = new BGridPane(1);
        grid.add(null, (BValue)name);
        grid.add(null, (BValue)status);
        if (station != null) {
            grid.add(null, (BValue)station);
        }
        BNotifyPane pane = new BNotifyPane();
        pane.setCenter((BWidget)grid);
        pane.open();
    }

    static BImage stateToIcon(BJobState state) {
        switch (state.getOrdinal()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return canceledIcon;
            }
            case 4: {
                return successIcon;
            }
            case 5: {
                return failedIcon;
            }
        }
        return unknownIcon;
    }

    public BJobService[] list() {
        Array result = new Array(class$javax$baja$job$BJobService == null ? (class$javax$baja$job$BJobService = JobMonitor.class$("javax.baja.job.BJobService")) : class$javax$baja$job$BJobService);
        Session[] sessions = (Session[])this.sessions.trim();
        for (int i = 0; i < sessions.length; ++i) {
            BJobService service = sessions[i].service;
            if (service == null) continue;
            result.add((Object)service);
        }
        return (BJobService[])result.trim();
    }

    public void addListener(JobListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(JobListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void jobEvent(JobEvent event) {
        if (this.log.isTraceOn()) {
            this.log.trace(event.toString());
        }
        JobListener[] listeners = (JobListener[])this.listeners.trim();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                listeners[i].jobEvent(event);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void spy(SpyWriter out) {
        int i;
        Session[] sessions = (Session[])this.sessions.trim();
        out.startTable(true);
        out.trTitle((Object)"Sessions", 4);
        out.w((Object)"<tr>").th((Object)"Ord").th((Object)"FoxSession").th((Object)"Err").th((Object)"Service").w((Object)"</tr>");
        for (i = 0; i < sessions.length; ++i) {
            Session s = sessions[i];
            out.tr((Object)s.foxSession.getNavOrd(), (Object)s.foxSession.getConnection().session(), (Object)("" + s.error), (Object)("" + s.service));
        }
        out.endTable();
        out.startTable(true);
        out.trTitle((Object)"Listeners", 1);
        for (i = 0; i < this.listeners.size(); ++i) {
            out.tr(this.listeners.get(0));
        }
        out.endTable();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Session {
        BFoxSession foxSession;
        BJobService service;
        boolean error;

        Session() {
        }
    }

    class MySpy
    extends Spy {
        MySpy() {
        }

        public void write(SpyWriter out) {
            JobMonitor.this.spy(out);
        }
    }

    class MySubscriber
    extends Subscriber {
        MySubscriber() {
        }

        public void event(BComponentEvent event) {
            JobMonitor.this.handleComponentEvent(event);
        }
    }
}

