/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.file;

import com.tridium.ui.CaretTracker;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.gx.RectGeom;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;
import javax.baja.xml.XInputStreamReader;

public class BTextFileEditor
extends BWbView
implements CaretTracker {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$file$BTextFileEditor == null ? (class$com$tridium$workbench$file$BTextFileEditor = BTextFileEditor.class$("com.tridium.workbench.file.BTextFileEditor")) : class$com$tridium$workbench$file$BTextFileEditor));
    static final Log log = Log.getLog((String)"textEditor");
    static final Lexicon lex = Lexicon.make((String)"workbench");
    static final String lexLine = lex.getText("fileEditor.line");
    static final String lexCol = lex.getText("fileEditor.col");
    static final int linePad = 6;
    static final int colPad = 4;
    private static Properties parserProps = new Properties();
    private static File parserPropsFile;
    private static long parserPropsLastModified;
    private static HashMap fileStates;
    public BTextEditorPane pane = new BTextEditorPane("", 80, 40, true);
    public BTextEditor text = this.pane.getEditor();
    public FileState state;
    public BTextField encodingStatus = new BTextField("", 0, false);
    public BTextField rwStatus = new BTextField("", 2, false);
    public BTextField lineStatus = new BTextField(lexLine, lexLine.length() + 6, false);
    public BTextField columnStatus = new BTextField(lexCol, lexCol.length() + 4, false);
    public Command saveAndCompile;
    public Command saveAndSlot;
    BGridPane status = new BGridPane(4);
    BIFile file;
    File localFile;
    BAbsTime lastModified;
    boolean zipped;
    String encoding;
    static /* synthetic */ Class class$com$tridium$workbench$file$BTextFileEditor;

    public Type getType() {
        return TYPE;
    }

    public BTextFileEditor() {
        this.text.setController((TextController)new Controller());
        this.setContent((BWidget)this.pane);
        this.linkTo("lk0", (BComponent)this.pane.getEditor(), (Slot)BTextEditor.textModified, (Slot)setModified);
        this.status.add("encoding", (BValue)this.encodingStatus);
        this.status.add("rw", (BValue)this.rwStatus);
        this.status.add("line", (BValue)this.lineStatus);
        this.status.add("col", (BValue)this.columnStatus);
        this.saveAndCompile = new SaveAndCompileCommand(this);
        this.saveAndSlot = new SaveAndSlotCommand(this);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.getUndoManager().setMaxArtifacts(10000);
        this.file = (BIFile)value;
        this.lastModified = this.file.getLastModified();
        this.localFile = null;
        if (this.file.getStore() instanceof BLocalFileStore) {
            this.localFile = ((BLocalFileStore)this.file.getStore()).getLocalFile();
        }
        this.saveAndCompile.setEnabled(this.localFile != null);
        this.saveAndSlot.setEnabled(this.localFile != null);
        String ext = this.file.getExtension();
        TextParser parser = BTextFileEditor.getParser(ext);
        if (parser != null) {
            this.text.setParser(parser);
        }
        boolean isEditable = !this.file.isReadonly();
        this.text.setEditable(isEditable);
        this.rwStatus.setText(isEditable ? "RW" : "RO");
        this.text.updateEnableStates();
        this.setTransferWidget((BTransferWidget)this.text);
        this.setCommandEnabled(6, true);
        this.setCommandEnabled(7, true);
        this.setCommandEnabled(8, true);
        this.setCommandEnabled(9, isEditable);
        this.setCommandEnabled(10, true);
        Reader in = this.toReader(new BufferedInputStream(this.file.getInputStream()));
        this.text.getModel().read(in);
        in.close();
        BOrd ord = this.getWbShell().getActiveOrd();
        this.state = (FileState)fileStates.get(ord);
        if (this.state == null) {
            this.state = new FileState(ord);
            fileStates.put(ord, this.state);
        }
        this.text.moveCaretPosition(this.state.lastPosition);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BIFile file = (BIFile)value;
        Writer out = this.toWriter(file.getOutputStream());
        this.text.getModel().write(out);
        out.flush();
        out.close();
        this.lastModified = file.getLastModified();
        return value;
    }

    public String getDefaultOptionsId() {
        return "textEditor";
    }

    public BMenu[] getViewMenus() {
        BMenu menu = new BMenu(TYPE.getDisplayName(null));
        menu.add(null, this.saveAndCompile);
        menu.add(null, this.saveAndSlot);
        return new BMenu[]{menu};
    }

    public BToolBar getViewToolBar() {
        BToolBar bar = new BToolBar();
        BNiagaraWbShell shell = (BNiagaraWbShell)this.getWbShell();
        bar.add("find", shell.commands.find);
        bar.add("replace", shell.commands.replace);
        bar.add("sep0", (BValue)new BSeparator());
        bar.add("findFiles", shell.commands.findFiles);
        bar.add("replaceInFiles", shell.commands.replaceInFiles);
        bar.add("sep1", (BValue)new BSeparator());
        bar.add("saveAndCompile", this.saveAndCompile);
        bar.add("sep2", (BValue)new BSeparator());
        bar.add("consolePrev", shell.commands.consolePrev);
        bar.add("consoleNext", shell.commands.consoleNext);
        return bar;
    }

    public BWidget getViewStatusBarSupplement() {
        return this.status;
    }

    public void prime() {
        this.text.requestFocus();
    }

    public CommandArtifact invokeCommand(int id) throws Exception {
        switch (id) {
            case 6: {
                return this.text.doFind();
            }
            case 8: {
                return this.text.doFindNext();
            }
            case 7: {
                return this.text.doFindPrev();
            }
            case 9: {
                return this.text.doReplace();
            }
            case 10: {
                return this.text.doGoto();
            }
        }
        return super.invokeCommand(id);
    }

    public static File findBuildFile(File f, String filename) {
        String parent;
        if (f == null) {
            return null;
        }
        if (f.isDirectory()) {
            File x = new File(f, filename);
            if (x.exists()) {
                return x;
            }
        } else if (f.getName().equals(filename)) {
            return f;
        }
        if ((parent = f.getParent()) == null) {
            return null;
        }
        return BTextFileEditor.findBuildFile(new File(f.getParent()), filename);
    }

    public static File findParentDirectory(File f, String filename) {
        if (f == null) {
            return null;
        }
        if (f.isDirectory() && f.getName().equals(filename)) {
            return f;
        }
        String parent = f.getParent();
        if (parent == null) {
            return null;
        }
        return BTextFileEditor.findParentDirectory(new File(f.getParent()), filename);
    }

    Reader toReader(InputStream in) throws Exception {
        XInputStreamReader reader = new XInputStreamReader(in);
        this.encoding = reader.getEncoding();
        this.zipped = reader.isZipped();
        String s = this.encoding;
        if (this.zipped) {
            s = "Zip/" + s;
        }
        this.encodingStatus.setText(s);
        this.encodingStatus.setVisibleColumns(s.length());
        return reader;
    }

    Writer toWriter(OutputStream out) throws Exception {
        if (this.zipped) {
            ZipOutputStream zip = new ZipOutputStream(out);
            zip.putNextEntry(new ZipEntry("file.xml"));
            out = zip;
        }
        if (this.encoding.equals("UTF-16LE")) {
            out.write(255);
            out.write(254);
        }
        if (this.encoding.equals("UTF-16BE")) {
            out.write(254);
            out.write(255);
        }
        return new OutputStreamWriter(out, this.encoding);
    }

    public String getSelectedText() {
        return this.text.getModel().getSelectedText();
    }

    public void highlight(int line1, int col1, int line2, int col2) {
        Position end = this.text.getModel().getEndPosition();
        Position p1 = new Position(line1 - 1, col1 - 1);
        Position p2 = new Position(line2 - 1, col2 - 1);
        if (p1.compareTo((Object)end) > 0) {
            p1 = end;
        }
        if (p2.compareTo((Object)end) > 0) {
            p2 = end;
        }
        this.state.viewport = null;
        this.text.getSelection().select(p1, p2);
        this.text.moveCaretPosition(p2);
        this.text.requestFocus();
    }

    public void caretMoved(Position pos) {
        this.state.lastPosition = pos;
        String line = String.valueOf(pos.line + 1);
        String col = String.valueOf(pos.column + 1);
        this.lineStatus.setText(lexLine + TextUtil.padLeft((String)line, (int)6));
        this.columnStatus.setText(lexCol + TextUtil.padLeft((String)col, (int)4));
    }

    public void doLayout(BWidget[] kids) {
        super.doLayout(kids);
        if (this.state != null && this.state.viewport != null) {
            this.pane.scrollToVisible(this.state.viewport);
            this.state.viewport = null;
        }
    }

    public void deactivated() {
        super.deactivated();
        if (this.state != null) {
            this.state.viewport = this.pane.getViewport();
        }
    }

    public void checkFileTimestamp() {
        if (this.lastModified == null) {
            return;
        }
        if (this.lastModified.equals((Object)this.file.getLastModified())) {
            return;
        }
        this.lastModified = this.file.getLastModified();
        new Thread(){

            public void run() {
                BTextFileEditor.this.confirmReload();
            }
        }.start();
    }

    public void confirmReload() {
        int r = BDialog.confirm((BWidget)this, (Object)lex.getText("fileEditor.fileHasChangedReload"));
        if (r == 4) {
            this.getWbShell().getRefreshCommand().invoke();
        }
    }

    public static TextParser getParser(String ext) {
        String x;
        if (ext == null) {
            return null;
        }
        if (parserPropsFile == null) {
            parserPropsFile = new File(Sys.getBajaHome() + File.separator + "lib" + File.separator + "colorCoding.properties");
        }
        if (parserPropsFile.lastModified() > parserPropsLastModified) {
            log.message("Load \"" + parserPropsFile + "\"");
            parserPropsLastModified = parserPropsFile.lastModified();
            try {
                parserProps.clear();
                FileInputStream in = new FileInputStream(parserPropsFile);
                parserProps.load(in);
                ((InputStream)in).close();
            }
            catch (Exception e) {
                log.message("Load failed \"" + parserPropsFile + "\"", (Throwable)e);
            }
        }
        if ((x = parserProps.getProperty(ext)) == null) {
            return null;
        }
        try {
            StringTokenizer st = new StringTokenizer(x, ":");
            String modName = st.nextToken();
            String className = st.nextToken();
            return (TextParser)Sys.loadModule((String)modName).loadClass(className).newInstance();
        }
        catch (Exception e) {
            log.message("Parser not found \"" + x + "\"", (Throwable)e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        fileStates = new HashMap();
    }

    public static class FileState {
        public BOrd ord;
        public Position lastPosition = new Position(0, 0);
        public RectGeom viewport;

        public FileState(BOrd ord) {
            this.ord = ord;
        }

        public String toString() {
            return this.ord.toString() + " " + this.lastPosition;
        }
    }

    class Controller
    extends TextController {
        Controller() {
        }

        public void focusGained(BFocusEvent event) {
            super.focusGained(event);
            BTextFileEditor.this.checkFileTimestamp();
        }
    }

    class SaveAndSlotCommand
    extends Command
    implements BConsole.ExecCallback {
        public SaveAndSlotCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "programEditor.saveAndSlot");
        }

        public void consoleExecDone(BConsole console, int exitCode) {
            BTextFileEditor.this.checkFileTimestamp();
        }

        public CommandArtifact doInvoke() throws Exception {
            BNiagaraWbShell shell = (BNiagaraWbShell)this.getOwner().getShell();
            shell.getSaveCommand().invoke();
            File build = BTextFileEditor.findBuildFile(BTextFileEditor.this.localFile, "build.xml");
            if (build == null) {
                BDialog.error((BWidget)this.getOwner(), (Object)"No build.xml file found");
                return null;
            }
            String srcString = "src";
            if (BTextFileEditor.findParentDirectory(BTextFileEditor.this.localFile, "srcTest") != null) {
                srcString = "srcTest";
            }
            shell.openConsole().exec("slot \"" + build.getParent() + File.separator + srcString + "\"", this);
            return null;
        }
    }

    class SaveAndCompileCommand
    extends Command {
        public SaveAndCompileCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "programEditor.saveAndCompile");
        }

        public CommandArtifact doInvoke() throws Exception {
            BNiagaraWbShell shell = (BNiagaraWbShell)this.getOwner().getShell();
            shell.getSaveCommand().invoke();
            File kit = BTextFileEditor.findBuildFile(BTextFileEditor.this.localFile, "kit.xml");
            if (kit != null) {
                shell.openConsole().exec("sedonac \"" + kit + "\"");
                return null;
            }
            File build = BTextFileEditor.findBuildFile(BTextFileEditor.this.localFile, "build.xml");
            if (build != null) {
                String options = "";
                if (BTextFileEditor.findParentDirectory(BTextFileEditor.this.localFile, "srcTest") != null) {
                    options = options + " -t";
                }
                shell.openConsole().exec("build \"" + build.getParent() + "\"" + options);
                return null;
            }
            BDialog.error((BWidget)this.getOwner(), (Object)"No build file found");
            return null;
        }
    }
}

