/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.file;

import com.tridium.sys.registry.NAgentList;
import com.tridium.util.PxUtil;
import com.tridium.workbench.shell.BNiagaraWbApplet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.collection.BITable;
import javax.baja.file.BExporter;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.ExportOp;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.px.BWbPxView;
import javax.baja.workbench.view.BIExportableTableView;
import javax.baja.workbench.view.BIWbViewExporter;
import javax.baja.workbench.view.BWbView;

public class BExportDialog
extends BEdgePane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$file$BExportDialog == null ? (class$com$tridium$workbench$file$BExportDialog = BExportDialog.class$("com.tridium.workbench.file.BExportDialog")) : class$com$tridium$workbench$file$BExportDialog));
    static AgentFilter viewFilter = AgentFilter.is((TypeInfo)BWbView.TYPE.getTypeInfo());
    static BImage icon = BImage.make((String)"module://icons/x32/export.png");
    UiLexicon lex = UiLexicon.bajaui();
    static final int VIEW_INTERNAL = 0;
    static final int VIEW_EXTERNAL = 1;
    static final int EMAIL = 2;
    static final int SAVE = 3;
    BWidget owner;
    BWbView view;
    OrdTarget target;
    ExporterItem[] exporters;
    ExporterItem cur;
    BListDropDown exporterField;
    BTextField email;
    BTextField saveOrd;
    ToggleCommandGroup action;
    ToggleCommand actionViewInternal = new ActionViewInternal((BWidget)this);
    ToggleCommand actionViewExternal = new ActionViewExternal((BWidget)this);
    ToggleCommand actionEmail = new ActionEmail((BWidget)this);
    ToggleCommand actionSave = new ActionSave((BWidget)this);
    Command saveBrowse = new SaveBrowse((BWidget)this);
    BBorderPane setupPane = new BBorderPane();
    BWbEditor setup;
    static /* synthetic */ Class class$com$tridium$workbench$file$BExportDialog;
    static /* synthetic */ Class class$com$tridium$workbench$file$BExportDialog$ExporterItem;
    static /* synthetic */ Class class$javax$baja$ui$BBinding;

    public Type getType() {
        return TYPE;
    }

    public static boolean hasExporters(BWbShell shell, boolean asPrint) throws Exception {
        BWbView view = shell.getActiveView();
        OrdTarget target = shell.getActiveOrdTarget();
        BExportDialog dlg = null;
        try {
            dlg = new BExportDialog((BWidget)shell, target, view, asPrint);
        }
        catch (Exception e) {
            return false;
        }
        return dlg.findExporters(shell.getProfile()).length > 0;
    }

    public static CommandArtifact invoke(BWbShell shell, boolean asPrint) throws Exception {
        BWbView view = shell.getActiveView();
        OrdTarget target = shell.getActiveOrdTarget();
        return BExportDialog.invoke(new BExportDialog((BWidget)shell, target, view, asPrint));
    }

    public static CommandArtifact invoke(BWidget owner, BITable table, boolean asPrint) throws Exception {
        OrdTarget target = BOrd.make((String)"view:?dummy=dummy").resolve((BObject)table, (Context)table.getTableFacets());
        return BExportDialog.invoke(new BExportDialog(owner, target, null, asPrint));
    }

    public static CommandArtifact invoke(BWidget owner, BOrd exportOrd, boolean asPrint) throws Exception {
        OrdTarget target = exportOrd.resolve();
        return BExportDialog.invoke(new BExportDialog(owner, target, null, asPrint));
    }

    public static CommandArtifact invoke(BExportDialog dialog) throws Exception {
        while (true) {
            int r;
            if ((r = BDialog.open((BWidget)dialog.owner, (String)"Export", (Object)((Object)dialog), (int)3)) != 1) {
                return null;
            }
            try {
                dialog.setup.saveValue();
            }
            catch (Exception e) {
                BDialog.error((BWidget)dialog.owner, (String)"Cannot save setup", (Object)e);
                continue;
            }
            break;
        }
        switch (dialog.getSelectedAction()) {
            case 0: {
                BExportDialog.viewInternal(dialog);
                break;
            }
            case 1: {
                BExportDialog.viewExternal(dialog);
                break;
            }
            case 2: {
                BExportDialog.email(dialog);
                break;
            }
            case 3: {
                BExportDialog.save(dialog);
            }
        }
        return null;
    }

    static void viewInternal(BExportDialog dialog) throws Exception {
        File file = BExportDialog.makeTempFile(dialog);
        BOrd ord = BFileSystem.INSTANCE.localFileToOrd(file);
        dialog.shell().hyperlink(ord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File makeTempFile(BExportDialog dialog) throws Exception {
        BExporter exporter = dialog.cur.getInstance();
        OrdTarget target = dialog.cur.target;
        File dir = new File(Sys.getBajaHome(), "temp");
        dir.mkdirs();
        File file = File.createTempFile("temp", "." + exporter.getFileExtension(), dir);
        file.deleteOnExit();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            exporter.export(ExportOp.make((OrdTarget)target, (OutputStream)out));
        }
        finally {
            out.close();
        }
        return file;
    }

    static void viewExternal(BExportDialog dialog) throws Exception {
        File file = BExportDialog.makeTempFile(dialog);
        BExportDialog.launchExternal(file);
    }

    public static void launchExternal(File file) throws Exception {
        String path = BExportDialog.formatPath(file);
        if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
            Runtime.getRuntime().exec("gnome-open " + path);
        } else {
            Runtime.getRuntime().exec("cmd.exe /c start " + path);
        }
    }

    static String formatPath(File file) throws Exception {
        String path = "";
        String[] s = TextUtil.split((String)file.getCanonicalPath(), (char)'\\');
        for (int i = 0; i < s.length; ++i) {
            if (i > 0) {
                path = path + "\\";
            }
            path = s[i].indexOf(" ") != -1 ? path + "\"" + s[i] + "\"" : path + s[i];
        }
        return path;
    }

    static void email(BExportDialog dialog) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void save(BExportDialog dialog) throws Exception {
        BExporter exporter = dialog.cur.getInstance();
        OrdTarget target = dialog.cur.target;
        String ext = exporter.getFileExtension();
        String path = dialog.saveOrd.getText();
        if (path.length() == 0) {
            BDialog.error((BWidget)dialog.owner, (Object)("Illegal filename: " + path));
            return;
        }
        if (!path.endsWith(ext)) {
            path = path + "." + ext;
        }
        BOrd ord = BOrd.make((String)path);
        BIFile file = null;
        try {
            file = (BIFile)ord.resolve().get();
            if (8 == BDialog.confirm((BWidget)dialog.owner, (Object)"File already exists.  Do you want to overwrite?")) {
                return;
            }
        }
        catch (UnresolvedException e) {
            OrdQuery[] q = ord.parse();
            FilePath filepath = (FilePath)q[q.length - 1];
            q[q.length - 1] = new FilePath("");
            BFileSpace space = (BFileSpace)BOrd.make((OrdQuery[])q).resolve().get();
            file = space.makeFile(filepath);
        }
        catch (SyntaxException e2) {
            BDialog.error((BWidget)dialog.owner, (Object)("Illegal filename: " + path));
            return;
        }
        BufferedOutputStream out = new BufferedOutputStream(file.getOutputStream());
        try {
            exporter.export(ExportOp.make((OrdTarget)target, (OutputStream)out));
        }
        finally {
            out.close();
        }
    }

    public static BWbProfile getProfile(BWidget owner) {
        if (BWbShell.getWbShell(owner) != null) {
            return BWbShell.getWbShell(owner).getProfile();
        }
        return new BWbProfile();
    }

    private BExportDialog(BWidget owner, OrdTarget target, BWbView view, boolean asPrint) throws Exception {
        this.owner = owner;
        this.target = target;
        this.view = view;
        BWbProfile profile = BExportDialog.getProfile(owner);
        this.exporters = this.findExporters(profile);
        if (this.exporters.length == 0) {
            throw new LocalizableException((Lexicon)this.lex, "exporter.noExporters");
        }
        this.setTop((BWidget)new BWizardHeader(icon, this.lex.getText("commands.export.label")));
        BTabbedPane tabs = new BTabbedPane();
        tabs.addPane(this.lex.getText("exporter.action"), this.buildAction());
        tabs.addPane(this.lex.getText("exporter.setup"), (BWidget)this.setupPane);
        this.setCenter((BWidget)new BBorderPane((BWidget)tabs));
        int index = 0;
        if (asPrint) {
            TypeInfo pdfExporter = Sys.getRegistry().getType("pdf:PdfExporter");
            for (int i = 0; i < this.exporters.length; ++i) {
                if (!this.exporters[i].agent.getAgentType().is(pdfExporter)) continue;
                index = i;
                break;
            }
        }
        this.exporterField.getList().setSelectedIndex(index);
    }

    BWidget buildAction() {
        this.exporterField = new BListDropDown();
        this.exporterField.getList().setSelection((ListSelection)new ExporterListSelection());
        for (int i = 0; i < this.exporters.length; ++i) {
            ExporterItem item = this.exporters[i];
            this.exporterField.getList().addItem(item.icon, (Object)item.label);
        }
        BGridPane exporterPane = new BGridPane(2);
        exporterPane.add(null, (BValue)new BLabel(this.lex.getText("exporter.select.exporter")));
        exporterPane.add(null, (BValue)this.exporterField);
        ToggleCommandGroup actionGroup = new ToggleCommandGroup();
        actionGroup.add(this.actionViewInternal);
        actionGroup.add(this.actionViewExternal);
        actionGroup.add(this.actionEmail);
        actionGroup.add(this.actionSave);
        this.actionViewExternal.setSelected(true);
        this.email = new BTextField("", 55, false);
        this.saveOrd = new BTextField("", 55, false);
        BEdgePane savePane = new BEdgePane();
        savePane.setRight((BWidget)new BButton(this.saveBrowse));
        BGridPane actionPane = new BGridPane(1);
        actionPane.setColumnAlign(BHalign.fill);
        BWbShell shell = this.shell();
        if (!(shell instanceof BNiagaraWbApplet)) {
            actionPane.add(null, (BValue)new BRadioButton(this.actionViewInternal));
        }
        actionPane.add(null, (BValue)new BRadioButton(this.actionViewExternal));
        actionPane.add(null, (BValue)new BRadioButton(this.actionSave));
        actionPane.add(null, (BValue)new BBorderPane((BWidget)this.saveOrd, 0.0, 0.0, 0.0, 20.0));
        actionPane.add(null, (BValue)new BBorderPane((BWidget)savePane, 0.0, 0.0, 0.0, 20.0));
        BGridPane pane = new BGridPane(1);
        pane.setValign(BValign.top);
        pane.setHalign(BHalign.left);
        pane.add(null, (BValue)exporterPane);
        pane.add(null, (BValue)new BBorderPane((BWidget)actionPane, 10.0, 0.0, 0.0, 0.0));
        return new BBorderPane((BWidget)pane);
    }

    ExporterItem[] findExporters(BWbProfile profile) {
        Array acc = new Array(class$com$tridium$workbench$file$BExportDialog$ExporterItem == null ? (class$com$tridium$workbench$file$BExportDialog$ExporterItem = BExportDialog.class$("com.tridium.workbench.file.BExportDialog$ExporterItem")) : class$com$tridium$workbench$file$BExportDialog$ExporterItem);
        if (this.view != null) {
            this.findViewExporters(acc, this.view, profile);
        }
        if (this.view instanceof BWbPxView) {
            this.findPxViewExporters(acc, this.target, profile);
        }
        if (this.view instanceof BIExportableTableView) {
            this.findTableViewExporters(acc, (BIExportableTableView)((Object)this.view), profile);
        }
        if (this.target != null) {
            this.findOrdTargetExporters(acc, this.target, profile);
        }
        return (ExporterItem[])acc.trim();
    }

    void findViewExporters(Array acc, BWbView view, BWbProfile profile) {
        BOrd ord = BOrd.make((String)("view:" + view.getType()));
        OrdTarget target = ord.resolve((BObject)view);
        AgentFilter filter = AgentFilter.is((Type)BIWbViewExporter.TYPE);
        AgentList list = profile.getAgents((BObject)view).filter(filter);
        this.addExporters(acc, list, target);
    }

    void findPxViewExporters(Array acc, OrdTarget target, BWbProfile profile) {
        BAbstractPxView pxView = ((BWbPxView)this.view).getPxAgent();
        AgentFilter filter = AgentFilter.is((Type)BExporter.TYPE);
        AgentList list = profile.getAgents(target.get()).filter(filter);
        NAgentList remove = new NAgentList();
        for (int i = 0; i < list.size(); ++i) {
            String b;
            String a;
            AgentInfo info = list.get(i);
            if (info instanceof PxUtil.PxAgent && (a = pxView.getAgentId()).equals(b = ((PxUtil.PxAgent)info).getPxView().getAgentId())) continue;
            remove.add(info);
        }
        list.remove((AgentList)remove);
        this.addExporters(acc, list, target);
        this.findEmbeddedViews(acc, this.view, profile);
    }

    void findEmbeddedViews(Array acc, BWidget widget, BWbProfile profile) {
        BWidget[] children = widget.getChildWidgets();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof BWbView) {
                this.findViewExporters(acc, (BWbView)children[i], profile);
                continue;
            }
            this.findEmbeddedViews(acc, children[i], profile);
        }
    }

    void findTableViewExporters(Array acc, BIExportableTableView view, BWbProfile profile) {
        BITable itable = view.getExportTable().getModel().export();
        OrdTarget target = BOrd.make((String)"view:?dummy=dummy").resolve((BObject)itable, (Context)itable.getTableFacets());
        this.findOrdTargetExporters(acc, target, profile);
    }

    void findOrdTargetExporters(Array acc, OrdTarget target, BWbProfile profile) {
        AgentFilter filter = AgentFilter.is((Type)BExporter.TYPE);
        AgentList list = profile.getAgents(target.get()).filter(filter);
        list = this.pruneViewExporters(list);
        this.addExporters(acc, list, target);
    }

    AgentList pruneViewExporters(AgentList list) {
        TypeInfo[] interfaces = null;
        NAgentList removeList = new NAgentList();
        block0: for (int i = 0; i < list.size(); ++i) {
            AgentInfo info = list.get(i);
            if (info instanceof PxUtil.PxAgent) {
                removeList.add(info);
                continue;
            }
            interfaces = info.getAgentType().getInterfaces();
            for (int j = 0; j < interfaces.length; ++j) {
                if (!interfaces[j].is(BIWbViewExporter.TYPE)) continue;
                removeList.add(info);
                continue block0;
            }
        }
        list.remove((AgentList)removeList);
        return list;
    }

    void addExporters(Array acc, AgentList agents, OrdTarget target) {
        for (int i = 0; i < agents.size(); ++i) {
            acc.add((Object)new ExporterItem(agents.get(i), target));
        }
    }

    public BWbShell shell() {
        return BWbShell.getWbShell(this.owner);
    }

    void updateExporter(ExporterItem item) {
        try {
            this.cur = item;
            BExporter exporter = item.getInstance();
            this.setup = (BWbEditor)exporter.getAgents().filter(viewFilter).getDefault().getInstance();
            this.setup.loadValue((BObject)exporter);
            this.setupPane.setContent((BWidget)this.setup);
            AgentList agents = exporter.getAgents().filter(viewFilter);
            this.actionViewInternal.setEnabled(agents.size() > 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setup = null;
            this.setupPane.setContent((BWidget)new BLabel("ERROR"));
        }
    }

    int getSelectedAction() {
        if (this.actionViewInternal.isSelected()) {
            return 0;
        }
        if (this.actionViewExternal.isSelected()) {
            return 1;
        }
        if (this.actionEmail.isSelected()) {
            return 2;
        }
        if (this.actionSave.isSelected()) {
            return 3;
        }
        throw new IllegalStateException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ExporterItem {
        final AgentInfo agent;
        final OrdTarget target;
        final BImage icon;
        final String label;
        private BExporter instance;

        ExporterItem(AgentInfo agent, OrdTarget target) {
            BBinding[] bindings;
            this.agent = agent;
            this.target = target;
            this.icon = BImage.make((BIcon)agent.getIcon(null));
            StringBuffer labelText = new StringBuffer(agent.getDisplayName(null));
            BComponent targetComp = target.getComponent();
            if (targetComp != null && (bindings = (BBinding[])targetComp.getChildren(class$javax$baja$ui$BBinding == null ? (class$javax$baja$ui$BBinding = BExportDialog.class$("javax.baja.ui.BBinding")) : class$javax$baja$ui$BBinding)).length > 0) {
                labelText.append(" (").append(bindings[0].getOrd().toString()).append(")");
            }
            this.label = labelText.toString();
        }

        public BExporter getInstance() {
            if (this.instance == null) {
                this.instance = (BExporter)this.agent.getInstance();
            }
            return this.instance;
        }
    }

    class SaveBrowse
    extends Command {
        SaveBrowse(BWidget owner) {
            super(owner, (Lexicon)BExportDialog.this.lex, "exporter.save.browse");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
            chooser.setCreateFileOnSave(false);
            chooser.setConfirmOverwrite(false);
            BOrd ord = chooser.show();
            if (ord != null) {
                ord = ord.relativizeToSession();
                BExportDialog.this.saveOrd.setText(ord.toString());
            }
            return null;
        }
    }

    class ActionSave
    extends ToggleCommand {
        ActionSave(BWidget owner) {
            super(owner, (Lexicon)BExportDialog.this.lex, "exporter.action.save");
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            BExportDialog.this.saveOrd.setEditable(this.isSelected());
            BExportDialog.this.saveBrowse.setEnabled(this.isSelected());
        }
    }

    class ActionEmail
    extends ToggleCommand {
        ActionEmail(BWidget owner) {
            super(owner, (Lexicon)BExportDialog.this.lex, "exporter.action.email");
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            BExportDialog.this.email.setEditable(this.isSelected());
        }
    }

    class ActionViewExternal
    extends ToggleCommand {
        ActionViewExternal(BWidget owner) {
            super(owner, (Lexicon)BExportDialog.this.lex, "exporter.action.viewExternal");
        }
    }

    class ActionViewInternal
    extends ToggleCommand {
        ActionViewInternal(BWidget owner) {
            super(owner, (Lexicon)BExportDialog.this.lex, "exporter.action.viewInternal");
        }
    }

    class ExporterListSelection
    extends ListSelection {
        ExporterListSelection() {
        }

        public void updateList() {
            super.updateList();
            int index = this.getList().getSelectedIndex();
            if (index >= 0) {
                BExportDialog.this.updateExporter(BExportDialog.this.exporters[index]);
            }
        }
    }
}

