/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BTimeEditors
extends BWidget {
    public static final Action updateEnabledStates = BTimeEditors.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$fieldeditors$BTimeEditors == null ? (class$com$tridium$workbench$fieldeditors$BTimeEditors = BTimeEditors.class$("com.tridium.workbench.fieldeditors.BTimeEditors")) : class$com$tridium$workbench$fieldeditors$BTimeEditors));
    private static final int NONE = 0;
    private static final int FIXED = 1;
    private static final double HGAP = 8.0;
    private static final BFacets FACETS = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE, (String)"showMilliseconds", (BIDataValue)BBoolean.FALSE);
    private Context context;
    private BLabel startLabel;
    private BListDropDown startModeChoice;
    private BWbFieldEditor startEd;
    private BLabel endLabel;
    private BListDropDown endModeChoice;
    private BWbFieldEditor endEd;
    static /* synthetic */ Class class$com$tridium$workbench$fieldeditors$BTimeEditors;

    public void updateEnabledStates() {
        this.invoke(updateEnabledStates, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BTimeEditors() {
    }

    public BTimeEditors(BAbsTime startTime, BAbsTime endTime, Context context) {
        this.context = new BasicContext(context, FACETS);
        Lexicon lex = Lexicon.make((String)"bql");
        this.startLabel = new BLabel(lex.getText("dynamicTimeRangeFE.startTime") + ":");
        this.add("startLabel", (BValue)this.startLabel);
        this.startModeChoice = this.makeModeList(lex);
        this.add("startMode", (BValue)this.startModeChoice);
        this.startEd = BWbFieldEditor.makeFor((BObject)BAbsTime.DEFAULT);
        this.add("startEd", (BValue)this.startEd);
        this.setStartTime(startTime);
        this.endLabel = new BLabel(lex.getText("dynamicTimeRangeFE.endTime") + ":");
        this.add("endLabel", (BValue)this.endLabel);
        this.endModeChoice = this.makeModeList(lex);
        this.add("endMode", (BValue)this.endModeChoice);
        this.endEd = BWbFieldEditor.makeFor((BObject)BAbsTime.DEFAULT);
        this.add("endEd", (BValue)this.endEd);
        this.setEndTime(endTime);
        this.add("startLink", (BValue)new BLink((BComponent)this.startModeChoice, (Slot)BListDropDown.listActionPerformed, (Slot)updateEnabledStates));
        this.add("endLink", (BValue)new BLink((BComponent)this.endModeChoice, (Slot)BListDropDown.listActionPerformed, (Slot)updateEnabledStates));
    }

    public BAbsTime getStartTime() {
        int startMode = this.startModeChoice.getSelectedIndex();
        if (startMode == 0) {
            return BAbsTime.NULL;
        }
        BAbsTime t = null;
        try {
            t = (BAbsTime)this.startEd.saveValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t;
    }

    public BAbsTime getEndTime() {
        int endMode = this.endModeChoice.getSelectedIndex();
        if (endMode == 0) {
            return BAbsTime.NULL;
        }
        BAbsTime t = null;
        try {
            t = (BAbsTime)this.endEd.saveValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t;
    }

    public void setStartTime(BAbsTime startTime) {
        if (startTime == null || startTime.isNull()) {
            this.startModeChoice.setSelectedIndex(0);
            this.startEd.loadValue((BObject)Clock.time().timeOfDay(0, 0, 0, 0), this.context);
            this.startEd.setReadonly(true);
        } else {
            this.startModeChoice.setSelectedIndex(1);
            this.startEd.loadValue((BObject)startTime, this.context);
            this.startEd.setReadonly(false);
        }
    }

    public void setEndTime(BAbsTime endTime) {
        if (endTime == null || endTime.isNull()) {
            this.endModeChoice.setSelectedIndex(0);
            this.endEd.loadValue((BObject)Clock.time(), this.context);
            this.endEd.setReadonly(true);
        } else {
            this.endModeChoice.setSelectedIndex(1);
            this.endEd.loadValue((BObject)endTime, this.context);
            this.endEd.setReadonly(false);
        }
    }

    private BListDropDown makeModeList(Lexicon lex) {
        BListDropDown result = new BListDropDown();
        BList modeList = result.getList();
        modeList.addItem((Object)lex.getText("none"));
        modeList.addItem((Object)lex.getText("fixed"));
        result.setSelectedIndex(0);
        return result;
    }

    public void computePreferredSize() {
        double maxLabel;
        this.startLabel.computePreferredSize();
        this.startModeChoice.computePreferredSize();
        this.startEd.computePreferredSize();
        this.endLabel.computePreferredSize();
        this.endModeChoice.computePreferredSize();
        this.endEd.computePreferredSize();
        double pw = 0.0;
        double ph = 0.0;
        pw = maxLabel = Math.max(this.startLabel.getPreferredWidth(), this.endLabel.getPreferredWidth());
        pw += 8.0 + this.startModeChoice.getPreferredWidth();
        ph = this.startLabel.getPreferredHeight();
        ph = Math.max(ph, this.startModeChoice.getPreferredHeight());
        ph = Math.max(ph, this.startEd.getPreferredHeight());
        this.setPreferredSize((pw += 8.0 + this.startEd.getPreferredWidth()) + 50.0, ph *= 2.0);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        this.startLabel.computePreferredSize();
        this.startModeChoice.computePreferredSize();
        this.startEd.computePreferredSize();
        this.endLabel.computePreferredSize();
        this.endModeChoice.computePreferredSize();
        this.endEd.computePreferredSize();
        double row0 = 0.0;
        double row1 = h / 2.0;
        double rowHeight = h / 2.0;
        double maxLabel = Math.max(this.startLabel.getPreferredWidth(), this.endLabel.getPreferredWidth());
        double x = 0.0;
        this.startLabel.setBounds(x, row0 + (rowHeight - this.startLabel.getPreferredHeight()) / 2.0, this.startLabel.getPreferredWidth(), this.startLabel.getPreferredHeight());
        this.startModeChoice.setBounds(x += 8.0 + maxLabel, row0 + (rowHeight - this.startModeChoice.getPreferredHeight()) / 2.0, this.startModeChoice.getPreferredWidth(), this.startModeChoice.getPreferredHeight());
        this.startEd.setBounds(x += 8.0 + this.startModeChoice.getPreferredWidth(), row0 + (rowHeight - this.startEd.getPreferredHeight()) / 2.0, this.startEd.getPreferredWidth(), this.startEd.getPreferredHeight());
        x = 0.0;
        this.endLabel.setBounds(x, row1 + (rowHeight - this.endLabel.getPreferredHeight()) / 2.0, this.endLabel.getPreferredWidth(), this.endLabel.getPreferredHeight());
        this.endModeChoice.setBounds(x += 8.0 + maxLabel, row1 + (rowHeight - this.endModeChoice.getPreferredHeight()) / 2.0, this.endModeChoice.getPreferredWidth(), this.endModeChoice.getPreferredHeight());
        this.endEd.setBounds(x += 8.0 + this.endModeChoice.getPreferredWidth(), row1 + (rowHeight - this.endEd.getPreferredHeight()) / 2.0, this.endEd.getPreferredWidth(), this.endEd.getPreferredHeight());
    }

    public void doUpdateEnabledStates() {
        int mode = this.startModeChoice.getSelectedIndex();
        this.startEd.setReadonly(mode == 0);
        mode = this.endModeChoice.getSelectedIndex();
        this.endEd.setReadonly(mode == 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

