/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.workbench.fieldeditors.BAbsTimeFE;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BRelaxedFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$fieldeditors$BRelaxedFE == null ? (class$com$tridium$workbench$fieldeditors$BRelaxedFE = BRelaxedFE.class$("com.tridium.workbench.fieldeditors.BRelaxedFE")) : class$com$tridium$workbench$fieldeditors$BRelaxedFE));
    private static final Lexicon lex = Lexicon.make((Class)(class$com$tridium$workbench$fieldeditors$BRelaxedFE == null ? (class$com$tridium$workbench$fieldeditors$BRelaxedFE = BRelaxedFE.class$("com.tridium.workbench.fieldeditors.BRelaxedFE")) : class$com$tridium$workbench$fieldeditors$BRelaxedFE));
    public static BAbsTime END_OF_TIME = BAbsTime.make((int)9000, (BMonth)BMonth.january, (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)BTimeZone.UTC);
    private ToggleCommand cmdStrict;
    private ToggleCommand cmdRelaxed;
    private ToggleCommand cmdRelaxedUntil;
    private BAbsTimeFE editor;
    static /* synthetic */ Class class$com$tridium$workbench$fieldeditors$BRelaxedFE;

    public Type getType() {
        return TYPE;
    }

    public BRelaxedFE() {
        ToggleCommandGroup toggles = new ToggleCommandGroup();
        this.cmdStrict = new StrictToggle(this);
        toggles.add(this.cmdStrict);
        this.cmdRelaxedUntil = new RelaxedUntilToggle(this);
        toggles.add(this.cmdRelaxedUntil);
        this.cmdRelaxed = new RelaxedToggle(this);
        toggles.add(this.cmdRelaxed);
        BRadioButton strict = new BRadioButton(this.cmdStrict);
        BRadioButton relaxedUntil = new BRadioButton(this.cmdRelaxedUntil);
        BRadioButton relaxed = new BRadioButton(this.cmdRelaxed);
        this.editor = new BAbsTimeFE();
        BGridPane pane = new BGridPane(4);
        pane.add(null, (BValue)new BBorderPane((BWidget)strict, 0.0, 10.0, 0.0, 0.0));
        pane.add(null, (BValue)relaxedUntil);
        pane.add(null, (BValue)new BBorderPane((BWidget)this.editor, 0.0, 10.0, 2.0, 0.0));
        pane.add(null, (BValue)relaxed);
        this.setContent((BWidget)pane);
        this.linkTo(null, (BComponent)strict, (Slot)BRadioButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)relaxedUntil, (Slot)BRadioButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)relaxed, (Slot)BRadioButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.editor, (Slot)BAbsTimeFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.editor, (Slot)BAbsTimeFE.actionPerformed, (Slot)actionPerformed);
    }

    protected void doSetReadonly(boolean readonly) {
        this.cmdStrict.setEnabled(!readonly);
        this.cmdRelaxedUntil.setEnabled(!readonly);
        this.cmdRelaxed.setEnabled(!readonly);
        this.updateEditorState();
    }

    public void computePreferredSize() {
        super.computePreferredSize();
        BAbsTimeFE fe = new BAbsTimeFE();
        fe.computePreferredSize();
        this.setPreferredSize(this.getPreferredWidth(), fe.getPreferredHeight());
    }

    protected void doLoadValue(BObject value, Context cx) {
        BAbsTime time = (BAbsTime)value;
        if (time.equals((Object)BAbsTime.NULL)) {
            this.cmdStrict.setSelected(true);
            BAbsTime relaxedUntilTime = Clock.time().timeOfDay(23, 59, 0, 0);
            relaxedUntilTime = relaxedUntilTime.add(BRelTime.makeDays((int)30));
            this.editor.loadValue((BObject)relaxedUntilTime);
        } else if (time.equals((Object)BAbsTime.make((BAbsTime)END_OF_TIME, (BTimeZone)time.getTimeZone()))) {
            this.cmdRelaxed.setSelected(true);
            BAbsTime relaxedUntilTime = Clock.time().timeOfDay(23, 59, 0, 0);
            relaxedUntilTime = relaxedUntilTime.add(BRelTime.makeDays((int)30));
            this.editor.loadValue((BObject)relaxedUntilTime);
        } else {
            this.cmdRelaxedUntil.setSelected(true);
            this.editor.loadValue((BObject)time);
        }
        this.updateEditorState();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (this.cmdStrict.isSelected()) {
            return BAbsTime.make((BAbsTime)BAbsTime.NULL, (BTimeZone)Clock.time().getTimeZone());
        }
        if (this.cmdRelaxed.isSelected()) {
            return BAbsTime.make((BAbsTime)END_OF_TIME, (BTimeZone)Clock.time().getTimeZone());
        }
        BAbsTime time = (BAbsTime)this.editor.saveValue();
        return time;
    }

    void updateEditorState() {
        if (this.editor != null) {
            this.editor.setReadonly(this.isReadonly() || !this.cmdRelaxedUntil.isSelected());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RelaxedUntilToggle
    extends ToggleCommand {
        RelaxedUntilToggle(BWidget owner) {
            super(owner, lex.getText("relaxedFE.relaxedUntil"));
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            BRelaxedFE.this.updateEditorState();
        }
    }

    class RelaxedToggle
    extends ToggleCommand {
        RelaxedToggle(BWidget owner) {
            super(owner, lex.getText("relaxedFE.relaxed"));
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            BRelaxedFE.this.updateEditorState();
        }
    }

    class StrictToggle
    extends ToggleCommand {
        StrictToggle(BWidget owner) {
            super(owner, lex.getText("relaxedFE.strict"));
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            BRelaxedFE.this.updateEditorState();
        }
    }
}

