/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.fieldeditors.BViewQueryFE;
import com.tridium.workbench.ord.BFileOrdChooser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.file.BFileScheme;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.ViewQuery;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.ord.BIOrdChooser;

public class BOrdFE
extends BWbFieldEditor {
    public static final Property ordFieldLength = BOrdFE.newProperty((int)2, (int)60, null);
    public static final Action textModified = BOrdFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$fieldeditors$BOrdFE == null ? (class$com$tridium$workbench$fieldeditors$BOrdFE = BOrdFE.class$("com.tridium.workbench.fieldeditors.BOrdFE")) : class$com$tridium$workbench$fieldeditors$BOrdFE));
    static AgentFilter filter = new AgentFilter(){

        public boolean include(AgentInfo agent) {
            if (pxEditor != null && agent.getAgentType().is(pxEditor)) {
                return false;
            }
            if (subPxView != null && agent.getAgentType().is(subPxView)) {
                return true;
            }
            if (agent.getAgentType().is(pxView)) {
                return true;
            }
            return agent.getAgentType().is(wbView);
        }
    };
    static final TypeInfo pxView = Sys.getType((String)"baja:PxView").getTypeInfo();
    static final TypeInfo wbView = Sys.getType((String)"workbench:WbView").getTypeInfo();
    static TypeInfo pxEditor;
    static TypeInfo subPxView;
    private static BImage browseIcon;
    private static BModule module;
    private static Lexicon lex;
    private BWbShell shell = null;
    protected BTextField field = new BTextField("", 60);
    protected BButton views = new BButton();
    protected String selectedView = null;
    protected BMenu menu;
    protected Browse defaultBrowse;
    protected BButton button;
    protected BButton linkButton;
    private boolean allowLinkButton = true;
    private ArrayList list = new ArrayList();
    private BViewQueryFE viewQueryFE;
    static /* synthetic */ Class class$com$tridium$workbench$fieldeditors$BOrdFE;

    public int getOrdFieldLength() {
        return this.getInt(ordFieldLength);
    }

    public void setOrdFieldLength(int v) {
        this.setInt(ordFieldLength, v, null);
    }

    public void textModified() {
        this.invoke(textModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOrdFE() {
        this.loadMenu(this.loadTypes());
        this.views.setFont(Theme.widget().getTextFont());
        this.views.setMenuController((BAbstractButton.MenuController)new ViewController());
        this.views.setButtonStyle(BButtonStyle.toolBar);
        this.button = new BButton((Command)this.defaultBrowse);
        this.button.setMenuController((BAbstractButton.MenuController)new MenuController());
        this.button.setButtonStyle(BButtonStyle.toolBar);
        if (this.button != null) {
            this.button.setVisible(this.menu.getMenuItems().length > 0);
        }
        this.linkButton = new BButton((Command)new Hyperlink());
        this.linkButton.setButtonStyle(BButtonStyle.toolBar);
        this.viewQueryFE = new BViewQueryFE();
        BGridPane grid = new BGridPane(4);
        grid.setStretchColumn(0);
        grid.add(null, (BValue)this.field);
        grid.add(null, (BValue)this.button);
        grid.add(null, (BValue)this.views);
        grid.add(null, (BValue)this.linkButton);
        grid.add(null, (BValue)this.viewQueryFE);
        this.setContent((BWidget)grid);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextField.textModified, (Slot)textModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.viewQueryFE, (Slot)BViewQueryFE.pluginModified, (Slot)setModified);
    }

    public void doTextModified() {
        this.views.setText(lex.getText("ordFE.default"));
        this.viewQueryFE.loadValue((BObject)BString.DEFAULT);
        this.selectedView = null;
        this.setModified();
    }

    public void started() {
        this.shell = this.getWbShell();
        BObject val = this.getCurrentValue();
        if (val != null) {
            this.lockModifiedState();
            this.doLoadValue(val, this.getCurrentContext());
            this.unlockModifiedState();
        }
    }

    public void setEnabled(boolean v) {
        super.setEnabled(v);
        this.field.setEnabled(v);
    }

    protected void doSetReadonly(boolean readonly) {
        this.field.setEditable(!readonly);
        this.button.setEnabled(!readonly);
        this.views.setEnabled(!readonly);
        this.viewQueryFE.setReadonly(readonly);
    }

    private AgentInfo getAgentInfo(String agentId) {
        if (agentId == null) {
            return null;
        }
        AgentList agents = this.getAgentList();
        for (int i = 0; i < agents.size(); ++i) {
            AgentInfo info = agents.get(i);
            if (!agentId.equals(info.getAgentId())) continue;
            return info;
        }
        return null;
    }

    private void updateSelectedView(AgentInfo agentInfo) {
        this.views.setText(agentInfo.getDisplayName(null));
        this.views.setImage(BImage.make((BIcon)agentInfo.getIcon(null)));
        this.selectedView = agentInfo.getAgentId();
    }

    protected void doLoadValue(BObject v, Context cx) {
        BOrd ord = (BOrd)v;
        String ordStr = ord.toString();
        this.field.setText(ordStr);
        this.field.setVisibleColumns(this.getOrdFieldLength());
        this.views.setVisible(false);
        this.viewQueryFE.setVisible(false);
        if (this.isReadonly() && this.allowLinkButton && cx != null && cx.getFacets().getb("nVirtual", false)) {
            this.allowLinkButton = false;
        }
        this.linkButton.setVisible(this.allowLinkButton && this.getShell() != null && !(this.getShell() instanceof BDialog));
        try {
            this.defaultBrowse.info = BFileOrdChooser.TYPE.getTypeInfo();
            TypeInfo info = null;
            if (cx != null) {
                BString str;
                BBoolean b = (BBoolean)cx.getFacet("chooseView");
                if (b != null && b.getBoolean()) {
                    int index = ordStr.indexOf("|view:");
                    int lastIndex = ordStr.lastIndexOf("|view:");
                    if (index == -1) {
                        this.views.setText(lex.getText("ordFE.default"));
                    } else if (this.getWbShell() != null) {
                        this.field.setText(ordStr.substring(0, index));
                        String queryBody = ordStr.substring(lastIndex + 6);
                        this.viewQueryFE.loadValue((BObject)BString.make((String)queryBody));
                        ViewQuery vq = new ViewQuery(queryBody);
                        String agentId = vq.getViewId();
                        AgentInfo agentInfo = this.getAgentInfo(agentId);
                        if (agentInfo != null) {
                            this.updateSelectedView(agentInfo);
                        }
                    }
                    this.views.setVisible(b.getBoolean());
                    this.viewQueryFE.setVisible(b.getBoolean());
                }
                if ((str = (BString)cx.getFacet("targetType")) != null) {
                    info = Sys.getRegistry().getType(str.toString());
                }
            }
            if (info == null && !ord.isNull()) {
                try {
                    OrdQuery[] q = ord.parse();
                    if (q.length != 0) {
                        BOrdScheme scheme = BOrdScheme.lookup((String)q[q.length - 1].getScheme());
                        info = scheme.getType().getTypeInfo();
                    }
                }
                catch (SyntaxException e) {
                    // empty catch block
                }
            }
            if (info == null) {
                return;
            }
            AgentList agents = Sys.getRegistry().getAgents(info);
            agents = agents.filter(AgentFilter.is((String)"workbench:IOrdChooser"));
            if (info.getTypeSpec().getResolvedType() == BFileScheme.TYPE || agents.size() == 0) {
                return;
            }
            for (int i = 0; i < this.list.size(); ++i) {
                if (!agents.get(0).getAgentType().is((TypeInfo)this.list.get(i))) continue;
                this.defaultBrowse.info = (TypeInfo)this.list.get(i);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected BObject doSaveValue(BObject v, Context cx) throws Exception {
        return this.getOrdValue();
    }

    protected BOrd getOrdValue() throws Exception {
        BOrd ord;
        boolean hasParams;
        if (this.field.getText().length() == 0) {
            return BOrd.NULL;
        }
        String s = this.field.getText();
        String viewQueryString = this.viewQueryFE.saveValue().toString();
        String viewParams = BViewQueryFE.getParamString(viewQueryString);
        boolean bl = hasParams = viewParams.length() > 0;
        if (this.views.isVisible() && this.selectedView != null) {
            s = s + "|view:" + this.selectedView;
            if (hasParams) {
                s = s + "?" + viewParams;
            }
        } else if (hasParams) {
            s = s + "|view:?" + viewParams;
        }
        if (!(ord = BOrd.make((String)s)).isNull() && !ord.hasVariables() && this.isRelativize(ord) && ((ord = ord.relativizeToSession()).isNull() || ord.toString().length() == 0)) {
            ord = BOrd.make((String)s);
        }
        return ord;
    }

    public boolean isRelativize(BOrd currentOrd) {
        return BOrdFE.isRelativize(currentOrd, this.getCurrentContext(), this.shell);
    }

    public static boolean isRelativize(BOrd currentOrd, Context cx, BWbShell shell) {
        BBoolean val;
        BFacets facets;
        if (cx != null && (facets = cx.getFacets()) != null && (val = (BBoolean)facets.get("ordRelativize")) instanceof BBoolean) {
            return val.getBoolean();
        }
        if (shell != null) {
            BOrd activeOrd = shell.getActiveOrd();
            OrdQuery[] active = activeOrd.parse();
            OrdQuery[] current = currentOrd.parse();
            if (active.length > 1 && current.length > 1) {
                if (!active[0].toString().equals(current[0].toString())) {
                    return false;
                }
                if (!active[1].toString().equals(current[1].toString())) {
                    return false;
                }
            }
        }
        return true;
    }

    AgentList getAgentList() {
        BObject base = this.getWbShell().getActiveOrdTarget().get();
        BObject obj = BOrd.make((String)this.field.getText()).resolve(base).get();
        if (obj instanceof BComponent) {
            obj.asComponent().lease();
        }
        return obj.getAgents().filter(filter);
    }

    public TypeInfo[] loadTypes() {
        TypeInfo[] types = Sys.getRegistry().getTypes(BIOrdChooser.TYPE.getTypeInfo());
        Arrays.sort(types, new OrdFeComparator());
        return types;
    }

    public void loadMenu(TypeInfo[] types) {
        this.menu = new BMenu();
        for (int i = 0; i < types.length; ++i) {
            if (types[i].isAbstract()) continue;
            if (this.defaultBrowse == null) {
                this.defaultBrowse = new Browse(types[i], true);
            }
            this.menu.add(null, (Command)new Browse(types[i], false));
            this.list.add(types[i]);
        }
        if (this.button != null) {
            this.button.setVisible(this.menu.getMenuItems().length > 0);
        }
    }

    public void allowLinkButton(boolean allow) {
        this.allowLinkButton = allow;
    }

    public BTextField getTextField() {
        return this.field;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            pxEditor = Sys.getType((String)"pxEditor:PxEditor").getTypeInfo();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            subPxView = Sys.getType((String)"exportTags:SubstitutePxView").getTypeInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        browseIcon = BImage.make((String)"module://icons/x16/open.png");
        module = Sys.getModuleForClass((Class)(class$com$tridium$workbench$fieldeditors$BOrdFE == null ? (class$com$tridium$workbench$fieldeditors$BOrdFE = BOrdFE.class$("com.tridium.workbench.fieldeditors.BOrdFE")) : class$com$tridium$workbench$fieldeditors$BOrdFE));
        lex = Lexicon.make((String)"workbench");
    }

    class OrdFeComparator
    implements Comparator {
        OrdFeComparator() {
        }

        public int compare(Object o1, Object o2) {
            TypeInfo a = (TypeInfo)o1;
            TypeInfo b = (TypeInfo)o2;
            return a.getDisplayName(null).compareTo(b.getDisplayName(null));
        }
    }

    class Hyperlink
    extends Command {
        public Hyperlink() {
            super((BWidget)BOrdFE.this, module, "ordFE.hyperlink");
        }

        public CommandArtifact doInvoke() {
            try {
                BOrd ord = BOrdFE.this.getOrdValue();
                BOrdFE.this.getWbShell().hyperlink(ord);
            }
            catch (Exception e) {
                BDialog.error((BWidget)this.getOwner(), (String)"Error", (Object)"Hyperlink Failed.", (Throwable)e);
            }
            return null;
        }

        public String getLabel() {
            return null;
        }
    }

    protected class Browse
    extends Command {
        public TypeInfo info;
        public boolean def;

        public Browse(TypeInfo info, boolean def) {
            super((BWidget)BOrdFE.this, info.getDisplayName(null));
            this.info = info;
            this.def = def;
        }

        public CommandArtifact doInvoke() {
            BObject base = null;
            BWbShell shell = BOrdFE.this.getWbShell();
            if (shell != null) {
                base = shell.getActiveOrdTarget().get();
            }
            BOrd temp = BOrd.make((String)BOrdFE.this.field.getText());
            BIOrdChooser chooser = (BIOrdChooser)this.info.getInstance();
            BOrd ord = chooser.openChooser(BOrdFE.this, base, temp, BOrdFE.this.getCurrentContext());
            if (ord != null) {
                if (BOrdFE.this.isRelativize(ord)) {
                    ord = ord.relativizeToSession();
                }
                BOrdFE.this.field.setText(ord.toString());
                BOrdFE.this.views.setText(lex.getText("ordFE.default"));
                BOrdFE.this.viewQueryFE.loadValue((BObject)BString.DEFAULT);
            }
            return null;
        }

        public String getLabel() {
            return this.def ? null : super.getLabel();
        }

        public BImage getIcon() {
            return this.def ? browseIcon : null;
        }
    }

    class MenuController
    implements BAbstractButton.MenuController {
        MenuController() {
        }

        public boolean isMenuDistinct() {
            return true;
        }

        public BMenu getMenu(BAbstractButton b) {
            return BOrdFE.this.menu;
        }
    }

    class ViewController
    implements BAbstractButton.MenuController {
        ViewController() {
        }

        public boolean isMenuDistinct() {
            return false;
        }

        public BMenu getMenu(BAbstractButton b) {
            BMenu menu = new BMenu();
            menu.add(null, (Command)new Cmd(BOrdFE.this, null));
            try {
                AgentList list = BOrdFE.this.getAgentList();
                for (int i = 0; i < list.size(); ++i) {
                    menu.add(null, (Command)new Cmd(BOrdFE.this, list.get(i)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return menu;
        }

        class Cmd
        extends Command {
            AgentInfo agent;
            String text;
            BImage icon;

            public Cmd(BWidget owner, AgentInfo agent) {
                super(owner, "");
                if (agent == null) {
                    this.text = lex.getText("ordFE.default");
                    this.icon = BImage.make((String)"module://icons/x16/views/view.png");
                } else {
                    this.agent = agent;
                    this.text = agent.getDisplayName(null);
                    this.icon = BImage.make((BIcon)agent.getIcon(null));
                }
            }

            public String getLabel() {
                return this.text;
            }

            public BImage getIcon() {
                return this.icon;
            }

            public CommandArtifact doInvoke() {
                if (this.agent == null) {
                    ((ViewController)ViewController.this).BOrdFE.this.selectedView = null;
                    BOrdFE.this.viewQueryFE.loadValue((BObject)BString.DEFAULT);
                } else {
                    String id;
                    ((ViewController)ViewController.this).BOrdFE.this.selectedView = id = this.agent.getAgentId();
                    BOrdFE.this.viewQueryFE.loadValue((BObject)BString.make((String)id));
                }
                ((ViewController)ViewController.this).BOrdFE.this.views.setText(this.text);
                ((ViewController)ViewController.this).BOrdFE.this.views.setImage(this.icon);
                BOrdFE.this.setModified();
                return null;
            }
        }
    }
}

