/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.ui.theme.TextFieldTheme;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.util.BDatePickerCalendar;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BSpinnerButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.style.IStylable;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public abstract class BMultiFieldFE
extends BWbFieldEditor {
    public static final Action increment = BMultiFieldFE.newAction((int)0, null);
    public static final Action decrement = BMultiFieldFE.newAction((int)0, null);
    public static final Action showDatePicker = BMultiFieldFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$fieldeditors$BMultiFieldFE == null ? (class$com$tridium$workbench$fieldeditors$BMultiFieldFE = BMultiFieldFE.class$("com.tridium.workbench.fieldeditors.BMultiFieldFE")) : class$com$tridium$workbench$fieldeditors$BMultiFieldFE));
    public static final BImage calendarIcon = BImage.make((String)"module://icons/x16/calendar.png");
    protected Field[] fields = new Field[0];
    BSpinnerButton spinner = new BSpinnerButton();
    BWidget datePickerButton;
    int selection = 0;
    boolean paintNull;
    double prefHeight;
    static final double textViewFix = 4.0;
    static /* synthetic */ Class class$com$tridium$workbench$fieldeditors$BMultiFieldFE;

    public void increment() {
        this.invoke(increment, null, null);
    }

    public void decrement() {
        this.invoke(decrement, null, null);
    }

    public void showDatePicker() {
        this.invoke(showDatePicker, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMultiFieldFE() {
        this.add("spinner", (BValue)this.spinner, 6);
        this.linkTo("incrementLink", (BComponent)this.spinner, (Slot)BSpinnerButton.increment, (Slot)increment);
        this.linkTo("decrementLink", (BComponent)this.spinner, (Slot)BSpinnerButton.decrement, (Slot)decrement);
    }

    protected void addDatePicker() {
        if (this.get("picker") != null) {
            return;
        }
        this.datePickerButton = new BButton(calendarIcon);
        ((BButton)this.datePickerButton).setFocusTraversable(false);
        ((BButton)this.datePickerButton).setButtonStyle(BButtonStyle.toolBar);
        this.add("picker", (BValue)this.datePickerButton);
        this.linkTo("editButtonLink", (BComponent)this.datePickerButton, (Slot)BButton.actionPerformed, (Slot)showDatePicker);
    }

    protected void doSetReadonly(boolean readonly) {
        this.relayout();
    }

    public void computePreferredSize() {
        BFont font = Theme.textField().getFont();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.fields.length; ++i) {
            buf.append(this.fields[i].string());
        }
        double tw = font.width(buf.toString());
        BInsets insets = Theme.textField().getInsets();
        double pw = tw + insets.left + insets.right + Theme.spinner().getSpinnerWidth();
        double ph = font.getHeight() - 4.0 + insets.top + insets.bottom;
        if (this.datePickerButton != null && !this.isReadonly()) {
            this.datePickerButton.computePreferredSize();
            pw += this.datePickerButton.getPreferredWidth() + 5.0;
            ph = Math.max(ph, this.datePickerButton.getPreferredHeight());
        }
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        this.computePreferredSize();
        BFont font = Theme.textField().getFont();
        BInsets insets = Theme.textField().getInsets();
        this.prefHeight = this.getPreferredHeight();
        if (this.isReadonly()) {
            this.spinner.setVisible(false);
            this.spinner.setBounds(-1.0, -1.0, 0.0, 0.0);
            if (this.datePickerButton != null) {
                this.datePickerButton.setVisible(false);
                this.datePickerButton.setBounds(-1.0, -1.0, 0.0, 0.0);
            }
        } else {
            double w = this.getWidth();
            double h = this.getHeight();
            double sw = Theme.spinner().getSpinnerWidth();
            double dpw = 0.0;
            double th = font.getHeight() - 4.0 + insets.top + insets.bottom;
            if (this.datePickerButton != null) {
                this.datePickerButton.computePreferredSize();
                dpw = this.datePickerButton.getPreferredWidth();
                this.datePickerButton.setVisible(true);
                this.datePickerButton.setBounds(w - dpw, 0.0, dpw, Math.min(h, this.prefHeight));
            }
            this.spinner.setVisible(true);
            this.spinner.setBounds(w - sw - (dpw == 0.0 ? 0.0 : dpw + 5.0), 0.0, sw, Math.min(th, this.prefHeight));
        }
    }

    int fieldAt(double x, double y) {
        TextFieldTheme theme = Theme.textField();
        double currentX = theme.getInsets().left;
        BFont font = theme.getFont();
        for (int i = 0; i < this.fields.length; ++i) {
            String str = this.fields[i].string();
            if (!((currentX += font.width(str)) > x)) continue;
            return i;
        }
        return -1;
    }

    public void paint(Graphics g) {
        TextFieldTheme theme = Theme.textField();
        BFont font = theme.getFont();
        BInsets insets = theme.getInsets();
        double w = this.getWidth();
        double h = this.prefHeight;
        double tw = w - this.spinner.getWidth();
        double th = font.getHeight() - 4.0 + insets.top + insets.bottom;
        boolean readonly = this.isReadonly();
        boolean focus = this.hasFocus();
        if (this.datePickerButton != null) {
            tw -= this.datePickerButton.getWidth() + 5.0;
        }
        BBrush fg = theme.getTextBrush((IStylable)this);
        BBrush bg = theme.getControlBackground((IStylable)this);
        BBrush fgSel = theme.getSelectionForeground((IStylable)this);
        BBrush bgSel = theme.getSelectionBackground((IStylable)this);
        g.setFont(font);
        g.setBrush(bg);
        g.fillRect(0.0, 0.0, tw, th);
        g.setBrush(fg);
        double tx = insets.left;
        double ty = th - insets.bottom - 2.0;
        if (this.paintNull && this.isReadonly()) {
            g.drawString("null", tx, ty);
        } else {
            for (int i = 0; i < this.fields.length; ++i) {
                Field f = this.fields[i];
                String str = f.string();
                if (str == null) {
                    str = "?";
                }
                double strWidth = font.width(str);
                if (i == this.selection && focus) {
                    g.setBrush(bgSel);
                    g.fillRect(tx, insets.top, strWidth, th - insets.top - insets.bottom);
                    g.setBrush(fgSel);
                }
                g.drawString(str, tx, ty);
                tx += strWidth;
                g.setBrush(fg);
            }
        }
        Theme.textField().paintBorder(g, (BWidget)this, tw, th);
        this.paintChildren(g);
    }

    public String getStyleSelector() {
        return "text-editor";
    }

    public void mousePressed(BMouseEvent event) {
        super.mousePressed(event);
        if (this.isReadonly()) {
            return;
        }
        this.requestFocus();
        int f = this.fieldAt(event.getX(), event.getY());
        if (f != -1 && this.fields[f].isEditable()) {
            this.setSelection(f);
        }
    }

    public void keyTyped(BKeyEvent event) {
        char key = event.getKeyChar();
        if (key == '\n' || key == '\r') {
            this.fireActionPerformed(new BWidgetEvent(2, (BWidget)this));
            event.consume();
        } else if (this.fields[this.selection].keyTyped(key)) {
            event.consume();
        }
    }

    public void keyPressed(BKeyEvent event) {
        if (event.getModifiers() != 0) {
            return;
        }
        int s = this.selection;
        switch (event.getKeyCode()) {
            case 39: {
                do {
                    if (++s < this.fields.length) continue;
                    s = 0;
                } while (!this.fields[s].isEditable());
                this.setSelection(s);
                event.consume();
                break;
            }
            case 37: {
                do {
                    if (--s >= 0) continue;
                    s = this.fields.length - 1;
                } while (!this.fields[s].isEditable());
                this.setSelection(s);
                event.consume();
                break;
            }
            case 38: {
                this.doIncrement();
                event.consume();
                break;
            }
            case 40: {
                this.doDecrement();
                event.consume();
            }
        }
    }

    public boolean isFocusTraversable() {
        return !this.isReadonly();
    }

    public void focusGained(BFocusEvent event) {
        this.repaint();
    }

    public void focusLost(BFocusEvent event) {
        this.repaint();
    }

    public void doIncrement() {
        this.fields[this.selection].increment();
    }

    public void doDecrement() {
        this.fields[this.selection].decrement();
    }

    public void doShowDatePicker() {
        Field year = null;
        Field month = null;
        Field day = null;
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i] instanceof YearField) {
                year = this.fields[i];
            }
            if (this.fields[i] instanceof MonthField) {
                month = this.fields[i];
            }
            if (!(this.fields[i] instanceof DayField)) continue;
            day = this.fields[i];
        }
        if (year == null || month == null || day == null) {
            return;
        }
        BDatePickerCalendar picker = BDatePickerCalendar.dialog(this, year.value, BMonth.make((int)month.value));
        if (picker == null) {
            return;
        }
        year.set(picker.year);
        month.set(picker.month.getOrdinal());
        day.set(picker.day);
        this.setModified();
        this.repaint();
    }

    void setSelection(int f) {
        if (!this.fields[f].isEditable()) {
            throw new IllegalStateException();
        }
        this.fields[this.selection].typeCount = 0;
        this.selection = f;
        this.repaint();
    }

    protected void fieldModified(Field f) {
        this.setModified();
        this.repaint();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class AmPmField
    extends Field {
        String string() {
            return this.value == 0 ? "AM" : "PM";
        }

        int length() {
            return 2;
        }

        int max() {
            return 1;
        }
    }

    public class LabelField
    extends Field {
        LabelField(String s) {
            if (s == null) {
                throw new NullPointerException();
            }
            this.string = s;
        }

        int length() {
            return this.string.length();
        }

        boolean isEditable() {
            return false;
        }

        int max() {
            return 1;
        }
    }

    public class YearField
    extends Field {
        int length() {
            return 4;
        }

        int max() {
            return 2100;
        }
    }

    public class MonthTagField
    extends MonthField {
        int length() {
            return 3;
        }

        int max() {
            return 11;
        }

        public void set(int v) {
            BMonth m = BMonth.make((int)v);
            this.value = v;
            this.string = m.getShortDisplayTag(null);
            while (this.string.length() < 3) {
                this.string = this.string + " ";
            }
            if (this.string.length() > 3) {
                this.string = this.string.substring(0, 3);
            }
            if (BMultiFieldFE.this != null) {
                this.fieldModified();
            }
        }

        boolean keyTyped(int key) {
            return false;
        }
    }

    public class MonthField
    extends Field {
        int length() {
            return 2;
        }

        int max() {
            return 11;
        }

        public void set(int v) {
            this.value = v;
            this.string = String.valueOf(v + 1);
            for (int i = this.string.length(); i < this.length(); ++i) {
                this.string = "0" + this.string;
            }
            if (BMultiFieldFE.this != null) {
                this.fieldModified();
            }
        }

        boolean keyTyped(int key) {
            if (Character.isDigit((char)key)) {
                int v;
                int k = key - 48;
                if (this.typeCount == 0) {
                    v = k;
                } else {
                    int pow = 1;
                    for (int i = 0; i < this.length() - 1; ++i) {
                        pow *= 10;
                    }
                    v = (this.value + 1) % pow * 10 + k;
                }
                if (v > 0 && v <= this.max() + 1) {
                    this.set(v - 1);
                }
                ++this.typeCount;
                return true;
            }
            return false;
        }
    }

    public class DayField
    extends Field {
        int maxDay = 31;

        int length() {
            return 2;
        }

        int min() {
            return 1;
        }

        int max() {
            return this.maxDay;
        }

        void setMax(int newMax) {
            this.maxDay = newMax;
            if (this.value > this.maxDay) {
                this.set(this.maxDay);
            }
        }
    }

    public class MillisecondField
    extends Field {
        int length() {
            return 3;
        }

        int max() {
            return 999;
        }
    }

    public class SecondField
    extends Field {
        int length() {
            return 2;
        }

        int max() {
            return 59;
        }
    }

    public class MinuteField
    extends Field {
        int length() {
            return 2;
        }

        int max() {
            return 59;
        }
    }

    public class BigHourField
    extends Field {
        int length() {
            return 5;
        }

        int max() {
            return 99999;
        }
    }

    public class TwelveHourField
    extends HourField {
        int length() {
            return 2;
        }

        int min() {
            return 1;
        }

        int max() {
            return 12;
        }

        public void set(int v) {
            this.value = v;
            this.string = v == 0 ? "12" : String.valueOf(v);
            for (int i = this.string.length(); i < this.length(); ++i) {
                this.string = "0" + this.string;
            }
            if (BMultiFieldFE.this != null) {
                this.fieldModified();
            }
        }
    }

    public class HourField
    extends Field {
        int length() {
            return 2;
        }

        int max() {
            return 23;
        }
    }

    public abstract class Field {
        public int value;
        String string;
        int typeCount;

        Field() {
            this.set(this.min());
        }

        int min() {
            return 0;
        }

        abstract int max();

        abstract int length();

        boolean isEditable() {
            return true;
        }

        String string() {
            return this.string;
        }

        public void set(int v) {
            this.value = v;
            this.string = String.valueOf(v);
            for (int i = this.string.length(); i < this.length(); ++i) {
                this.string = "0" + this.string;
            }
            this.fieldModified();
        }

        void fieldModified() {
            if (!BMultiFieldFE.this.isModifiedStateLocked()) {
                BMultiFieldFE.this.fieldModified(this);
            }
        }

        void increment() {
            int v = this.value + 1;
            if (v > this.max()) {
                v = this.min();
            }
            this.set(v);
        }

        void decrement() {
            int v = this.value - 1;
            if (v < this.min()) {
                v = this.max();
            }
            this.set(v);
        }

        boolean keyTyped(int key) {
            if (Character.isDigit((char)key)) {
                int v;
                int k = key - 48;
                if (this.typeCount == 0) {
                    v = k;
                } else {
                    int pow = 1;
                    for (int i = 0; i < this.length() - 1; ++i) {
                        pow *= 10;
                    }
                    v = this.value % pow * 10 + k;
                }
                if (v <= this.max()) {
                    this.set(v);
                }
                ++this.typeCount;
                return true;
            }
            return false;
        }
    }
}

