/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.sys.Nre;
import com.tridium.ui.KeyboardLayout;
import com.tridium.ui.UiEnv;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import javax.baja.gx.BBrush;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextRenderer;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BFloatFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$fieldeditors$BFloatFE == null ? (class$com$tridium$workbench$fieldeditors$BFloatFE = BFloatFE.class$("com.tridium.workbench.fieldeditors.BFloatFE")) : class$com$tridium$workbench$fieldeditors$BFloatFE));
    private static HashMap formatters = new HashMap();
    private static DecimalFormat fSN = new DecimalFormat("0.###############E0");
    private static final long MAX_LONG_PREC = 0x20000000000000L;
    private int width = 10;
    private boolean forceSign = false;
    private BTextField field = new BTextField("", this.width);
    private BLabel postlabel = new BLabel("");
    private BLabel prelabel = new BLabel("");
    private String range = "";
    private DecimalFormat format = BFloatFE.getFormat(2, false);
    private boolean isFloat = true;
    private BUnit realUnits;
    private BUnit displayUnits;
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;
    private double MIN = Double.NEGATIVE_INFINITY;
    private double MAX = Double.POSITIVE_INFINITY;
    BBrush fg = BBrush.NULL;
    BBrush bg = BBrush.NULL;
    static /* synthetic */ Class class$com$tridium$workbench$fieldeditors$BFloatFE;

    public Type getType() {
        return TYPE;
    }

    public BFloatFE() {
        this.field.setRenderer((TextRenderer)new Renderer());
        this.field.setController((TextController)new Controller());
        BGridPane pane = new BGridPane(3);
        pane.add("pre", (BValue)this.prelabel);
        pane.add("field", (BValue)this.field);
        pane.add("post", (BValue)this.postlabel);
        this.setContent((BWidget)pane);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
    }

    protected void doSetReadonly(boolean readonly) {
        this.field.setEditable(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.isFloat = value instanceof BFloat;
        if (this.isFloat) {
            this.MIN = Double.NEGATIVE_INFINITY;
            this.MAX = Double.POSITIVE_INFINITY;
        } else {
            this.MIN = Double.NEGATIVE_INFINITY;
            this.MAX = Double.POSITIVE_INFINITY;
        }
        this.min = this.MIN;
        this.max = this.MAX;
        this.width = 10;
        double v = ((BNumber)value).getDouble();
        this.realUnits = null;
        int prec = 2;
        boolean showSeparators = false;
        this.forceSign = false;
        int convert = Nre.unitConversion;
        if (cx != null) {
            BNumber maxFacet;
            BNumber minFacet;
            BInteger widthFacet;
            BFacets facets = cx.getFacets();
            this.realUnits = (BUnit)cx.getFacet("units");
            if (this.realUnits != null && this.realUnits.isNull()) {
                this.realUnits = null;
            }
            if ((widthFacet = (BInteger)cx.getFacet("fieldWidth")) != null) {
                this.width = widthFacet.getInt();
            }
            if ((minFacet = (BNumber)cx.getFacet("min")) != null) {
                double d = this.min = this.isFloat ? (double)minFacet.getFloat() : minFacet.getDouble();
            }
            if ((maxFacet = (BNumber)cx.getFacet("max")) != null) {
                this.max = this.isFloat ? (double)maxFacet.getFloat() : maxFacet.getDouble();
            }
            convert = cx.getFacets().geti("unitConversion", convert);
            prec = facets.geti("precision", prec);
            showSeparators = facets.getb("showSeparators", showSeparators);
            this.forceSign = facets.getb("forceSign", this.forceSign);
        }
        if (this.width != 10) {
            this.field.setVisibleColumns(this.width);
        }
        this.format = BFloatFE.getFormat(prec, showSeparators);
        this.displayUnits = this.realUnits;
        if (convert != 0 && this.realUnits != null) {
            BUnitConversion c = BUnitConversion.make((int)convert);
            this.displayUnits = c.getDesiredUnit(this.realUnits);
            if (this.displayUnits != this.realUnits) {
                v = this.realUnits.convertTo(this.displayUnits, v);
                this.min = this.realUnits.convertTo(this.displayUnits, this.min);
                this.max = this.realUnits.convertTo(this.displayUnits, this.max);
            }
        }
        String postmeta = "";
        String premeta = "";
        if (this.displayUnits != null) {
            if (this.displayUnits.getIsPrefix()) {
                premeta = this.displayUnits.getSymbol();
            } else {
                postmeta = this.displayUnits.getSymbol();
            }
        }
        if (this.min != this.MIN || this.max != this.MAX) {
            this.range = '[' + this.toString(this.min) + " - " + this.toString(this.max) + ']';
            if (postmeta.length() > 0) {
                postmeta = postmeta + ' ';
            }
            postmeta = postmeta + this.range;
        }
        this.field.setText(this.toString(v));
        this.prelabel.setText(premeta);
        this.postlabel.setText(postmeta);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        String text = this.field.getText();
        double v = 0.0;
        try {
            text = TextUtil.toLowerCase((String)text);
            if (text.equals("-inf")) {
                v = Double.NEGATIVE_INFINITY;
            } else if (text.equals("+inf")) {
                v = Double.POSITIVE_INFINITY;
            } else if (text.equals("nan")) {
                v = Double.NaN;
            } else {
                String stripped = text.startsWith("+") ? text.substring(1) : text;
                ParsePosition pos = new ParsePosition(0);
                v = stripped.indexOf(101) != -1 ? fSN.parse(TextUtil.toUpperCase((String)stripped), pos).doubleValue() : this.format.parse(stripped, pos).doubleValue();
                if (pos.getIndex() != stripped.length()) {
                    throw new CannotSaveException("Invalid format: " + text);
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new CannotSaveException("Invalid format: " + nfe.getMessage());
        }
        catch (Exception e) {
            throw new CannotSaveException("Invalid format: " + text);
        }
        if (v < this.min) {
            throw new CannotSaveException(this.toString(v) + " < " + this.toString(this.min) + " " + this.range);
        }
        if (v > this.max) {
            throw new CannotSaveException(this.toString(v) + " > " + this.toString(this.max) + " " + this.range);
        }
        if (this.realUnits != this.displayUnits) {
            v = this.displayUnits.convertTo(this.realUnits, v);
        }
        BDouble savedValue = this.isFloat ? BFloat.make((float)((float)v)) : BDouble.make((double)v);
        this.field.setText(this.toString(v));
        return savedValue;
    }

    private String toString(double d) {
        String prefix;
        if (d == this.MIN) {
            return "-inf";
        }
        if (d == this.MAX) {
            return "+inf";
        }
        if (this.isFloat && Float.isNaN((float)d)) {
            return "nan";
        }
        if (!this.isFloat && Double.isNaN(d)) {
            return "nan";
        }
        String string = prefix = this.forceSign && d > 0.0 ? "+" : "";
        if (Math.IEEEremainder(d, 1.0) == 0.0) {
            if ((long)Math.abs(d) >= 0x20000000000000L) {
                return prefix + fSN.format(d);
            }
            return prefix + this.format.format(d);
        }
        return d == 0.0 ? this.format.format(d) : prefix + this.format.format(d);
    }

    public void requestFocus() {
        this.field.requestFocus();
    }

    private static DecimalFormat getFormat(int precision, boolean showSeparators) {
        String key = "" + precision + showSeparators;
        DecimalFormat formatter = (DecimalFormat)formatters.get(key);
        if (formatter == null) {
            StringBuffer pattern = new StringBuffer(16);
            if (showSeparators) {
                pattern.append("#,##0");
            } else {
                pattern.append("#0");
            }
            if (precision > 0) {
                pattern.append('.');
                for (int i = 0; i < precision; ++i) {
                    pattern.append('0');
                }
            }
            formatter = new DecimalFormat(pattern.toString());
            formatters.put(key, formatter);
        }
        return formatter;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 306: {
                this.fg = (BBrush)a;
                this.bg = (BBrush)b;
                this.repaint();
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Controller
    extends TextController {
        private static final BOrd defNumberpad = BOrd.make((String)"module://bajaui/com/tridium/ui/numberpad.xml");
        private static KeyboardLayout numberpad;

        public void mouseReleased(BMouseEvent event) {
            BTextEditor editor = this.getEditor();
            if (!UiEnv.get().hasKeyboard() && editor.isEditable()) {
                UiEnv.get().input(editor, numberpad);
                return;
            }
        }

        static {
            String lang = Sys.getLanguage();
            try {
                numberpad = lang.equals("en") ? KeyboardLayout.make((BOrd)defNumberpad) : KeyboardLayout.make((BOrd)BOrd.make((String)("file:!lexicon/" + lang + "/numberpad.xml")));
            }
            catch (Exception x) {
                try {
                    numberpad = KeyboardLayout.make();
                }
                catch (Exception xx) {
                    throw new BajaRuntimeException((Throwable)xx);
                }
            }
        }
    }

    class Renderer
    extends TextRenderer {
        Renderer() {
        }

        public BBrush getBackground() {
            if (BFloatFE.this.bg.isNull()) {
                return super.getBackground();
            }
            return BFloatFE.this.bg;
        }

        public BBrush getForeground(Segment seg) {
            if (BFloatFE.this.fg.isNull()) {
                return super.getForeground(seg);
            }
            return BFloatFE.this.fg;
        }
    }
}

