/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.util.TimeFormat;
import com.tridium.workbench.fieldeditors.BMultiFieldFE;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public class BAbsTimeFE
extends BMultiFieldFE {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$fieldeditors$BAbsTimeFE == null ? (class$com$tridium$workbench$fieldeditors$BAbsTimeFE = BAbsTimeFE.class$("com.tridium.workbench.fieldeditors.BAbsTimeFE")) : class$com$tridium$workbench$fieldeditors$BAbsTimeFE));
    BMultiFieldFE.YearField year;
    BMultiFieldFE.MonthField month;
    BMultiFieldFE.DayField day;
    BTimeZone timeZone;
    static /* synthetic */ Class class$com$tridium$workbench$fieldeditors$BAbsTimeFE;

    public Type getType() {
        return TYPE;
    }

    public BAbsTimeFE() {
    }

    public BAbsTimeFE(BAbsTime time) {
        this();
        this.loadValue((BObject)time);
    }

    protected void doLoadValue(BObject value, Context cx) {
        BAbsTime abs = (BAbsTime)value;
        this.timeZone = abs.getTimeZone();
        if (abs.isNull() && this.isReadonly()) {
            this.fields = new BMultiFieldFE.Field[]{new BMultiFieldFE.LabelField(this, "null")};
            return;
        }
        ArrayList<BMultiFieldFE.Field> v = new ArrayList<BMultiFieldFE.Field>();
        int[] pattern = TimeFormat.pattern((Context)cx);
        boolean showMillis = false;
        if (cx != null) {
            BTimeZone tz;
            BBoolean b = (BBoolean)cx.getFacet("showMilliseconds");
            if (b != null) {
                showMillis = b.getBoolean();
            }
            if ((b = (BBoolean)cx.getFacet("showDate")) == null || b.getBoolean()) {
                this.addDatePicker();
            }
            if ((tz = (BTimeZone)cx.getFacet("TimeZone")) != null) {
                this.timeZone = tz;
                abs = BAbsTime.make((BAbsTime)abs, (BTimeZone)tz);
            }
        }
        block13: for (int i = 0; i < pattern.length; ++i) {
            switch (pattern[i]) {
                case 1: 
                case 2: {
                    this.year = new BMultiFieldFE.YearField(this);
                    this.year.set(abs.getYear());
                    v.add(this.year);
                    continue block13;
                }
                case 3: 
                case 4: {
                    this.month = new BMultiFieldFE.MonthField(this);
                    this.month.set(abs.getMonth().getOrdinal());
                    v.add(this.month);
                    continue block13;
                }
                case 5: {
                    this.month = new BMultiFieldFE.MonthTagField(this);
                    this.month.set(abs.getMonth().getOrdinal());
                    v.add(this.month);
                    continue block13;
                }
                case 6: 
                case 7: {
                    this.day = new BMultiFieldFE.DayField(this);
                    this.day.set(abs.getDay());
                    v.add(this.day);
                    continue block13;
                }
                case 8: 
                case 9: {
                    BMultiFieldFE.TwelveHourField hour12 = new BMultiFieldFE.TwelveHourField(this);
                    int h = abs.getHour();
                    if (h >= 12) {
                        h -= 12;
                    }
                    hour12.set(h);
                    v.add(hour12);
                    continue block13;
                }
                case 10: 
                case 11: {
                    BMultiFieldFE.HourField hour = new BMultiFieldFE.HourField(this);
                    hour.set(abs.getHour());
                    v.add(hour);
                    continue block13;
                }
                case 12: {
                    BMultiFieldFE.MinuteField min = new BMultiFieldFE.MinuteField(this);
                    min.set(abs.getMinute());
                    v.add(min);
                    continue block13;
                }
                case 13: {
                    BMultiFieldFE.AmPmField m = new BMultiFieldFE.AmPmField(this);
                    m.set(abs.getHour() < 12 ? 0 : 1);
                    v.add(m);
                    continue block13;
                }
                case 14: {
                    BMultiFieldFE.SecondField sec = new BMultiFieldFE.SecondField(this);
                    sec.set(abs.getSecond());
                    v.add(sec);
                    if (!showMillis) continue block13;
                    BMultiFieldFE.MillisecondField millis = new BMultiFieldFE.MillisecondField(this);
                    millis.set(abs.getMillisecond());
                    v.add(new BMultiFieldFE.LabelField(this, "."));
                    v.add(millis);
                    continue block13;
                }
                case 15: {
                    String tz = abs.getTimeZoneShortName(cx);
                    if (tz == null) {
                        tz = "???";
                    }
                    v.add(new BMultiFieldFE.LabelField(this, tz));
                    continue block13;
                }
                case 16: 
                case 17: {
                    continue block13;
                }
                default: {
                    v.add(new BMultiFieldFE.LabelField(this, "" + (char)pattern[i]));
                }
            }
        }
        this.fields = v.toArray(new BMultiFieldFE.Field[v.size()]);
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        Date targetDate = new Date(value instanceof BAbsTime ? ((BAbsTime)value).getMillis() : 0L);
        GregorianCalendar c = new GregorianCalendar((TimeZone)this.timeZone.tzSupport());
        c.setTime(targetDate);
        int targetMilliseconds = -1;
        int targetSeconds = -1;
        boolean twelveHour = false;
        boolean addPM = false;
        boolean addAM = false;
        for (int i = 0; i < this.fields.length; ++i) {
            int calendarHourOfDay;
            BMultiFieldFE.Field f = this.fields[i];
            if (f instanceof BMultiFieldFE.TwelveHourField) {
                twelveHour = true;
            }
            if (f instanceof BMultiFieldFE.YearField) {
                c.set(1, f.value);
            }
            if (f instanceof BMultiFieldFE.MonthField) {
                c.set(2, f.value);
            }
            if (f instanceof BMultiFieldFE.DayField) {
                c.set(5, f.value);
            }
            if (f instanceof BMultiFieldFE.HourField || f instanceof BMultiFieldFE.TwelveHourField) {
                calendarHourOfDay = f.value;
                if (addPM && twelveHour) {
                    if (calendarHourOfDay < 12) {
                        calendarHourOfDay += 12;
                    }
                } else if (addAM && twelveHour && calendarHourOfDay == 12) {
                    calendarHourOfDay = 0;
                }
                c.set(11, calendarHourOfDay);
            }
            if (f instanceof BMultiFieldFE.MinuteField) {
                c.set(12, f.value);
            }
            if (f instanceof BMultiFieldFE.SecondField) {
                targetSeconds = f.value;
            }
            if (f instanceof BMultiFieldFE.MillisecondField) {
                targetMilliseconds = f.value;
            }
            if (f instanceof BMultiFieldFE.AmPmField && twelveHour) {
                calendarHourOfDay = c.get(11);
                if (f.value == 1) {
                    if (calendarHourOfDay >= 12) continue;
                    c.set(11, calendarHourOfDay + 12);
                    continue;
                }
                if (calendarHourOfDay != 12) continue;
                c.set(11, 0);
                continue;
            }
            if (!(f instanceof BMultiFieldFE.AmPmField) || twelveHour) continue;
            if (f.value == 1) {
                addPM = true;
                continue;
            }
            addAM = true;
        }
        c.set(13, targetSeconds == -1 ? 0 : targetSeconds);
        c.set(14, targetMilliseconds == -1 ? 0 : targetMilliseconds);
        return BAbsTime.make((long)c.getTime().getTime(), (BTimeZone)this.timeZone);
    }

    protected void fieldModified(BMultiFieldFE.Field field) {
        if ((field == this.month || field == this.year) && this.month != null && this.year != null) {
            BMonth mon = BMonth.make((int)this.month.value);
            int daysInMonth = BAbsTime.getDaysInMonth((int)this.year.value, (BMonth)mon);
            this.day.setMax(daysInMonth);
        }
        super.fieldModified(field);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

