/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.console;

import com.tridium.nsh.NShell;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.console.BConsoleBuffer;
import com.tridium.workbench.console.BConsoleEntry;
import com.tridium.workbench.console.BConsolePane;
import com.tridium.workbench.console.ConsoleWriter;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BScrollEvent;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.view.BWbView;

public class BConsole
extends BEdgePane {
    public static final Action scrolled = BConsole.newAction((int)0, (BValue)new BScrollEvent());
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$console$BConsole == null ? (class$com$tridium$workbench$console$BConsole = BConsole.class$("com.tridium.workbench.console.BConsole")) : class$com$tridium$workbench$console$BConsole));
    public static final int BUFFER_SIZE = 500;
    BNiagaraWbShell shell;
    BLabel prompt;
    BConsoleEntry entry;
    BScrollBar scrollBar;
    BConsoleBuffer buffer;
    ExecCallback execCallback;
    NShell nsh;
    ArrayList history = new ArrayList();
    int historyPosition = -1;
    static /* synthetic */ Class class$com$tridium$workbench$console$BConsole;

    public void scrolled(BScrollEvent event) {
        this.invoke(scrolled, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BConsole() {
        throw new IllegalStateException();
    }

    public BConsole(BNiagaraWbShell shell) {
        this.shell = shell;
        this.entry = new BConsoleEntry(this);
        this.buffer = new BConsoleBuffer(this);
        this.nsh = new ConsoleShell(new PrintStream(new ConsoleWriter(this)));
        this.scrollBar = new BScrollBar();
        this.prompt = new BLabel(">", Theme.textEditor().getFont());
        this.scrollBar.setMin(0);
        this.scrollBar.setMax(499);
        this.scrollBar.setExtent(10);
        this.scrollBar.setPosition(489);
        this.scrollBar.setUnitIncrement(1);
        this.linkTo("scrollLink", (BComponent)this.scrollBar, (Slot)BScrollBar.positionChanged, (Slot)scrolled);
        this.updatePrompt();
        this.setCenter((BWidget)new BConsolePane(this.buffer, this.prompt, this.entry));
        this.setRight((BWidget)this.scrollBar);
    }

    public String getStyleSelector() {
        return "console";
    }

    public void appendBreak() {
        this.buffer.append("", true);
    }

    public void appendLine(String line) {
        this.buffer.append(line, false);
    }

    public void show(int index) {
        String status = null;
        if (index == -1) {
            status = UiLexicon.bajaui().getText("noMore");
            if (this.buffer.highlight == -1) {
                this.showStatus(status);
                return;
            }
            index = this.buffer.highlight;
        }
        this.buffer.highlight = index;
        this.buffer.repaint();
        this.scrollToVisible(index);
        if (this.buffer.lines[index].isOrd()) {
            if (this.shell != null) {
                this.shell.hyperlink(((BConsoleBuffer.OrdLine)this.buffer.lines[index]).getHyperlinkInfo());
            }
            return;
        }
        BConsoleBuffer.FileLine line = this.buffer.getFileLine(index);
        if (this.shell != null) {
            HyperlinkInterceptor interceptor;
            BWbView view = this.shell.getActiveView();
            if (view instanceof HyperlinkInterceptor && (interceptor = (HyperlinkInterceptor)((Object)view)).consoleHyperlink(line.file, line.line1, line.col1, line.line2, line.col2)) {
                return;
            }
            this.shell.hyperlink(line.file, line.line1, line.col1, line.line2, line.col2);
        }
        if (status == null) {
            status = line.text;
        }
        this.showStatus(status);
    }

    public void next() {
        this.show(this.buffer.next());
    }

    public void prev() {
        this.show(this.buffer.prev());
    }

    public void prime() {
        this.scrollToEnd();
        this.entry.requestFocus();
    }

    public void doScrolled(BScrollEvent event) {
        this.buffer.repaint();
    }

    public void scrollToEnd() {
        this.scrollBar.setPosition(500 - this.scrollBar.getExtent() - 1);
    }

    public void mouseWheel(BMouseWheelEvent event) {
        BScrollBar sb = this.scrollBar;
        if (!sb.isVisible() || sb.getWidth() == 0.0) {
            return;
        }
        if (event.getWheelRotation() > 0) {
            sb.incrementByUnit();
        } else {
            sb.decrementByUnit();
        }
        event.consume();
    }

    public void scrollToVisible(int index) {
        int extent = this.scrollBar.getExtent();
        int start = this.scrollBar.getPosition();
        int end = start + extent;
        int count = this.scrollBar.getMax();
        if (index <= start) {
            int pos = index - 1;
            if (pos < 0) {
                pos = 0;
            }
            this.scrollBar.setPosition(pos);
        } else if (index >= end) {
            int pos = index - extent;
            if (pos >= count) {
                pos = count - 1;
            }
            if (pos < 0) {
                pos = 0;
            }
            this.scrollBar.setPosition(pos);
        }
    }

    public void nextCommand() {
        if (this.historyPosition < this.history.size() - 1) {
            ++this.historyPosition;
            this.entry.setCommand((String)this.history.get(this.historyPosition));
        }
    }

    public void prevCommand() {
        if (this.historyPosition > 0) {
            --this.historyPosition;
            this.entry.setCommand((String)this.history.get(this.historyPosition));
        }
    }

    private void updateHistory(String cmd) {
        for (int i = 0; i < this.history.size(); ++i) {
            if (!cmd.equals(this.history.get(i))) continue;
            this.history.remove(i);
            break;
        }
        this.history.add(cmd);
        this.historyPosition = this.history.size();
    }

    public void exec(String cmd) {
        this.exec(cmd, null);
    }

    public void exec(String cmd, ExecCallback execCallback) {
        this.showStatus(null);
        this.updateHistory(cmd);
        this.entry.setCommand("");
        this.scrollToEnd();
        this.entry.getUndoManager().discardAllArtifacts();
        this.buffer.append(this.prompt.getText() + cmd, true);
        if (cmd.equalsIgnoreCase("cls")) {
            this.cls();
            return;
        }
        try {
            this.execCallback = execCallback;
            this.nsh.exec(cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.nsh.out().println("Command failed: " + e);
        }
        this.shell.updateCommandStates(this.shell.getActiveView());
        this.updatePrompt();
    }

    public void kill() {
        if (!this.nsh.inExec()) {
            return;
        }
        if (4 == BDialog.confirm((BWidget)this, (Object)this.getLexicon().get("killConsoleCommand.warning.message"))) {
            this.nsh.execKill();
        }
    }

    public boolean inExec() {
        boolean running = false;
        if (this.nsh != null) {
            running = this.nsh.inExec();
        }
        return running;
    }

    public void updatePrompt() {
        this.prompt.setText(this.nsh.cd() + ">");
    }

    public void cls() {
        for (int i = 0; i < this.buffer.lines.length; ++i) {
            this.buffer.lines[i] = null;
        }
        this.buffer.repaint();
    }

    public void dump() {
        System.out.println("Console");
        System.out.println("  historyPosition = " + this.historyPosition);
        for (int i = 0; i < this.history.size(); ++i) {
            System.out.println("    history[" + i + "] = " + this.history.get(i));
        }
    }

    public void showStatus(String msg) {
        if (this.shell != null) {
            this.shell.showStatus(msg);
        } else {
            System.out.println("showStatus: " + msg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ConsoleShell
    extends NShell {
        ConsoleShell(PrintStream out) {
            super(out);
        }

        public void execWaitForDone() {
        }

        public void execDone(int exitCode) {
            super.execDone(exitCode);
            if (BConsole.this.execCallback != null) {
                try {
                    BConsole.this.execCallback.consoleExecDone(BConsole.this, exitCode);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                BConsole.this.execCallback = null;
            }
            BConsole.this.shell.updateCommandStates(BConsole.this.shell.getActiveView());
            BConsole.this.repaint();
        }
    }

    public static interface HyperlinkInterceptor {
        public boolean consoleHyperlink(File var1, int var2, int var3, int var4, int var5);
    }

    public static interface ExecCallback {
        public void consoleExecDone(BConsole var1, int var2);
    }
}

