/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.celltable;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.celltable.BAbstractCellTable;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.table.TableModel;
import javax.baja.workbench.celleditor.BWbCellEditor;

public class BLabeledCellTable
extends BAbstractCellTable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$celltable$BLabeledCellTable == null ? (class$com$tridium$workbench$celltable$BLabeledCellTable = BLabeledCellTable.class$("com.tridium.workbench.celltable.BLabeledCellTable")) : class$com$tridium$workbench$celltable$BLabeledCellTable));
    private Array rows = new Array(class$com$tridium$workbench$celltable$BLabeledCellTable$Row == null ? (class$com$tridium$workbench$celltable$BLabeledCellTable$Row = BLabeledCellTable.class$("com.tridium.workbench.celltable.BLabeledCellTable$Row")) : class$com$tridium$workbench$celltable$BLabeledCellTable$Row);
    private double[] prefCellWidths = null;
    static /* synthetic */ Class class$com$tridium$workbench$celltable$BLabeledCellTable;
    static /* synthetic */ Class class$com$tridium$workbench$celltable$BLabeledCellTable$Row;

    public Type getType() {
        return TYPE;
    }

    public BLabeledCellTable() {
        super(null, false);
        throw new IllegalStateException();
    }

    public BLabeledCellTable(final String[] colNames) {
        super(colNames, true);
        this.setModel(new TableModel(){

            public int getRowCount() {
                return BLabeledCellTable.this.rows.size();
            }

            public int getColumnCount() {
                return colNames.length + 1;
            }

            public String getColumnName(int c) {
                return c == 0 ? "" : colNames[c - 1];
            }

            public Object getSubject(int r) {
                return BLabeledCellTable.this.getRowCells(r);
            }

            public Object getValueAt(int r, int c) {
                if (c == 0) {
                    return BLabeledCellTable.this.getRowName(r);
                }
                return BLabeledCellTable.this.getRowCells(r)[c - 1];
            }
        });
    }

    public void doLayout(BWidget[] children) {
        super.doLayout(children);
        double h = this.getCellRenderer().getCellHeight();
        double y = this.getHeaderRenderer().getHeaderHeight() - 1.0;
        for (int r = 0; r < this.rows.size(); ++r) {
            BWbCellEditor[] cells = this.getRowCells(r);
            double x = 0.0;
            int n = 0;
            x = this.getCellWidth(0);
            n = 1;
            for (int c = 0; c < cells.length; ++c) {
                double w = this.getCellWidth(c + n);
                cells[c].setBounds(x, y, w, h);
                x += w;
            }
            y += h;
        }
    }

    public void computePreferredSize() {
        this.preferredCellWidths();
        super.computePreferredSize();
    }

    public void addRow(String name, BWbCellEditor[] cells) {
        this.checkEnabled(cells);
        this.insertRow(this.rows.size(), name, cells);
    }

    public void insertRow(int idx, String name, BWbCellEditor[] cells) {
        this.checkEnabled(cells);
        this.rows.add(idx, (Object)new Row(name, cells));
        this.prefCellWidths = null;
        for (int c = 0; c < this.colNames.length; ++c) {
            String stem = this.colNames[c] + this.stemCtr++;
            this.add("ce" + stem, (BValue)cells[c]);
            this.linkTo("mod" + stem, (BComponent)cells[c], (Slot)BWbCellEditor.pluginModified, (Slot)modified);
            this.rowLinks.put(cells[c], "mod" + stem);
        }
        this.resetRowIndexes();
        this.getModel().updateTable(true);
    }

    public String getRowName(int r) {
        return this.row(r).name;
    }

    public void setRowName(int r, String name) {
        this.row(r).name = name;
    }

    public void removeRow(int idx) {
        BWbCellEditor[] cells = this.getRowCells(idx);
        this.rows.remove(idx);
        this.prefCellWidths = null;
        for (int c = 0; c < cells.length; ++c) {
            this.remove(cells[c].getPropertyInParent());
            this.remove((String)this.rowLinks.get((Object)cells[c]));
            this.rowLinks.remove((Object)cells[c]);
        }
        this.resetRowIndexes();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public void clearRows() {
        for (int r = 0; r < this.rows.size(); ++r) {
            BWbCellEditor[] cells = this.getRowCells(r);
            for (int c = 0; c < cells.length; ++c) {
                this.remove(cells[c].getPropertyInParent());
                this.remove((String)this.rowLinks.get((Object)cells[c]));
            }
        }
        this.rows.clear();
        this.prefCellWidths = null;
        this.rowLinks.clear();
    }

    public BWbCellEditor[] getRowCells(int r) {
        return this.row(r).cells;
    }

    private void resetRowIndexes() {
        for (int r = 0; r < this.rows.size(); ++r) {
            BWbCellEditor[] cells = this.getRowCells(r);
            for (int c = 0; c < cells.length; ++c) {
                cells[c].setRowIndex(r);
            }
        }
    }

    private Row row(int r) {
        return (Row)this.rows.get(r);
    }

    protected double[] preferredCellWidths() {
        if (this.prefCellWidths == null) {
            int n = this.getModel().getColumnCount();
            this.prefCellWidths = new double[n];
            for (int c = 0; c < n; ++c) {
                this.prefCellWidths[c] = this.columnWidth(c);
            }
        }
        return this.prefCellWidths;
    }

    private double columnWidth(int c) {
        if (this.rows.size() == 0) {
            return 10.0;
        }
        if (c == 0) {
            double p = BLabeledCellTable.stringWidth(this.getRowName(0));
            for (int r = 1; r < this.rows.size(); ++r) {
                p = Math.max(p, BLabeledCellTable.stringWidth(this.getRowName(r)));
            }
            return p + 10.0;
        }
        return BLabeledCellTable.cellEditorWidth(this.getRowCells(0)[c - 1]);
    }

    private static double cellEditorWidth(BWbCellEditor ce) {
        ce.computePreferredSize();
        return ce.getPreferredWidth();
    }

    private static double stringWidth(String str) {
        return Theme.label().getTextFont().width(str);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Row {
        private String name;
        private BWbCellEditor[] cells;

        private Row(String name, BWbCellEditor[] cells) {
            this.name = name;
            this.cells = cells;
        }
    }
}

