/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bql.filter;

import com.tridium.workbench.filter.BWbFilter;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BTimeQueryBuilder
extends BFlowPane {
    public static final Property bqlEnabled = BTimeQueryBuilder.newProperty((int)0, (boolean)true, null);
    public static final Action updateState = BTimeQueryBuilder.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$bql$filter$BTimeQueryBuilder == null ? (class$com$tridium$workbench$bql$filter$BTimeQueryBuilder = BTimeQueryBuilder.class$("com.tridium.workbench.bql.filter.BTimeQueryBuilder")) : class$com$tridium$workbench$bql$filter$BTimeQueryBuilder));
    private static final int ABSOLUTE_RANGE = 0;
    private static final int TODAY = 1;
    private static final int YESTERDAY = 2;
    private static final int LAST_WEEK = 3;
    private static final int LAST_7_DAYS = 4;
    private static final int LAST_MONTH = 5;
    private static final int LAST_YEAR = 6;
    private static final int MONTH_TO_DATE = 7;
    private static final int YEAR_TO_DATE = 8;
    private BListDropDown typeChoice = new BListDropDown();
    private BWbFilter startEditor;
    private BWbFilter endEditor;
    private BPane timeEditors;
    private BFacets timeFacets;
    static /* synthetic */ Class class$com$tridium$workbench$bql$filter$BTimeQueryBuilder;

    public boolean getBqlEnabled() {
        return this.getBoolean(bqlEnabled);
    }

    public void setBqlEnabled(boolean v) {
        this.setBoolean(bqlEnabled, v, null);
    }

    public void updateState() {
        this.invoke(updateState, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BTimeQueryBuilder() {
        super(BHalign.left, 6, 4);
        this.add("typeChoice", (BValue)this.typeChoice);
        Lexicon bqlLex = Lexicon.make((String)"bql");
        this.timeEditors = new BFlowPane(BHalign.left, 4, 4);
        this.timeFacets = BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.FALSE);
        this.timeFacets = BFacets.make((BFacets)this.timeFacets, (String)"showSeconds", (BIDataValue)BBoolean.FALSE);
        this.timeFacets = BFacets.make((BFacets)this.timeFacets, (String)"showTimeZone", (BIDataValue)BBoolean.FALSE);
        BAbsTime t = BAbsTime.now();
        t = BAbsTime.make((int)t.getYear(), (BMonth)t.getMonth(), (int)t.getDay(), (int)t.getHour(), (int)t.getMinute());
        this.timeEditors.add("startLabel", (BValue)new BLabel(bqlLex.getText("dynamicTimeRangeFE.startTime")));
        this.startEditor = new BWbFilter(BWbFieldEditor.makeFor((BObject)t));
        this.startEditor.setDefault(null);
        try {
            this.startEditor.loadValue((BObject)t, (Context)this.timeFacets);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.timeEditors.add("startEd", (BValue)this.startEditor);
        this.timeEditors.add("endLabel", (BValue)new BLabel(bqlLex.getText("dynamicTimeRangeFE.endTime")));
        this.endEditor = new BWbFilter(BWbFieldEditor.makeFor((BObject)t));
        this.endEditor.setDefault(null);
        try {
            this.endEditor.loadValue((BObject)t, (Context)this.timeFacets);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.timeEditors.add("endEd", (BValue)this.endEditor);
        this.add("timeEditors", (BValue)this.timeEditors);
        this.timeEditors.setVisible(true);
        this.add("typeChange", (BValue)new BLink((BComponent)this.typeChoice, (Slot)BListDropDown.listActionPerformed, (Slot)updateState));
        this.updateOptions();
    }

    public void setStartTime(BAbsTime t) {
        if (t.getSecond() != 0 || t.getMillisecond() != 0) {
            t = BAbsTime.make((int)t.getYear(), (BMonth)t.getMonth(), (int)t.getDay(), (int)t.getHour(), (int)t.getMinute());
        }
        try {
            this.startEditor.loadValue((BObject)t, (Context)this.timeFacets);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEndTime(BAbsTime t) {
        if (t.getSecond() != 0 || t.getMillisecond() != 0) {
            t = BAbsTime.make((int)t.getYear(), (BMonth)t.getMonth(), (int)t.getDay(), (int)t.getHour(), (int)t.getMinute());
        }
        try {
            this.endEditor.loadValue((BObject)t, (Context)this.timeFacets);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void computePreferredSize() {
        boolean useBql = this.getBqlEnabled();
        if (useBql && this.typeChoice.getList().getItemCount() < 2) {
            this.updateOptions();
        }
        this.timeEditors.computePreferredSize();
        double w = this.timeEditors.getPreferredWidth();
        if (useBql) {
            this.typeChoice.computePreferredSize();
            w += this.typeChoice.getPreferredWidth() + 6.0;
        }
        double h = this.timeEditors.getPreferredHeight();
        if (useBql) {
            h = Math.max(h, this.typeChoice.getPreferredHeight());
        }
        this.setPreferredSize(w, h);
    }

    public void doLayout(BWidget[] kids) {
        boolean useBql = this.getBqlEnabled();
        if (useBql && this.typeChoice.getList().getItemCount() < 2) {
            this.updateOptions();
        }
        super.doLayout(kids);
    }

    private void updateOptions() {
        boolean useBql = this.getBqlEnabled();
        Lexicon bqlLex = Lexicon.make((String)"bql");
        BList typeList = this.typeChoice.getList();
        typeList.removeAllItems();
        typeList.addItem((Object)new RangeType(0, bqlLex.getText("timeRange.absoluteRange"), null));
        if (useBql) {
            typeList.addItem((Object)new RangeType(1, bqlLex.getText("timeRange.today"), "BqlTime.today"));
            typeList.addItem((Object)new RangeType(2, bqlLex.getText("timeRange.yesterday"), "BqlTime.yesterday"));
            typeList.addItem((Object)new RangeType(3, bqlLex.getText("timeRange.lastWeek"), "BqlTime.lastWeek"));
            typeList.addItem((Object)new RangeType(4, bqlLex.getText("timeRange.last7Days"), "BqlTime.last7Days"));
            typeList.addItem((Object)new RangeType(5, bqlLex.getText("timeRange.lastMonth"), "BqlTime.lastMonth"));
            typeList.addItem((Object)new RangeType(6, bqlLex.getText("timeRange.lastYear"), "BqlTime.lastYear"));
            typeList.addItem((Object)new RangeType(7, bqlLex.getText("timeRange.monthToDate"), "BqlTime.monthToDate"));
            typeList.addItem((Object)new RangeType(8, bqlLex.getText("timeRange.yearToDate"), "BqlTime.yearToDate"));
        }
        if (useBql) {
            typeList.setSelectedIndex(1);
        } else {
            typeList.setSelectedIndex(0);
        }
        this.updateState();
    }

    public boolean requiresBql() {
        RangeType type = (RangeType)this.typeChoice.getSelectedItem();
        return type.getId() != 0;
    }

    public String getBqlQualifier(String attrName) {
        RangeType type = (RangeType)this.typeChoice.getSelectedItem();
        if (!this.getBqlEnabled() || type != null && type.getId() == 0) {
            try {
                BAbsTime startTime = (BAbsTime)this.startEditor.saveValue(null);
                BAbsTime endTime = (BAbsTime)this.endEditor.saveValue(null);
                StringBuffer s = new StringBuffer(64);
                if (startTime != null) {
                    s.append(attrName).append(" >= AbsTime '").append(startTime.encodeToString()).append("'");
                }
                if (endTime != null) {
                    if (startTime != null) {
                        s.append(" and ");
                    }
                    s.append(attrName).append(" <= AbsTime '").append(endTime.encodeToString()).append("'");
                }
                return s.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (type != null) {
            return attrName + " in " + type.toBql();
        }
        return null;
    }

    public BAbsTime getStartTime() {
        RangeType type = (RangeType)this.typeChoice.getSelectedItem();
        if (type.getId() != 0) {
            return null;
        }
        try {
            return (BAbsTime)this.startEditor.saveValue(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public BAbsTime getEndTime() {
        RangeType type = (RangeType)this.typeChoice.getSelectedItem();
        if (type.getId() != 0) {
            return null;
        }
        try {
            return (BAbsTime)this.endEditor.saveValue(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void doUpdateState() {
        boolean useBql = this.getBqlEnabled();
        RangeType type = (RangeType)this.typeChoice.getSelectedItem();
        this.typeChoice.setVisible(useBql);
        boolean timeRange = type.getId() == 0;
        this.timeEditors.setVisible(timeRange || !useBql);
        this.relayout();
    }

    public void changed(Property p, Context c) {
        super.changed(p, c);
        if (p == bqlEnabled) {
            this.updateOptions();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RangeType {
        int id;
        String displayText;
        String bqlText;

        public RangeType(int id, String displayText, String bqlText) {
            this.id = id;
            this.displayText = displayText;
            this.bqlText = bqlText;
        }

        public String toString() {
            return this.displayText;
        }

        public String toBql() {
            return this.bqlText;
        }

        public int getId() {
            return this.id;
        }
    }
}

