/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bql.builder;

import com.tridium.bql.compiler.BqlTokenizer;
import com.tridium.bql.compiler.Constants;
import com.tridium.bql.compiler.Token;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.script.ScriptField;
import com.tridium.script.ScriptUtil;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.util.AbstractStubGen;
import com.tridium.workbench.bql.builder.BBqlQueryManager;
import com.tridium.workbench.bql.builder.BExtentChooser;
import com.tridium.workbench.fieldeditors.BDynamicTimeRangeFE;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.OpenUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Insets;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nav.BINavNode;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWindow;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.options.BMruButton;
import javax.baja.ui.options.BMruOptions;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.NavTreeNode;
import javax.baja.workbench.ord.BIOrdChooser;

public class BBqlQueryBuilder
extends BEdgePane
implements BIOrdChooser {
    public static final Action projChanged = BBqlQueryBuilder.newAction((int)0, null);
    public static final Action columnChanged = BBqlQueryBuilder.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action qualChanged = BBqlQueryBuilder.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$bql$builder$BBqlQueryBuilder == null ? (class$com$tridium$workbench$bql$builder$BBqlQueryBuilder = BBqlQueryBuilder.class$("com.tridium.workbench.bql.builder.BBqlQueryBuilder")) : class$com$tridium$workbench$bql$builder$BBqlQueryBuilder));
    static AgentFilter filter = AgentFilter.is((String)"workbench:ExtentChooser");
    int last = 0;
    static BModule module = Sys.getModuleForClass((Class)(class$com$tridium$workbench$bql$builder$BBqlQueryBuilder == null ? (class$com$tridium$workbench$bql$builder$BBqlQueryBuilder = BBqlQueryBuilder.class$("com.tridium.workbench.bql.builder.BBqlQueryBuilder")) : class$com$tridium$workbench$bql$builder$BBqlQueryBuilder));
    static Lexicon lex = Lexicon.make((String)"workbench");
    static BImage addIcon = BImage.make((String)"module://icons/x16/add.png");
    static BImage minusIcon = BImage.make((String)"module://icons/x16/subtract.png");
    static BImage browseIcon = BImage.make((String)"module://icons/x16/magnifyingGlass.png");
    static BInsets insets = BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0);
    BObject base;
    BOrd query;
    BComponentSpace station;
    Model model;
    BLabel baseLabel;
    BDynamicTimeRangeFE periodFE;
    BExtentChooser extent;
    BWidget extentParent;
    Support support = new Support();
    BGridPane projPane;
    BGridPane qualPane;
    BListDropDown projDrop;
    BListDropDown qualDrop;
    AddProj addProj;
    BMruButton mru;
    static /* synthetic */ Class class$com$tridium$workbench$bql$builder$BBqlQueryBuilder;

    public void projChanged() {
        this.invoke(projChanged, null, null);
    }

    public void columnChanged(BWidgetEvent event) {
        this.invoke(columnChanged, (BValue)event, null);
    }

    public void qualChanged(BWidgetEvent event) {
        this.invoke(qualChanged, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BOrd open(BWidget owner, BObject base, BOrd ord) {
        BBqlQueryBuilder b = new BBqlQueryBuilder(base, ord);
        return b.open(owner);
    }

    public BOrd openChooser(BWidget owner, BObject base, BOrd ord, Context cx) {
        return BBqlQueryBuilder.open(owner, base, ord);
    }

    public BOrd open(BWidget owner) {
        if (owner instanceof BNiagaraWbShell) {
            BNiagaraWbShell shell = (BNiagaraWbShell)owner;
            try {
                OrdTarget target = shell.getActiveOrdTarget();
                BObject base = this.getValidBase(target);
                this.reinitializeBase(base);
            }
            catch (Exception e) {
                e.printStackTrace();
                OpenUtil.makeErrorDisplay(shell);
                return null;
            }
        }
        if (1 == BDialog.open((BWidget)owner, (String)BBqlQueryBuilder.text("queryBuilder"), (Object)this, (int)3)) {
            if (this.model.expr == null) {
                this.extent.cleanup();
            }
            BOrd ord = this.model.toOrd();
            BMruOptions options = this.mru.getMruOptions();
            options.save(ord.relativizeToSession().toString());
            return ord;
        }
        return null;
    }

    public BObject getValidBase(OrdTarget target) {
        BObject base = null;
        while (target != null) {
            BISession currentSession;
            base = target.get();
            if (base instanceof BISpaceNode ? !((currentSession = ((BISpaceNode)base).getSession()) instanceof BLocalHost) : base instanceof BFoxSession) {
                return base;
            }
            target = target.getBaseOrdTarget();
        }
        throw new BajaRuntimeException("Cannot find Valid Base");
    }

    public void reinitializeBase(BObject base) {
        this.initializeBase(base);
        try {
            this.doBaseChanged(this.model.base);
            this.parseOrd(this.query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initializeBase(BObject base) {
        this.base = base;
        this.station = base instanceof BComponent ? ((BComponent)base).getComponentSpace() : (BComponentSpace)BOrd.make((String)"station:").resolve(base).get();
        this.model.base = this.station.getRootComponent();
    }

    public BBqlQueryBuilder() {
    }

    public BBqlQueryBuilder(BObject base, BOrd query) {
        this(base, query, true);
    }

    public BBqlQueryBuilder(BObject base, BOrd query, boolean projVisible) {
        this.query = query;
        this.model = new Model();
        this.initializeBase(base);
        this.mru = new BMruButton("bqlQueryBuilder");
        this.mru.setMruController((BMruButton.MruController)new MruController());
        BButton load = new BButton((Command)new Load((BWidget)this), false, true);
        load.setMenuController((BAbstractButton.MenuController)new LoadController());
        BToolBar bar = new BToolBar();
        bar.add(null, (BValue)load);
        bar.add(null, (Command)new Save((BWidget)this));
        bar.add(null, (Command)new Manage((BWidget)this));
        bar.add(null, (BValue)new BSeparator());
        bar.add(null, (BValue)this.mru);
        BGridPane grid = new BGridPane(1);
        grid.setStretchColumn(0);
        grid.setColumnAlign(BHalign.fill);
        grid.setRowGap(15.0);
        grid.add(null, (BValue)this.makeBase());
        if (projVisible) {
            grid.add(null, (BValue)this.makeProjHeader());
        }
        grid.add(null, (BValue)this.makeQualHeader());
        BEdgePane content = new BEdgePane();
        content.setTop((BWidget)bar);
        content.setCenter((BWidget)grid);
        this.setCenter((BWidget)content);
        try {
            this.doBaseChanged(this.model.base);
            this.parseOrd(query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BButton makeButton(Command cmd, BColor fill) {
        BButton b = new BButton(cmd);
        b.setButtonStyle(BButtonStyle.toolBar);
        if (fill != null) {
            b.setBackground(fill.toBrush());
        }
        return b;
    }

    private BWidget makeInset(BWidget content) {
        BBorderPane pane = new BBorderPane(content, BBorder.make((String)"1px solid black"), BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        return new BBorderPane((BWidget)pane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
    }

    private BWidget makeBase() {
        BLabel label = new BLabel(BBqlQueryBuilder.text("find"));
        label.setForeground(BColor.white.toBrush());
        label.setFont(Theme.widget().getBoldText());
        label.setHalign(BHalign.left);
        BEdgePane a = new BEdgePane();
        a.setLeft((BWidget)label);
        BBorderPane top = new BBorderPane((BWidget)a, BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
        top.setFill(BColor.make((int)0x666666).toBrush());
        this.baseLabel = new BLabel(BImage.make((BIcon)this.station.getNavIcon()), this.station.getNavDisplayName(null));
        this.extent = this.getExtentChooser((BObject)this.model.base);
        this.extent.setSupport(this.support);
        BBorderPane field = new BBorderPane((BWidget)this.baseLabel, BBorder.solid, BInsets.make((double)1.0, (double)10.0, (double)1.0, (double)2.0));
        field.setFill(BColor.make((int)0xEEEEEE).toBrush());
        BGridPane b = new BGridPane(4);
        b.setHalign(BHalign.left);
        b.add(null, (BValue)new BLabel(BBqlQueryBuilder.text("in")));
        b.add(null, (BValue)new BBorderPane((BWidget)field, BBorder.inset, BInsets.DEFAULT));
        b.add(null, (BValue)this.makeButton(new Chooser((BWidget)this), null));
        this.periodFE = new BDynamicTimeRangeFE();
        this.periodFE.loadValue((BObject)BDynamicTimeRange.DEFAULT);
        b.add("period", (BValue)this.periodFE);
        BGridPane c = new BGridPane(1);
        c.setHalign(BHalign.right);
        c.add("extent", (BValue)this.extent);
        this.extentParent = c;
        BEdgePane e = new BEdgePane();
        e.setLeft((BWidget)b);
        e.setCenter((BWidget)c);
        BBorderPane pane = new BBorderPane((BWidget)e, insets);
        pane.setBorder(BBorder.make((String)"top(black)"));
        BGridPane grid = new BGridPane(1);
        grid.setStretchColumn(0);
        grid.setColumnAlign(BHalign.fill);
        grid.setRowGap(0.0);
        grid.add(null, (BValue)top);
        grid.add(null, (BValue)pane);
        return this.makeInset((BWidget)grid);
    }

    private BExtentChooser getExtentChooser(BObject obj) {
        AgentList list = obj.getAgents().filter(filter);
        return (BExtentChooser)list.getDefault().getInstance();
    }

    private BWidget makeProjHeader() {
        BLabel label = new BLabel(BBqlQueryBuilder.text("choose"));
        label.setForeground(BColor.white.toBrush());
        label.setFont(Theme.widget().getBoldText());
        label.setHalign(BHalign.left);
        this.projDrop = new BListDropDown();
        this.projDrop.getList().addItem((Object)BBqlQueryBuilder.text("columns"));
        this.projDrop.getList().addItem((Object)BBqlQueryBuilder.text("expression"));
        this.projDrop.getList().getSelection().select(0);
        this.linkTo((BComponent)this.projDrop, (Slot)BListDropDown.listActionPerformed, (Slot)projChanged);
        BGridPane g = new BGridPane(2);
        g.setColumnGap(5.0);
        g.add(null, (BValue)label);
        g.add(null, (BValue)this.projDrop);
        BEdgePane a = new BEdgePane();
        a.setLeft((BWidget)g);
        this.addProj = new AddProj((BWidget)this);
        a.setRight((BWidget)this.makeButton(this.addProj, BColor.make((int)0x666666)));
        BBorderPane top = new BBorderPane((BWidget)a, BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
        top.setFill(BColor.make((int)0x666666).toBrush());
        BGridPane grid = new BGridPane(1);
        grid.setStretchColumn(0);
        grid.setColumnAlign(BHalign.fill);
        grid.setRowGap(0.0);
        grid.add(null, (BValue)top);
        this.projPane = grid;
        return this.makeInset((BWidget)this.projPane);
    }

    private BWidget makeProjSlice(boolean remove) {
        BTextDropDown drop = new BTextDropDown();
        if (remove) {
            drop.getList().setModel(this.getPropertyModelFromExtent());
            this.model.proj.add(drop);
        } else {
            drop.getList().setModel(this.getPropertyModelFromBase());
            this.model.expr = drop;
        }
        drop.getList().setSelectedIndex(0);
        drop.setText(String.valueOf(drop.getList().getSelectedItem()));
        this.linkTo((BComponent)drop, (Slot)BTextDropDown.valueModified, (Slot)columnChanged);
        BGridPane grid = new BGridPane(3);
        grid.add("dropdown", (BValue)drop);
        grid.add(null, (BValue)new BBorderPane((BWidget)new BLabel(BBqlQueryBuilder.text("columnName")), 0.0, 0.0, 0.0, 15.0));
        grid.add("alias", (BValue)new BTextField(((Item)drop.getList().getSelectedItem()).displayName));
        BEdgePane edge = new BEdgePane();
        edge.setLeft((BWidget)grid);
        BBorderPane pane = new BBorderPane((BWidget)edge, insets);
        pane.setBorder(BBorder.make((String)"top(groove)"));
        if (remove) {
            edge.setRight((BWidget)this.makeButton(new RemoveProj((BWidget)this, (BWidget)pane, (BWidget)drop), null));
        }
        return pane;
    }

    private BWidget makeProjSlice(boolean remove, String prop) {
        BWidget w = this.makeProjSlice(remove);
        BEdgePane edge = (BEdgePane)((BBorderPane)w).getContent();
        BGridPane grid = (BGridPane)edge.getLeft();
        BTextDropDown drop = (BTextDropDown)grid.get("dropdown");
        ListModel model = drop.getList().getModel();
        for (int i = 0; i < model.getItemCount(); ++i) {
            if (!model.getItem(i).toString().equals(prop)) continue;
            drop.getList().setSelectedIndex(i);
            drop.setText(String.valueOf(drop.getList().getSelectedItem()));
            break;
        }
        return w;
    }

    private BWidget makeQualHeader() {
        BLabel label = new BLabel(BBqlQueryBuilder.text("qualifier"));
        label.setForeground(BColor.white.toBrush());
        label.setFont(Theme.widget().getBoldText());
        label.setHalign(BHalign.left);
        BListDropDown drop = new BListDropDown();
        drop.getList().addItem((Object)BBqlQueryBuilder.text("all"));
        drop.getList().addItem((Object)BBqlQueryBuilder.text("any"));
        drop.getList().setSelectedIndex(0);
        this.qualDrop = drop;
        BGridPane g = new BGridPane(2);
        g.add(null, (BValue)label);
        g.add(null, (BValue)drop);
        BEdgePane a = new BEdgePane();
        a.setLeft((BWidget)g);
        a.setRight((BWidget)this.makeButton(new AddQual((BWidget)this), BColor.make((int)0x666666)));
        BBorderPane top = new BBorderPane((BWidget)a, insets);
        top.setFill(BColor.make((int)0x666666).toBrush());
        BGridPane grid = new BGridPane(1);
        grid.setStretchColumn(0);
        grid.setColumnAlign(BHalign.fill);
        grid.setRowGap(0.0);
        grid.add(null, (BValue)top);
        this.qualPane = grid;
        return this.makeInset((BWidget)this.qualPane);
    }

    private BWidget makeQualSlice(String[] s) {
        Match m = new Match();
        this.model.qual.add(m);
        m.source = new BTextDropDown();
        m.source.getList().setModel(this.getPropertyModelFromExtent());
        m.source.getList().setSelectedIndex(0);
        m.source.setText(String.valueOf(m.source.getList().getSelectedItem()));
        if (s != null) {
            m.source.setText(s[0]);
            for (int i = 0; i < m.source.getList().getItemCount(); ++i) {
                Item item = (Item)m.source.getList().getItem(i);
                if (!item.name.equals(s[0])) continue;
                m.source.getList().setSelectedIndex(i);
                break;
            }
        }
        this.linkTo((BComponent)m.source, (Slot)BTextDropDown.valueModified, (Slot)qualChanged);
        m.op = new BListDropDown();
        String[] ops = Constants.OPTYPE_STRINGS;
        for (int i = 0; i < ops.length; ++i) {
            m.op.getList().addItem((Object)ops[i]);
        }
        m.op.getList().setSelectedIndex(5);
        m.editor = new BTextField("", 40);
        BGridPane grid = new BGridPane(3);
        grid.add("source", (BValue)m.source);
        grid.add("op", (BValue)m.op);
        grid.add("editor", (BValue)m.editor);
        m.parent = grid;
        this.doQualChanged(new BWidgetEvent(1, (BWidget)m.source));
        if (s != null) {
            for (int i = 0; i < m.op.getList().getItemCount(); ++i) {
                if (!m.op.getList().getItem(i).toString().equals(s[1])) continue;
                m.op.getList().setSelectedIndex(i);
                break;
            }
            if (m.editor instanceof BTextField) {
                ((BTextField)m.editor).setText(s[2]);
            } else if (m.editor instanceof BWbFieldEditor) {
                try {
                    BWbFieldEditor fe = (BWbFieldEditor)m.editor;
                    BObject obj = fe.saveValue();
                    if (obj instanceof BSimple) {
                        obj = ((BSimple)obj).decodeFromString(s[2]);
                        fe.loadValue(obj);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        BEdgePane edge = new BEdgePane();
        edge.setLeft((BWidget)grid);
        BBorderPane pane = new BBorderPane((BWidget)edge, insets);
        pane.setBorder(BBorder.make((String)"top(groove)"));
        edge.setRight((BWidget)this.makeButton(new RemoveQual((BWidget)this, m, (BWidget)pane), null));
        return pane;
    }

    public void computePreferredSize() {
        this.getCenter().computePreferredSize();
        double pw = Math.max(750.0, this.getCenter().getPreferredWidth());
        double ph = this.getCenter().getPreferredHeight();
        this.setPreferredSize(pw, ph);
    }

    private void setQuery(BOrd ord) {
        try {
            int i;
            BWidget[] kids;
            this.model.expr = null;
            this.model.proj.clear();
            this.model.qual.clear();
            if (this.projPane != null) {
                kids = this.projPane.getChildWidgets();
                for (i = 1; i < kids.length; ++i) {
                    this.projPane.remove(kids[i].getPropertyInParent());
                }
            }
            if (this.qualPane != null) {
                kids = this.qualPane.getChildWidgets();
                for (i = 1; i < kids.length; ++i) {
                    this.qualPane.remove(kids[i].getPropertyInParent());
                }
            }
            this.parseOrd(ord);
            this.resize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resize() {
        if (this.getShell() instanceof BDialog) {
            BDialog dlg = (BDialog)this.getShell();
            Insets insets = UiEnv.get().getWindowInsets((BWindow)dlg);
            dlg.computePreferredSize();
            double h = dlg.getPreferredHeight() + insets.top + insets.bottom;
            IRectGeom cur = dlg.getScreenBounds();
            dlg.setScreenBounds(cur.x(), cur.y(), cur.width(), h);
        }
    }

    public void doBaseChanged(BINavNode node) {
        if (node instanceof BComponentSpace) {
            node = ((BComponentSpace)node).getRootComponent();
        }
        this.model.base = node;
        this.baseLabel.setText(node.getNavDisplayName(null));
        this.baseLabel.setImage(BImage.make((BIcon)node.getNavIcon()));
        this.periodFE.setVisible(this.model.isHistoryQuery());
        BExtentChooser ec = this.getExtentChooser((BObject)this.model.base);
        if (this.extent.getType().equals(ec.getType())) {
            this.extent.rootChanged(this.model.base);
        } else if (this.model.expr == null) {
            this.extent = ec;
            this.extent.setSupport(this.support);
            this.extent.rootChanged(this.model.base);
            this.extentParent.set("extent", (BValue)this.extent);
            this.support.changed();
        }
        if (this.model.expr != null) {
            ListModel m = this.model.expr.getList().getModel();
            int index = m.getSelection().getItem();
            String curr = m.getItem(index).toString();
            m = this.getPropertyModelFromBase();
            this.model.expr.getList().setModel(m);
            this.model.expr.getList().setSelectedIndex(0);
            for (int k = 0; k < m.getItemCount(); ++k) {
                if (!m.getItem(k).toString().equals(curr)) continue;
                this.model.expr.getList().setSelectedIndex(k);
                break;
            }
            this.model.expr.relayout();
        }
    }

    public void doProjChanged() {
        int i;
        if (this.projPane == null) {
            return;
        }
        int index = this.projDrop.getList().getSelection().getItem();
        if (index == this.last) {
            return;
        }
        this.last = index;
        boolean v = this.last == 0;
        this.addProj.setEnabled(v);
        BWidget[] kids = this.projPane.getChildWidgets();
        if (!v) {
            this.model.proj.clear();
            for (i = 1; i < kids.length; ++i) {
                this.projPane.remove(kids[i].getPropertyInParent());
            }
            this.projPane.add(null, (BValue)this.makeProjSlice(false));
            this.extentParent.set("extent", (BValue)new BNullWidget());
        } else {
            this.model.expr = null;
            if (kids.length > 1) {
                this.projPane.remove(kids[1].getPropertyInParent());
            }
            this.extent = this.getExtentChooser((BObject)this.model.base);
            this.extent.setSupport(this.support);
            this.extentParent.set("extent", (BValue)this.extent);
        }
        kids = this.qualPane.getChildWidgets();
        for (i = 1; i < kids.length; ++i) {
            this.qualPane.remove(kids[i].getPropertyInParent());
        }
        this.resize();
    }

    public void doColumnChanged(BWidgetEvent event) {
        BTextDropDown drop = event.getWidget() instanceof BTextDropDown ? (BTextDropDown)event.getWidget() : (BTextDropDown)event.getWidget().getParentWidget();
        BTextField field = (BTextField)drop.getParent().get("alias");
        field.setText(((Item)drop.getList().getSelectedItem()).displayName);
    }

    public void doQualChanged(BWidgetEvent event) {
        BTextDropDown drop = event.getWidget() instanceof BTextDropDown ? (BTextDropDown)event.getWidget() : (BTextDropDown)event.getWidget().getParentWidget();
        for (int i = 0; i < this.model.qual.size(); ++i) {
            Match m = (Match)this.model.qual.get(i);
            if (m.source != drop) continue;
            Item item = (Item)m.source.getList().getSelectedItem();
            if (!drop.getText().equals(item.toString()) || item.obj == null) {
                m.op.getList().setModel(this.getAllOpModel());
                m.editor = new BTextField("", 40);
            } else {
                if (item.obj instanceof BString) {
                    m.op.getList().setModel(this.getStringOpModel());
                } else if (item.obj instanceof BIComparable) {
                    m.op.getList().setModel(this.getComparableOpModel());
                } else {
                    m.op.getList().setModel(this.getObjectOpModel());
                }
                BWbFieldEditor ed = BWbFieldEditor.makeFor(item.obj);
                ed.loadValue(item.obj);
                m.editor = ed;
            }
            m.op.getList().setSelectedIndex(0);
            m.parent.set("editor", (BValue)m.editor);
        }
    }

    private ListModel getAllOpModel() {
        DefaultListModel m = new DefaultListModel();
        m.addItem((Object)"=");
        m.addItem((Object)"!=");
        m.addItem((Object)"<");
        m.addItem((Object)"<=");
        m.addItem((Object)">");
        m.addItem((Object)">=");
        m.addItem((Object)"like");
        return m;
    }

    private ListModel getStringOpModel() {
        DefaultListModel m = new DefaultListModel();
        m.addItem((Object)"=");
        m.addItem((Object)"like");
        return m;
    }

    private ListModel getComparableOpModel() {
        DefaultListModel m = new DefaultListModel();
        m.addItem((Object)"=");
        m.addItem((Object)"!=");
        m.addItem((Object)"<");
        m.addItem((Object)"<=");
        m.addItem((Object)">");
        m.addItem((Object)">=");
        return m;
    }

    private ListModel getObjectOpModel() {
        DefaultListModel m = new DefaultListModel();
        m.addItem((Object)"=");
        m.addItem((Object)"!=");
        return m;
    }

    private ListModel getPropertyModelFromBase() {
        return this.getPropertyModel((BObject)this.model.base);
    }

    private ListModel getPropertyModelFromExtent() {
        BObject obj = null;
        try {
            BTypeSpec spec = this.extent.getBaseType().getTypeSpec();
            Type type = spec.getResolvedType();
            if (type.isAbstract()) {
                Class cls = AbstractStubGen.getConcreteClass((Class)type.getTypeClass());
                obj = (BObject)cls.newInstance();
            } else {
                obj = type.getInstance();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return this.getPropertyModel(obj);
    }

    private ListModel getPropertyModel(BObject obj) {
        boolean v = this.projPane != null;
        ScriptField[] fields = ScriptUtil.scriptFields((Object)obj, (boolean)v);
        Item[] s = new Item[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            s[i] = new Item(fields[i].scriptName(), fields[i].scriptDisplayName((Object)obj, null), null);
            try {
                Type type = Sys.getType((Class)fields[i].scriptType());
                if (type.isAbstract()) continue;
                s[i].obj = type.getInstance();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Arrays.sort(s, new ItemComparator());
        DefaultListModel m = new DefaultListModel();
        for (int i = 0; i < s.length; ++i) {
            m.addItem((Object)s[i]);
        }
        return m;
    }

    private void parseOrd(BOrd ord) throws Exception {
        if (ord.isNull() || ord.toString().length() == 0) {
            return;
        }
        OrdQuery[] qs = ord.parse();
        OrdQuery q = qs[qs.length - 1];
        ArrayList<String> temp1 = new ArrayList<String>();
        ArrayList<String[]> temp2 = new ArrayList<String[]>();
        ArrayList<String> as = new ArrayList<String>();
        boolean and = true;
        int end = qs.length;
        if (q.getScheme().equals("bql")) {
            int i;
            String[] s;
            BOrd sub;
            OrdQuery[] subQs;
            if ((subQs = (sub = ord.getSubOrd(0, --end)).parse())[subQs.length - 1].getScheme().equals("history")) {
                sub = this.parseHistorySubOrd(sub, subQs);
            }
            BObject obj = sub.resolve(this.base).get();
            this.doBaseChanged((BINavNode)obj);
            String body = q.getBody();
            if (body.toLowerCase().indexOf("select") == -1 && !body.equals("null")) {
                int j;
                this.projDrop.setSelectedIndex(1);
                this.doProjChanged();
                for (j = 0; j < body.length() && body.charAt(j) != ' '; ++j) {
                }
                if (j > 0) {
                    String toMatch = body.substring(0, j);
                    ListModel m = this.model.expr.getList().getModel();
                    for (int i2 = 0; i2 < m.getItemCount(); ++i2) {
                        Item item = (Item)m.getItem(i2);
                        if (!item.name.equals(toMatch)) continue;
                        this.model.expr.getList().setSelectedIndex(i2);
                        return;
                    }
                }
                return;
            }
            if (this.projDrop != null) {
                this.projDrop.setSelectedIndex(0);
            }
            this.doProjChanged();
            BqlTokenizer tokenizer = new BqlTokenizer(q.getBody());
            Token token = tokenizer.next();
            block7: while (token.type != 2) {
                switch (token.type) {
                    case 13: {
                        token = tokenizer.next();
                        while (token.type != 16 && token.type != 15 && token.type != 2) {
                            if (token.type == 1) {
                                String lex = token.lex;
                                token = tokenizer.next();
                                while (token.type == 12) {
                                    token = tokenizer.next();
                                    lex = lex + "." + token.lex;
                                    token = tokenizer.next();
                                }
                                temp1.add(lex);
                                if (token.type == 14) {
                                    token = tokenizer.next();
                                    as.add(token.lex);
                                } else {
                                    as.add("");
                                }
                                if (token.type == 11) {
                                    token = tokenizer.next();
                                }
                                BWidget w = this.makeProjSlice(true, lex);
                                if (this.projPane == null) continue;
                                this.projPane.add(null, (BValue)w);
                                continue;
                            }
                            token = tokenizer.next();
                        }
                        continue block7;
                    }
                    case 16: {
                        token = tokenizer.next();
                        StringBuffer buf = new StringBuffer();
                        while (token.type != 15 && token.type != 2) {
                            buf.append(token.lex);
                            token = tokenizer.next();
                        }
                        this.extent.setExtent(buf.toString());
                        continue block7;
                    }
                    case 15: {
                        token = tokenizer.next();
                        while (token.type != 2) {
                            if (token.lex.equals("and")) {
                                token = tokenizer.next();
                            } else if (token.lex.equals("or")) {
                                and = false;
                                token = tokenizer.next();
                            }
                            s = new String[3];
                            s[0] = token.lex;
                            token = tokenizer.next();
                            while (token.type == 12) {
                                token = tokenizer.next();
                                s[0] = s[0] + "." + token.lex;
                                token = tokenizer.next();
                            }
                            s[1] = token.lex;
                            token = tokenizer.next();
                            s[2] = token.lex;
                            token = tokenizer.next();
                            temp2.add(s);
                        }
                        continue block7;
                    }
                }
                token = tokenizer.next();
            }
            this.support.changed();
            for (i = 0; i < temp1.size(); ++i) {
                BTextDropDown d = (BTextDropDown)this.model.proj.get(i);
                ListModel m = d.getList().getModel();
                boolean set = false;
                for (int j = 0; j < m.getItemCount(); ++j) {
                    BTextField f;
                    String s2;
                    Item item = (Item)m.getItem(j);
                    if (item.name.equals((String)temp1.get(i))) {
                        d.getList().setSelectedIndex(j);
                        d.setText(item.toString());
                        s2 = (String)as.get(i);
                        f = (BTextField)d.getParent().get("alias");
                        f.setText(s2.length() > 0 ? s2 : item.displayName);
                        set = true;
                    }
                    if (set) continue;
                    d.setText((String)temp1.get(i));
                    s2 = (String)as.get(i);
                    f = (BTextField)d.getParent().get("alias");
                    f.setText(s2.length() > 0 ? s2 : (String)temp1.get(i));
                }
            }
            this.qualDrop.setSelectedIndex(and ? 0 : 1);
            for (i = 0; i < temp2.size(); ++i) {
                s = (String[])temp2.get(i);
                this.qualPane.add(null, (BValue)this.makeQualSlice(s));
            }
        }
    }

    private BOrd parseHistorySubOrd(BOrd sub, OrdQuery[] subQueries) {
        BOrd histSubOrd = sub;
        OrdQuery hist = subQueries[subQueries.length - 1];
        int paramStart = hist.getBody().indexOf(63);
        if (paramStart < 0) {
            this.periodFE.loadValue((BObject)BDynamicTimeRange.DEFAULT);
        } else {
            String period = hist.getBody().substring(paramStart + 1);
            try {
                this.periodFE.loadValue((BObject)BDynamicTimeRange.fromOrdParams((String)period));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            histSubOrd = BOrd.make((String)("history:" + hist.getBody().substring(0, paramStart)));
            if (subQueries.length > 1) {
                histSubOrd = BOrd.make((BOrd)sub.getSubOrd(0, subQueries.length - 2), (BOrd)histSubOrd);
            }
        }
        return histSubOrd;
    }

    private BOptions getQueries() {
        return BOptions.load((String)"bqlQueries", (Type)BOptions.TYPE);
    }

    private SavedQuery[] getQueryArray() {
        ArrayList<SavedQuery> list = new ArrayList<SavedQuery>();
        BOptions op = this.getQueries();
        BComponent[] kids = op.getChildComponents();
        for (int i = 0; i < kids.length; ++i) {
            list.add(new SavedQuery(kids[i].get("name"), kids[i].get("query")));
        }
        return list.toArray(new SavedQuery[list.size()]);
    }

    static String text(String s) {
        return lex.getText("bqlQueryBuilder." + s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SavedQuery {
        public String name;
        public BOrd query;

        public SavedQuery(BValue name, BValue query) {
            this.name = ((BString)name).getString();
            this.query = (BOrd)query;
        }
    }

    class Match {
        BWidget parent = null;
        BTextDropDown source = null;
        BListDropDown op = null;
        BWidget editor = null;

        Match() {
        }
    }

    class Model {
        BINavNode base;
        ArrayList proj = new ArrayList();
        ArrayList qual = new ArrayList();
        boolean matchAll = true;
        BTextDropDown expr = null;

        Model() {
        }

        public boolean isHistoryQuery() {
            OrdQuery[] q = this.base.getNavOrd().parse();
            return q[q.length - 1].getScheme().equals("history");
        }

        public BOrd toOrd() {
            String s;
            String q = "|bql:";
            if (this.proj.size() == 0 && this.expr == null) {
                q = q + "select *";
            } else if (this.expr != null) {
                ListModel m = this.expr.getList().getModel();
                q = q + m.getItem(m.getSelection().getItem());
            } else {
                for (int i = 0; i < this.proj.size(); ++i) {
                    BTextDropDown drop = (BTextDropDown)this.proj.get(i);
                    BTextField field = (BTextField)drop.getParent().get("alias");
                    Item item = (Item)drop.getList().getSelectedItem();
                    s = drop.getText();
                    if (s.equals(item.name)) {
                        if (!item.displayName.equals(field.getText())) {
                            s = s + " as '" + field.getText() + "'";
                        }
                    } else {
                        s = s + " as '" + field.getText() + "'";
                    }
                    q = q + (i == 0 ? "select " : ",");
                    q = q + s;
                }
            }
            if (this.expr == null) {
                String e = BBqlQueryBuilder.this.extent.toBql();
                if (e != null) {
                    q = q + " " + e;
                }
                for (int i = 0; i < this.qual.size(); ++i) {
                    try {
                        String bool = BBqlQueryBuilder.this.qualDrop.getList().getSelectedIndex() == 0 ? " and " : " or ";
                        Match match = (Match)this.qual.get(i);
                        s = match.source.getText();
                        s = s + " " + match.op.getList().getSelectedItem().toString();
                        if (match.editor instanceof BTextField) {
                            s = s + " '" + ((BTextField)match.editor).getText() + "'";
                        } else if (match.editor instanceof BWbFieldEditor) {
                            BObject obj = ((BWbFieldEditor)match.editor).saveValue();
                            s = obj.isNull() || obj instanceof BNumber || obj instanceof BBoolean ? s + " " + obj.toString() : s + " '" + obj.toString() + "'";
                        }
                        q = q + (i == 0 ? " where " : bool);
                        q = q + s;
                        continue;
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                    }
                }
            }
            if (this.isHistoryQuery()) {
                BDynamicTimeRange period = BDynamicTimeRange.DEFAULT;
                try {
                    period = (BDynamicTimeRange)BBqlQueryBuilder.this.periodFE.saveValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!period.equals((Object)BDynamicTimeRange.DEFAULT)) {
                    q = "?" + period.toOrdParams() + q;
                }
            }
            return BOrd.make((String)(this.base.getNavOrd().toString() + q));
        }
    }

    class ItemComparator
    implements Comparator {
        ItemComparator() {
        }

        public int compare(Object o1, Object o2) {
            Item a = (Item)o1;
            Item b = (Item)o2;
            return a.name.compareTo(b.name);
        }
    }

    class Item {
        String name;
        String displayName;
        BObject obj;

        public Item(String name, String displayName, BObject obj) {
            this.name = name;
            this.displayName = displayName;
            this.obj = obj;
        }

        public String toString() {
            return this.name;
        }
    }

    class Support
    extends BExtentChooser.Support {
        Support() {
        }

        public void changed() {
            if (BBqlQueryBuilder.this.model.expr == null) {
                int k;
                String curr;
                int index;
                ListModel m;
                int i;
                if (BBqlQueryBuilder.this.projPane != null) {
                    for (i = 0; i < BBqlQueryBuilder.this.model.proj.size(); ++i) {
                        BTextDropDown drop = (BTextDropDown)BBqlQueryBuilder.this.model.proj.get(i);
                        m = drop.getList().getModel();
                        index = m.getSelection().getItem();
                        curr = m.getItem(index).toString();
                        m = BBqlQueryBuilder.this.getPropertyModelFromExtent();
                        drop.getList().setModel(m);
                        drop.getList().setSelectedIndex(0);
                        for (k = 0; k < m.getItemCount(); ++k) {
                            if (!m.getItem(k).toString().equals(curr)) continue;
                            drop.getList().setSelectedIndex(k);
                            break;
                        }
                        drop.setText(String.valueOf(drop.getList().getSelectedItem()));
                        drop.relayout();
                    }
                }
                for (i = 0; i < BBqlQueryBuilder.this.model.qual.size(); ++i) {
                    Match match = (Match)BBqlQueryBuilder.this.model.qual.get(i);
                    m = match.source.getList().getModel();
                    index = m.getSelection().getItem();
                    curr = m.getItem(index).toString();
                    m = BBqlQueryBuilder.this.getPropertyModelFromExtent();
                    match.source.getList().setModel(m);
                    match.source.getList().setSelectedIndex(0);
                    for (k = 0; k < m.getItemCount(); ++k) {
                        if (!m.getItem(k).toString().equals(curr)) continue;
                        match.source.getList().setSelectedIndex(k);
                        break;
                    }
                    if (!match.source.getList().getSelectedItem().toString().equals(curr)) {
                        BBqlQueryBuilder.this.doQualChanged(new BWidgetEvent(1, (BWidget)match.source));
                    }
                    match.source.relayout();
                }
            }
        }
    }

    class MruController
    extends BMruButton.MruController {
        MruController() {
        }

        public void select(String value) {
            BBqlQueryBuilder.this.setQuery(BOrd.make((String)value));
        }
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        protected void doSelectAction(TreeNode target, double x, double y) {
            BOptionDialog dlg = (BOptionDialog)this.getTree().getShell();
            dlg.getOkButton().invokeAction();
        }
    }

    class Chooser
    extends Command {
        public Chooser(BWidget owner) {
            super(owner, "");
        }

        public BImage getIcon() {
            return browseIcon;
        }

        public CommandArtifact doInvoke() {
            NavTreeNode node;
            BNavTree tree = new BNavTree(BBqlQueryBuilder.this.station.getNavParent());
            try {
                tree.expandToNavNode(BBqlQueryBuilder.this.model.base);
            }
            catch (Exception e) {
                // empty catch block
            }
            tree.setReadonly(true);
            tree.setController(new Controller());
            BConstrainedPane cpane = new BConstrainedPane((BWidget)new BTreePane((BTree)tree));
            cpane.setMinWidth(300.0);
            cpane.setMinHeight(400.0);
            BBorderPane pane = new BBorderPane((BWidget)cpane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)BBqlQueryBuilder.text("chooseBase"), (Object)pane, (int)3) && (node = (NavTreeNode)tree.getSelection().getNode()) != null) {
                BBqlQueryBuilder.this.doBaseChanged(node.getNavNode());
            }
            return null;
        }
    }

    class Manage
    extends Command {
        public Manage(BWidget owner) {
            super(owner, module, "bqlQueryBuilder.manageQueries");
        }

        public CommandArtifact doInvoke() {
            BBqlQueryManager.openInDialog(this.getOwner(), BBqlQueryBuilder.this.getQueries());
            return null;
        }
    }

    class LoadQuery
    extends Command {
        private BOrd ord;

        public LoadQuery(BWidget owner, String name, BOrd ord) {
            super(owner, name);
            this.ord = ord;
        }

        public CommandArtifact doInvoke() {
            BBqlQueryBuilder.this.setQuery(this.ord);
            return null;
        }
    }

    class Load
    extends Command {
        public Load(BWidget owner) {
            super(owner, module, "bqlQueryBuilder.loadQuery");
        }
    }

    class LoadController
    implements BAbstractButton.MenuController {
        LoadController() {
        }

        public boolean isMenuDistinct() {
            return false;
        }

        public BMenu getMenu(BAbstractButton b) {
            BMenu menu = new BMenu();
            SavedQuery[] q = BBqlQueryBuilder.this.getQueryArray();
            for (int i = 0; i < q.length; ++i) {
                menu.add(null, (Command)new LoadQuery((BWidget)b, q[i].name, q[i].query));
            }
            return menu;
        }
    }

    class Save
    extends Command {
        public Save(BWidget owner) {
            super(owner, module, "bqlQueryBuilder.saveQuery");
        }

        public CommandArtifact doInvoke() {
            BOrd ord = BBqlQueryBuilder.this.model.toOrd().relativizeToSession();
            BTextField name = new BTextField("Query", 50);
            BTextField ford = new BTextField(ord.toString(), 50);
            ford.setEditable(false);
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel("Name:"));
            grid.add(null, (BValue)name);
            grid.add(null, (BValue)new BLabel("Query:"));
            grid.add(null, (BValue)ford);
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)"Save Query", (Object)new BBorderPane((BWidget)grid), (int)3)) {
                BComponent c = new BComponent();
                c.add("name", (BValue)BString.make((String)name.getText()));
                c.add("query", (BValue)ord);
                BBqlQueryBuilder.this.getQueries().add(null, (BValue)c);
                BBqlQueryBuilder.this.getQueries().save();
            }
            return null;
        }
    }

    class RemoveQual
    extends Command {
        Match m;
        BWidget w;

        public RemoveQual(BWidget owner, Match m, BWidget w) {
            super(owner, "");
            this.m = m;
            this.w = w;
        }

        public BImage getIcon() {
            return minusIcon;
        }

        public CommandArtifact doInvoke() {
            BBqlQueryBuilder.this.model.qual.remove(this.m);
            BBqlQueryBuilder.this.qualPane.remove(this.w.getPropertyInParent());
            BBqlQueryBuilder.this.resize();
            return null;
        }
    }

    class AddQual
    extends Command {
        public AddQual(BWidget owner) {
            super(owner, "");
        }

        public BImage getIcon() {
            return addIcon;
        }

        public CommandArtifact doInvoke() {
            BBqlQueryBuilder.this.qualPane.add(null, (BValue)BBqlQueryBuilder.this.makeQualSlice(null));
            BBqlQueryBuilder.this.resize();
            return null;
        }
    }

    class RemoveProj
    extends Command {
        BWidget p;
        BWidget w;

        public RemoveProj(BWidget owner, BWidget p, BWidget w) {
            super(owner, "");
            this.p = p;
            this.w = w;
        }

        public BImage getIcon() {
            return minusIcon;
        }

        public CommandArtifact doInvoke() {
            BBqlQueryBuilder.this.model.proj.remove(this.w);
            BBqlQueryBuilder.this.projPane.remove(this.p.getPropertyInParent());
            BBqlQueryBuilder.this.resize();
            return null;
        }
    }

    class AddProj
    extends Command {
        public AddProj(BWidget owner) {
            super(owner, "");
        }

        public BImage getIcon() {
            return addIcon;
        }

        public CommandArtifact doInvoke() {
            BBqlQueryBuilder.this.projPane.add(null, (BValue)BBqlQueryBuilder.this.makeProjSlice(true));
            BBqlQueryBuilder.this.resize();
            return null;
        }
    }
}

