/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bookmark;

import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.bookmark.BBookmarkMenu;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BViewTabbedPane;
import com.tridium.workbench.shell.WbHistory;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkFolder;
import javax.baja.ui.bookmark.BBookmarkItem;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSubject;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BookmarkUtil {
    private TreeNode last = null;
    private static BModule module = Sys.getModuleForClass((Class)(class$com$tridium$workbench$bookmark$BBookmarkMenu == null ? (class$com$tridium$workbench$bookmark$BBookmarkMenu = BookmarkUtil.class$("com.tridium.workbench.bookmark.BBookmarkMenu")) : class$com$tridium$workbench$bookmark$BBookmarkMenu));
    private static BImage folderIcon = BImage.make((String)"module://icons/x16/bookmarkFolder.png");
    private BWidget owner;
    private BBookmarkFolder rootFolder;
    private BBookmark bookmark;
    private BTextField name;
    private BTree tree;
    static /* synthetic */ Class class$javax$baja$ui$bookmark$BBookmarkFolder;
    static /* synthetic */ Class class$com$tridium$workbench$bookmark$BBookmarkMenu;

    public static void add(BWidget owner, BBookmarkFolder folder, BBookmark bookmark) {
        BookmarkUtil.add(owner, folder, null, bookmark);
    }

    public static void add(BWidget owner, BBookmarkFolder folder, BBookmarkFolder init, BBookmark bookmark) {
        BookmarkUtil util = new BookmarkUtil(owner);
        BWidget pane = util.makeAdd(folder, init, bookmark);
        if (1 == BDialog.open((BWidget)owner, (String)BookmarkUtil.lex().getText("bookmark.add.label"), (Object)new BBorderPane(pane), (int)3)) {
            util.bookmark.setText(util.name.getText());
            TreeNode node = util.tree.getSelection().getNode();
            BBookmarkFolder f = ((Node)node).folder;
            f.add(null, (BValue)util.bookmark);
        }
    }

    public static void add(BWidget owner, BBookmarkFolder root, BBookmark[] tabs) {
        BookmarkUtil util = new BookmarkUtil(owner);
        BBookmark tf = new BBookmark("New Folder");
        BWidget pane = util.makeAdd(root, null, tf);
        if (1 == BDialog.open((BWidget)owner, (String)BookmarkUtil.lex().getText("bookmark.addAll.label"), (Object)new BBorderPane(pane), (int)3)) {
            TreeNode node = util.tree.getSelection().getNode();
            BBookmarkFolder f = ((Node)node).folder;
            BBookmarkFolder tabFolder = new BBookmarkFolder(util.name.getText());
            for (int i = 0; i < tabs.length; ++i) {
                tabFolder.add(null, (BValue)tabs[i]);
            }
            f.add(null, (BValue)tabFolder);
        }
    }

    public static BBookmarkFolder copy(BWidget owner, BBookmarkFolder folder, BComponent[] clipboard) {
        BookmarkUtil util = new BookmarkUtil(owner);
        BWidget pane = util.makeMove(folder, BookmarkUtil.lex().getText("bookmark.copyTo"));
        if (1 == BDialog.open((BWidget)owner, (String)BookmarkUtil.lex().getText("bookmark.copyTo"), (Object)new BBorderPane(pane), (int)3)) {
            TreeNode node = util.tree.getSelection().getNode();
            BBookmarkFolder dest = ((Node)node).folder;
            for (int i = 0; i < clipboard.length; ++i) {
                dest.add(null, clipboard[i].newCopy());
            }
            return dest;
        }
        return null;
    }

    public static BBookmarkFolder move(BWidget owner, BBookmarkFolder folder, BComponent[] clipboard) {
        BookmarkUtil util = new BookmarkUtil(owner);
        BWidget pane = util.makeMove(folder, BookmarkUtil.lex().getText("bookmark.moveTo"));
        if (1 == BDialog.open((BWidget)owner, (String)BookmarkUtil.lex().getText("bookmark.moveTo"), (Object)new BBorderPane(pane), (int)3)) {
            int i;
            TreeNode node = util.tree.getSelection().getNode();
            BBookmarkFolder dest = ((Node)node).folder;
            for (i = 0; i < clipboard.length; ++i) {
                BBookmarkFolder c = dest;
                while (c instanceof BBookmarkItem) {
                    if (c == clipboard[i]) {
                        BDialog.error((BWidget)owner, (Object)BookmarkUtil.lex().getText("bookmark.manage.cannotMove"));
                        return null;
                    }
                    c = c.getParent().asComponent();
                }
            }
            for (i = 0; i < clipboard.length; ++i) {
                clipboard[i].getParent().asComponent().remove((BComplex)clipboard[i]);
                dest.add(null, (BValue)clipboard[i]);
            }
            return dest;
        }
        return null;
    }

    public static void open(BWbShell shell, BBookmark mark) {
        BookmarkUtil.open(shell, mark, false);
    }

    public static void open(BWbShell shell, BBookmark mark, boolean newTab) {
        BNiagaraWbShell nwbShell;
        if (newTab) {
            shell.hyperlink(new HyperlinkInfo(mark.getBookmarkOrd(), BHyperlinkMode.newTab));
        } else {
            shell.hyperlink(mark.getBookmarkOrd());
        }
        if (shell instanceof BNiagaraWbShell && (nwbShell = (BNiagaraWbShell)shell).getActiveOrdTarget() != null) {
            nwbShell.syncTree(true);
        }
    }

    public static BBookmark makeForCurrentContext(BWbShell shell) {
        BOrd ord = shell.getActiveOrd();
        String name = WbHistory.toName(ord);
        BObject obj = shell.getActiveOrdTarget().get();
        return new BBookmark(name, ord, obj.getIcon());
    }

    public static BBookmark makeForTab(BViewTab tab) {
        BOrd ord = tab.getOrd();
        String name = WbHistory.toName(ord);
        BObject obj = tab.getTarget().get();
        return new BBookmark(name, ord, obj.getIcon());
    }

    public static BViewTab[] tabs(BWbShell shell) {
        if (!(shell instanceof BNiagaraWbShell)) {
            return new BViewTab[0];
        }
        BNiagaraWbShell ns = (BNiagaraWbShell)shell;
        return ((BViewTabbedPane)ns.tab().getParentWidget()).getTabs();
    }

    private BookmarkUtil(BWidget owner) {
        this.owner = owner;
    }

    private BWidget makeAdd(BBookmarkFolder folder, BBookmarkFolder init, BBookmark bookmark) {
        this.rootFolder = folder;
        this.bookmark = bookmark;
        this.name = new BTextField(bookmark.getText());
        this.tree = new BTree((TreeModel)new Model());
        this.tree.setController((TreeController)new Controller());
        this.last = this.tree.getModel().getRoot(0);
        this.tree.getSelection().select(this.last);
        BToolBar toolbar = new BToolBar();
        toolbar.add(null, (Command)new NewFolder(this.owner));
        BEdgePane a = new BEdgePane();
        a.setLeft((BWidget)new BBorderPane((BWidget)new BLabel(BookmarkUtil.lex().getText("bookmark.name")), 0.0, 0.0, 0.0, 5.0));
        a.setCenter((BWidget)this.name);
        BEdgePane b = new BEdgePane();
        b.setLeft((BWidget)new BLabel(BookmarkUtil.lex().getText("bookmark.createIn")));
        b.setRight((BWidget)toolbar);
        BEdgePane top = new BEdgePane();
        top.setTop((BWidget)a);
        top.setBottom((BWidget)new BBorderPane((BWidget)b, 5.0, 0.0, 0.0, 0.0));
        BEdgePane content = new BEdgePane();
        content.setTop((BWidget)top);
        content.setCenter((BWidget)new BBorderPane((BWidget)new BTreePane(this.tree), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        if (init != null) {
            TreeNode node = this.findNode((BComponent)init);
            this.tree.scrollNodeToVisible(node);
            this.tree.getSelection().select(node);
        }
        return this.makeConstrainedPane((BWidget)content, 400, 300);
    }

    private BWidget makeMove(BBookmarkFolder folder, String label) {
        this.rootFolder = folder;
        this.tree = new BTree((TreeModel)new Model());
        this.tree.setController((TreeController)new Controller());
        this.last = this.tree.getModel().getRoot(0);
        this.tree.getSelection().select(this.last);
        BToolBar toolbar = new BToolBar();
        toolbar.add(null, (Command)new NewFolder(this.owner));
        BEdgePane top = new BEdgePane();
        top.setLeft((BWidget)new BLabel(label));
        top.setRight((BWidget)toolbar);
        BEdgePane content = new BEdgePane();
        content.setTop((BWidget)top);
        content.setCenter((BWidget)new BBorderPane((BWidget)new BTreePane(this.tree), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        return this.makeConstrainedPane((BWidget)content, 400, 300);
    }

    private BWidget makeConstrainedPane(BWidget content, int w, int h) {
        BConstrainedPane pane = new BConstrainedPane(content);
        pane.setMinWidth((double)w);
        pane.setMaxWidth((double)w);
        pane.setMinHeight((double)h);
        pane.setMaxHeight((double)h);
        return pane;
    }

    private BOptionDialog getOptionDialog() {
        BWidget parent = this.tree.getParentWidget();
        while (!(parent instanceof BOptionDialog)) {
            parent = parent.getParentWidget();
        }
        return (BOptionDialog)parent;
    }

    TreeNode findNode(BComponent c) {
        TreeModel model = this.tree.getModel();
        for (int i = 0; i < model.getRootCount(); ++i) {
            TreeNode node = this.findNode(model.getRoot(i), c);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    TreeNode findNode(TreeNode node, BComponent c) {
        if (c == ((Node)node).folder) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = this.findNode(node.getChild(i), c);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    static Lexicon lex() {
        return BBookmarkMenu.TYPE.getModule().getLexicon();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class NewFolder
    extends Command {
        NewFolder(BWidget owner) {
            super(owner, module, "bookmark.manage.newFolder");
        }

        public CommandArtifact doInvoke() {
            String name = BDialog.prompt((BWidget)this.getOwner(), (String)"New Folder", (String)"New Folder", (int)20);
            if (name == null) {
                return null;
            }
            TreeNode treeNode = BookmarkUtil.this.tree.getSelection().getNode();
            Node node = (Node)treeNode;
            BBookmarkFolder folder = new BBookmarkFolder(name);
            node.folder.add(null, (BValue)folder);
            Node[] temp = new Node[node.kids.length + 1];
            System.arraycopy(node.kids, 0, temp, 0, node.kids.length);
            temp[temp.length - 1] = new Node(node, folder);
            node.kids = temp;
            node.setExpanded(true);
            BookmarkUtil.this.tree.getSelection().select((TreeNode)node.kids[node.kids.length - 1]);
            BookmarkUtil.this.tree.relayout();
            return null;
        }
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        protected void mouseSelection(TreeNode target, BMouseEvent evt) {
            TreeNode node = this.getSelection().getNode();
            super.mouseSelection(target, evt);
            if (this.getSelection().getNode() == null) {
                if (node == null) {
                    TreeNode x = node = BookmarkUtil.this.last;
                    while (node != null) {
                        if (!node.isExpanded()) {
                            x = node;
                        }
                        node = node.getParent();
                    }
                    node = x;
                }
                this.getSelection().select(node);
            }
            BookmarkUtil.this.last = node;
        }

        protected void doSelectAction(TreeNode target, double x, double y) {
            BookmarkUtil.this.getOptionDialog().getOkButton().invokeAction();
        }

        protected BMenu makePopup(TreeSubject subject) {
            BMenu menu = super.makePopup(subject);
            if (menu == null) {
                menu = new BMenu();
            }
            menu.add(null, (Command)new NewFolder((BWidget)BookmarkUtil.this.tree));
            return menu;
        }
    }

    class Node
    extends TreeNode {
        BBookmarkFolder folder;
        Node[] kids;

        public Node(TreeModel model, BBookmarkFolder folder) {
            super(model);
            this.folder = folder;
            this.load();
        }

        public Node(TreeNode parent, BBookmarkFolder folder) {
            super(parent);
            this.folder = folder;
            this.load();
        }

        public void load() {
            BBookmarkFolder[] f = (BBookmarkFolder[])this.folder.getChildren(class$javax$baja$ui$bookmark$BBookmarkFolder == null ? (class$javax$baja$ui$bookmark$BBookmarkFolder = BookmarkUtil.class$("javax.baja.ui.bookmark.BBookmarkFolder")) : class$javax$baja$ui$bookmark$BBookmarkFolder);
            this.kids = new Node[f.length];
            for (int i = 0; i < f.length; ++i) {
                this.kids[i] = new Node(this, f[i]);
            }
        }

        public Object getSubject() {
            return this.folder;
        }

        public String getText() {
            return this.folder.getText();
        }

        public BImage getIcon() {
            return folderIcon;
        }

        public int getChildCount() {
            return this.kids.length;
        }

        public TreeNode getChild(int index) {
            return this.kids[index];
        }
    }

    class Model
    extends TreeModel {
        Node root;

        public Model() {
            this.root = new Node(this, BookmarkUtil.this.rootFolder);
            BBookmarkFolder[] f = (BBookmarkFolder[])BookmarkUtil.this.rootFolder.getChildren(class$javax$baja$ui$bookmark$BBookmarkFolder == null ? (class$javax$baja$ui$bookmark$BBookmarkFolder = BookmarkUtil.class$("javax.baja.ui.bookmark.BBookmarkFolder")) : class$javax$baja$ui$bookmark$BBookmarkFolder);
            this.root.kids = new Node[f.length];
            for (int i = 0; i < f.length; ++i) {
                this.root.kids[i] = new Node(this.root, f[i]);
            }
            this.root.setExpanded(true);
        }

        public int getRootCount() {
            return 1;
        }

        public TreeNode getRoot(int index) {
            return this.root;
        }
    }
}

