/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bookmark;

import com.tridium.workbench.bookmark.BookmarkUtil;
import java.util.HashMap;
import javax.baja.gx.BImage;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkFolder;
import javax.baja.ui.bookmark.BBookmarkItem;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.workbench.BWbShell;

public class BBookmarkTable
extends BTreeTable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$bookmark$BBookmarkTable == null ? (class$com$tridium$workbench$bookmark$BBookmarkTable = BBookmarkTable.class$("com.tridium.workbench.bookmark.BBookmarkTable")) : class$com$tridium$workbench$bookmark$BBookmarkTable));
    private Model model;
    private boolean compact = false;
    static /* synthetic */ Class class$com$tridium$workbench$bookmark$BBookmarkTable;
    static /* synthetic */ Class class$javax$baja$ui$bookmark$BBookmarkItem;

    public Type getType() {
        return TYPE;
    }

    public BBookmarkTable() {
        throw new IllegalStateException();
    }

    public BBookmarkTable(BBookmarkFolder folder) {
        this.model = new Model(folder);
        this.setModel((TableModel)this.model);
        this.setMultipleSelection(false);
        this.setController((TableController)new Controller());
    }

    public void setCompact(boolean b) {
        this.compact = b;
        this.setHeaderVisible(!this.compact);
        this.setHgridVisible(!this.compact);
    }

    public void addBookmark() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Controller
    extends TreeTableController {
        Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            Node node = (Node)BBookmarkTable.this.model.rowToNode(row);
            if (node.item instanceof BBookmark) {
                BBookmark b = (BBookmark)node.item;
                try {
                    BObject obj = b.getBookmarkOrd().resolve().get();
                    b.setIcon(obj.getIcon());
                }
                catch (Exception e) {
                    // empty catch block
                }
                BookmarkUtil.open((BWbShell)this.getShell(), b, event.isControlDown());
            }
        }
    }

    public static class Node
    extends TreeTableNode {
        String[] cols;
        BBookmarkItem item;
        HashMap hash = new HashMap();

        Node(TreeTableModel model, BBookmarkItem item) {
            super(model);
            this.item = item;
            this.load();
        }

        Node(TreeTableNode parent, BBookmarkItem item) {
            super(parent);
            this.item = item;
            this.load();
        }

        void load() {
            if (this.item instanceof BBookmark) {
                BBookmark b = (BBookmark)this.item;
                this.cols = new String[]{b.getText(), b.getBookmarkOrd().toString()};
            } else {
                BBookmarkFolder f = (BBookmarkFolder)this.item;
                this.cols = new String[]{f.getText(), ""};
            }
        }

        public Object getSubject() {
            return this.item;
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.item.getIcon());
        }

        public Object getValueAt(int col) {
            return this.cols[col];
        }

        public boolean isGroup() {
            return false;
        }

        public int getChildCount() {
            this.item.loadSlots();
            return this.item.getChildComponents().length;
        }

        public TreeTableNode getChild(int i) {
            BBookmarkItem[] kids = (BBookmarkItem[])this.item.getChildren(class$javax$baja$ui$bookmark$BBookmarkItem == null ? (class$javax$baja$ui$bookmark$BBookmarkItem = BBookmarkTable.class$("javax.baja.ui.bookmark.BBookmarkItem")) : class$javax$baja$ui$bookmark$BBookmarkItem);
            TreeTableNode node = (TreeTableNode)this.hash.get(kids[i]);
            if (node == null) {
                node = new Node(this, kids[i]);
                this.hash.put(kids[i], node);
            }
            return node;
        }
    }

    class Model
    extends TreeTableModel {
        String[] cols = new String[]{"Name", "Ord"};
        Node root;

        public Model(BBookmarkFolder folder) {
            this.root = new Node(this, (BBookmarkItem)folder);
        }

        public int getRootCount() {
            return 1;
        }

        public TreeTableNode getRoot(int i) {
            return this.root;
        }

        public int getColumnCount() {
            return BBookmarkTable.this.compact ? 1 : 2;
        }

        public String getColumnName(int col) {
            return this.cols[col];
        }
    }
}

