/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth.kerb;

import com.tridium.workbench.auth.kerb.BKerbSimpleCredPane;
import com.tridium.workbench.auth.kerb.KerberosInfo;
import com.tridium.workbench.shell.BGeneralOptions;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.kerberos.BKerberosCredentials;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;

public class BKerbSelectCredPane
extends BKerbSimpleCredPane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$auth$kerb$BKerbSelectCredPane == null ? (class$com$tridium$workbench$auth$kerb$BKerbSelectCredPane = BKerbSelectCredPane.class$("com.tridium.workbench.auth.kerb.BKerbSelectCredPane")) : class$com$tridium$workbench$auth$kerb$BKerbSelectCredPane));
    private ToggleCommand newUserCommand;
    private ToggleCommand curUserCommand;
    private BKerberosCredentials kCredentials;
    private boolean preserveKerberosTicket = false;
    static /* synthetic */ Class class$com$tridium$workbench$auth$kerb$BKerbSelectCredPane;

    public Type getType() {
        return TYPE;
    }

    public BKerbSelectCredPane(BICredentials credentials, KerberosInfo kInfo) {
        if (credentials == null) {
            credentials = new BUsernameAndPassword();
        }
        if (kInfo.getCreds() == null) {
            throw new IllegalArgumentException();
        }
        this.kCredentials = kInfo.getCreds();
        String username = this.kCredentials.getUsername();
        this.curUserCommand = new ToggleCommand((BWidget)this, "Log in as current user (" + username + ")");
        BRadioButton curUserButton = new BRadioButton(this.curUserCommand);
        BGridPane curUserPane = new BGridPane(1);
        curUserPane.setHalign(BHalign.left);
        curUserPane.add(null, (BValue)new BBorderPane((BWidget)curUserButton, 0.0, 0.0, 0.0, 10.0));
        this.newUserCommand = new CredToggleCommand((BWidget)this, "Log in as different user");
        BRadioButton newUserButton = new BRadioButton(this.newUserCommand);
        BGridPane newUserButtonPane = new BGridPane(1);
        newUserButtonPane.setHalign(BHalign.left);
        newUserButtonPane.add(null, (BValue)newUserButton);
        newUserButtonPane.add(null, (BValue)this.buildSimpleKerbPane(credentials, kInfo));
        BGridPane newUserPane = new BGridPane(1);
        newUserPane.setHalign(BHalign.left);
        newUserPane.add(null, (BValue)new BBorderPane((BWidget)newUserButtonPane, 0.0, 0.0, 0.0, 10.0));
        this.add(null, (BValue)curUserPane);
        this.add(null, (BValue)newUserPane);
        ToggleCommandGroup toggleGroup = new ToggleCommandGroup();
        toggleGroup.add(this.newUserCommand);
        toggleGroup.add(this.curUserCommand);
        this.curUserCommand.setSelected(true);
    }

    protected BICredentials doGetCredentials() throws Exception {
        BKerberosCredentials extractedCreds = null;
        if (this.curUserCommand.isSelected()) {
            extractedCreds = this.kCredentials;
            this.preserveKerberosTicket = true;
        } else if (this.newUserCommand.isSelected()) {
            extractedCreds = (BICredentials)this.editor.saveValue();
        }
        return extractedCreds;
    }

    protected void doCleanCredentials() {
        if (!this.preserveKerberosTicket) {
            this.kCredentials.destroyTicket();
        }
        this.kCredentials = null;
        this.editor = null;
    }

    public boolean getKerbUserState() {
        return this.newUserCommand.isSelected() && this.domainList.getSelectedItem().equals(this.ldapDomainItem);
    }

    public boolean shouldSaveCredentials() {
        return this.newUserCommand.isSelected() && this.saveCredBox.isSelected();
    }

    public boolean shouldDeleteCredentials() {
        return this.newUserCommand.isSelected() && !this.saveCredBox.isSelected();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class CredToggleCommand
    extends ToggleCommand {
        CredToggleCommand(BWidget owner, String label) {
            super(owner, label);
        }

        public CommandArtifact doInvoke() throws Exception {
            BGeneralOptions gopt = BGeneralOptions.make();
            boolean allowCaching = gopt.getAllowUserCredentialCaching();
            BKerbSelectCredPane.this.editor.setReadonly(!this.isSelected());
            if (BKerbSelectCredPane.this.saveCredBox != null) {
                BKerbSelectCredPane.this.saveCredBox.setEnabled(this.isSelected() && allowCaching);
            }
            if (BKerbSelectCredPane.this.domainList != null) {
                BKerbSelectCredPane.this.domainList.setDropDownEnabled(this.isSelected());
            }
            return null;
        }
    }
}

