/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.WbMain;
import java.io.File;
import java.util.HashMap;
import javax.baja.nre.util.Base64;
import javax.baja.security.BICredentials;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class CredentialsList {
    public static final CredentialsList INSTANCE = new CredentialsList(new File(Sys.getCredentialsHome(), "credentials.xml"));
    File file;
    private HashMap map = new HashMap();
    private BGeneralOptions gopt = BGeneralOptions.make();

    public CredentialsList(File file) {
        this.file = file;
    }

    public CredentialsList(CredentialsList orig) {
        this.copyFrom(orig);
    }

    public BICredentials lookup(String realm) {
        if (WbMain.isKiosk()) {
            return null;
        }
        if (!this.gopt.getAllowUserCredentialCaching()) {
            return null;
        }
        BValue v = (BValue)this.map.get(realm);
        if (v == null) {
            return null;
        }
        return (BICredentials)v.newCopy();
    }

    public String[] keys() {
        return this.map.keySet().toArray(new String[this.map.size()]);
    }

    public void put(String realm, BICredentials credentials) {
        this.map.put(realm, ((BValue)credentials).newCopy());
    }

    public void remove(String realm) {
        this.map.remove(realm);
    }

    public void clear() {
        this.map.clear();
    }

    public void copyFrom(CredentialsList list) {
        this.map = (HashMap)list.map.clone();
    }

    public void load() throws Exception {
        this.map.clear();
        if (!this.file.exists()) {
            return;
        }
        XElem root = XParser.make((File)this.file).parse();
        XElem[] entries = root.elems("entry");
        for (int i = 0; i < entries.length; ++i) {
            XElem entry = entries[i];
            String realm = entry.get("realm");
            BICredentials c = (BICredentials)BTypeSpec.make((String)entry.get("type")).getInstance();
            byte[] data = Base64.decode((String)entry.get("value"));
            c = c.decodeCredentials(data);
            this.put(realm, c);
        }
    }

    public void save() throws Exception {
        if (!this.gopt.getAllowUserCredentialCaching()) {
            return;
        }
        XWriter out = new XWriter(this.file);
        out.w((Object)"<credentials>\n");
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            String realm = keys[i];
            BICredentials c = this.lookup(realm);
            out.w((Object)" <entry").attr(" realm", realm).attr(" type", c.asObject().getType().toString()).attr(" value", Base64.encode((byte[])c.encodeCredentials())).w((Object)"/>\n");
        }
        out.w((Object)"</credentials>\n");
        out.close();
    }

    static {
        try {
            INSTANCE.load();
        }
        catch (Exception e) {
            AuthUtil.log.error("Cannot load credentials list", (Throwable)e);
        }
    }
}

