/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.auth.BCredInputPane;
import com.tridium.workbench.auth.BSaveCredInputPane;
import com.tridium.workbench.auth.kerb.BKerbSelectCredPane;
import com.tridium.workbench.auth.kerb.BKerbSimpleCredPane;
import com.tridium.workbench.auth.kerb.KerberosInfo;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;

public class BWbLoginPane
extends BEdgePane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$auth$BWbLoginPane == null ? (class$com$tridium$workbench$auth$BWbLoginPane = BWbLoginPane.class$("com.tridium.workbench.auth.BWbLoginPane")) : class$com$tridium$workbench$auth$BWbLoginPane));
    static final BImage icon = BImage.make((String)"module://icons/x32/keys.png");
    private BCredInputPane credInputPane;
    static /* synthetic */ Class class$com$tridium$workbench$auth$BWbLoginPane;

    public Type getType() {
        return TYPE;
    }

    public BWbLoginPane(AuthenticationRealm realm, boolean showError) {
        this(realm, showError, null, null);
    }

    public BWbLoginPane(AuthenticationRealm realm, boolean showError, String errorMessage) {
        this(realm, showError, errorMessage, null);
    }

    public BWbLoginPane(AuthenticationRealm realm, boolean showError, KerberosInfo kInfo) {
        this(realm, showError, null, kInfo);
    }

    public BWbLoginPane(AuthenticationRealm realm, boolean showError, String errorMessage, KerberosInfo kInfo) {
        UiLexicon lex = UiLexicon.bajaui();
        String lexTitle = lex.getText("auth.title");
        String lexDesc = lex.getText("auth.description");
        String lexRealm = lex.getText("auth.realm");
        String lexRealmName = lex.getText("auth.realmName");
        String lexScheme = lex.getText("auth.scheme");
        String lexCred = lex.getText("auth.credentials");
        BFont bold = Theme.widget().getBoldText();
        BGridPane sessionSummary = new BGridPane(2);
        sessionSummary.setHalign(BHalign.left);
        sessionSummary.setColumnGap(20.0);
        sessionSummary.add(null, (BValue)new BLabel(lexRealmName));
        sessionSummary.add(null, (BValue)new BLabel(realm.getAuthenticationRealmName()));
        sessionSummary.add(null, (BValue)new BLabel(lexScheme));
        sessionSummary.add(null, (BValue)new BLabel(realm.getAuthenticationScheme()));
        BBorderPane sessionBorder = new BBorderPane((BWidget)sessionSummary);
        sessionBorder.setBorder(BBorder.none);
        sessionBorder.setMargin(BInsets.NULL);
        sessionBorder.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)10.0));
        BGridPane session = new BGridPane(1);
        session.add(null, (BValue)new BLabel(lexRealm, bold));
        session.add(null, (BValue)sessionBorder);
        this.credInputPane = this.buildCredInputPane(realm, kInfo);
        BGridPane credentialInputPane = new BGridPane(1);
        credentialInputPane.setHalign(BHalign.left);
        credentialInputPane.add(null, (BValue)new BLabel(lexCred, bold));
        credentialInputPane.add(null, (BValue)new BBorderPane((BWidget)this.credInputPane, 0.0, 0.0, 0.0, 10.0));
        BGridPane content = new BGridPane(1);
        content.setHalign(BHalign.left);
        content.setRowGap(10.0);
        content.add(null, (BValue)session);
        content.add(null, (BValue)credentialInputPane);
        this.setCenter((BWidget)new BBorderPane((BWidget)content, 5.0, 5.0, 5.0, 5.0));
        this.setTop((BWidget)new BWizardHeader(icon, lexTitle, lexDesc));
        if (showError) {
            if (errorMessage == null) {
                errorMessage = lex.getText("loginFailed");
            }
            BLabel errLabel = new BLabel(icon, errorMessage);
            errLabel.setHalign(BHalign.left);
            errLabel.setFont(bold);
            BBorderPane err = new BBorderPane((BWidget)errLabel);
            err.setFill(BColor.make((int)0xFFEEEE).toBrush());
            err.setBorder(BBorder.make((double)1.0, (int)1, (BBrush)BColor.make((int)0x800000).toBrush()));
            err.computePreferredSize();
            this.setTop((BWidget)err);
        } else {
            this.setTop((BWidget)new BWizardHeader(icon, lexTitle, lexDesc));
        }
    }

    protected BCredInputPane buildCredInputPane(AuthenticationRealm realm, KerberosInfo kInfo) {
        BICredentials credentials = AuthUtil.getCredentials(realm);
        if (realm.getAuthenticationScheme().contains("kerberos")) {
            if (kInfo.getCreds() != null) {
                return new BKerbSelectCredPane(credentials, kInfo);
            }
            return new BKerbSimpleCredPane(credentials, kInfo);
        }
        return new BSaveCredInputPane(credentials);
    }

    public BCredInputPane getCredInputPane() {
        return this.credInputPane;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

