/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.auth.BCnxHandler;
import com.tridium.workbench.ord.BHostOrdFE;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Insets;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BRoundedDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.BWindow;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.CannotSaveException;

public class BCnxConfigPane
extends BEdgePane {
    public static final Action sessionSelected = BCnxConfigPane.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$auth$BCnxConfigPane == null ? (class$com$tridium$workbench$auth$BCnxConfigPane = BCnxConfigPane.class$("com.tridium.workbench.auth.BCnxConfigPane")) : class$com$tridium$workbench$auth$BCnxConfigPane));
    public static final BImage logo = BImage.make((String)"module://icons/x32/keys.png");
    public static final BImage keys = BImage.make((String)"module://icons/x16/keys.png");
    private static final String PROP_ERR_PANE = "errorPane";
    public static Lexicon lex = Lexicon.make((String)"workbench");
    private static final BFont bold = Theme.widget().getBoldText();
    private BListDropDown sessions;
    private BGridPane errorPane;
    private BPane sessionPane;
    static /* synthetic */ Class class$com$tridium$workbench$auth$BCnxConfigPane;

    public void sessionSelected() {
        this.invoke(sessionSelected, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BCnxConfigPane() {
        throw new IllegalStateException();
    }

    public BCnxConfigPane(BCnxHandler[] handlers) {
        this.buildDisplay(handlers);
        this.updateDisplay();
    }

    private void buildDisplay(BCnxHandler[] handlers) {
        BGridPane main = new BGridPane(1);
        BBorderPane border = new BBorderPane((BWidget)main, 5.0, 5.0, 5.0, 5.0);
        this.setCenter((BWidget)border);
        this.sessions = new BListDropDown();
        for (int i = 0; i < handlers.length; ++i) {
            this.sessions.getList().addItem(BImage.make((BIcon)handlers[i].getIcon()), (Object)handlers[i]);
        }
        this.sessions.setSelectedIndex(0);
        if (this.sessions.getList().getItemCount() == 1) {
            this.sessions.setDropDownEnabled(false);
        }
        this.linkTo((BComponent)this.sessions, (Slot)BListDropDown.valueModified, (Slot)sessionSelected);
        main.add(null, (BValue)new BLabel(lex.get("CnxConfigPane.session.label", "Session"), bold));
        BGridPane sessionTypeGridPane = new BGridPane(2);
        sessionTypeGridPane.add(null, (BValue)new BLabel(lex.get("CnxConfigPane.type.label", "Type")));
        sessionTypeGridPane.add(null, (BValue)this.sessions);
        BGridPane sessionGridPane = new BGridPane(1);
        sessionGridPane.add(null, (BValue)sessionTypeGridPane);
        this.sessionPane = new BGridPane(1);
        sessionGridPane.add(null, (BValue)this.sessionPane);
        BBorderPane sessionSelectorBorder = new BBorderPane((BWidget)sessionGridPane, 0.0, 0.0, 0.0, 10.0);
        main.add(null, (BValue)sessionSelectorBorder);
    }

    private void updateDisplay() {
        BValue oldSessionFE;
        BCnxHandler connectionHandler = this.getCurrentHandler();
        BWbPlugin sessionFE = connectionHandler.getCnxEditor();
        Property parentProp = sessionFE.getPropertyInParent();
        if (null != parentProp) {
            BComponent parent = (BComponent)sessionFE.getParent();
            parent.set(parentProp, (BValue)new BNullWidget());
        }
        if ((oldSessionFE = this.sessionPane.get("sessionFE")) == null) {
            this.sessionPane.add("sessionFE", (BValue)sessionFE);
        } else {
            this.sessionPane.set("sessionFE", (BValue)sessionFE);
            if (oldSessionFE instanceof BHostOrdFE && sessionFE instanceof BHostOrdFE) {
                try {
                    ((BHostOrdFE)sessionFE).loadValue(((BHostOrdFE)oldSessionFE).saveValue(), (Context)new BasicContext());
                    ((BHostOrdFE)sessionFE).setReadonly(((BHostOrdFE)oldSessionFE).isReadonly());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        sessionFE.repaint();
        this.setTop((BWidget)new BWizardHeader(logo, connectionHandler.getTitle(), connectionHandler.getDescription()));
    }

    public void displayException(Exception e) {
        BLabel errLabel = new BLabel(keys, e.getMessage());
        errLabel.setHalign(BHalign.left);
        errLabel.setFont(bold);
        BBorderPane err = new BBorderPane((BWidget)errLabel);
        err.setFill(BColor.make((int)0xFFEEEE).toBrush());
        err.setBorder(BBorder.make((double)1.0, (int)1, (BBrush)BColor.make((int)0x800000).toBrush()));
        err.computePreferredSize();
        this.errorPane.set(PROP_ERR_PANE, (BValue)err);
    }

    public BCnxHandler saveCnxHandler() throws CannotSaveException, Exception {
        return this.getCurrentHandler();
    }

    public void clearCnxHandlers() {
        BList list = this.sessions.getList();
        if (list.getItemCount() > 0) {
            for (int i = 0; i < list.getItemCount(); ++i) {
                ((BCnxHandler)((Object)list.getItem(i))).clearCnx();
            }
        }
    }

    public void doSessionSelected() {
        this.updateDisplay();
        this.relayout();
        BWidgetShell shell = this.getShell();
        BRoundedDialog dlg = null;
        if (shell instanceof BRoundedDialog) {
            dlg = (BRoundedDialog)shell;
        } else if (shell instanceof BDialog) {
            dlg = (BDialog)shell;
        }
        Insets insets = UiEnv.get().getWindowInsets((BWindow)dlg);
        dlg.computePreferredSize();
        double h = dlg.getPreferredHeight() + insets.top + insets.bottom;
        double w = dlg.getPreferredWidth() + insets.left + insets.right;
        IRectGeom cur = dlg.getScreenBounds();
        dlg.setScreenBounds(cur.x(), cur.y(), w, h);
    }

    private BCnxHandler getCurrentHandler() {
        Object selectedItem = this.sessions.getSelectedItem();
        if (null != selectedItem) {
            return (BCnxHandler)((Object)selectedItem);
        }
        BList list = this.sessions.getList();
        if (list.getItemCount() > 0) {
            return (BCnxHandler)((Object)list.getItem(0));
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

