/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.fox.kerberos.KerberosConfig;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.util.ThrowableUtil;
import com.tridium.workbench.auth.BCnxConfigPane;
import com.tridium.workbench.auth.BCnxHandler;
import com.tridium.workbench.auth.BCredentialsManager;
import com.tridium.workbench.auth.BIAuthResponseHandler;
import com.tridium.workbench.auth.BOpenPane;
import com.tridium.workbench.auth.BWbLoginPane;
import com.tridium.workbench.auth.CredentialsList;
import com.tridium.workbench.auth.kerb.KerberosInfo;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.NHyperlinkInfo;
import java.security.PrivilegedAction;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.registry.TypeInfo;
import javax.baja.security.AuthenticationException;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.kerberos.BKerberosCredentials;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.TextUtil;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class AuthUtil {
    public static final char SSO_SEP = ';';
    public static boolean saveCredentials;
    public static boolean kerberosUser;
    static final BImage icon;
    static final Log log;

    public static boolean challenge(BWidget owner, AuthenticationException ex) {
        return AuthUtil.challenge(owner, ex, false);
    }

    public static boolean challenge(BWidget owner, AuthenticationException ex, boolean showError) {
        if (ex == null) {
            return false;
        }
        AuthenticationRealm realm = ex.getAuthenticationRealm();
        FoxMessage data = null;
        Throwable cause = ex.getCause();
        if (cause instanceof FoxAuthenticationException) {
            data = ((FoxAuthenticationException)cause).data;
        }
        return AuthUtil.challenge(owner, realm, showError, data);
    }

    public static boolean challenge(BWidget owner, AuthenticationRealm realm) {
        return AuthUtil.challenge(owner, realm, false, null);
    }

    public static boolean challenge(BWidget owner, AuthenticationRealm realm, boolean showError) {
        return AuthUtil.challenge(owner, realm, showError, null);
    }

    public static boolean challenge(BWidget owner, AuthenticationRealm realm, boolean showError, FoxMessage data) {
        BWbLoginPane loginPane;
        int result;
        BICredentials credentials = AuthUtil.getCredentials(realm);
        UiLexicon lex = UiLexicon.bajaui();
        String lexTitle = lex.getText("auth.title");
        BGeneralOptions gopt = BGeneralOptions.make();
        boolean allowCaching = gopt.getAllowUserCredentialCaching();
        saveCredentials = !allowCaching ? false : AuthUtil.hasSavedCredentials(realm);
        BKerberosCredentials kCreds = null;
        KerberosInfo kInfo = new KerberosInfo();
        if (realm.getAuthenticationScheme().contains("kerberos")) {
            try {
                FoxMessage ldapData = data.getMessage("ldap");
                String kRealm = ldapData.getString("kerberosRealm");
                kInfo.setRealm(kRealm);
                if (realm instanceof BFoxSession) {
                    kInfo.setStationName(((BFoxSession)realm).getStationName());
                }
                if ((kCreds = AuthUtil.getCurrentKerberosCredentials()) != null && kRealm.equals(kCreds.getRealm()) && !kCreds.isExpired()) {
                    kInfo.setCreds(kCreds);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((result = BDialog.open((BWidget)owner, (String)lexTitle, (Object)((Object)(loginPane = new BWbLoginPane(realm, showError, kInfo))), (int)3)) == 2) {
            loginPane.getCredInputPane().cleanCredentials();
            return false;
        }
        try {
            credentials = loginPane.getCredInputPane().extractCredentials();
        }
        catch (Exception e) {
            Throwable cause = ThrowableUtil.getCause((Throwable)e);
            if (cause != null) {
                cause.printStackTrace();
            }
            BDialog.error((BWidget)owner, (String)UiLexicon.bajaui().getText("dialog.error"), (Object)e.getMessage(), (Throwable)e);
            return false;
        }
        if (loginPane.getCredInputPane().shouldSaveCredentials()) {
            saveCredentials = true;
            AuthUtil.saveCredentials(realm.getAuthenticationRealmName(), credentials);
        } else if (loginPane.getCredInputPane().shouldDeleteCredentials()) {
            saveCredentials = false;
            AuthUtil.removeCredentials(realm.getAuthenticationRealmName());
        }
        kerberosUser = loginPane.getCredInputPane().getKerbUserState();
        if (kerberosUser && credentials instanceof BUsernameAndPassword) {
            BUsernameAndPassword creds = (BUsernameAndPassword)credentials;
            credentials = new BUsernameAndPassword("kerberos:" + creds.getUsername(), creds.getPassword());
        }
        realm.setCredentials(credentials);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BKerberosCredentials getCurrentKerberosCredentials() {
        KerberosConfig kerberosConfig = new KerberosConfig(true, true);
        LoginContext lc = null;
        try {
            lc = new LoginContext("com.tridium.workbench.auth.AuthUtil", null, null, (Configuration)kerberosConfig);
            lc.login();
            GSSCredential gssCred = (GSSCredential)Subject.doAs(lc.getSubject(), new ExtractGSSCredentialAction());
            if (gssCred != null) {
                BKerberosCredentials bKerberosCredentials = new BKerberosCredentials(gssCred);
                return bKerberosCredentials;
            }
        }
        catch (LoginException e) {
            BKerberosCredentials bKerberosCredentials = null;
            return bKerberosCredentials;
        }
        finally {
            try {
                lc.logout();
            }
            catch (LoginException e) {}
        }
        return null;
    }

    public static boolean connect(BWidget owner, BCnxHandler[] handlers) {
        BCnxConfigPane pane = new BCnxConfigPane(handlers);
        int r = BDialog.open((BWidget)owner, (String)UiLexicon.bajaui().get("auth.connect", "Connect"), (Object)((Object)pane), (int)3);
        if (r != 1) {
            pane.clearCnxHandlers();
            return false;
        }
        BOrd hyperlinkOrd = null;
        try {
            BCnxHandler handler = pane.saveCnxHandler();
            BGeneralOptions.make().setIsDefaultConnectionTypeSsl(handler.isSecure());
            handler.saveCnx();
            hyperlinkOrd = handler.toHyperlink().normalize();
            pane.clearCnxHandlers();
        }
        catch (Exception e) {
            Throwable cause = ThrowableUtil.getCause((Throwable)e);
            if (cause != null) {
                cause.printStackTrace();
            }
            BDialog.error((BWidget)owner, (String)UiLexicon.bajaui().getText("dialog.error"), (Object)e.getMessage(), (Throwable)e);
            return false;
        }
        BUsernameAndPassword credentials = new BUsernameAndPassword();
        BWidgetShell shell = owner.getShell();
        if (shell instanceof BNiagaraWbShell) {
            BNiagaraWbShell wbShell = (BNiagaraWbShell)shell;
            wbShell.hyperlink(new NHyperlinkInfo(hyperlinkOrd, BHyperlinkMode.replace, true, (BICredentials)credentials));
        }
        return saveCredentials;
    }

    public static boolean handleAuthResponse(AuthenticationException re, BWidgetShell shell, BICredentials credentials) {
        TypeInfo[] responseHandlers = Sys.getRegistry().getTypes(BIAuthResponseHandler.TYPE.getTypeInfo());
        for (int i = 0; i < responseHandlers.length; ++i) {
            TypeInfo typeInfo = responseHandlers[i];
            if (typeInfo.isInterface() || typeInfo.isAbstract()) continue;
            BIAuthResponseHandler authHandler = (BIAuthResponseHandler)typeInfo.getInstance();
            try {
                if (!authHandler.canAccept(re, credentials) || !authHandler.processResponse(re, shell, credentials)) continue;
                return true;
            }
            catch (AbstractMethodError ame) {
                log.message("Skipping unsupported BIAuthResponseHandler: ", (Throwable)ame);
            }
        }
        return false;
    }

    public static boolean open(BWidget owner, OpenHandler handler) {
        BWidgetShell shell;
        BOpenPane pane = handler.makeOpenPane();
        int r = BDialog.open((BWidget)owner, (String)handler.title, (Object)((Object)pane), (int)3);
        if (r != 1) {
            return false;
        }
        BICredentials credentials = null;
        String realm = null;
        BOrd hyperlinkOrd = null;
        try {
            credentials = (BICredentials)pane.credentialsEditor.saveValue();
            pane.saveAddress();
            pane.host.saveHistory();
            realm = handler.toAuthenticationRealm();
            hyperlinkOrd = handler.toHyperlink().normalize();
        }
        catch (Exception e) {
            Throwable cause = ThrowableUtil.getCause((Throwable)e);
            if (cause != null) {
                cause.printStackTrace();
            }
            BDialog.error((BWidget)owner, (String)UiLexicon.bajaui().getText("dialog.error"), (Object)e.getMessage(), (Throwable)e);
            return false;
        }
        saveCredentials = pane.saveCredentials.isSelected();
        if (realm != null) {
            if (saveCredentials) {
                AuthUtil.saveCredentials(realm, credentials);
            } else {
                AuthUtil.removeCredentials(realm);
            }
        }
        if ((shell = owner.getShell()) instanceof BNiagaraWbShell) {
            BNiagaraWbShell wbShell = (BNiagaraWbShell)shell;
            wbShell.hyperlink(new NHyperlinkInfo(hyperlinkOrd, BHyperlinkMode.replace, true, credentials));
            if (wbShell.getActiveOrdTarget() != null) {
                wbShell.syncTree();
            }
        }
        return saveCredentials;
    }

    public static boolean hasSavedCredentials(AuthenticationRealm realm) {
        String name = realm.getAuthenticationRealmName();
        BICredentials credentials = CredentialsList.INSTANCE.lookup(name);
        return credentials != null;
    }

    public static BICredentials getCredentials(AuthenticationRealm realm) {
        BICredentials c = realm.getCredentials();
        if (c == null) {
            String name = realm.getAuthenticationRealmName();
            c = CredentialsList.INSTANCE.lookup(name);
            if (c == null) {
                c = realm.makeCredentials();
            }
        } else {
            c = (BICredentials)((BValue)c).newCopy();
        }
        return c;
    }

    public static void saveCredentials(String realm, BICredentials credentials) {
        if (credentials instanceof BKerberosCredentials) {
            return;
        }
        CredentialsList.INSTANCE.put(realm, credentials);
        AuthUtil.saveCredentials();
    }

    public static void removeCredentials(String realm) {
        CredentialsList.INSTANCE.remove(realm);
        AuthUtil.saveCredentials();
    }

    public static void manageCredentials(BWidget owner, String title) {
        CredentialsList copy = new CredentialsList(CredentialsList.INSTANCE);
        int s = BDialog.open((BWidget)owner, (String)title, (Object)((Object)new BCredentialsManager(owner, copy)), (int)3);
        if (s == 1) {
            CredentialsList.INSTANCE.copyFrom(copy);
            AuthUtil.saveCredentials();
        }
    }

    public static void saveCredentials() {
        try {
            CredentialsList.INSTANCE.save();
        }
        catch (Exception e) {
            log.error("Cannot save credentials list", (Throwable)e);
        }
    }

    public static boolean resolveSSO(AuthenticationException e) {
        if (!(e.getCause() instanceof FoxAuthenticationException)) {
            return false;
        }
        FoxAuthenticationException cause = (FoxAuthenticationException)e.getCause();
        BFoxSession[] bFoxSessions = BFoxSession.list();
        BFoxSession ssoSession = null;
        String[] remoteSSORealms = AuthUtil.extractSSO(cause.session.getRemoteHello());
        if (remoteSSORealms.length == 0) {
            return false;
        }
        for (int i = 0; i < bFoxSessions.length; ++i) {
            if (!AuthUtil.inSSORealm(bFoxSessions[i], remoteSSORealms) || ssoSession != null && !bFoxSessions[i].getConnection().getLastConnectTime().isAfter(ssoSession.getConnection().getLastConnectTime())) continue;
            ssoSession = bFoxSessions[i];
        }
        if (ssoSession == null) {
            return false;
        }
        e.getAuthenticationRealm().setCredentials(ssoSession.getCredentials());
        return true;
    }

    private static boolean inSSORealm(BFoxSession bFoxSession, String[] remoteSSORealms) {
        FoxSession session = bFoxSession.getConnection().session();
        if (session == null) {
            return false;
        }
        FoxMessage hello = session.getRemoteHello();
        String[] sessionSSORealms = AuthUtil.extractSSO(hello);
        if (sessionSSORealms.length == 0) {
            return false;
        }
        for (int i = 0; i < sessionSSORealms.length; ++i) {
            if (sessionSSORealms[i].length() == 0) continue;
            for (int j = 0; j < remoteSSORealms.length; ++j) {
                if (!sessionSSORealms[i].equals(remoteSSORealms[j])) continue;
                return true;
            }
        }
        return false;
    }

    private static String[] extractSSO(FoxMessage hello) {
        if (null == hello) {
            return new String[0];
        }
        String ssoString = null;
        ssoString = hello.getString("realms", null);
        if (ssoString != null) {
            return TextUtil.splitAndTrim((String)ssoString, (char)';');
        }
        return new String[0];
    }

    static {
        BGeneralOptions gopt = BGeneralOptions.make();
        boolean allowCaching = gopt.getAllowUserCredentialCaching();
        if (!allowCaching) {
            saveCredentials = false;
        }
        saveCredentials = false;
        kerberosUser = false;
        icon = BImage.make((String)"module://icons/x32/keys.png");
        log = Log.getLog((String)"workbench.auth");
    }

    public static class OpenHandler {
        public String title;
        public String description;
        public BICredentials credentials;
        public BOrd hostOrd;
        public String sessionScheme;
        public int port;
        public int defaultPort;
        public String[] tunnelAuthorities = null;

        public OpenHandler(String title, String description, BHost host, String sessionScheme, int defaultPort, BICredentials credentials) {
            this(title, description, host, sessionScheme, defaultPort, credentials, null);
        }

        public OpenHandler(String title, String description, BHost host, String sessionScheme, int defaultPort, BICredentials credentials, String[] tunnelAuthorities) {
            this.title = title;
            this.description = description;
            if (host != null) {
                this.hostOrd = host.getAbsoluteOrd();
            }
            this.sessionScheme = sessionScheme;
            this.defaultPort = defaultPort;
            this.port = defaultPort;
            this.credentials = credentials;
            this.tunnelAuthorities = tunnelAuthorities;
        }

        public BOpenPane makeOpenPane() {
            return new BOpenPane(this);
        }

        public BOrd toHyperlink() {
            return BOrd.make((String)this.addressToOrd());
        }

        public String toAuthenticationRealm() {
            return this.addressToOrd();
        }

        protected String addressToOrd() {
            String ord = this.hostOrd.toString() + "|" + this.sessionScheme + ":";
            if (this.port != this.defaultPort) {
                ord = ord + this.port;
            }
            if (this.tunnelAuthorities != null) {
                ord = ord + "/" + TextUtil.join((String[])this.tunnelAuthorities, (char)'/');
            }
            return ord;
        }
    }

    static class ExtractGSSCredentialAction
    implements PrivilegedAction {
        ExtractGSSCredentialAction() {
        }

        public Object run() {
            try {
                GSSManager manager = GSSManager.getInstance();
                GSSCredential credential = manager.createCredential(1);
                return credential;
            }
            catch (GSSException e) {
                return null;
            }
        }
    }
}

