/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusTcpSlave.comm;

import com.tridium.modbusCore.messages.ModbusMessage;
import com.tridium.modbusTcpSlave.BModbusTcpSlaveNetwork;
import com.tridium.modbusTcpSlave.comm.UnsolicitedMessageElement;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ModbusTcpSlaveSession {
    private BModbusTcpSlaveNetwork modbusNetwork;
    private boolean done;
    public Socket socket;
    private InputStream inStream;
    private OutputStream outStream;
    private ReceiveDriver rcvDriver;
    private Thread rcvThread;
    private int sessionId;

    public boolean start() {
        try {
            this.socket.setSoTimeout(this.modbusNetwork.getSocketTimeoutInMillis());
            this.inStream = this.socket.getInputStream();
            this.outStream = this.socket.getOutputStream();
            this.done = false;
        }
        catch (Exception exception) {
            this.done = true;
            String string = "ModbusTcpSlave Unable to get Socket input or output stream to client ";
            this.modbusNetwork.getModbusLog().error(string, (Throwable)exception);
            throw new RuntimeException(string);
        }
        this.rcvDriver = new ReceiveDriver(this);
        this.rcvThread = new Thread((Runnable)this.rcvDriver, "ModTcpSlave:RcvSess");
        this.rcvThread.start();
        this.rcvThread.setPriority(5);
        return true;
    }

    public synchronized void stop() {
        try {
            this.done = true;
            if (this.rcvDriver != null) {
                this.rcvThread.interrupt();
            }
            this.rcvDriver = null;
        }
        catch (Exception exception) {
            this.modbusNetwork.getModbusLog().error("ModbusTcpSlaveSession.stop() rcvThread.interrupt() caught exception", (Throwable)exception);
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
        }
        this.inStream = null;
        this.outStream = null;
    }

    public void setSessionId(int n) {
        this.sessionId = n;
    }

    public synchronized void sendMessage(ModbusMessage modbusMessage) {
        try {
            if (this.modbusNetwork.getLog().isTraceOn()) {
                this.modbusNetwork.getLog().trace("**** ModbusTcpSlave Sending Message: " + modbusMessage.toDebugString());
            }
            this.output(modbusMessage);
        }
        catch (Exception exception) {
            this.modbusNetwork.getLog().error("ModbusTcpSlaveSession.sendMessage() caught exception ", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void output(ModbusMessage modbusMessage) {
        OutputStream outputStream = this.outStream;
        synchronized (outputStream) {
            try {
                modbusMessage.write(this.outStream);
                this.modbusNetwork.incrementSent();
            }
            catch (Exception exception) {
                this.modbusNetwork.getLog().error("Exception in ModbusTcpSlaveSession", (Throwable)exception);
            }
            return;
        }
    }

    private final /* synthetic */ void this() {
        this.done = true;
        this.sessionId = -1;
    }

    public ModbusTcpSlaveSession(Socket socket, BModbusTcpSlaveNetwork bModbusTcpSlaveNetwork) {
        this.this();
        this.socket = socket;
        this.modbusNetwork = bModbusTcpSlaveNetwork;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ReceiveDriver
    implements Runnable {
        ModbusTcpSlaveSession tcpSession;

        public void initModbusnMode() {
        }

        public void run() {
            this.initModbusnMode();
            while (!ModbusTcpSlaveSession.this.done) {
                int n;
                byte[] byArray = new byte[261];
                try {
                    n = ModbusTcpSlaveSession.this.inStream.read(byArray, 0, 261);
                }
                catch (Exception exception) {
                    if (ModbusTcpSlaveSession.this.modbusNetwork.getLog().isTraceOn()) {
                        ModbusTcpSlaveSession.this.modbusNetwork.getLog().trace("ioException in ModbusTcpSlaveSession", (Throwable)exception);
                    }
                    ModbusTcpSlaveSession.this.done = true;
                    try {
                        ModbusTcpSlaveSession.this.socket.close();
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    ModbusTcpSlaveSession.this.modbusNetwork.tcpServer().closeConnection(ModbusTcpSlaveSession.this.sessionId);
                    break;
                }
                if (n > 10) {
                    byte[] byArray2 = new byte[n - 6];
                    System.arraycopy(byArray, 6, byArray2, 0, byArray2.length);
                    int n2 = byArray[0] << 8 & 0xFF00 | byArray[1] & 0xFF;
                    this.messageComplete(byArray2, n2);
                    continue;
                }
                if (n > 0) {
                    ModbusTcpSlaveSession.this.modbusNetwork.getLog().message("Received message too small!!! rxSize = " + n);
                    continue;
                }
                ModbusTcpSlaveSession.this.modbusNetwork.getLog().trace("*** closing socket *** thread = " + Thread.currentThread().getName());
                try {
                    ModbusTcpSlaveSession.this.socket.close();
                    ModbusTcpSlaveSession.this.done = true;
                    ModbusTcpSlaveSession.this.modbusNetwork.tcpServer().closeConnection(ModbusTcpSlaveSession.this.sessionId);
                }
                catch (Exception exception) {
                    ModbusTcpSlaveSession.this.modbusNetwork.getLog().error(" ****** Exception: ", (Throwable)exception);
                    ModbusTcpSlaveSession.this.done = true;
                }
            }
        }

        private final void messageComplete(byte[] byArray, int n) {
            ModbusTcpSlaveSession.this.modbusNetwork.incrementReceived();
            if (ModbusTcpSlaveSession.this.modbusNetwork.getLog().isTraceOn()) {
                System.out.println("**** ModbusTcpSlave Received Bytes: ****");
                ByteArrayUtil.hexDump((byte[])byArray);
                System.out.println("****************************************");
            }
            UnsolicitedMessageElement unsolicitedMessageElement = new UnsolicitedMessageElement(byArray, this.tcpSession, n);
            ModbusTcpSlaveSession.this.modbusNetwork.unsolicitedReceive().receiveMessage(unsolicitedMessageElement);
        }

        private final /* synthetic */ void this() {
            this.tcpSession = null;
        }

        ReceiveDriver(ModbusTcpSlaveSession modbusTcpSlaveSession2) {
            this.this();
            this.tcpSession = modbusTcpSlaveSession2;
        }
    }
}

