/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusTcpSlave.comm;

import com.tridium.modbusTcpSlave.BModbusTcpSlaveNetwork;
import com.tridium.modbusTcpSlave.comm.ModbusTcpSlaveSession;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ModbusTcpServer
implements Runnable {
    private int port;
    private boolean isAlive;
    private Thread thread;
    private ServerSocket serverSocket;
    private BModbusTcpSlaveNetwork host;
    private ModbusTcpSlaveSession[] sessions;

    public void start() {
        System.out.println("ModbusTcpServer.start()");
        this.host.setCurrentConnections(0);
        if (this.thread != null) {
            throw new IllegalStateException("Server already running");
        }
        this.port = this.host.getPort();
        this.isAlive = true;
        this.thread = new Thread((Runnable)this, "ModTcpSlave:Server");
        this.thread.start();
    }

    public void stop() {
        this.host.setCurrentConnections(0);
        if (this.thread == null) {
            return;
        }
        this.isAlive = false;
        this.thread.interrupt();
        this.stopSessions();
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {}
        this.thread = null;
        this.serverSocket = null;
    }

    public void run() {
        this.openPort();
        this.acceptSessions();
    }

    private final void openPort() {
        while (this.isAlive) {
            try {
                this.serverSocket = new ServerSocket(this.port);
                return;
            }
            catch (IOException iOException) {
                this.host.getModbusLog().error("Cannot open ModbusTcpSlave server port [" + this.port + "] ", (Throwable)iOException);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private final void acceptSessions() {
        while (this.isAlive) {
            try {
                if (this.getNumberSessions() < this.sessions.length) {
                    Socket socket = this.serverSocket.accept();
                    this.host.getModbusLog().trace("ModbusTcpServer acceptSession with: " + socket);
                    ModbusTcpSlaveSession modbusTcpSlaveSession = new ModbusTcpSlaveSession(socket, this.host);
                    int n = this.addSession(modbusTcpSlaveSession, socket);
                    if (n < 0) {
                        this.host.getModbusLog().error("*** ModbusTcpServer.addSession() returned -1 for some reason.  Should never get here!!!!");
                        continue;
                    }
                    modbusTcpSlaveSession.setSessionId(n);
                    modbusTcpSlaveSession.start();
                    this.host.setCurrentConnections(this.getNumberSessions());
                    continue;
                }
                Thread.sleep(1000L);
            }
            catch (Throwable throwable) {
                if (!this.isAlive) continue;
                throwable.printStackTrace();
            }
        }
    }

    public void closeConnection(int n) {
        this.host.getModbusLog().trace("closeConnection with sessionId: " + n);
        this.removeSession(n);
        this.host.setCurrentConnections(this.getNumberSessions());
    }

    private final int addSession(ModbusTcpSlaveSession modbusTcpSlaveSession, Socket socket) {
        this.host.getModbusLog().trace("ModbusTcpServer.addSession with: " + socket);
        int n = 0;
        while (n < this.sessions.length) {
            if (this.sessions[n] == null) {
                this.host.getModbusLog().trace("    found slot at: " + n);
                this.sessions[n] = modbusTcpSlaveSession;
                return n;
            }
            ++n;
        }
        return -1;
    }

    private final void removeSession(int n) {
        this.sessions[n] = null;
    }

    private final int getNumberSessions() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.sessions.length) {
            if (this.sessions[n2] != null) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private final void stopSessions() {
        int n = 0;
        while (n < this.sessions.length) {
            if (this.sessions[n] != null) {
                this.sessions[n].stop();
                this.sessions[n] = null;
            }
            ++n;
        }
    }

    public void tcpServerDump() {
        System.out.println(" tcpSessions:");
        int n = 0;
        while (n < this.sessions.length) {
            if (this.sessions[n] != null) {
                System.out.println("   " + this.sessions[n].socket);
            }
            ++n;
        }
        System.out.println("***** Node.dump()end *****");
    }

    public void removeOldSessions(int n) {
        ModbusTcpSlaveSession[] modbusTcpSlaveSessionArray = new ModbusTcpSlaveSession[n];
        int n2 = 0;
        while (n2 < this.sessions.length) {
            if (this.sessions[n2] != null) {
                if (n2 < modbusTcpSlaveSessionArray.length) {
                    modbusTcpSlaveSessionArray[n2] = this.sessions[n2];
                } else {
                    this.sessions[n2].stop();
                    this.sessions[n2] = null;
                }
            }
            ++n2;
        }
        this.sessions = modbusTcpSlaveSessionArray;
    }

    public boolean isStarted() {
        return this.isAlive;
    }

    private final /* synthetic */ void this() {
        this.isAlive = false;
    }

    public ModbusTcpServer(BModbusTcpSlaveNetwork bModbusTcpSlaveNetwork) {
        this.this();
        this.host = bModbusTcpSlaveNetwork;
        this.sessions = new ModbusTcpSlaveSession[bModbusTcpSlaveNetwork.getMaximumConnections()];
    }
}

