/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.backport.concurrent.locks;

import com.tridium.util.backport.concurrent.TimeUnit;
import com.tridium.util.backport.concurrent.helpers.Utils;
import com.tridium.util.backport.concurrent.locks.CondVar;
import com.tridium.util.backport.concurrent.locks.Condition;
import com.tridium.util.backport.concurrent.locks.Lock;
import com.tridium.util.backport.concurrent.locks.ReadWriteLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ReentrantReadWriteLock
implements ReadWriteLock,
Serializable {
    private static final long serialVersionUID = -3463448656717690166L;
    final ReadLock readerLock_;
    final WriteLock writerLock_;
    final Sync sync;

    public Lock writeLock() {
        return this.writerLock_;
    }

    public Lock readLock() {
        return this.readerLock_;
    }

    public final boolean isFair() {
        return false;
    }

    protected Thread getOwner() {
        return this.sync.getOwner();
    }

    public int getReadLockCount() {
        return this.sync.getReadLockCount();
    }

    public boolean isWriteLocked() {
        return this.sync.isWriteLocked();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.sync.isWriteLockedByCurrentThread();
    }

    public int getWriteHoldCount() {
        return this.sync.getWriteHoldCount();
    }

    public int getReadHoldCount() {
        return this.sync.getReadHoldCount();
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    public String toString() {
        return super.toString() + "[Write locks = " + this.getWriteHoldCount() + ", Read locks = " + this.getReadLockCount() + ']';
    }

    private final /* synthetic */ void this() {
        this.readerLock_ = new ReadLock(this);
        this.writerLock_ = new WriteLock(this);
    }

    public ReentrantReadWriteLock() {
        this.this();
        this.sync = new NonfairSync();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static abstract class Sync
    implements Serializable {
        private static final int NONE = 0;
        private static final int READER = 1;
        private static final int WRITER = 2;
        static final Integer IONE = new Integer(1);
        transient int activeReaders_;
        transient Thread activeWriter_;
        transient int waitingReaders_;
        transient int waitingWriters_;
        transient int writeHolds_;
        transient HashMap readers_;

        synchronized boolean startReadFromNewReader() {
            boolean bl = this.startRead();
            if (!bl) {
                ++this.waitingReaders_;
            }
            return bl;
        }

        synchronized boolean startWriteFromNewWriter() {
            boolean bl = this.startWrite();
            if (!bl) {
                ++this.waitingWriters_;
            }
            return bl;
        }

        synchronized boolean startReadFromWaitingReader() {
            boolean bl = this.startRead();
            if (bl) {
                --this.waitingReaders_;
            }
            return bl;
        }

        synchronized boolean startWriteFromWaitingWriter() {
            boolean bl = this.startWrite();
            if (bl) {
                --this.waitingWriters_;
            }
            return bl;
        }

        synchronized void cancelledWaitingReader() {
            --this.waitingReaders_;
        }

        synchronized void cancelledWaitingWriter() {
            --this.waitingWriters_;
        }

        boolean allowReader() {
            boolean bl = false;
            if (this.activeWriter_ == null && this.waitingWriters_ == 0 || this.activeWriter_ == Thread.currentThread()) {
                bl = true;
            }
            return bl;
        }

        synchronized boolean startRead() {
            Thread thread = Thread.currentThread();
            Object v = this.readers_.get(thread);
            if (v != null) {
                this.readers_.put(thread, new Integer((Integer)v + 1));
                ++this.activeReaders_;
                return true;
            }
            if (this.allowReader()) {
                this.readers_.put(thread, IONE);
                ++this.activeReaders_;
                return true;
            }
            return false;
        }

        synchronized boolean startWrite() {
            if (this.activeWriter_ == Thread.currentThread()) {
                ++this.writeHolds_;
                return true;
            }
            if (this.writeHolds_ == 0) {
                if (this.activeReaders_ == 0 || this.readers_.size() == 1 && this.readers_.get(Thread.currentThread()) != null) {
                    this.activeWriter_ = Thread.currentThread();
                    this.writeHolds_ = 1;
                    return true;
                }
                return false;
            }
            return false;
        }

        synchronized int endRead() {
            Thread thread = Thread.currentThread();
            Object v = this.readers_.get(thread);
            if (v == null) {
                throw new IllegalMonitorStateException();
            }
            --this.activeReaders_;
            if (v != IONE) {
                int n = (Integer)v - 1;
                Integer n2 = n == 1 ? IONE : new Integer(n);
                this.readers_.put(thread, n2);
                return 0;
            }
            this.readers_.remove(thread);
            if (this.writeHolds_ > 0) {
                return 0;
            }
            if (this.activeReaders_ == 0 && this.waitingWriters_ > 0) {
                return 2;
            }
            return 0;
        }

        synchronized int endWrite() {
            if (this.activeWriter_ != Thread.currentThread()) {
                throw new IllegalMonitorStateException();
            }
            --this.writeHolds_;
            if (this.writeHolds_ > 0) {
                return 0;
            }
            this.activeWriter_ = null;
            if (this.waitingReaders_ > 0 && this.allowReader()) {
                return 1;
            }
            if (this.waitingWriters_ > 0) {
                return 2;
            }
            return 0;
        }

        synchronized Thread getOwner() {
            return this.activeWriter_;
        }

        synchronized int getReadLockCount() {
            return this.activeReaders_;
        }

        synchronized boolean isWriteLocked() {
            boolean bl = false;
            if (this.activeWriter_ != null) {
                bl = true;
            }
            return bl;
        }

        synchronized boolean isWriteLockedByCurrentThread() {
            boolean bl = false;
            if (this.activeWriter_ == Thread.currentThread()) {
                bl = true;
            }
            return bl;
        }

        synchronized int getWriteHoldCount() {
            int n = 0;
            if (this.isWriteLockedByCurrentThread()) {
                n = this.writeHolds_;
            }
            return n;
        }

        synchronized int getReadHoldCount() {
            if (this.activeReaders_ == 0) {
                return 0;
            }
            Thread thread = Thread.currentThread();
            Integer n = (Integer)this.readers_.get(thread);
            int n2 = 0;
            if (n != null) {
                n2 = n;
            }
            return n2;
        }

        final synchronized boolean hasQueuedThreads() {
            boolean bl = false;
            if (this.waitingWriters_ > 0 || this.waitingReaders_ > 0) {
                bl = true;
            }
            return bl;
        }

        final synchronized int getQueueLength() {
            return this.waitingWriters_ + this.waitingReaders_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            Sync sync = this;
            synchronized (sync) {
                this.readers_ = new HashMap();
                return;
            }
        }

        private final /* synthetic */ void this() {
            this.activeReaders_ = 0;
            this.activeWriter_ = null;
            this.waitingReaders_ = 0;
            this.waitingWriters_ = 0;
            this.writeHolds_ = 0;
            this.readers_ = new HashMap();
        }

        Sync() {
            this.this();
        }
    }

    public static class ReadLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -5992448646407690164L;
        final ReentrantReadWriteLock lock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void lock() {
            ReadLock readLock = this;
            synchronized (readLock) {
                if (this.lock.sync.startReadFromNewReader()) {
                    return;
                }
                boolean bl = Thread.interrupted();
                try {
                    while (true) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                        if (this.lock.sync.startReadFromWaitingReader()) {
                            Object var5_4 = null;
                            if (!bl) return;
                            Thread.currentThread().interrupt();
                            return;
                        }
                        continue;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (!bl) throw throwable;
                    Thread.currentThread().interrupt();
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void lockInterruptibly() throws InterruptedException {
            block9: {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                var1_1 = null;
                var2_2 = this;
                synchronized (var2_2) {
                    if (!this.lock.sync.startReadFromNewReader()) {
                    }
                    ** GOTO lbl20
                    {
                        catch (Throwable v0) {
                            throw v0;
                        }
                        ** try [egrp 1[TRYBLOCK] [1 : 39->62)] { 
lbl13:
                        // 1 sources

                        do {
                            this.wait();
                        } while (!this.lock.sync.startReadFromWaitingReader());
                        return;
                    }
lbl-1000:
                    // 1 sources

                    {
                        catch (InterruptedException var4_3) {
                            this.lock.sync.cancelledWaitingReader();
                            var1_1 = var4_3;
                        }
lbl20:
                        // 2 sources

                        // MONITOREXIT @DISABLED, blocks:[2, 3] lbl21 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (var1_1 == null) break block9;
                        this.lock.writerLock_.signalWaiters();
                    }
                }
                throw var1_1;
            }
        }

        public boolean tryLock() {
            return this.lock.sync.startRead();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            InterruptedException interruptedException;
            block10: {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                interruptedException = null;
                long l2 = timeUnit.toNanos(l);
                ReadLock readLock = this;
                synchronized (readLock) {
                    if (l2 <= 0L) {
                        return this.lock.sync.startRead();
                    }
                    if (this.lock.sync.startReadFromNewReader()) {
                        return true;
                    }
                    long l3 = Utils.nanoTime() + l2;
                    do {
                        try {
                            TimeUnit.NANOSECONDS.timedWait(this, l2);
                        }
                        catch (InterruptedException interruptedException2) {
                            this.lock.sync.cancelledWaitingReader();
                            interruptedException = interruptedException2;
                            break block10;
                        }
                        if (!this.lock.sync.startReadFromWaitingReader()) continue;
                        return true;
                    } while ((l2 = l3 - Utils.nanoTime()) > 0L);
                    this.lock.sync.cancelledWaitingReader();
                }
            }
            this.lock.writerLock_.signalWaiters();
            if (interruptedException != null) {
                throw interruptedException;
            }
            return false;
        }

        public void unlock() {
            switch (this.lock.sync.endRead()) {
                case 0: {
                    return;
                }
                case 1: {
                    this.lock.readerLock_.signalWaiters();
                    return;
                }
                case 2: {
                    this.lock.writerLock_.signalWaiters();
                    return;
                }
            }
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        synchronized void signalWaiters() {
            this.notifyAll();
        }

        public String toString() {
            int n = this.lock.getReadLockCount();
            return super.toString() + "[Read locks = " + n + ']';
        }

        protected ReadLock(ReentrantReadWriteLock reentrantReadWriteLock) {
            if (reentrantReadWriteLock == null) {
                throw new NullPointerException();
            }
            this.lock = reentrantReadWriteLock;
        }
    }

    public static class WriteLock
    implements Lock,
    CondVar.ExclusiveLock,
    Serializable {
        private static final long serialVersionUID = -4992448646407690164L;
        final ReentrantReadWriteLock lock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void lock() {
            WriteLock writeLock = this;
            synchronized (writeLock) {
                if (this.lock.sync.startWriteFromNewWriter()) {
                    return;
                }
                boolean bl = Thread.interrupted();
                try {
                    while (true) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                        if (this.lock.sync.startWriteFromWaitingWriter()) {
                            Object var5_4 = null;
                            if (!bl) return;
                            Thread.currentThread().interrupt();
                            return;
                        }
                        continue;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (!bl) throw throwable;
                    Thread.currentThread().interrupt();
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void lockInterruptibly() throws InterruptedException {
            block9: {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                var1_1 = null;
                var2_2 = this;
                synchronized (var2_2) {
                    if (!this.lock.sync.startWriteFromNewWriter()) {
                    }
                    ** GOTO lbl21
                    {
                        catch (Throwable v0) {
                            throw v0;
                        }
                        ** try [egrp 1[TRYBLOCK] [1 : 39->62)] { 
lbl13:
                        // 1 sources

                        do {
                            this.wait();
                        } while (!this.lock.sync.startWriteFromWaitingWriter());
                        return;
                    }
lbl-1000:
                    // 1 sources

                    {
                        catch (InterruptedException var4_3) {
                            this.lock.sync.cancelledWaitingWriter();
                            this.notify();
                            var1_1 = var4_3;
                        }
lbl21:
                        // 2 sources

                        // MONITOREXIT @DISABLED, blocks:[2, 3] lbl22 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (var1_1 == null) break block9;
                        this.lock.readerLock_.signalWaiters();
                    }
                }
                throw var1_1;
            }
        }

        public boolean tryLock() {
            return this.lock.sync.startWrite();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            InterruptedException interruptedException;
            block10: {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                interruptedException = null;
                long l2 = timeUnit.toNanos(l);
                WriteLock writeLock = this;
                synchronized (writeLock) {
                    if (l2 <= 0L) {
                        return this.lock.sync.startWrite();
                    }
                    if (this.lock.sync.startWriteFromNewWriter()) {
                        return true;
                    }
                    long l3 = Utils.nanoTime() + l2;
                    do {
                        try {
                            TimeUnit.NANOSECONDS.timedWait(this, l2);
                        }
                        catch (InterruptedException interruptedException2) {
                            this.lock.sync.cancelledWaitingWriter();
                            this.notify();
                            interruptedException = interruptedException2;
                            break block10;
                        }
                        if (!this.lock.sync.startWriteFromWaitingWriter()) continue;
                        return true;
                    } while ((l2 = l3 - Utils.nanoTime()) > 0L);
                    this.lock.sync.cancelledWaitingWriter();
                    this.notify();
                }
            }
            this.lock.readerLock_.signalWaiters();
            if (interruptedException != null) {
                throw interruptedException;
            }
            return false;
        }

        public void unlock() {
            switch (this.lock.sync.endWrite()) {
                case 0: {
                    return;
                }
                case 1: {
                    this.lock.readerLock_.signalWaiters();
                    return;
                }
                case 2: {
                    this.lock.writerLock_.signalWaiters();
                    return;
                }
            }
        }

        public Condition newCondition() {
            return new CondVar(this);
        }

        synchronized void signalWaiters() {
            this.notify();
        }

        public String toString() {
            Thread thread = this.lock.getOwner();
            return super.toString() + (thread == null ? "[Unlocked]" : "[Locked by thread " + thread.getName() + ']');
        }

        public boolean isHeldByCurrentThread() {
            return this.lock.sync.isWriteLockedByCurrentThread();
        }

        public int getHoldCount() {
            return this.lock.sync.getWriteHoldCount();
        }

        protected WriteLock(ReentrantReadWriteLock reentrantReadWriteLock) {
            if (reentrantReadWriteLock == null) {
                throw new NullPointerException();
            }
            this.lock = reentrantReadWriteLock;
        }
    }

    private static class NonfairSync
    extends Sync {
        NonfairSync() {
        }
    }
}

