/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.backport.concurrent.locks;

import com.tridium.util.backport.concurrent.TimeUnit;
import com.tridium.util.backport.concurrent.helpers.FIFOWaitQueue;
import com.tridium.util.backport.concurrent.helpers.WaitQueue;
import com.tridium.util.backport.concurrent.locks.CondVar;
import com.tridium.util.backport.concurrent.locks.Condition;
import com.tridium.util.backport.concurrent.locks.FIFOCondVar;
import com.tridium.util.backport.concurrent.locks.Lock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;

public class ReentrantLock
implements Lock,
Serializable,
CondVar.ExclusiveLock {
    private static final long serialVersionUID = 7373984872572414699L;
    private final Sync sync;

    public void lock() {
        this.sync.lock();
    }

    public void lockInterruptibly() throws InterruptedException {
        this.sync.lockInterruptibly();
    }

    public boolean tryLock() {
        return this.sync.tryLock();
    }

    public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.sync.tryLock(timeUnit.toNanos(l));
    }

    public void unlock() {
        this.sync.unlock();
    }

    public Condition newCondition() {
        return this.isFair() ? new FIFOCondVar(this) : new CondVar(this);
    }

    public int getHoldCount() {
        return this.sync.getHoldCount();
    }

    public boolean isHeldByCurrentThread() {
        return this.sync.isHeldByCurrentThread();
    }

    public boolean isLocked() {
        return this.sync.isLocked();
    }

    public final boolean isFair() {
        return this.sync.isFair();
    }

    protected Thread getOwner() {
        return this.sync.getOwner();
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread thread) {
        return this.sync.isQueued(thread);
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public boolean hasWaiters(Condition condition) {
        return this.asCondVar(condition).hasWaiters();
    }

    public int getWaitQueueLength(Condition condition) {
        return this.asCondVar(condition).getWaitQueueLength();
    }

    protected Collection getWaitingThreads(Condition condition) {
        return this.asCondVar(condition).getWaitingThreads();
    }

    public String toString() {
        Thread thread = this.getOwner();
        return super.toString() + (thread == null ? "[Unlocked]" : "[Locked by thread " + thread.getName() + ']');
    }

    private final CondVar asCondVar(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof CondVar)) {
            throw new IllegalArgumentException("not owner");
        }
        CondVar condVar = (CondVar)condition;
        if (condVar.lock != this) {
            throw new IllegalArgumentException("not owner");
        }
        return condVar;
    }

    public ReentrantLock() {
        this.sync = new NonfairSync();
    }

    public ReentrantLock(boolean bl) {
        this.sync = bl ? new FairSync() : new NonfairSync();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static abstract class Sync
    implements Serializable {
        private static final long serialVersionUID = -5179523762034025860L;
        protected transient Thread owner_;
        protected transient int holds_;

        public abstract void lock();

        public abstract void lockInterruptibly() throws InterruptedException;

        final void incHolds() {
            int n;
            if ((n = ++this.holds_) < 0) {
                throw new Error("Maximum lock count exceeded");
            }
            this.holds_ = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean tryLock() {
            Thread thread = Thread.currentThread();
            Sync sync = this;
            synchronized (sync) {
                if (this.owner_ == null) {
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return true;
                }
                if (thread == this.owner_) {
                    this.incHolds();
                    return true;
                }
                return false;
            }
        }

        public abstract boolean tryLock(long var1) throws InterruptedException;

        public abstract void unlock();

        public synchronized int getHoldCount() {
            int n = 0;
            if (this.isHeldByCurrentThread()) {
                n = this.holds_;
            }
            return n;
        }

        public synchronized boolean isHeldByCurrentThread() {
            boolean bl = false;
            if (this.holds_ > 0 && Thread.currentThread() == this.owner_) {
                bl = true;
            }
            return bl;
        }

        public synchronized boolean isLocked() {
            boolean bl = false;
            if (this.owner_ != null) {
                bl = true;
            }
            return bl;
        }

        public abstract boolean isFair();

        protected synchronized Thread getOwner() {
            return this.owner_;
        }

        public boolean hasQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public int getQueueLength() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public Collection getQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public boolean isQueued(Thread thread) {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        private final /* synthetic */ void this() {
            this.owner_ = null;
            this.holds_ = 0;
        }

        protected Sync() {
            this.this();
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = 7316153563782823691L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void lock() {
            Thread thread = Thread.currentThread();
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.owner_ == null) {
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return;
                }
                if (thread == this.owner_) {
                    this.incHolds();
                    return;
                }
                boolean bl = Thread.interrupted();
                try {
                    while (true) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                        if (this.owner_ == null) {
                            this.owner_ = thread;
                            this.holds_ = 1;
                            Object var6_5 = null;
                            if (!bl) return;
                            Thread.currentThread().interrupt();
                            return;
                        }
                        continue;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (!bl) throw throwable;
                    Thread.currentThread().interrupt();
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void lockInterruptibly() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread thread = Thread.currentThread();
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.owner_ == null) {
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return;
                }
                if (thread == this.owner_) {
                    this.incHolds();
                    return;
                }
                try {
                    do {
                        this.wait();
                    } while (this.owner_ != null);
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return;
                }
                catch (InterruptedException interruptedException) {
                    if (this.owner_ == null) {
                        this.notify();
                    }
                    throw interruptedException;
                }
            }
        }

        /*
         * Exception decompiling
         */
        public final boolean tryLock(long var1_1) throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [11 : 30->171)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public final synchronized void unlock() {
            if (Thread.currentThread() != this.owner_) {
                throw new IllegalMonitorStateException("Not owner");
            }
            if (--this.holds_ == 0) {
                this.owner_ = null;
                this.notify();
            }
        }

        public final boolean isFair() {
            return false;
        }

        NonfairSync() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static final class FairSync
    extends Sync
    implements WaitQueue.QueuedSync {
        private static final long serialVersionUID = -3000897897090466540L;
        private transient WaitQueue wq_;

        public final synchronized boolean recheck(WaitQueue.WaitNode waitNode) {
            Thread thread = Thread.currentThread();
            if (this.owner_ == null) {
                this.owner_ = thread;
                this.holds_ = 1;
                return true;
            }
            if (thread == this.owner_) {
                this.incHolds();
                return true;
            }
            this.wq_.insert(waitNode);
            return false;
        }

        public final synchronized void takeOver(WaitQueue.WaitNode waitNode) {
            this.owner_ = waitNode.getOwner();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void lock() {
            Thread thread = Thread.currentThread();
            FairSync fairSync = this;
            synchronized (fairSync) {
                if (this.owner_ == null) {
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return;
                }
                if (thread == this.owner_) {
                    this.incHolds();
                    return;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : var2_2
                WaitQueue.WaitNode waitNode = new WaitQueue.WaitNode();
                waitNode.doWaitUninterruptibly(this);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void lockInterruptibly() throws InterruptedException {
            WaitQueue.WaitNode waitNode;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread thread = Thread.currentThread();
            FairSync fairSync = this;
            synchronized (fairSync) {
                if (this.owner_ == null) {
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return;
                }
                if (thread == this.owner_) {
                    this.incHolds();
                    return;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl17 : MonitorExitStatement: MONITOREXIT : var2_2
                waitNode = new WaitQueue.WaitNode();
            }
            waitNode.doWait(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final boolean tryLock(long l) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread thread = Thread.currentThread();
            FairSync fairSync = this;
            synchronized (fairSync) {
                if (this.owner_ == null) {
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return true;
                }
                if (thread == this.owner_) {
                    this.incHolds();
                    return true;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl17 : MonitorExitStatement: MONITOREXIT : var4_3
                WaitQueue.WaitNode waitNode = new WaitQueue.WaitNode();
                return waitNode.doTimedWait(this, l);
            }
        }

        protected final synchronized WaitQueue.WaitNode getSignallee(Thread thread) {
            if (thread != this.owner_) {
                throw new IllegalMonitorStateException("Not owner");
            }
            if (this.holds_ >= 2) {
                --this.holds_;
                return null;
            }
            WaitQueue.WaitNode waitNode = this.wq_.extract();
            if (waitNode == null) {
                this.owner_ = null;
                this.holds_ = 0;
            }
            return waitNode;
        }

        public final void unlock() {
            WaitQueue.WaitNode waitNode;
            Thread thread = Thread.currentThread();
            do {
                if ((waitNode = this.getSignallee(thread)) != null) continue;
                return;
            } while (!waitNode.signal(this));
        }

        public final boolean isFair() {
            return true;
        }

        public final synchronized boolean hasQueuedThreads() {
            return this.wq_.hasNodes();
        }

        public final synchronized int getQueueLength() {
            return this.wq_.getLength();
        }

        public final synchronized Collection getQueuedThreads() {
            return this.wq_.getWaitingThreads();
        }

        public final synchronized boolean isQueued(Thread thread) {
            return this.wq_.isWaiting(thread);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            FairSync fairSync = this;
            synchronized (fairSync) {
                this.wq_ = new FIFOWaitQueue();
                return;
            }
        }

        private final /* synthetic */ void this() {
            this.wq_ = new FIFOWaitQueue();
        }

        FairSync() {
            this.this();
        }
    }
}

