/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.backport.concurrent.helpers;

public class ThreadHelpers {
    public static Runnable assignExceptionHandler(final Runnable runnable, final UncaughtExceptionHandler uncaughtExceptionHandler) {
        if (runnable == null || uncaughtExceptionHandler == null) {
            throw new NullPointerException();
        }
        return new Runnable(){

            public final void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    try {
                        uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), throwable);
                    }
                    catch (Throwable throwable2) {}
                }
            }
        };
    }

    private ThreadHelpers() {
    }

    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }
}

