/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.backport.concurrent;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;

public abstract class TimeUnit
implements Serializable {
    public static final TimeUnit NANOSECONDS = new TimeUnit(0, "NANOSECONDS"){
        private static final long serialVersionUID = 535148490883208361L;

        public final long toNanos(long l) {
            return l;
        }

        public final long toMicros(long l) {
            return l / 1000L;
        }

        public final long toMillis(long l) {
            return l / 1000000L;
        }

        public final long toSeconds(long l) {
            return l / 1000000000L;
        }

        public final long toMinutes(long l) {
            return l / 60000000000L;
        }

        public final long toHours(long l) {
            return l / 3600000000000L;
        }

        public final long toDays(long l) {
            return l / 86400000000000L;
        }

        public final long convert(long l, TimeUnit timeUnit) {
            return timeUnit.toNanos(l);
        }

        final int excessNanos(long l, long l2) {
            return (int)(l - l2 * 1000000L);
        }
    };
    public static final TimeUnit MICROSECONDS = new TimeUnit(1, "MICROSECONDS"){
        private static final long serialVersionUID = 2185906575929579108L;

        public final long toNanos(long l) {
            return 2.x(l, 1000L, 9223372036854775L);
        }

        public final long toMicros(long l) {
            return l;
        }

        public final long toMillis(long l) {
            return l / 1000L;
        }

        public final long toSeconds(long l) {
            return l / 1000000L;
        }

        public final long toMinutes(long l) {
            return l / 60000000L;
        }

        public final long toHours(long l) {
            return l / 3600000000L;
        }

        public final long toDays(long l) {
            return l / 86400000000L;
        }

        public final long convert(long l, TimeUnit timeUnit) {
            return timeUnit.toMicros(l);
        }

        final int excessNanos(long l, long l2) {
            return (int)(l * 1000L - l2 * 1000000L);
        }
    };
    public static final TimeUnit MILLISECONDS = new TimeUnit(2, "MILLISECONDS"){
        private static final long serialVersionUID = 9032047794123325184L;

        public final long toNanos(long l) {
            return 3.x(l, 1000000L, 9223372036854L);
        }

        public final long toMicros(long l) {
            return 3.x(l, 1000L, 9223372036854775L);
        }

        public final long toMillis(long l) {
            return l;
        }

        public final long toSeconds(long l) {
            return l / 1000L;
        }

        public final long toMinutes(long l) {
            return l / 60000L;
        }

        public final long toHours(long l) {
            return l / 3600000L;
        }

        public final long toDays(long l) {
            return l / 86400000L;
        }

        public final long convert(long l, TimeUnit timeUnit) {
            return timeUnit.toMillis(l);
        }

        final int excessNanos(long l, long l2) {
            return 0;
        }
    };
    public static final TimeUnit SECONDS = new TimeUnit(3, "SECONDS"){
        private static final long serialVersionUID = 227755028449378390L;

        public final long toNanos(long l) {
            return 4.x(l, 1000000000L, 9223372036L);
        }

        public final long toMicros(long l) {
            return 4.x(l, 1000000L, 9223372036854L);
        }

        public final long toMillis(long l) {
            return 4.x(l, 1000L, 9223372036854775L);
        }

        public final long toSeconds(long l) {
            return l;
        }

        public final long toMinutes(long l) {
            return l / 60L;
        }

        public final long toHours(long l) {
            return l / 3600L;
        }

        public final long toDays(long l) {
            return l / 86400L;
        }

        public final long convert(long l, TimeUnit timeUnit) {
            return timeUnit.toSeconds(l);
        }

        final int excessNanos(long l, long l2) {
            return 0;
        }
    };
    public static final TimeUnit MINUTES = new TimeUnit(4, "MINUTES"){
        private static final long serialVersionUID = 1827351566402609187L;

        public final long toNanos(long l) {
            return 5.x(l, 60000000000L, 153722867L);
        }

        public final long toMicros(long l) {
            return 5.x(l, 60000000L, 153722867280L);
        }

        public final long toMillis(long l) {
            return 5.x(l, 60000L, 153722867280912L);
        }

        public final long toSeconds(long l) {
            return 5.x(l, 60L, 0x222222222222222L);
        }

        public final long toMinutes(long l) {
            return l;
        }

        public final long toHours(long l) {
            return l / 60L;
        }

        public final long toDays(long l) {
            return l / 1440L;
        }

        public final long convert(long l, TimeUnit timeUnit) {
            return timeUnit.toMinutes(l);
        }

        final int excessNanos(long l, long l2) {
            return 0;
        }
    };
    public static final TimeUnit HOURS = new TimeUnit(5, "HOURS"){
        private static final long serialVersionUID = -6438436134732089810L;

        public final long toNanos(long l) {
            return 6.x(l, 3600000000000L, 2562047L);
        }

        public final long toMicros(long l) {
            return 6.x(l, 3600000000L, 2562047788L);
        }

        public final long toMillis(long l) {
            return 6.x(l, 3600000L, 2562047788015L);
        }

        public final long toSeconds(long l) {
            return 6.x(l, 3600L, 2562047788015215L);
        }

        public final long toMinutes(long l) {
            return 6.x(l, 60L, 0x222222222222222L);
        }

        public final long toHours(long l) {
            return l;
        }

        public final long toDays(long l) {
            return l / 24L;
        }

        public final long convert(long l, TimeUnit timeUnit) {
            return timeUnit.toHours(l);
        }

        final int excessNanos(long l, long l2) {
            return 0;
        }
    };
    public static final TimeUnit DAYS = new TimeUnit(6, "DAYS"){
        private static final long serialVersionUID = 567463171959674600L;

        public final long toNanos(long l) {
            return 7.x(l, 86400000000000L, 106751L);
        }

        public final long toMicros(long l) {
            return 7.x(l, 86400000000L, 106751991L);
        }

        public final long toMillis(long l) {
            return 7.x(l, 86400000L, 106751991167L);
        }

        public final long toSeconds(long l) {
            return 7.x(l, 86400L, 106751991167300L);
        }

        public final long toMinutes(long l) {
            return 7.x(l, 1440L, 0x16C16C16C16C16L);
        }

        public final long toHours(long l) {
            return 7.x(l, 24L, 0x555555555555555L);
        }

        public final long toDays(long l) {
            return l;
        }

        public final long convert(long l, TimeUnit timeUnit) {
            return timeUnit.toDays(l);
        }

        final int excessNanos(long l, long l2) {
            return 0;
        }
    };
    private static final TimeUnit[] values = new TimeUnit[]{NANOSECONDS, MICROSECONDS, MILLISECONDS, SECONDS, MINUTES, HOURS, DAYS};
    static final long C0 = 1L;
    static final long C1 = 1000L;
    static final long C2 = 1000000L;
    static final long C3 = 1000000000L;
    static final long C4 = 60000000000L;
    static final long C5 = 3600000000000L;
    static final long C6 = 86400000000000L;
    static final long MAX = Long.MAX_VALUE;
    private final int index;
    private final String name;

    public static TimeUnit[] values() {
        return (TimeUnit[])values.clone();
    }

    public static TimeUnit valueOf(String string) {
        int n = 0;
        while (n < values.length) {
            if (TimeUnit.values[n].name.equals(string)) {
                return values[n];
            }
            ++n;
        }
        throw new IllegalArgumentException("No enum const TimeUnit." + string);
    }

    static long x(long l, long l2, long l3) {
        if (l > l3) {
            return Long.MAX_VALUE;
        }
        if (l < -l3) {
            return Long.MIN_VALUE;
        }
        return l * l2;
    }

    public abstract long convert(long var1, TimeUnit var3);

    public abstract long toNanos(long var1);

    public abstract long toMicros(long var1);

    public abstract long toMillis(long var1);

    public abstract long toSeconds(long var1);

    public abstract long toMinutes(long var1);

    public abstract long toHours(long var1);

    public abstract long toDays(long var1);

    abstract int excessNanos(long var1, long var3);

    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.index;
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            return TimeUnit.valueOf(this.name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidObjectException(this.name + " is not a valid enum for TimeUnit");
        }
    }

    public void timedWait(Object object, long l) throws InterruptedException {
        if (l > 0L) {
            long l2 = this.toMillis(l);
            int n = this.excessNanos(l, l2);
            object.wait(l2, n);
        }
    }

    public void timedJoin(Thread thread, long l) throws InterruptedException {
        if (l > 0L) {
            long l2 = this.toMillis(l);
            int n = this.excessNanos(l, l2);
            thread.join(l2, n);
        }
    }

    public void sleep(long l) throws InterruptedException {
        if (l > 0L) {
            long l2 = this.toMillis(l);
            int n = this.excessNanos(l, l2);
            Thread.sleep(l2, n);
        }
    }

    public String toString() {
        return this.name;
    }

    TimeUnit(int n, String string) {
        this.index = n;
        this.name = string;
    }
}

