/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.backport.concurrent;

import com.tridium.util.backport.concurrent.TimeUnit;
import com.tridium.util.backport.concurrent.helpers.FIFOWaitQueue;
import com.tridium.util.backport.concurrent.helpers.WaitQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;

public class Semaphore
implements Serializable {
    private static final long serialVersionUID = -3222578661600680210L;
    private final Sync sync;

    public void acquire() throws InterruptedException {
        this.sync.acquire(1);
    }

    public void acquireUninterruptibly() {
        this.sync.acquireUninterruptibly(1);
    }

    public boolean tryAcquire() {
        return this.sync.attempt(1);
    }

    public boolean tryAcquire(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.sync.attempt(1, timeUnit.toNanos(l));
    }

    public void release() {
        this.sync.release(1);
    }

    public void acquire(int n) throws InterruptedException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.acquire(n);
    }

    public void acquireUninterruptibly(int n) {
        this.sync.acquireUninterruptibly(n);
    }

    public boolean tryAcquire(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return this.sync.attempt(n);
    }

    public boolean tryAcquire(int n, long l, TimeUnit timeUnit) throws InterruptedException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return this.sync.attempt(n, timeUnit.toNanos(l));
    }

    public void release(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.release(n);
    }

    public int availablePermits() {
        return this.sync.getPermits();
    }

    public int drainPermits() {
        return this.sync.drain();
    }

    protected void reducePermits(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.reduce(n);
    }

    public boolean isFair() {
        return this.sync instanceof FairSync;
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public String toString() {
        return super.toString() + "[Permits = " + this.sync.getPermits() + ']';
    }

    public Semaphore(int n) {
        this.sync = new NonfairSync(n);
    }

    public Semaphore(int n, boolean bl) {
        this.sync = bl ? new FairSync(n) : new NonfairSync(n);
    }

    static abstract class Sync
    implements Serializable {
        private static final long serialVersionUID = 1192457210091910933L;
        int permits_;

        abstract void acquireUninterruptibly(int var1);

        abstract void acquire(int var1) throws InterruptedException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean attempt(int n) {
            Sync sync = this;
            synchronized (sync) {
                if (this.permits_ >= n) {
                    this.permits_ -= n;
                    return true;
                }
                return false;
            }
        }

        abstract boolean attempt(int var1, long var2) throws InterruptedException;

        abstract void release(int var1);

        public synchronized int getPermits() {
            return this.permits_;
        }

        public synchronized int drain() {
            int n = this.permits_;
            this.permits_ = 0;
            return n;
        }

        public synchronized void reduce(int n) {
            this.permits_ -= n;
        }

        abstract boolean hasQueuedThreads();

        abstract int getQueueLength();

        abstract Collection getQueuedThreads();

        protected Sync(int n) {
            this.permits_ = n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static final class FairSync
    extends Sync
    implements WaitQueue.QueuedSync {
        private static final long serialVersionUID = 2014338818796000944L;
        private transient WaitQueue wq_;

        public final void acquireUninterruptibly(int n) {
            if (this.precheck(n)) {
                return;
            }
            Node node = new Node(n);
            node.doWaitUninterruptibly(this);
        }

        public final void acquire(int n) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.precheck(n)) {
                return;
            }
            Node node = new Node(n);
            node.doWait(this);
        }

        public final boolean attempt(int n, long l) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.precheck(n)) {
                return true;
            }
            if (l <= 0L) {
                return false;
            }
            Node node = new Node(n);
            return node.doTimedWait(this, l);
        }

        protected final synchronized boolean precheck(int n) {
            boolean bl;
            boolean bl2 = false;
            if (this.permits_ >= n) {
                bl2 = true;
            }
            if (bl = bl2) {
                this.permits_ -= n;
            }
            return bl;
        }

        public final synchronized boolean recheck(WaitQueue.WaitNode waitNode) {
            boolean bl;
            Node node = (Node)waitNode;
            boolean bl2 = false;
            if (this.permits_ >= node.requests) {
                bl2 = true;
            }
            if (bl = bl2) {
                this.permits_ -= node.requests;
            } else {
                this.wq_.insert(waitNode);
            }
            return bl;
        }

        public final void takeOver(WaitQueue.WaitNode waitNode) {
        }

        protected final synchronized Node getSignallee(int n) {
            Node node = (Node)this.wq_.extract();
            this.permits_ += n;
            if (node == null) {
                return null;
            }
            if (node.requests > this.permits_) {
                this.wq_.putBack(node);
                return null;
            }
            this.permits_ -= node.requests;
            return node;
        }

        public final void release(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative argument");
            }
            Node node;
            while ((node = this.getSignallee(n)) != null) {
                if (node.signal(this)) {
                    return;
                }
                n = node.requests;
            }
            return;
        }

        public final synchronized boolean hasQueuedThreads() {
            return this.wq_.hasNodes();
        }

        public final synchronized int getQueueLength() {
            return this.wq_.getLength();
        }

        public final synchronized Collection getQueuedThreads() {
            return this.wq_.getWaitingThreads();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            FairSync fairSync = this;
            synchronized (fairSync) {
                this.wq_ = new FIFOWaitQueue();
                return;
            }
        }

        private final /* synthetic */ void this() {
            this.wq_ = new FIFOWaitQueue();
        }

        FairSync(int n) {
            super(n);
            this.this();
        }

        static final class Node
        extends WaitQueue.WaitNode {
            final int requests;

            Node(int n) {
                this.requests = n;
            }
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = -2694183684443567898L;

        private static final void checkAgainstMultiacquire(int n) {
            if (n != 1) {
                throw new UnsupportedOperationException("Atomic multi-acquire supported only in FAIR semaphores");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void acquireUninterruptibly(int n) {
            if (n == 0) {
                return;
            }
            NonfairSync.checkAgainstMultiacquire(n);
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.permits_ > 0) {
                    --this.permits_;
                    return;
                }
                boolean bl = Thread.interrupted();
                try {
                    while (true) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                        if (this.permits_ > 0) {
                            --this.permits_;
                            Object var6_5 = null;
                            if (!bl) return;
                            Thread.currentThread().interrupt();
                            return;
                        }
                        continue;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (!bl) throw throwable;
                    Thread.currentThread().interrupt();
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void acquire(int n) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (n == 0) {
                return;
            }
            NonfairSync.checkAgainstMultiacquire(n);
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                while (true) {
                    if (this.permits_ > 0) {
                        --this.permits_;
                        return;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.notify();
                        throw interruptedException;
                    }
                }
            }
        }

        /*
         * Exception decompiling
         */
        public final boolean attempt(int var1_1, long var2_2) throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [8 : 36->136)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public final synchronized void release(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative argument");
            }
            this.permits_ += n;
            int n2 = 0;
            while (n2 < n) {
                this.notify();
                ++n2;
            }
        }

        public final boolean hasQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public final int getQueueLength() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public final Collection getQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        protected NonfairSync(int n) {
            super(n);
        }
    }
}

