/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.backport.concurrent;

import com.tridium.util.backport.AbstractQueue;
import com.tridium.util.backport.concurrent.BlockingDeque;
import com.tridium.util.backport.concurrent.TimeUnit;
import com.tridium.util.backport.concurrent.helpers.Utils;
import com.tridium.util.backport.concurrent.locks.Condition;
import com.tridium.util.backport.concurrent.locks.ReentrantLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LinkedBlockingDeque
extends AbstractQueue
implements BlockingDeque,
Serializable {
    private static final long serialVersionUID = -387911632671998426L;
    private transient Node first;
    private transient Node last;
    private transient int count;
    private final int capacity;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    private final boolean linkFirst(Object object) {
        Node node;
        if (this.count >= this.capacity) {
            return false;
        }
        ++this.count;
        Node node2 = this.first;
        this.first = node = new Node(object, null, node2);
        if (this.last == null) {
            this.last = node;
        } else {
            node2.prev = node;
        }
        this.notEmpty.signal();
        return true;
    }

    private final boolean linkLast(Object object) {
        Node node;
        if (this.count >= this.capacity) {
            return false;
        }
        ++this.count;
        Node node2 = this.last;
        this.last = node = new Node(object, node2, null);
        if (this.first == null) {
            this.first = node;
        } else {
            node2.next = node;
        }
        this.notEmpty.signal();
        return true;
    }

    private final Object unlinkFirst() {
        Node node;
        Node node2 = this.first;
        if (node2 == null) {
            return null;
        }
        this.first = node = node2.next;
        if (node == null) {
            this.last = null;
        } else {
            node.prev = null;
        }
        --this.count;
        this.notFull.signal();
        return node2.item;
    }

    private final Object unlinkLast() {
        Node node;
        Node node2 = this.last;
        if (node2 == null) {
            return null;
        }
        this.last = node = node2.prev;
        if (node == null) {
            this.first = null;
        } else {
            node.next = null;
        }
        --this.count;
        this.notFull.signal();
        return node2.item;
    }

    private final void unlink(Node node) {
        Node node2 = node.prev;
        Node node3 = node.next;
        if (node2 == null) {
            if (node3 == null) {
                this.last = null;
                this.first = null;
            } else {
                node3.prev = null;
                this.first = node3;
            }
        } else if (node3 == null) {
            node2.next = null;
            this.last = node2;
        } else {
            node2.next = node3;
            node3.prev = node2;
        }
        --this.count;
        this.notFull.signalAll();
    }

    public void addFirst(Object object) {
        if (!this.offerFirst(object)) {
            throw new IllegalStateException("Deque full");
        }
    }

    public void addLast(Object object) {
        if (!this.offerLast(object)) {
            throw new IllegalStateException("Deque full");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerFirst(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            boolean bl = this.linkFirst(object);
            Object var3_3 = null;
            this.lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerLast(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            boolean bl = this.linkLast(object);
            Object var3_3 = null;
            this.lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putFirst(Object object) throws InterruptedException {
        if (object == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            while (!this.linkFirst(object)) {
                this.notFull.await();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.lock.unlock();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putLast(Object object) throws InterruptedException {
        if (object == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            while (!this.linkLast(object)) {
                this.notFull.await();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.lock.unlock();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean offerFirst(Object object, long l, TimeUnit timeUnit) throws InterruptedException {
        boolean bl;
        if (object == null) {
            throw new NullPointerException();
        }
        long l2 = timeUnit.toNanos(l);
        long l3 = Utils.nanoTime() + l2;
        this.lock.lockInterruptibly();
        try {
            while (true) {
                if (this.linkFirst(object)) {
                    boolean bl2 = true;
                    Object var10_8 = null;
                    this.lock.unlock();
                    return bl2;
                }
                if (l2 <= 0L) {
                    bl = false;
                    break;
                }
                this.notFull.await(l2, TimeUnit.NANOSECONDS);
                l2 = l3 - Utils.nanoTime();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var10_9 = null;
        this.lock.unlock();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean offerLast(Object object, long l, TimeUnit timeUnit) throws InterruptedException {
        boolean bl;
        if (object == null) {
            throw new NullPointerException();
        }
        long l2 = timeUnit.toNanos(l);
        long l3 = Utils.nanoTime() + l2;
        this.lock.lockInterruptibly();
        try {
            while (true) {
                if (this.linkLast(object)) {
                    boolean bl2 = true;
                    Object var10_8 = null;
                    this.lock.unlock();
                    return bl2;
                }
                if (l2 <= 0L) {
                    bl = false;
                    break;
                }
                this.notFull.await(l2, TimeUnit.NANOSECONDS);
                l2 = l3 - Utils.nanoTime();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var10_9 = null;
        this.lock.unlock();
        return bl;
    }

    public Object removeFirst() {
        Object object = this.pollFirst();
        if (object == null) {
            throw new NoSuchElementException();
        }
        return object;
    }

    public Object removeLast() {
        Object object = this.pollLast();
        if (object == null) {
            throw new NoSuchElementException();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pollFirst() {
        this.lock.lock();
        try {
            Object object = this.unlinkFirst();
            Object var2_2 = null;
            this.lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pollLast() {
        this.lock.lock();
        try {
            Object object = this.unlinkLast();
            Object var2_2 = null;
            this.lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object takeFirst() throws InterruptedException {
        this.lock.lock();
        try {
            Object object;
            while ((object = this.unlinkFirst()) == null) {
                this.notEmpty.await();
            }
            Object object2 = object;
            Object var2_3 = null;
            this.lock.unlock();
            return object2;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object takeLast() throws InterruptedException {
        this.lock.lock();
        try {
            Object object;
            while ((object = this.unlinkLast()) == null) {
                this.notEmpty.await();
            }
            Object object2 = object;
            Object var2_3 = null;
            this.lock.unlock();
            return object2;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object pollFirst(long l, TimeUnit timeUnit) throws InterruptedException {
        Object var10_7;
        long l2 = timeUnit.toNanos(l);
        long l3 = Utils.nanoTime() + l2;
        this.lock.lockInterruptibly();
        try {
            while (true) {
                Object object;
                if ((object = this.unlinkFirst()) != null) {
                    Object object2 = object;
                    Object var9_8 = null;
                    this.lock.unlock();
                    return object2;
                }
                if (l2 <= 0L) {
                    var10_7 = null;
                    break;
                }
                this.notEmpty.await(l2, TimeUnit.NANOSECONDS);
                l2 = l3 - Utils.nanoTime();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var9_9 = null;
        this.lock.unlock();
        return var10_7;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object pollLast(long l, TimeUnit timeUnit) throws InterruptedException {
        Object var10_7;
        long l2 = timeUnit.toNanos(l);
        long l3 = Utils.nanoTime() + l2;
        this.lock.lockInterruptibly();
        try {
            while (true) {
                Object object;
                if ((object = this.unlinkLast()) != null) {
                    Object object2 = object;
                    Object var9_8 = null;
                    this.lock.unlock();
                    return object2;
                }
                if (l2 <= 0L) {
                    var10_7 = null;
                    break;
                }
                this.notEmpty.await(l2, TimeUnit.NANOSECONDS);
                l2 = l3 - Utils.nanoTime();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var9_9 = null;
        this.lock.unlock();
        return var10_7;
    }

    public Object getFirst() {
        Object object = this.peekFirst();
        if (object == null) {
            throw new NoSuchElementException();
        }
        return object;
    }

    public Object getLast() {
        Object object = this.peekLast();
        if (object == null) {
            throw new NoSuchElementException();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peekFirst() {
        this.lock.lock();
        try {
            Object object = this.first == null ? null : this.first.item;
            Object var2_2 = null;
            this.lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peekLast() {
        this.lock.lock();
        try {
            Object object = this.last == null ? null : this.last.item;
            Object var2_2 = null;
            this.lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeFirstOccurrence(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node node = this.first;
            while (true) {
                if (node == null) {
                    bl = false;
                    break;
                }
                if (object.equals(node.item)) {
                    this.unlink(node);
                    boolean bl2 = true;
                    Object var3_5 = null;
                    this.lock.unlock();
                    return bl2;
                }
                node = node.next;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var3_6 = null;
        this.lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeLastOccurrence(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node node = this.last;
            while (true) {
                if (node == null) {
                    bl = false;
                    break;
                }
                if (object.equals(node.item)) {
                    this.unlink(node);
                    boolean bl2 = true;
                    Object var3_5 = null;
                    this.lock.unlock();
                    return bl2;
                }
                node = node.prev;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var3_6 = null;
        this.lock.unlock();
        return bl;
    }

    public boolean add(Object object) {
        this.addLast(object);
        return true;
    }

    public boolean offer(Object object) {
        return this.offerLast(object);
    }

    public void put(Object object) throws InterruptedException {
        this.putLast(object);
    }

    public boolean offer(Object object, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.offerLast(object, l, timeUnit);
    }

    public Object remove() {
        return this.removeFirst();
    }

    public Object poll() {
        return this.pollFirst();
    }

    public Object take() throws InterruptedException {
        return this.takeFirst();
    }

    public Object poll(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.pollFirst(l, timeUnit);
    }

    public Object element() {
        return this.getFirst();
    }

    public Object peek() {
        return this.peekFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remainingCapacity() {
        this.lock.lock();
        try {
            int n = this.capacity - this.count;
            Object var2_2 = null;
            this.lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            Node node = this.first;
            while (node != null) {
                collection.add(node.item);
                node = node.next;
            }
            int n = this.count;
            this.count = 0;
            this.last = null;
            this.first = null;
            this.notFull.signalAll();
            int n2 = n;
            Object var3_5 = null;
            this.lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection collection, int n) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            int n2 = 0;
            while (n2 < n && this.first != null) {
                collection.add(this.first.item);
                this.first.prev = null;
                this.first = this.first.next;
                --this.count;
                ++n2;
            }
            if (this.first == null) {
                this.last = null;
            }
            this.notFull.signalAll();
            int n3 = n2;
            Object var4_5 = null;
            this.lock.unlock();
            return n3;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public void push(Object object) {
        this.addFirst(object);
    }

    public Object pop() {
        return this.removeFirst();
    }

    public boolean remove(Object object) {
        return this.removeFirstOccurrence(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.lock();
        try {
            int n = this.count;
            Object var2_2 = null;
            this.lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node node = this.first;
            while (true) {
                if (node == null) {
                    bl = false;
                    break;
                }
                if (object.equals(node.item)) {
                    boolean bl2 = true;
                    Object var3_5 = null;
                    this.lock.unlock();
                    return bl2;
                }
                node = node.next;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var3_6 = null;
        this.lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean removeNode(Node node) {
        boolean bl;
        this.lock.lock();
        try {
            Node node2 = this.first;
            while (true) {
                if (node2 == null) {
                    bl = false;
                    break;
                }
                if (node2 == node) {
                    this.unlink(node2);
                    boolean bl2 = true;
                    Object var3_5 = null;
                    this.lock.unlock();
                    return bl2;
                }
                node2 = node2.next;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var3_6 = null;
        this.lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        this.lock.lock();
        try {
            Object[] objectArray = new Object[this.count];
            int n = 0;
            Node node = this.first;
            while (node != null) {
                objectArray[n++] = node.item;
                node = node.next;
            }
            Object[] objectArray2 = objectArray;
            Object var2_5 = null;
            this.lock.unlock();
            return objectArray2;
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] objectArray) {
        this.lock.lock();
        try {
            if (objectArray.length < this.count) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.count);
            }
            int n = 0;
            Node node = this.first;
            while (node != null) {
                objectArray[n++] = node.item;
                node = node.next;
            }
            if (objectArray.length > n) {
                objectArray[n] = null;
            }
            Object[] objectArray2 = objectArray;
            Object var3_5 = null;
            this.lock.unlock();
            return objectArray2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.lock();
        try {
            String string = super.toString();
            Object var2_2 = null;
            this.lock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        this.lock.lock();
        try {
            this.last = null;
            this.first = null;
            this.count = 0;
            this.notFull.signalAll();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
        {
            Object var2_3 = null;
            this.lock.unlock();
            return;
        }
    }

    public Iterator iterator() {
        return new Itr();
    }

    public Iterator descendingIterator() {
        return new DescendingItr();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.lock.lock();
        try {
            objectOutputStream.defaultWriteObject();
            Node node = this.first;
            while (true) {
                block4: {
                    if (node != null) break block4;
                    objectOutputStream.writeObject(null);
                    break;
                }
                objectOutputStream.writeObject(node.item);
                node = node.next;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.lock.unlock();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.lock.unlock();
            return;
        }
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.count = 0;
        this.first = null;
        this.last = null;
        while ((object = objectInputStream.readObject()) != null) {
            this.add(object);
        }
    }

    private final /* synthetic */ void this() {
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    public LinkedBlockingDeque() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingDeque(int n) {
        this.this();
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = n;
    }

    public LinkedBlockingDeque(Collection collection) {
        this(Integer.MAX_VALUE);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.add(e);
        }
    }

    static final class Node {
        Object item;
        Node prev;
        Node next;

        Node(Object object, Node node, Node node2) {
            this.item = object;
            this.prev = node;
            this.next = node2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Itr
    extends AbstractItr {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void advance() {
            ReentrantLock reentrantLock = LinkedBlockingDeque.this.lock;
            reentrantLock.lock();
            try {
                this.next = this.next == null ? LinkedBlockingDeque.this.first : this.next.next;
                this.nextItem = this.next == null ? null : this.next.item;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            {
                Object var3_4 = null;
                reentrantLock.unlock();
                return;
            }
        }

        private Itr() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DescendingItr
    extends AbstractItr {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void advance() {
            ReentrantLock reentrantLock = LinkedBlockingDeque.this.lock;
            reentrantLock.lock();
            try {
                this.next = this.next == null ? LinkedBlockingDeque.this.last : this.next.prev;
                this.nextItem = this.next == null ? null : this.next.item;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            {
                Object var3_4 = null;
                reentrantLock.unlock();
                return;
            }
        }

        private DescendingItr() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private abstract class AbstractItr
    implements Iterator {
        Node next;
        Object nextItem;
        private Node lastRet;

        abstract void advance();

        public boolean hasNext() {
            boolean bl = false;
            if (this.next != null) {
                bl = true;
            }
            return bl;
        }

        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.next;
            Object object = this.nextItem;
            this.advance();
            return object;
        }

        public void remove() {
            Node node = this.lastRet;
            if (node == null) {
                throw new IllegalStateException();
            }
            this.lastRet = null;
            LinkedBlockingDeque.this.removeNode(node);
        }

        AbstractItr() {
            this.advance();
        }
    }
}

