/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.backport.concurrent;

import com.tridium.util.backport.concurrent.AbstractExecutorService;
import com.tridium.util.backport.concurrent.BlockingQueue;
import com.tridium.util.backport.concurrent.Callable;
import com.tridium.util.backport.concurrent.CompletionService;
import com.tridium.util.backport.concurrent.Executor;
import com.tridium.util.backport.concurrent.Future;
import com.tridium.util.backport.concurrent.FutureTask;
import com.tridium.util.backport.concurrent.LinkedBlockingQueue;
import com.tridium.util.backport.concurrent.RunnableFuture;
import com.tridium.util.backport.concurrent.TimeUnit;

public class ExecutorCompletionService
implements CompletionService {
    private final Executor executor;
    private final AbstractExecutorService aes;
    private final BlockingQueue completionQueue;

    private final RunnableFuture newTaskFor(Callable callable) {
        if (this.aes == null) {
            return new FutureTask(callable);
        }
        return this.aes.newTaskFor(callable);
    }

    private final RunnableFuture newTaskFor(Runnable runnable, Object object) {
        if (this.aes == null) {
            return new FutureTask(runnable, object);
        }
        return this.aes.newTaskFor(runnable, object);
    }

    public Future submit(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        RunnableFuture runnableFuture = this.newTaskFor(callable);
        this.executor.execute(new QueueingFuture(runnableFuture));
        return runnableFuture;
    }

    public Future submit(Runnable runnable, Object object) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableFuture runnableFuture = this.newTaskFor(runnable, object);
        this.executor.execute(new QueueingFuture(runnableFuture));
        return runnableFuture;
    }

    public Future take() throws InterruptedException {
        return (Future)this.completionQueue.take();
    }

    public Future poll() {
        return (Future)this.completionQueue.poll();
    }

    public Future poll(long l, TimeUnit timeUnit) throws InterruptedException {
        return (Future)this.completionQueue.poll(l, timeUnit);
    }

    public ExecutorCompletionService(Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = new LinkedBlockingQueue();
    }

    public ExecutorCompletionService(Executor executor, BlockingQueue blockingQueue) {
        if (executor == null || blockingQueue == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = blockingQueue;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class QueueingFuture
    extends FutureTask {
        private final Future task;

        protected void done() {
            ExecutorCompletionService.this.completionQueue.add(this.task);
        }

        QueueingFuture(RunnableFuture runnableFuture) {
            super(runnableFuture, null);
            this.task = runnableFuture;
        }
    }
}

