/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.backport;

import com.tridium.util.backport.AbstractMap;
import com.tridium.util.backport.NavigableMap;
import com.tridium.util.backport.NavigableSet;
import com.tridium.util.backport.TreeMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class TreeSet
extends AbstractSet
implements NavigableSet,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2479143000061671589L;
    private static final Object PRESENT = new Object();
    private transient NavigableMap map;

    public Object lower(Object object) {
        return this.map.lowerKey(object);
    }

    public Object floor(Object object) {
        return this.map.floorKey(object);
    }

    public Object ceiling(Object object) {
        return this.map.ceilingKey(object);
    }

    public Object higher(Object object) {
        return this.map.higherKey(object);
    }

    public Object pollFirst() {
        Map.Entry entry = this.map.pollFirstEntry();
        return entry != null ? entry.getKey() : null;
    }

    public Object pollLast() {
        Map.Entry entry = this.map.pollLastEntry();
        return entry != null ? entry.getKey() : null;
    }

    public Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public Iterator descendingIterator() {
        return this.map.descendingKeySet().iterator();
    }

    public SortedSet subSet(Object object, Object object2) {
        return this.subSet(object, true, object2, false);
    }

    public SortedSet headSet(Object object) {
        return this.headSet(object, false);
    }

    public SortedSet tailSet(Object object) {
        return this.tailSet(object, true);
    }

    public NavigableSet subSet(Object object, boolean bl, Object object2, boolean bl2) {
        return new TreeSet(this.map.subMap(object, bl, object2, bl2));
    }

    public NavigableSet headSet(Object object, boolean bl) {
        return new TreeSet(this.map.headMap(object, bl));
    }

    public NavigableSet tailSet(Object object, boolean bl) {
        return new TreeSet(this.map.tailMap(object, bl));
    }

    public NavigableSet descendingSet() {
        return new TreeSet(this.map.descendingMap());
    }

    public Comparator comparator() {
        return this.map.comparator();
    }

    public Object first() {
        return this.map.firstKey();
    }

    public Object last() {
        return this.map.lastKey();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.map.keySet().toArray(objectArray);
    }

    public boolean add(Object object) {
        boolean bl = false;
        if (this.map.put(object, PRESENT) == null) {
            bl = true;
        }
        return bl;
    }

    public boolean remove(Object object) {
        boolean bl = false;
        if (this.map.remove(object) != null) {
            bl = true;
        }
        return bl;
    }

    public boolean addAll(Collection collection) {
        if (this.map.size() == 0 && collection.size() > 0 && collection instanceof SortedSet && this.map instanceof TreeMap && TreeSet.eq(((SortedSet)collection).comparator(), this.comparator())) {
            ((TreeMap)this.map).buildFromSorted(new MapIterator(collection.iterator()), collection.size());
            return true;
        }
        return super.addAll(collection);
    }

    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        TreeSet treeSet;
        try {
            treeSet = (TreeSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        treeSet.map = new TreeMap(this.map);
        return treeSet;
    }

    private static final boolean eq(Object object, Object object2) {
        boolean bl;
        if (object == null) {
            bl = false;
            if (object2 == null) {
                bl = true;
            }
        } else {
            bl = object.equals(object2);
        }
        return bl;
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.map.comparator());
        objectOutputStream.writeInt(this.map.size());
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Comparator comparator = (Comparator)objectInputStream.readObject();
        TreeMap treeMap = new TreeMap(comparator);
        int n = objectInputStream.readInt();
        try {
            treeMap.buildFromSorted(new IOIterator(objectInputStream, n), n);
            this.map = treeMap;
        }
        catch (TreeMap.IteratorIOException iteratorIOException) {
            throw iteratorIOException.getException();
        }
        catch (TreeMap.IteratorNoClassException iteratorNoClassException) {
            throw iteratorNoClassException.getException();
        }
    }

    public TreeSet() {
        this.map = new TreeMap();
    }

    public TreeSet(Comparator comparator) {
        this.map = new TreeMap(comparator);
    }

    public TreeSet(Collection collection) {
        this.map = new TreeMap();
        this.addAll(collection);
    }

    public TreeSet(SortedSet sortedSet) {
        this.map = new TreeMap(sortedSet.comparator());
        this.addAll((Collection)sortedSet);
    }

    private TreeSet(NavigableMap navigableMap) {
        this.map = navigableMap;
    }

    private static class MapIterator
    implements Iterator {
        final Iterator itr;

        public boolean hasNext() {
            return this.itr.hasNext();
        }

        public Object next() {
            return new AbstractMap.SimpleImmutableEntry(this.itr.next(), PRESENT);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        MapIterator(Iterator iterator) {
            this.itr = iterator;
        }
    }

    static class IOIterator
    extends TreeMap.IOIterator {
        public Object next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            --this.remaining;
            try {
                return new AbstractMap.SimpleImmutableEntry(this.ois.readObject(), PRESENT);
            }
            catch (IOException iOException) {
                throw new TreeMap.IteratorIOException(iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new TreeMap.IteratorNoClassException(classNotFoundException);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        IOIterator(ObjectInputStream objectInputStream, int n) {
            super(objectInputStream, n);
        }
    }
}

