/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.backport;

import com.tridium.util.backport.AbstractQueue;
import com.tridium.util.backport.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PriorityQueue
extends AbstractQueue
implements Serializable {
    private static final long serialVersionUID = -7720805057305804111L;
    private static final int DEFAULT_INIT_CAPACITY = 11;
    private transient Object[] buffer;
    private int size;
    private final Comparator comparator;
    private transient int modCount;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public Iterator iterator() {
        return new Itr();
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public boolean offer(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.size == this.buffer.length) {
            int n = this.buffer.length * 2;
            if (n < this.buffer.length) {
                if (this.buffer.length == Integer.MAX_VALUE) {
                    throw new OutOfMemoryError();
                }
                n = Integer.MAX_VALUE;
            }
            Object[] objectArray = new Object[n];
            System.arraycopy(this.buffer, 0, objectArray, 0, this.size);
            this.buffer = objectArray;
        }
        ++this.modCount;
        this.percolateUp(this.size++, object);
        return true;
    }

    public Object peek() {
        return this.size == 0 ? null : this.buffer[0];
    }

    public Object poll() {
        if (this.size == 0) {
            return null;
        }
        ++this.modCount;
        Object object = this.buffer[0];
        --this.size;
        this.percolateDown(0, this.buffer[this.size]);
        this.buffer[this.size] = null;
        return object;
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int percolateDown(int n, Object object) {
        try {
            if (this.comparator != null) {
                int n2;
                while ((n2 = (n << 1) + 1) < this.size) {
                    if (n2 + 1 < this.size && this.comparator.compare(this.buffer[n2], this.buffer[n2 + 1]) > 0) {
                        ++n2;
                    }
                    if (this.comparator.compare(object, this.buffer[n2]) > 0) {
                        this.buffer[n] = this.buffer[n2];
                        n = n2;
                        continue;
                    }
                    break;
                }
            } else {
                int n3;
                Comparable comparable = (Comparable)object;
                while ((n3 = (n << 1) + 1) < this.size) {
                    if (n3 + 1 < this.size && ((Comparable)this.buffer[n3]).compareTo(this.buffer[n3 + 1]) > 0) {
                        ++n3;
                    }
                    if (comparable.compareTo(this.buffer[n3]) > 0) {
                        this.buffer[n] = this.buffer[n3];
                        n = n3;
                        continue;
                    }
                    break;
                }
            }
            int n4 = n;
            Object var4_7 = null;
            this.buffer[n] = object;
            return n4;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.buffer[n] = object;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int percolateUp(int n, Object object) {
        block5: {
            if (this.comparator == null) break block5;
            while (n > 0) {
                int n2 = n - 1 >>> 1;
                if (this.comparator.compare(object, this.buffer[n2]) >= 0) break;
                this.buffer[n] = this.buffer[n2];
                n = n2;
            }
            int n3 = n;
            Object var4_7 = null;
            this.buffer[n] = object;
            return n3;
        }
        try {
            Comparable comparable = (Comparable)object;
            while (n > 0) {
                int n4 = n - 1 >>> 1;
                if (comparable.compareTo(this.buffer[n4]) >= 0) break;
                this.buffer[n] = this.buffer[n4];
                n = n4;
            }
            int n5 = n;
            Object var4_8 = null;
            this.buffer[n] = object;
            return n5;
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            this.buffer[n] = object;
            throw throwable;
        }
    }

    public boolean add(Object object) {
        return this.offer(object);
    }

    public Object remove() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        Object object = this.buffer[0];
        ++this.modCount;
        --this.size;
        this.percolateDown(0, this.buffer[this.size]);
        this.buffer[this.size] = null;
        return object;
    }

    public Object element() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.buffer[0];
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.size == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(Object object) {
        int n = 0;
        while (n < this.size) {
            if (object.equals(this.buffer[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Object[] toArray() {
        Class clazz = array$Ljava$lang$Object;
        if (clazz == null) {
            clazz = array$Ljava$lang$Object = PriorityQueue.class("[Ljava.lang.Object;", true);
        }
        return Arrays.copyOf(this.buffer, this.size, clazz);
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            return Arrays.copyOf(this.buffer, this.size, objectArray.getClass());
        }
        System.arraycopy(this.buffer, 0, objectArray, 0, this.size);
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        if (this.comparator != null) {
            int n = 0;
            while (n < this.size) {
                if (this.comparator.compare(this.buffer[n], object) == 0) {
                    this.removeAt(n);
                    return true;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.size) {
                if (((Comparable)this.buffer[n]).compareTo(object) == 0) {
                    this.removeAt(n);
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private final Object removeAt(int n) {
        ++this.modCount;
        --this.size;
        Object object = this.buffer[this.size];
        this.buffer[this.size] = null;
        int n2 = this.percolateDown(n, object);
        if (n2 != n) {
            return null;
        }
        n2 = this.percolateUp(n, object);
        return n2 < n ? object : null;
    }

    public void clear() {
        ++this.modCount;
        Arrays.fill(this.buffer, 0, this.size, null);
        this.size = 0;
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.buffer.length);
        int n = 0;
        while (n < this.size) {
            objectOutputStream.writeObject(this.buffer[n]);
            ++n;
        }
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.buffer = new Object[objectInputStream.readInt()];
        int n = 0;
        while (n < this.size) {
            this.buffer[n] = objectInputStream.readObject();
            ++n;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PriorityQueue() {
        this(11, null);
    }

    public PriorityQueue(int n) {
        this(n, null);
    }

    public PriorityQueue(Comparator comparator) {
        this(11, comparator);
    }

    public PriorityQueue(int n, Comparator comparator) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.buffer = new Object[n];
        this.comparator = comparator;
    }

    public PriorityQueue(PriorityQueue priorityQueue) {
        this((Collection)priorityQueue);
    }

    public PriorityQueue(SortedSet sortedSet) {
        this((Collection)sortedSet);
    }

    public PriorityQueue(Collection collection) {
        int n = collection.size();
        if ((n += this.size / 10) < 0) {
            n = Integer.MAX_VALUE;
        } else if (n == 0) {
            n = 1;
        }
        this.buffer = new Object[n];
        if (collection instanceof PriorityQueue) {
            PriorityQueue priorityQueue = (PriorityQueue)collection;
            this.comparator = priorityQueue.comparator;
            this.size = priorityQueue.size;
            System.arraycopy(priorityQueue.buffer, 0, this.buffer, 0, this.size);
        } else if (collection instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)collection;
            this.comparator = sortedSet.comparator();
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                this.buffer[this.size++] = iterator.next();
            }
        } else {
            this.comparator = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.buffer[this.size++] = iterator.next();
            }
            int n2 = this.size / 2;
            while (n2 >= 0) {
                this.percolateDown(n2, this.buffer[n2]);
                --n2;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Itr
    implements Iterator {
        int cursor;
        List percolatedElems;
        int cursorPercolated;
        int expectedModCount;
        int lastRet;
        Object lastRetPercolated;

        public boolean hasNext() {
            boolean bl = false;
            if (this.cursor < PriorityQueue.this.size || this.percolatedElems != null) {
                bl = true;
            }
            return bl;
        }

        public Object next() {
            this.checkForComodification();
            if (this.cursor < PriorityQueue.this.size) {
                this.lastRet = this.cursor++;
                return PriorityQueue.this.buffer[this.lastRet];
            }
            if (this.percolatedElems != null) {
                this.lastRet = -1;
                this.lastRetPercolated = this.percolatedElems.remove(this.percolatedElems.size() - 1);
                if (this.percolatedElems.isEmpty()) {
                    this.percolatedElems = null;
                }
                return this.lastRetPercolated;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastRet >= 0) {
                Object object = PriorityQueue.this.removeAt(this.lastRet);
                this.lastRet = -1;
                if (object == null) {
                    --this.cursor;
                } else {
                    if (this.percolatedElems == null) {
                        this.percolatedElems = new ArrayList();
                    }
                    this.percolatedElems.add(object);
                }
            } else if (this.lastRetPercolated != null) {
                PriorityQueue.this.remove(this.lastRetPercolated);
                this.lastRetPercolated = null;
            } else {
                throw new IllegalStateException();
            }
            this.expectedModCount = PriorityQueue.this.modCount;
        }

        private final void checkForComodification() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private final /* synthetic */ void this() {
            this.cursor = 0;
            this.cursorPercolated = 0;
            this.expectedModCount = PriorityQueue.this.modCount;
        }

        Itr() {
            this.this();
        }
    }
}

