/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.sql;

import com.tridium.rdb.BResultSetTable;
import com.tridium.rdb.RdbmsUtil;
import java.sql.Connection;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsSession;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.sql.SqlQuery;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSqlScheme
extends BOrdScheme {
    public static final BSqlScheme INSTANCE = new BSqlScheme();
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$rdb$sql$BSqlScheme == null ? (class$javax$baja$rdb$sql$BSqlScheme = BSqlScheme.class$("javax.baja.rdb.sql.BSqlScheme")) : class$javax$baja$rdb$sql$BSqlScheme));
    static /* synthetic */ Class class$javax$baja$rdb$sql$BSqlScheme;

    public BSqlScheme() {
        super("sql");
    }

    public OrdQuery parse(String string) {
        return new SqlQuery(string);
    }

    public OrdTarget resolve(OrdTarget ordTarget, OrdQuery ordQuery) throws SyntaxException, UnresolvedException {
        Connection connection = null;
        try {
            ConnectionAndContext connectionAndContext = this.obtainConnectionAndContext(ordTarget);
            connection = connectionAndContext.connection;
            RdbmsContext rdbmsContext = connectionAndContext.context;
            String string = ((SqlQuery)ordQuery).getBody();
            RdbmsUtil.checkSqlBody(string);
            OrdTarget ordTarget2 = new OrdTarget(ordTarget, (BObject)new BResultSetTable(connection, string, rdbmsContext));
            return ordTarget2;
        }
        catch (Exception exception) {
            throw new UnresolvedException("Could not resolve " + ordTarget + ", " + ordQuery, (Throwable)exception);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private ConnectionAndContext obtainConnectionAndContext(OrdTarget ordTarget) throws Exception {
        BObject bObject = ordTarget.get();
        if (bObject instanceof BRdbms) {
            BRdbms bRdbms = (BRdbms)bObject;
            BPermissions bPermissions = bRdbms.getPermissions((Context)ordTarget);
            bRdbms.lease();
            if (!bRdbms.getSqlSchemeEnabled()) {
                throw new BajaRuntimeException("The 'sql' scheme is not enabled.");
            }
            BPermissions bPermissions2 = bRdbms.getPermissions((Context)ordTarget);
            if (!bPermissions2.hasAdminWrite() || !bPermissions2.hasAdminInvoke()) {
                throw new PermissionException();
            }
            return new ConnectionAndContext(bRdbms.getConnection(bRdbms.getUserName(), bRdbms.getPassword()), bRdbms.getRdbmsContext());
        }
        BRdbmsSession bRdbmsSession = (BRdbmsSession)BOrd.toSession((BObject)bObject);
        bRdbmsSession.connect();
        bRdbmsSession.getDatabase().lease();
        return new ConnectionAndContext(bRdbmsSession.getConnection(), bRdbmsSession.getDatabase().getRdbmsContext());
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ConnectionAndContext {
        Connection connection;
        RdbmsContext context;

        ConnectionAndContext(Connection connection, RdbmsContext rdbmsContext) {
            this.connection = connection;
            this.context = rdbmsContext;
        }
    }
}

