/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.point;

import com.tridium.rdb.BResultSetTable;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.rdb.point.BRdbmsPointDeviceExt;
import javax.baja.rdb.point.BRdbmsPointQuery;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFilter;

public class BRdbmsProxyExt
extends BProxyExt {
    public static final Property valueColumn = BRdbmsProxyExt.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"rdb:RdbmsColumnNamePickerFE"));
    public static final Property keyValue1 = BRdbmsProxyExt.newProperty((int)0, (String)"", null);
    public static final Property keyValue2 = BRdbmsProxyExt.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$rdb$point$BRdbmsProxyExt == null ? (class$javax$baja$rdb$point$BRdbmsProxyExt = BRdbmsProxyExt.class$("javax.baja.rdb.point.BRdbmsProxyExt")) : class$javax$baja$rdb$point$BRdbmsProxyExt));
    static /* synthetic */ Class class$javax$baja$rdb$point$BRdbmsProxyExt;

    public String getValueColumn() {
        return this.getString(valueColumn);
    }

    public void setValueColumn(String string) {
        this.setString(valueColumn, string, null);
    }

    public String getKeyValue1() {
        return this.getString(keyValue1);
    }

    public void setKeyValue1(String string) {
        this.setString(keyValue1, string, null);
    }

    public String getKeyValue2() {
        return this.getString(keyValue2);
    }

    public void setKeyValue2(String string) {
        this.setString(keyValue2, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BRdbmsPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readonly;
    }

    public void changed(Property property, Context context) {
        BRdbmsPointQuery bRdbmsPointQuery;
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if ((property.equals(enabled) || property.getName().startsWith("keyValue") || property.equals(valueColumn)) && (bRdbmsPointQuery = this.getQuery()) != null) {
            bRdbmsPointQuery.invoke(BRdbmsPointQuery.execute, null, context);
        }
    }

    public boolean write(Context context) {
        return false;
    }

    private BRdbmsPointQuery getQuery() {
        BRdbmsProxyExt bRdbmsProxyExt = this;
        while (!bRdbmsProxyExt.getType().is(BRdbmsPointQuery.TYPE)) {
            if ((bRdbmsProxyExt = bRdbmsProxyExt.getParent()) != null) continue;
            return null;
        }
        return (BRdbmsPointQuery)((Object)bRdbmsProxyExt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(BResultSetTable bResultSetTable) {
        if (!this.getEnabled() || !this.isRunning()) {
            return;
        }
        if (this.getValueColumn() == null || this.getValueColumn().trim().length() == 0) {
            this.readFail("Value column must be set.");
            return;
        }
        Cursor cursor = null;
        try {
            cursor = bResultSetTable.filter(new IFilter(){

                public boolean accept(Object object) {
                    BRdbmsPointQuery bRdbmsPointQuery = BRdbmsProxyExt.this.getQuery();
                    int n = 0;
                    while (true) {
                        block12: {
                            BString bString;
                            if ((bString = (BString)bRdbmsPointQuery.get("keyColumn" + (n + 1))) == null || bString.equals((Object)BString.DEFAULT)) {
                                return true;
                            }
                            String string = bString.toString().trim();
                            BValue bValue = ((BComponent)object).get(string);
                            String string2 = ((BString)BRdbmsProxyExt.this.get("keyValue" + (n + 1))).toString();
                            if (bValue == null) {
                                throw new BajaRuntimeException("No value returned by query for primary key " + string + ".");
                            }
                            try {
                                if (string2 == null) {
                                    throw new BajaRuntimeException("No key value defined.");
                                }
                                if (bValue.getType().is(BNumber.TYPE)) {
                                    if (((BNumber)bValue).getDouble() != Double.parseDouble(string2)) {
                                        return false;
                                    }
                                    break block12;
                                }
                                if (bValue.getType().is(BBoolean.TYPE)) {
                                    if (((BBoolean)bValue).getBoolean() ? !string2.equals("1") && !string2.equalsIgnoreCase("true") : !string2.equals("0") && !string2.equalsIgnoreCase("false")) {
                                        return false;
                                    }
                                    break block12;
                                }
                                if (bValue.getType().is(BString.TYPE)) {
                                    if (!((BString)bValue).getString().trim().equals(string2.trim())) {
                                        return false;
                                    }
                                    break block12;
                                }
                                throw new BajaRuntimeException("Unexpected data type: " + bValue.getType() + " on " + BRdbmsProxyExt.this.toString(null));
                            }
                            catch (Exception exception) {
                                throw new BajaRuntimeException("Invalid value for KeyValue" + (n + 1) + " on " + BRdbmsProxyExt.this.toString(null), (Throwable)exception);
                            }
                        }
                        ++n;
                    }
                }
            }).cursor();
        }
        catch (Exception exception) {
            this.getQuery().getLog().error(exception.getMessage(), (Throwable)exception);
            this.readFail(exception.getMessage());
            return;
        }
        if (cursor.next()) {
            BComponent bComponent = (BComponent)cursor.get();
            BValue bValue = bComponent.get(this.getValueColumn());
            try {
                try {
                    if (this.getParentPoint().getType().is(BEnumPoint.TYPE)) {
                        if (bValue.getType().is(BNumber.TYPE)) {
                            this.readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)((BNumber)bValue).getInt())));
                        } else {
                            if (!bValue.getType().is(BBoolean.TYPE)) throw new BajaRuntimeException(this.toString(null) + " is type " + this.getParentPoint().getType() + " but value is " + bValue.getType());
                            this.readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)((BBoolean)bValue).getOrdinal())));
                        }
                    } else if (this.getParentPoint().getType().is(BBooleanPoint.TYPE)) {
                        this.readOk((BStatusValue)new BStatusBoolean(((BBoolean)bValue).getBoolean()));
                    } else if (this.getParentPoint().getType().is(BNumericPoint.TYPE)) {
                        this.readOk((BStatusValue)new BStatusNumeric(((BNumber)bValue).getDouble()));
                    } else if (this.getParentPoint().getType().is(BStringPoint.TYPE)) {
                        this.readOk((BStatusValue)new BStatusString(bValue.toString().trim()));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BajaRuntimeException(this.toString(null) + " is type " + this.getParentPoint().getType() + " but value is " + bValue.getType(), (Throwable)numberFormatException);
                }
                catch (ClassCastException classCastException) {
                    throw new BajaRuntimeException(this.toString(null) + " is type " + this.getParentPoint().getType() + " but value is " + bValue.getType(), (Throwable)classCastException);
                }
            }
            catch (Exception exception) {
                this.getQuery().getLog().error(exception.getMessage(), (Throwable)exception);
                this.readFail(exception.getMessage());
            }
            if (!cursor.next()) return;
            this.getQuery().getLog().warning("Key columns not specific enough, multiple matches for " + this.toString(null) + ".");
            return;
        }
        this.readFail("No value found.");
        this.getQuery().getLog().warning("Key columns do not match any value for " + this.toString(null) + ".");
    }

    public void subscribed() {
        super.subscribed();
        this.readSubscribed(null);
    }

    public void unsubscribed() {
        super.unsubscribed();
        this.readUnsubscribed(null);
    }

    public void readSubscribed(Context context) {
        BRdbmsPointQuery bRdbmsPointQuery = this.getQuery();
        if (bRdbmsPointQuery != null) {
            bRdbmsPointQuery.addToPollGroup(this);
        }
    }

    public void readUnsubscribed(Context context) {
        BRdbmsPointQuery bRdbmsPointQuery = this.getQuery();
        if (bRdbmsPointQuery != null) {
            bRdbmsPointQuery.removeFromPollGroup(this);
        }
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getQuery().getName()).append(".").append(this.getParentPoint().getDisplayName(context));
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

