/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.point;

import com.tridium.rdb.BResultSetTable;
import java.util.HashMap;
import javax.baja.collection.Column;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.point.BRdbmsPointFolder;
import javax.baja.rdb.point.BRdbmsProxyExt;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BRdbmsPointQuery
extends BRdbmsPointFolder {
    public static final Property status = BRdbmsPointQuery.newProperty((int)3, (BValue)BStatus.nullStatus, null);
    public static final Property faultCause = BRdbmsPointQuery.newProperty((int)3, (String)"", null);
    public static final Property enabled = BRdbmsPointQuery.newProperty((int)0, (boolean)true, null);
    public static final Property updateFrequency = BRdbmsPointQuery.newProperty((int)0, (BValue)BRelTime.HOUR, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0)));
    public static final Property lastUpdate = BRdbmsPointQuery.newProperty((int)3, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    public static final Property sql = BRdbmsPointQuery.newProperty((int)0, (BValue)BFormat.make((String)""), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property keyColumn1 = BRdbmsPointQuery.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"rdb:RdbmsColumnNamePickerFE"));
    public static final Property keyColumn2 = BRdbmsPointQuery.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"rdb:RdbmsColumnNamePickerFE"));
    public static final Action execute = BRdbmsPointQuery.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$rdb$point$BRdbmsPointQuery == null ? (class$javax$baja$rdb$point$BRdbmsPointQuery = BRdbmsPointQuery.class$("javax.baja.rdb.point.BRdbmsPointQuery")) : class$javax$baja$rdb$point$BRdbmsPointQuery));
    private Clock.Ticket updateTicket;
    private static final BIcon icon = BIcon.std((String)"widgets/table.png");
    private Column[] resultColumns;
    HashMap pollGroup = new HashMap();
    static /* synthetic */ Class class$javax$baja$rdb$point$BRdbmsPointQuery;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BRelTime getUpdateFrequency() {
        return (BRelTime)this.get(updateFrequency);
    }

    public void setUpdateFrequency(BRelTime bRelTime) {
        this.set(updateFrequency, (BValue)bRelTime, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime bAbsTime) {
        this.set(lastUpdate, (BValue)bAbsTime, null);
    }

    public BFormat getSql() {
        return (BFormat)this.get(sql);
    }

    public void setSql(BFormat bFormat) {
        this.set(sql, (BValue)bFormat, null);
    }

    public String getKeyColumn1() {
        return this.getString(keyColumn1);
    }

    public void setKeyColumn1(String string) {
        this.setString(keyColumn1, string, null);
    }

    public String getKeyColumn2() {
        return this.getString(keyColumn2);
    }

    public void setKeyColumn2(String string) {
        this.setString(keyColumn2, string, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(sql)) {
            this.execute();
        }
        if (property.equals(updateFrequency) || property.equals(enabled) || property.getName().startsWith("keyColumn")) {
            if (this.updateTicket != null) {
                this.updateTicket.cancel();
                this.updateTicket = null;
            }
            if (this.getEnabled() && this.isSubscribed()) {
                this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdateFrequency(), (Action)execute, null);
                this.invoke(execute, null);
            }
        }
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        BRdbms bRdbms;
        if (action == execute && (bRdbms = (BRdbms)this.getDevice()) != null && bRdbms.isRunning()) {
            return bRdbms.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public BResultSetTable getData() {
        String string;
        try {
            string = this.getSql().format((Object)this);
            string = string.replace('\n', ' ');
        }
        catch (Exception exception) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Invalid formatting");
            this.getLog().error("Invalid formatting.", (Throwable)exception);
            return null;
        }
        BOrd bOrd = BOrd.make((BOrd)this.getDevice().getAbsoluteOrd(), (String)("sql:" + string));
        try {
            this.getLog().trace("Executing query: " + string);
            return (BResultSetTable)bOrd.get((BObject)this.getDevice(), null);
        }
        catch (Exception exception) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Unable to execute query.");
            this.getLog().error("Unable to execute query.", (Throwable)exception);
            return null;
        }
    }

    public void doExecute() {
        if (!this.isRunning()) {
            return;
        }
        Log log = this.getLog();
        log.trace("Executing query " + this.getName());
        BRdbms bRdbms = (BRdbms)this.getDevice();
        BStatus bStatus = bRdbms.getStatus();
        if (!bStatus.isValid()) {
            if (log.isTraceOn()) {
                log.trace("Cannot execute query: database status is " + bStatus);
            }
            this.setStatus(bRdbms.getStatus());
            return;
        }
        BResultSetTable bResultSetTable = this.getData();
        if (bResultSetTable == null) {
            if (log.isTraceOn()) {
                log.trace("Cannot execute query: result set table is null");
            }
            return;
        }
        this.setStatus(bRdbms.getStatus());
        this.setFaultCause(bRdbms.getFaultCause());
        this.setLastUpdate(BAbsTime.now());
        int n = this.executeChildren(bResultSetTable);
        if ((double)n > (double)bResultSetTable.size() * 1.5 && bResultSetTable.size() > 15) {
            this.getLog().warning("Query " + this.getName() + " returned more data than neccessary.");
        }
        this.resultColumns = bResultSetTable.getColumns().list();
    }

    public String getColumnName(Object object, Context context) {
        if (this.resultColumns != null && this.resultColumns.length > 0) {
            return this.resultColumns[((BInteger)object).getInt()].getName();
        }
        return null;
    }

    public int getColumnCount(Object object, Context context) {
        if (this.resultColumns != null && this.resultColumns.length > 0) {
            return this.resultColumns.length;
        }
        return 0;
    }

    public void subscribed() {
        if (this.getEnabled()) {
            if (this.updateTicket == null && this.isRunning()) {
                if (this.getLastUpdate().add(this.getUpdateFrequency()).isBefore(BAbsTime.now())) {
                    this.invoke(execute, null);
                }
                this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdateFrequency(), (Action)execute, null);
            }
        } else if (this.updateTicket != null) {
            this.updateTicket.cancel();
            this.updateTicket = null;
        }
    }

    public void unsubscribed() {
        if (this.updateTicket != null) {
            this.updateTicket.cancel();
            this.updateTicket = null;
        }
        super.unsubscribed();
    }

    Log getLog() {
        BRdbms bRdbms = (BRdbms)this.getDevice();
        if (bRdbms != null) {
            return bRdbms.getLog();
        }
        return null;
    }

    public void addToPollGroup(BRdbmsProxyExt bRdbmsProxyExt) {
        this.pollGroup.put(bRdbmsProxyExt, bRdbmsProxyExt);
        this.subscribed();
    }

    public void removeFromPollGroup(BRdbmsProxyExt bRdbmsProxyExt) {
        this.pollGroup.remove((Object)bRdbmsProxyExt);
        if (this.pollGroup.size() == 0) {
            this.unsubscribed();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

