/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.history;

import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.BRdbmsOptionalColumnSelection;
import com.tridium.rdb.RdbmsUtil;
import com.tridium.rdb.jdbc.RdbmsDialect;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.history.BRdbmsColumnSelection;
import javax.baja.rdb.history.BRdbmsHistoryDeviceExt;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

public class BRdbmsHistoryImport
extends BHistoryImport {
    private static Lexicon lex = Lexicon.make((String)"driver");
    public static final Property rdbTableName = BRdbmsHistoryImport.newProperty((int)0, (String)"", null);
    public static final Property rdbCatalogName = BRdbmsHistoryImport.newProperty((int)0, (String)"", null);
    public static final Property rdbSchemaName = BRdbmsHistoryImport.newProperty((int)0, (String)"", null);
    public static final Property timestampColumn = BRdbmsHistoryImport.newProperty((int)0, (BValue)new BRdbmsColumnSelection(), null);
    public static final Property valueColumn = BRdbmsHistoryImport.newProperty((int)0, (BValue)new BRdbmsColumnSelection(), null);
    public static final Property statusColumn = BRdbmsHistoryImport.newProperty((int)0, (BValue)new BRdbmsOptionalColumnSelection(), null);
    public static final Property queryPredicate = BRdbmsHistoryImport.newProperty((int)0, (String)"", null);
    public static final Property fullImportOnExecute = BRdbmsHistoryImport.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)lex.getText("import.fullImport.enabled"), (String)lex.getText("import.fullImport.disabled")));
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$rdb$history$BRdbmsHistoryImport == null ? (class$javax$baja$rdb$history$BRdbmsHistoryImport = BRdbmsHistoryImport.class$("javax.baja.rdb.history.BRdbmsHistoryImport")) : class$javax$baja$rdb$history$BRdbmsHistoryImport));
    private Connection connection;
    private RdbmsDialect rdbmsContext;
    private BRdbms db;
    private BRdbmsHistoryDeviceExt devicelet;
    private BRdbmsDeprecatedDialect dialect;
    private int timestampColumnType = 93;
    private boolean timestampColumnTypeInitialized = false;
    private boolean importingLicensed = false;
    private String licenseFailure = null;
    private static HashMap importCounts = new HashMap();
    private static final TimeZone localTimeZone = BTimeZone.getLocal().getJavaTimeZone();
    private static final Calendar utcCalender = Calendar.getInstance(BTimeZone.UTC.getJavaTimeZone());
    private static final String HISTORY_CONFIG_TABLE = "HISTORY_CONFIG";
    private static final String HISTORY_TYPE_MAP_TABLE = "HISTORY_TYPE_MAP";
    private static final String TIMEZONE_COLUMN = "TIMEZONE";
    private static final String DB_TIMEZONE_COLUMN = "DB_TIMEZONE";
    static /* synthetic */ Class class$javax$baja$rdb$history$BRdbmsHistoryImport;

    public String getRdbTableName() {
        return this.getString(rdbTableName);
    }

    public void setRdbTableName(String string) {
        this.setString(rdbTableName, string, null);
    }

    public String getRdbCatalogName() {
        return this.getString(rdbCatalogName);
    }

    public void setRdbCatalogName(String string) {
        this.setString(rdbCatalogName, string, null);
    }

    public String getRdbSchemaName() {
        return this.getString(rdbSchemaName);
    }

    public void setRdbSchemaName(String string) {
        this.setString(rdbSchemaName, string, null);
    }

    public BRdbmsColumnSelection getTimestampColumn() {
        return (BRdbmsColumnSelection)this.get(timestampColumn);
    }

    public void setTimestampColumn(BRdbmsColumnSelection bRdbmsColumnSelection) {
        this.set(timestampColumn, (BValue)bRdbmsColumnSelection, null);
    }

    public BRdbmsColumnSelection getValueColumn() {
        return (BRdbmsColumnSelection)this.get(valueColumn);
    }

    public void setValueColumn(BRdbmsColumnSelection bRdbmsColumnSelection) {
        this.set(valueColumn, (BValue)bRdbmsColumnSelection, null);
    }

    public BRdbmsColumnSelection getStatusColumn() {
        return (BRdbmsColumnSelection)this.get(statusColumn);
    }

    public void setStatusColumn(BRdbmsColumnSelection bRdbmsColumnSelection) {
        this.set(statusColumn, (BValue)bRdbmsColumnSelection, null);
    }

    public String getQueryPredicate() {
        return this.getString(queryPredicate);
    }

    public void setQueryPredicate(String string) {
        this.setString(queryPredicate, string, null);
    }

    public boolean getFullImportOnExecute() {
        return this.getBoolean(fullImportOnExecute);
    }

    public void setFullImportOnExecute(boolean bl) {
        this.setBoolean(fullImportOnExecute, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        super.started();
        this.checkLicense();
        if (this.importingLicensed) {
            this.importDescriptorStarted();
        }
    }

    public void importDescriptorStarted() throws Exception {
    }

    private void checkLicense() {
        try {
            Feature feature = ((BRdbms)this.getDevice()).getLicenseFeature();
            if (feature != null) {
                feature.check();
            }
            this.importingLicensed = feature.getb("historyImport", false);
            if (this.importingLicensed) {
                String string = feature.getVendorName() + ":" + feature.getFeatureName();
                string = TextUtil.toLowerCase((String)string);
                Integer n = (Integer)importCounts.get(string);
                int n2 = 0;
                if (n != null) {
                    n2 = n;
                }
                importCounts.put(string, new Integer(++n2));
                String string2 = feature.get("history.limit", "0");
                int n3 = Integer.MAX_VALUE;
                if (string2 != null && !TextUtil.toLowerCase((String)string2).equals("none")) {
                    n3 = Integer.parseInt(string2);
                }
                if (n3 == 0) {
                    this.importingLicensed = false;
                    this.licenseFailure = "Unlicensed: history.limit is zero or non-existent";
                } else if (n2 > n3) {
                    this.importingLicensed = false;
                    this.licenseFailure = "Unlicensed: Exceeded history.limit of " + n3;
                }
            } else {
                this.licenseFailure = "Unlicensed: Missing or disabled historyImport license attribute";
            }
        }
        catch (Exception exception) {
            this.importingLicensed = false;
            this.licenseFailure = "Unlicensed: " + exception;
        }
        if (!this.importingLicensed) {
            this.executeFail(this.licenseFailure);
        }
    }

    public final void doExecute() {
        if (this.importingLicensed) {
            this.executeRdbImport();
        } else {
            this.executeFail(this.licenseFailure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeRdbImport() {
        Statement statement = null;
        Statement statement2 = null;
        ResultSet resultSet = null;
        this.executeInProgress();
        try {
            BAbsTime bAbsTime;
            Object object;
            String string;
            BIHistory bIHistory;
            BTypeSpec bTypeSpec;
            BHistoryConfig bHistoryConfig;
            boolean bl;
            boolean bl2;
            Calendar calendar;
            block99: {
                StringBuffer stringBuffer;
                BHistoryId bHistoryId;
                block101: {
                    boolean bl3;
                    String string2;
                    block100: {
                        String string3;
                        BHistoryDatabase bHistoryDatabase;
                        block98: {
                            bHistoryId = this.getHistoryId();
                            if (bHistoryId.isNull()) {
                                this.executeFail(lex.getText("import.error.nullId"));
                                return;
                            }
                            bHistoryDatabase = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
                            if (bHistoryDatabase == null) {
                                this.executeFail(lex.getText("import.error.dbNotAvailable"));
                                return;
                            }
                            this.devicelet = (BRdbmsHistoryDeviceExt)this.getDeviceExt();
                            this.db = (BRdbms)this.devicelet.getDevice();
                            this.dialect = BRdbmsDeprecatedDialect.make(this.db);
                            this.connection = this.db.getConnection();
                            this.connection.setCatalog(this.getRdbCatalogName());
                            String string4 = this.getRdbSchemaName();
                            String string5 = this.getRdbTableName();
                            this.rdbmsContext = (RdbmsDialect)this.db.getRdbmsContext();
                            string3 = BRdbmsHistoryImport.getColumnIdentifier(string4, string5, SlotPath.unescape((String)this.getTimestampColumn().getColumn().getTag()), this.rdbmsContext);
                            String string6 = BRdbmsHistoryImport.getColumnIdentifier(string4, string5, SlotPath.unescape((String)this.getValueColumn().getColumn().getTag()), this.rdbmsContext);
                            String string7 = BRdbmsHistoryImport.getColumnIdentifier(string4, string5, SlotPath.unescape((String)this.getStatusColumn().getColumn().getTag()), this.rdbmsContext);
                            string5 = BRdbmsHistoryImport.getTableIdentifier(string4, string5, this.rdbmsContext);
                            BTimeZone bTimeZone = this.getImportTimeZone();
                            calendar = Calendar.getInstance(bTimeZone.getJavaTimeZone());
                            string2 = this.getQueryPredicate();
                            boolean bl4 = bl3 = string2 != null && string2.length() > 0;
                            if (bl3) {
                                String string8 = (string2 = string2.trim()).toUpperCase();
                                if (string8.startsWith("WHERE ")) {
                                    string2 = string2.substring(6);
                                } else if (string8.equals("WHERE")) {
                                    string2 = null;
                                }
                                bl3 = string2 != null && string2.length() > 0;
                            }
                            bl2 = true;
                            if (this.getTimestampColumn().getType().is(BRdbmsOptionalColumnSelection.TYPE)) {
                                bl2 = !((BRdbmsOptionalColumnSelection)this.getTimestampColumn()).getUnspecified();
                            }
                            bl = true;
                            if (this.getStatusColumn().getType().is(BRdbmsOptionalColumnSelection.TYPE)) {
                                bl = !((BRdbmsOptionalColumnSelection)this.getStatusColumn()).getUnspecified();
                            }
                            stringBuffer = new StringBuffer();
                            stringBuffer.append("SELECT " + string6);
                            if (bl2) {
                                stringBuffer.append("," + string3);
                            }
                            if (bl) {
                                stringBuffer.append("," + string7);
                            }
                            stringBuffer.append(" FROM " + string5);
                            bHistoryConfig = null;
                            bTypeSpec = null;
                            bIHistory = null;
                            if (bHistoryDatabase.exists(bHistoryId)) break block98;
                            if (bl3) {
                                stringBuffer.append(" WHERE " + string2);
                            }
                            statement = this.connection.createStatement();
                            string = stringBuffer.toString();
                            RdbmsUtil.checkSqlBody(string);
                            if (this.db.getLog().isTraceOn()) {
                                this.db.getLog().trace("Issuing the following SQL query to import data for history: " + bHistoryId);
                                this.db.getLog().trace("    " + string);
                            }
                            resultSet = statement.executeQuery(string);
                            object = resultSet.getMetaData();
                            bTypeSpec = BRdbmsHistoryImport.getRecordType((ResultSetMetaData)object, 1);
                            if (bl2) {
                                this.timestampColumnType = object.getColumnType(2);
                                this.timestampColumnTypeInitialized = true;
                            }
                            if (bTypeSpec == null) {
                                Object[] objectArray = new Object[]{string6};
                                this.executeFail(lex.getText("import.error.invalidRecordType", objectArray));
                                return;
                            }
                            bHistoryConfig = this.makeLocalConfig(this.makeLocalRdbConfig(bHistoryId, bTypeSpec));
                            bHistoryDatabase.createHistory(bHistoryConfig);
                            bIHistory = bHistoryDatabase.getHistory(bHistoryId);
                            break block99;
                        }
                        if (this.getFullImportOnExecute()) {
                            bHistoryDatabase.clearAllRecords(bHistoryId, null);
                        }
                        bHistoryConfig = this.makeLocalConfig(bHistoryDatabase.getHistory(bHistoryId).getConfig());
                        bHistoryDatabase.reconfigureHistory(bHistoryConfig);
                        bIHistory = bHistoryDatabase.getHistory(bHistoryId);
                        string = bIHistory.getLastTimestamp();
                        if (!bl2) break block100;
                        if (string != null && !this.getFullImportOnExecute()) {
                            stringBuffer.append(" WHERE (" + string3 + " > ?)");
                            if (bl3) {
                                stringBuffer.append(" AND (" + string2 + ")");
                            }
                            break block101;
                        } else if (bl3) {
                            stringBuffer.append(" WHERE " + string2);
                        }
                        break block101;
                    }
                    if (bl3) {
                        stringBuffer.append(" WHERE " + string2);
                    }
                }
                object = stringBuffer.toString();
                if (this.db.getLog().isTraceOn()) {
                    this.db.getLog().trace("Issuing the following SQL query to import data for history: " + bHistoryId);
                    this.db.getLog().trace("    " + (String)object);
                }
                RdbmsUtil.checkSqlBody((String)object);
                statement2 = this.connection.prepareStatement((String)object);
                if (bl2 && string != null && !this.getFullImportOnExecute()) {
                    if (!this.timestampColumnTypeInitialized) {
                        ResultSet resultSet2 = this.connection.getMetaData().getColumns(null, null, this.getRdbTableName(), this.getTimestampColumn().getColumn().getTag());
                        if (!resultSet2.next()) throw new Exception("Unable to determine timestamp column type");
                        this.timestampColumnType = resultSet2.getInt("DATA_TYPE");
                    }
                    if (this.timestampColumnType == 93) {
                        statement2.setTimestamp(1, new Timestamp(string.getMillis()), calendar);
                    } else {
                        statement2.setLong(1, string.getMillis());
                    }
                }
                resultSet = statement2.executeQuery();
            }
            bTypeSpec = bHistoryConfig.getRecordType();
            string = bTypeSpec.getTypeName();
            object = bHistoryConfig.makeRecord();
            boolean bl5 = true;
            BAbsTime bAbsTime2 = null;
            while (resultSet.next()) {
                Object object2;
                bAbsTime = null;
                if (bl2) {
                    object2 = null;
                    long l = -1L;
                    try {
                        object2 = resultSet.getTimestamp(2, calendar);
                        if (object2 == null) continue;
                        l = ((Timestamp)object2).getTime();
                    }
                    catch (Exception exception) {
                        l = resultSet.getLong(2);
                    }
                    bAbsTime = BAbsTime.make((long)l);
                } else {
                    bAbsTime = BAbsTime.now();
                }
                object2 = BStatus.ok;
                if (bl) {
                    object2 = BStatus.make((int)resultSet.getInt(this.getStatusColumn().getColumn().getTag()));
                }
                if (!bl5 && object.getTimestamp().equals((Object)bAbsTime)) {
                    bAbsTime2 = bAbsTime;
                    continue;
                }
                if (string.equals("NumericTrendRecord")) {
                    double d = resultSet.getDouble(1);
                    bIHistory.append((BIHistoryRecordSet)((BNumericTrendRecord)object).set(bAbsTime, d, (BStatus)object2));
                } else if (string.equals("BooleanTrendRecord")) {
                    boolean bl6 = resultSet.getBoolean(1);
                    bIHistory.append((BIHistoryRecordSet)((BBooleanTrendRecord)object).set(bAbsTime, bl6, (BStatus)object2));
                } else if (string.equals("StringTrendRecord")) {
                    String string9 = resultSet.getString(1);
                    bIHistory.append((BIHistoryRecordSet)((BStringTrendRecord)object).set(bAbsTime, string9, (BStatus)object2));
                }
                bl5 = false;
            }
            if (bAbsTime2 != null) {
                bAbsTime = new BAbsTime[]{bAbsTime2};
                this.executeFail(lex.getText("import.error.duplicateTimestamp", (Object[])bAbsTime));
                return;
            }
            this.executeOk();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.executeFail(exception);
            return;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (statement2 != null) {
                try {
                    statement2.close();
                }
                catch (Exception exception) {}
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected final IFuture postExecute(Action action, BValue bValue, Context context) {
        BRdbms bRdbms = (BRdbms)this.getDevice();
        if (bRdbms != null) {
            bRdbms.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return null;
    }

    private boolean columnExists(Connection connection, String string, String string2) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, null, string, string2);
        boolean bl = resultSet.next();
        resultSet.close();
        return bl;
    }

    private BTimeZone getImportTimeZone() throws SQLException {
        String string;
        ResultSet resultSet;
        String string2;
        String string3;
        if (this.rdbmsContext.useUtcTimestamps()) {
            return BTimeZone.UTC;
        }
        String string4 = "'" + this.getRdbTableName() + "'";
        Statement statement = this.connection.createStatement();
        BTimeZone bTimeZone = BTimeZone.getLocal();
        boolean bl = false;
        if (this.dialect.tableExists(this.db, this.connection, HISTORY_CONFIG_TABLE)) {
            try {
                String string5 = this.columnExists(this.connection, HISTORY_CONFIG_TABLE, DB_TIMEZONE_COLUMN) ? DB_TIMEZONE_COLUMN : (string3 = this.devicelet.getUseHistoryConfigTimeZone() && this.columnExists(this.connection, HISTORY_CONFIG_TABLE, TIMEZONE_COLUMN) ? TIMEZONE_COLUMN : null);
                if (string3 != null) {
                    string2 = "SELECT " + string3 + " FROM " + HISTORY_CONFIG_TABLE + " WHERE TABLE_NAME = " + string4;
                    resultSet = statement.executeQuery(string2);
                    if (resultSet.next()) {
                        string = resultSet.getString(string3);
                        string = string.substring(0, string.indexOf("(")).trim();
                        bTimeZone = BTimeZone.getTimeZone((String)string);
                        bl = true;
                    }
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl && this.dialect.tableExists(this.db, this.connection, HISTORY_TYPE_MAP_TABLE)) {
            try {
                String string6 = this.columnExists(this.connection, HISTORY_TYPE_MAP_TABLE, DB_TIMEZONE_COLUMN) ? DB_TIMEZONE_COLUMN : (string3 = this.devicelet.getUseHistoryConfigTimeZone() && this.columnExists(this.connection, HISTORY_TYPE_MAP_TABLE, TIMEZONE_COLUMN) ? TIMEZONE_COLUMN : null);
                if (string3 != null) {
                    string2 = "SELECT " + string3 + " FROM " + HISTORY_TYPE_MAP_TABLE + " WHERE TABLE_NAME = " + string4;
                    resultSet = statement.executeQuery(string2);
                    if (resultSet.next()) {
                        string = resultSet.getString(string3);
                        string = string.substring(0, string.indexOf("(")).trim();
                        bTimeZone = BTimeZone.getTimeZone((String)string);
                    }
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        statement.close();
        return bTimeZone;
    }

    private BOrd getSourceOrd() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null) {
            return null;
        }
        BOrd bOrd = bComponentSpace.getOrdInSession();
        if (bOrd == null) {
            return null;
        }
        return BOrd.make((BOrd)bOrd, (BOrd)this.getSlotPathOrd());
    }

    private BHistoryConfig makeLocalRdbConfig(BHistoryId bHistoryId, BTypeSpec bTypeSpec) {
        BHistoryConfig bHistoryConfig = new BHistoryConfig(bHistoryId, bTypeSpec);
        bHistoryConfig.setSource(BOrdList.make((BOrd)this.getSourceOrd()));
        bHistoryConfig.setSourceHandle(this.getHandleOrd());
        bHistoryConfig.setTimeZone(BTimeZone.getLocal());
        return bHistoryConfig;
    }

    private static BTypeSpec getRecordType(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        if (resultSetMetaData == null) {
            return null;
        }
        int n2 = resultSetMetaData.getColumnType(n);
        BTypeSpec bTypeSpec = null;
        switch (n2) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                bTypeSpec = BNumericTrendRecord.TYPE.getTypeSpec();
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                bTypeSpec = BStringTrendRecord.TYPE.getTypeSpec();
                break;
            }
            case -7: 
            case 16: {
                bTypeSpec = BBooleanTrendRecord.TYPE.getTypeSpec();
            }
        }
        return bTypeSpec;
    }

    private static String getColumnIdentifier(String string, String string2, String string3, RdbmsContext rdbmsContext) {
        if (rdbmsContext instanceof RdbmsDialect) {
            return ((RdbmsDialect)rdbmsContext).getColumnIdentifier(string, string2, string3);
        }
        if (string != null && string.length() > 0) {
            return string + "." + string2 + ".\"" + string3 + "\"";
        }
        return string2 + ".\"" + string3 + "\"";
    }

    private static String getTableIdentifier(String string, String string2, RdbmsContext rdbmsContext) {
        if (rdbmsContext instanceof RdbmsDialect) {
            return ((RdbmsDialect)rdbmsContext).getTableIdentifier(string, string2);
        }
        if (string != null && string.length() > 0) {
            return string + "." + string2;
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

