/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.history;

import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.jdbc.RdbmsDialect;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.baja.driver.history.BHistoryExport;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendRecord;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.history.BRdbmsHistoryDeviceExt;
import javax.baja.rdb.history.BRdbmsHistoryExportMode;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public abstract class BRdbmsHistoryExport
extends BHistoryExport {
    public static final Property userName = BRdbmsHistoryExport.newProperty((int)0, (String)"", null);
    public static final Property password = BRdbmsHistoryExport.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property lastTimestamp = BRdbmsHistoryExport.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$rdb$history$BRdbmsHistoryExport == null ? (class$javax$baja$rdb$history$BRdbmsHistoryExport = BRdbmsHistoryExport.class$("javax.baja.rdb.history.BRdbmsHistoryExport")) : class$javax$baja$rdb$history$BRdbmsHistoryExport));
    private BRdbmsHistoryDeviceExt devicelet;
    private BRdbms db;
    private BRdbmsDeprecatedDialect dialect;
    private Connection conn;
    private Statement stmt;
    private BIHistory history;
    private BHistoryConfig config;
    private BHistoryRecord template;
    private static final Log LOG = Log.getLog((String)"rdb");
    private static final BHistoryConfig CFG = new BHistoryConfig();
    private static final BFacets SHOW_MILLIS = BFacets.make((String)"showMilliseconds", (boolean)true);
    private boolean isNewSchema;
    static /* synthetic */ Class class$javax$baja$rdb$history$BRdbmsHistoryExport;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$baja$sys$Type;
    static /* synthetic */ Class class$javax$baja$sys$BFacets;
    static /* synthetic */ Class class$javax$baja$sys$Property;

    public String getUserName() {
        return this.getString(userName);
    }

    public void setUserName(String string) {
        this.setString(userName, string, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword bPassword) {
        this.set(password, (BValue)bPassword, null);
    }

    public BAbsTime getLastTimestamp() {
        return (BAbsTime)this.get(lastTimestamp);
    }

    public void setLastTimestamp(BAbsTime bAbsTime) {
        this.set(lastTimestamp, (BValue)bAbsTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute() {
        this.devicelet = (BRdbmsHistoryDeviceExt)this.getDeviceExt();
        this.db = (BRdbms)this.devicelet.getDevice();
        if (!this.db.getEnabled()) {
            this.logTrace("database disabled, on thread " + Thread.currentThread().getName());
            this.setState(BDescriptorState.idle);
            this.updateStatus();
            return;
        }
        this.logTrace("begin export on thread " + Thread.currentThread().getName());
        long l = System.currentTimeMillis();
        this.conn = null;
        boolean bl = false;
        this.executeInProgress();
        try {
            this.dialect = BRdbmsDeprecatedDialect.make(this.db);
            String string = this.devicelet.getUserName(this.db, this);
            BPassword bPassword = this.devicelet.getPassword(this.db, this);
            this.conn = this.db.getConnection(string, bPassword);
            this.conn.setAutoCommit(false);
            this.stmt = this.conn.createStatement();
            BHistoryDatabase bHistoryDatabase = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
            BHistoryId bHistoryId = this.getHistoryId();
            this.history = bHistoryDatabase.resolveHistory(bHistoryId);
            this.config = this.history.getConfig();
            this.template = this.config.makeRecord();
            if (this.devicelet.getUseHistoryConfigTimeZone()) {
                if (this.devicelet.getUseLastTimestamp()) {
                    this.dialect.setTimeZone(this.config.getTimeZone());
                } else {
                    throw new BajaRuntimeException("Export failed: useHistoryConfigTimeZone=true and useLastTimestamp=false.");
                }
            }
            this.exportRecords();
            this.stmt.close();
            this.conn.close();
            bl = true;
            this.executeOk();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.executeFail(exception);
        }
        finally {
            if (this.conn != null && !bl) {
                try {
                    this.conn.close();
                }
                catch (Exception exception) {
                    this.logError("Couldn't close connection: " + exception.getMessage());
                }
            }
            long l2 = System.currentTimeMillis() - l;
            this.logTrace("end export (" + l2 + "ms)");
        }
    }

    protected IFuture postExecute(Action action, BValue bValue, Context context) {
        BRdbms bRdbms = (BRdbms)this.getDevice();
        if (bRdbms != null) {
            bRdbms.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return null;
    }

    private void exportRecords() throws Exception {
        BValue bValue;
        String string;
        String string2 = this.getMetaTableName();
        this.isNewSchema = this.isNewSchema(string2);
        if (!this.dialect.tableExists(this.db, this.conn, string2)) {
            this.logTrace("table '" + string2 + "' does not exist.");
            this.createMetaTable();
        }
        ResultSet resultSet = this.getMetaRecord();
        String string3 = null;
        if (resultSet.next()) {
            string3 = resultSet.getString("TABLE_NAME");
            if (this.columnExists(string2, "VALUEFACETS")) {
                string = resultSet.getString("VALUEFACETS");
                bValue = this.config.get("valueFacets");
                if (bValue != null && bValue instanceof BFacets) {
                    String string4 = bValue.asSimple().encodeToString();
                    if (string != null && !string.equals(string4)) {
                        String string5 = this.dialect.makeUpdateSql(string2, new Property[]{this.config.getProperty("valueFacets")}, new String[0], this.dialect.mangleIdentifier(BHistoryConfig.id.getName()));
                        PreparedStatement preparedStatement = this.conn.prepareStatement(string5);
                        preparedStatement.setString(1, string4);
                        preparedStatement.setString(2, this.config.getId().toString());
                        preparedStatement.execute();
                        preparedStatement.close();
                    }
                }
            }
            resultSet.close();
        } else {
            resultSet.close();
            this.insertMetaRecord();
            resultSet = this.getMetaRecord();
            if (!resultSet.next()) {
                throw new BajaRuntimeException("Could not create metadata record for history " + this.config.getId().getDeviceName() + " ::: " + this.config.getId().getHistoryName());
            }
            string3 = resultSet.getString("TABLE_NAME");
            int n = resultSet.getInt("ID");
            resultSet.close();
            if (!this.dialect.tableExists(this.db, this.conn, string3)) {
                this.logTrace("table '" + string3 + "' does not exist.");
                this.createTable(string3, n);
            }
        }
        string = this.getLastTimestamp();
        bValue = this.insertRecords((BAbsTime)string, string3);
        this.setLastTimestamp((BAbsTime)bValue);
    }

    private void createTable(String string, int n) throws SQLException {
        StringBuffer stringBuffer;
        Property[] propertyArray = this.template.getPropertiesArray();
        Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BRdbmsHistoryExport.class$("java.lang.String")) : class$java$lang$String);
        Array array2 = new Array(class$javax$baja$sys$Type == null ? (class$javax$baja$sys$Type = BRdbmsHistoryExport.class$("javax.baja.sys.Type")) : class$javax$baja$sys$Type);
        Array array3 = new Array(class$javax$baja$sys$BFacets == null ? (class$javax$baja$sys$BFacets = BRdbmsHistoryExport.class$("javax.baja.sys.BFacets")) : class$javax$baja$sys$BFacets);
        String string2 = null;
        if (this.template instanceof BTrendRecord) {
            switch (this.db.getExportMode().getOrdinal()) {
                case 0: {
                    string2 = "ID";
                    break;
                }
                case 1: {
                    string2 = "TP";
                    array.add((Object)"HISTORY_ID");
                    array2.add((Object)BString.TYPE);
                    array3.add((Object)BFacets.NULL);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            array.addAll((Object[])new String[]{"TRENDFLAGS_TAG", "STATUS_TAG"});
            array2.addAll((Object[])new Type[]{BString.TYPE, BString.TYPE});
            array3.addAll((Object[])new BFacets[]{BFacets.NULL, BFacets.NULL});
        }
        String string3 = this.dialect.makeCreateTableSql(string, propertyArray, (String[])array.trim(), (Type[])array2.trim(), (BFacets[])array3.trim());
        this.stmt.executeUpdate(string3);
        if (this.dialect.hasSequences()) {
            this.stmt.executeUpdate("CREATE SEQUENCE " + string + "_Q");
        }
        if (!this.devicelet.getUseLastTimestamp() && this.template instanceof BTrendRecord) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("CREATE INDEX ");
            stringBuffer.append(string2).append("_").append(n).append("_TS ON ");
            stringBuffer.append(string);
            stringBuffer.append("(TIMESTAMP)");
            this.stmt.executeUpdate(stringBuffer.toString());
        }
        switch (this.db.getExportMode().getOrdinal()) {
            case 0: {
                break;
            }
            case 1: {
                if (this.devicelet.getUseLastTimestamp() || !(this.template instanceof BTrendRecord)) break;
                stringBuffer = new StringBuffer();
                stringBuffer.append("CREATE INDEX ");
                stringBuffer.append("IDX_").append(n).append("_ID ON ");
                stringBuffer.append(string);
                stringBuffer.append("(HISTORY_ID)");
                this.stmt.executeUpdate(stringBuffer.toString());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.conn.commit();
        this.logTrace("created table '" + string + "'.");
    }

    private boolean columnExists(String string, String string2) throws SQLException {
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, null, string, string2);
        boolean bl = resultSet.next();
        resultSet.close();
        return bl;
    }

    private BAbsTime insertRecords(BAbsTime bAbsTime, String string) throws SQLException {
        boolean bl;
        BAbsTime bAbsTime2 = this.lookupMaxTimestamp(string);
        if (bAbsTime2 != null) {
            bAbsTime2 = BAbsTime.make((long)(bAbsTime2.getMillis() + this.dialect.getTimestampAccuracy()));
            this.logTrace("maxTimestamp " + bAbsTime2.toString((Context)SHOW_MILLIS));
        }
        Cursor cursor = this.history.timeQuery(bAbsTime2, null).cursor();
        Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BRdbmsHistoryExport.class$("java.lang.String")) : class$java$lang$String);
        if (this.template instanceof BTrendRecord) {
            switch (this.db.getExportMode().getOrdinal()) {
                case 1: {
                    array.add((Object)"HISTORY_ID");
                }
            }
            array.addAll((Object[])new String[]{"TRENDFLAGS_TAG", "STATUS_TAG"});
        }
        if (bl = false) {
            array.add((Object)"UTC_OFFSET");
        }
        int n = array.size();
        BObject[] bObjectArray = new BObject[n];
        BFacets[] bFacetsArray = new BFacets[n];
        Property[] propertyArray = this.template.getPropertiesArray();
        String string2 = this.dialect.makeInsertSql(string, propertyArray, (String[])array.trim());
        int n2 = 0;
        int n3 = 0;
        PreparedStatement preparedStatement = this.conn.prepareStatement(string2);
        while (cursor.next()) {
            Object object;
            BHistoryRecord bHistoryRecord = (BHistoryRecord)cursor.get();
            BAbsTime bAbsTime3 = bHistoryRecord.getTimestamp();
            if (bAbsTime.compareTo((Object)bAbsTime3) < 0) {
                bAbsTime = bAbsTime3;
            }
            switch (this.db.getExportMode().getOrdinal()) {
                case 0: {
                    if (!(this.template instanceof BTrendRecord)) break;
                    object = (BTrendRecord)bHistoryRecord;
                    bObjectArray[0] = BString.make((String)object.getTrendFlags().toString());
                    bObjectArray[1] = BString.make((String)object.getStatus().toString());
                    break;
                }
                case 1: {
                    if (bObjectArray.length > 0) {
                        bObjectArray[0] = BString.make((String)this.history.getId().toString());
                    }
                    if (!(this.template instanceof BTrendRecord)) break;
                    object = (BTrendRecord)bHistoryRecord;
                    bObjectArray[1] = BString.make((String)object.getTrendFlags().toString());
                    bObjectArray[2] = BString.make((String)object.getStatus().toString());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (bl) {
                object = (RdbmsDialect)this.db.getRdbmsContext();
                BTimeZone bTimeZone = object.useUtcTimestamps() ? BTimeZone.UTC : (this.devicelet.getUseHistoryConfigTimeZone() ? this.config.getTimeZone() : BTimeZone.getLocal());
                BLong bLong = BLong.make((long)bTimeZone.getJavaTimeZone().getOffset(bAbsTime3.getMillis()));
                bObjectArray[bObjectArray.length - 1] = bLong;
            }
            this.dialect.insertRecord(preparedStatement, (BComplex)bHistoryRecord, propertyArray, bObjectArray, bFacetsArray);
            ++n2;
            if (++n3 < 1000) continue;
            this.logTrace("sending batch at " + n2 + " records");
            preparedStatement.executeBatch();
            preparedStatement.close();
            preparedStatement = this.conn.prepareStatement(string2);
            n3 = 0;
        }
        if (n3 > 0) {
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        this.conn.commit();
        this.logTrace("inserted " + n2 + " records");
        return bAbsTime;
    }

    private BAbsTime lookupMaxTimestamp(String string) throws SQLException {
        if (this.devicelet.getUseLastTimestamp()) {
            BAbsTime bAbsTime = this.getLastTimestamp();
            if (!bAbsTime.equals((Object)BAbsTime.NULL)) {
                return bAbsTime;
            }
            return null;
        }
        String string2 = "SELECT MAX(TIMESTAMP) AS MAX_TIMESTAMP FROM " + string;
        switch (this.db.getExportMode().getOrdinal()) {
            case 0: {
                break;
            }
            case 1: {
                string2 = string2 + (this.template instanceof BTrendRecord ? " WHERE HISTORY_ID = '" + BRdbmsHistoryExport.fixQuotes(this.history.getId().toString()) + "'" : "");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Timestamp timestamp = null;
        ResultSet resultSet = this.stmt.executeQuery(string2);
        boolean bl = resultSet.next();
        if (bl) {
            Object object;
            if (this.dialect.supportsTimestamp()) {
                object = this.db.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcTimestamp) ? Calendar.getInstance(BTimeZone.UTC.getJavaTimeZone()) : (this.devicelet.getUseHistoryConfigTimeZone() && this.devicelet.getUseLastTimestamp() ? Calendar.getInstance(this.config.getTimeZone().getJavaTimeZone()) : Calendar.getInstance());
                timestamp = resultSet.getTimestamp("MAX_TIMESTAMP", (Calendar)object);
                if (timestamp == null) {
                    return null;
                }
            } else {
                object = resultSet.getString("MAX_TIMESTAMP");
                if (object == null) {
                    return null;
                }
                timestamp = new Timestamp(Long.valueOf((String)object));
            }
            long l = timestamp.getTime();
            return BAbsTime.make((long)l);
        }
        return null;
    }

    private BTimeZone getExportTimeZone() throws SQLException {
        ResultSet resultSet = this.getMetaRecord();
        BTimeZone bTimeZone = BTimeZone.NULL;
        if (resultSet.next() && this.isNewSchema) {
            try {
                String string = resultSet.getString("DB_TIMEZONE");
                string = string.substring(0, string.indexOf("(")).trim();
                bTimeZone = BTimeZone.getTimeZone((String)string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            bTimeZone = this.devicelet.getUseHistoryConfigTimeZone() && this.devicelet.getUseLastTimestamp() ? this.config.getTimeZone() : BTimeZone.getLocal();
        }
        resultSet.close();
        return bTimeZone;
    }

    private String getMetaTableName() {
        switch (this.db.getExportMode().getOrdinal()) {
            case 0: {
                return "HISTORY_CONFIG";
            }
            case 1: {
                return "HISTORY_TYPE_MAP";
            }
        }
        throw new IllegalStateException();
    }

    private void createMetaTable() throws SQLException {
        String string = this.getMetaTableName();
        Property[] propertyArray = this.makeMetaTemplate();
        String string2 = this.dialect.makeCreateTableSql(string, propertyArray, new String[]{"TABLE_NAME", "DB_TIMEZONE"}, new Type[]{BString.TYPE, BString.TYPE}, new BFacets[]{BFacets.NULL, BFacets.NULL});
        this.stmt.executeUpdate(string2);
        if (this.dialect.hasSequences()) {
            this.stmt.executeUpdate("CREATE SEQUENCE " + string + "_Q");
        }
        this.conn.commit();
        this.logTrace("created table '" + string + "'.");
    }

    private void insertMetaRecord() throws SQLException {
        try {
            BFacets[] bFacetsArray;
            String[] stringArray;
            Property[] propertyArray = this.makeMetaTemplate();
            String string = this.getMetaTableName();
            if (this.isNewSchema) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "TABLE_NAME";
                stringArray = stringArray2;
                stringArray2[1] = "DB_TIMEZONE";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "TABLE_NAME";
            }
            PreparedStatement preparedStatement = this.conn.prepareStatement(this.dialect.makeInsertSql(string, propertyArray, stringArray));
            String string2 = this.inventTableName();
            BString bString = BString.make((String)string2);
            RdbmsDialect rdbmsDialect = (RdbmsDialect)this.db.getRdbmsContext();
            BTimeZone bTimeZone = rdbmsDialect.useUtcTimestamps() ? BTimeZone.UTC : (this.devicelet.getUseHistoryConfigTimeZone() ? this.config.getTimeZone() : BTimeZone.getLocal());
            BString bString2 = BString.make((String)bTimeZone.toString());
            BObject[] bObjectArray = new BObject[]{bString, bString2};
            BObject[] bObjectArray2 = new BObject[]{bString};
            BObject[] bObjectArray3 = this.isNewSchema ? bObjectArray : bObjectArray2;
            if (this.isNewSchema) {
                BFacets[] bFacetsArray2 = new BFacets[2];
                bFacetsArray2[0] = BFacets.NULL;
                bFacetsArray = bFacetsArray2;
                bFacetsArray2[1] = BFacets.NULL;
            } else {
                BFacets[] bFacetsArray3 = new BFacets[1];
                bFacetsArray = bFacetsArray3;
                bFacetsArray3[0] = BFacets.NULL;
            }
            this.dialect.insertRecord(preparedStatement, (BComplex)this.config, propertyArray, bObjectArray3, bFacetsArray);
            preparedStatement.executeBatch();
            preparedStatement.close();
            this.conn.commit();
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    private ResultSet getMetaRecord() throws SQLException {
        String string = null;
        String string2 = this.getMetaTableName();
        boolean bl = this.db.getExportMode().equals((Object)BRdbmsHistoryExportMode.byHistoryId);
        string = bl || this.isNewSchema ? "SELECT * FROM " + string2 + " WHERE ID_ = '" + BRdbmsHistoryExport.fixQuotes(this.config.getId().toString()) + "'" : "SELECT * FROM " + string2 + " WHERE RECORDTYPE = '" + BRdbmsHistoryExport.fixQuotes(this.config.getRecordType().toString()) + "'";
        return this.stmt.executeQuery(string);
    }

    private boolean isNewSchema(String string) throws SQLException {
        if (!this.dialect.tableExists(this.db, this.conn, string)) {
            return true;
        }
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, null, string, "DB_TIMEZONE");
        boolean bl = resultSet.next();
        resultSet.close();
        return bl;
    }

    private String inventTableName() throws SQLException {
        String string;
        String string2;
        int n;
        int n2 = this.dialect.getMaxTableName();
        if (this.dialect.hasSequences() && n2 > (n = this.dialect.getMaxSequenceName()) - 2) {
            n2 = n - 2;
        }
        switch (this.db.getExportMode().getOrdinal()) {
            case 0: {
                string2 = SlotPath.unescape((String)this.config.getId().getDeviceName().toUpperCase());
                String string3 = SlotPath.unescape((String)this.config.getId().getHistoryName().toUpperCase());
                string = TextUtil.truncate((String)(this.dialect.mangleIdentifier(string2) + "_" + this.dialect.mangleIdentifier(string3)), (int)n2);
                break;
            }
            case 1: {
                string = TextUtil.truncate((String)this.dialect.mangleIdentifier(this.config.getRecordType().toString()), (int)n2);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (this.metaRecordExists(string) && this.db.getExportMode().equals((Object)BRdbmsHistoryExportMode.byHistoryId)) {
            String string4;
            string2 = string;
            int n3 = 1;
            while (this.metaRecordExists(string = TextUtil.truncate((String)string2, (int)(n2 - (string4 = Integer.toString(n3++)).length())) + string4)) {
            }
        }
        return string;
    }

    private boolean metaRecordExists(String string) throws SQLException {
        ResultSet resultSet = this.stmt.executeQuery("SELECT * FROM " + this.getMetaTableName() + " WHERE " + "TABLE_NAME = '" + string + "'");
        boolean bl = resultSet.next();
        resultSet.close();
        return bl;
    }

    private Property[] makeMetaTemplate() throws SQLException {
        boolean bl;
        if (this.config.getProperty("valueFacets") == null) {
            this.config.add("valueFacets", (BValue)BFacets.NULL);
        }
        Array array = new Array(class$javax$baja$sys$Property == null ? (class$javax$baja$sys$Property = BRdbmsHistoryExport.class$("javax.baja.sys.Property")) : class$javax$baja$sys$Property);
        SlotCursor slotCursor = this.config.getProperties();
        boolean bl2 = this.db.getExportMode().equals((Object)BRdbmsHistoryExportMode.byHistoryId);
        boolean bl3 = bl = !bl2;
        while (slotCursor.next()) {
            Property property = slotCursor.property();
            String string = property.getName();
            if (string.equals("schema") || string.equals("capacity") || string.equals("fullPolicy") || string.equals("storageType") || (!bl ? bl2 && string.equals("recordType") : (this.isNewSchema ? string.equals("source") || string.equals("historyName") || string.equals("sourceHandle") || string.equals("interval") || string.equals("systemTags") : !string.equals("recordType")))) continue;
            if (property.isDynamic()) {
                if (!string.equals("valueFacets")) continue;
                String string2 = this.getMetaTableName();
                String string3 = this.dialect.mangleIdentifier(string);
                if (this.dialect.tableExists(this.db, this.conn, string2) && !this.columnExists(string2, string3)) continue;
                array.add((Object)property);
                continue;
            }
            array.add((Object)property);
        }
        return (Property[])array.trim();
    }

    private static String fixQuotes(String string) {
        return TextUtil.replace((String)string, (String)"'", (String)"''");
    }

    private void logTrace(String string) {
        LOG.trace("HistoryExport " + this.getHistoryId() + " " + string);
    }

    private void logError(String string) {
        LOG.error("HistoryExport " + this.getHistoryId() + " " + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

